/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IContextMenuHandler;
import editor.LabFrame;
import editor.MessageTree;
import editor.util.SmartMenuItem;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class MessageTreeContextMenu
implements IContextMenuHandler<MessageTree> {
    @Override
    public JPopupMenu getContextMenu(MessageTree message) {
        JPopupMenu menu = new JPopupMenu();
        if (((MessageTree.IssueNode)message.getNode()).hasTarget()) {
            menu.add(new SmartMenuItem(new OpenAction(message)));
            menu.add(new JSeparator());
        }
        menu.add(new SmartMenuItem(new ClipCopyAction(message.getText())));
        return menu;
    }

    @Override
    public void displayContextMenu(MessageTree message, int x, int y, Component eventSource) {
        message.getTree().requestFocus();
        this.getContextMenu(message).show(message.getTree(), x, y);
    }

    class ClipCopyAction
    extends AbstractAction
    implements ClipboardOwner {
        String _message;

        public ClipCopyAction(String message) {
            super("Copy");
            this.putValue("MnemonicKey", new Integer(67));
            this._message = message;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = LabFrame.instance().getGosuPanel().getClipboard();
            clipboard.setContents(new StringSelection(this._message), this);
        }
    }

    class OpenAction
    extends AbstractAction
    implements ClipboardOwner {
        MessageTree _message;

        public OpenAction(MessageTree message) {
            super("Open");
            this.putValue("MnemonicKey", new Integer(79));
            this._message = message;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((MessageTree.IssueNode)this._message.getNode()).jumpToTarget();
        }
    }
}

