/*
 * Decompiled with CFR 0.152.
 */
package editor;

import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IHasArguments;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;
import java.awt.Point;
import javax.swing.text.JTextComponent;

public class ParseExceptionResolver {
    public static IType resolvePossibleContextTypesFromEmptyMethodCalls(IExpression expression, JTextComponent editor) {
        IFunctionType funType;
        IBeanMethodCallExpression bmce;
        FunctionType funType2;
        IFunctionSymbol symbol;
        IMethodCallExpression mce;
        IType[] paramTypes = null;
        if (expression instanceof IMethodCallExpression && ((mce = (IMethodCallExpression)expression).getArgs() == null || mce.getArgs().length == 0) && ParseExceptionResolver.isEditorAtPossibleArgPosition((IParsedElement)mce, editor) && (symbol = mce.getFunctionSymbol()) != null && (funType2 = (FunctionType)symbol.getType()) != null && funType2.getParameterTypes() != null && funType2.getParameterTypes().length > 0) {
            paramTypes = funType2.getParameterTypes();
        }
        if (expression instanceof IBeanMethodCallExpression && ((bmce = (IBeanMethodCallExpression)expression).getArgs() == null || bmce.getArgs().length == 0) && ParseExceptionResolver.isEditorAtPossibleArgPosition((IParsedElement)bmce, editor) && (funType = bmce.getFunctionType()) != null && funType.getParameterTypes() != null && funType.getParameterTypes().length > 0) {
            paramTypes = funType.getParameterTypes();
        }
        return paramTypes != null && paramTypes.length > 0 ? paramTypes[0] : null;
    }

    public static boolean isEditorAtPossibleArgPosition(IParsedElement e, JTextComponent editor) {
        int position;
        Point argPosition;
        boolean returnVal = false;
        if (e instanceof IHasArguments && (argPosition = ParseExceptionResolver.findMethodArgPoint(e, editor)) != null && (position = editor.getCaretPosition()) > argPosition.x && position <= argPosition.y) {
            returnVal = true;
        }
        return returnVal;
    }

    private static Point findMethodArgPoint(IParsedElement mce, JTextComponent editor) {
        int end = mce.getLocation().getExtent();
        try {
            int start;
            for (start = mce.getLocation().getOffset(); !"(".equals(editor.getText(start, 1)) && start < end; ++start) {
            }
            while (!")".equals(editor.getText(end, 1)) && end > start) {
                --end;
            }
            return new Point(start, end);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

