/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.StepRequest;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.LabFrame;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointManager;
import editor.shipit.CompiledClass;
import editor.shipit.ExperimentBuild;
import editor.util.EditorUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JOptionPane;

public class Debugger {
    private static final String TEMPORARY = "temporary";
    private static final String FROM_LOCATION = "from_location";
    private static final String BACK_OUT_LOCATION = "back_out_location";
    private Thread _debuggerThread;
    private final BreakpointManager _bpm;
    private VirtualMachine _vm;
    private EventSet _eventSet;
    private boolean _vmExit;
    private Location _location;
    private ThreadReference _eventThread;
    private Map<String, ClassPrepareRequest> _classPrepareRequests;
    private final Object _monitor;
    private boolean _bPaused;
    private List<Consumer<Debugger>> _listeners;
    private String _eventName;
    private final HashSet<ObjectReference> _refs;
    private boolean _temporarilySuspended;
    private EventIterator _eventIterator;
    private ExperimentBuild _classRedefiner;

    public Debugger(VirtualMachine vm, BreakpointManager bpm) {
        this._vm = vm;
        this._bpm = bpm;
        this._classPrepareRequests = new HashMap<String, ClassPrepareRequest>();
        this._debuggerThread = new Thread(this::run, "Debugger");
        this._listeners = new ArrayList<Consumer<Debugger>>();
        this._refs = new HashSet();
        this._classRedefiner = new ExperimentBuild(false);
        this._monitor = new Object(){

            public String toString() {
                return "Debugger Monitor";
            }
        };
    }

    public void startDebugging() {
        this._debuggerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeExecution() {
        Object object = this._monitor;
        synchronized (object) {
            if (this.isPaused()) {
                this._bPaused = false;
                this._vm.resume();
                this.resumed(false);
            } else {
                this._monitor.notifyAll();
            }
        }
    }

    public Location getSuspendedLocation() {
        return this._location;
    }

    public ThreadReference getSuspendedThread() {
        return this._eventThread;
    }

    private void assignSuspendedState(LocatableEvent event, boolean temporary) {
        this._location = event.location();
        this._eventThread = event.thread();
        this._temporarilySuspended = temporary;
    }

    private void clearSuspendedState() {
        this._location = null;
        this._eventThread = null;
        this._temporarilySuspended = false;
    }

    public void addChangeListener(Consumer<Debugger> listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public boolean removeChangeListener(Consumer<Debugger> listener) {
        return this._listeners.remove(listener);
    }

    private void notifyListeners() {
        for (Consumer<Debugger> listener : this._listeners) {
            listener.accept(this);
        }
    }

    public String getEventName() {
        return this._eventName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isSuspended()) {
            String name;
            try {
                name = this.getSuspendedLocation().sourceName();
            }
            catch (AbsentInformationException e) {
                name = this.getSuspendedLocation().declaringType().name();
            }
            sb.append("Suspended for event: ").append(this._eventName).append(" at (").append(name).append(": ").append(this.getSuspendedLocation().lineNumber()).append(")");
        } else if (this.isPaused()) {
            sb.append("Paused");
        } else {
            sb.append("Running");
        }
        return sb.toString();
    }

    public void muteBreakpoints(boolean mute) {
        Breakpoint breakpoint;
        if (this._vm == null) {
            return;
        }
        EventRequestManager erm = this.getEventRequestManager();
        ArrayList<BreakpointRequest> bpRequests = new ArrayList<BreakpointRequest>(erm.breakpointRequests());
        for (BreakpointRequest req : bpRequests) {
            if (mute) {
                req.setEnabled(false);
                continue;
            }
            Location location = req.location();
            breakpoint = this._bpm.findBreakpoint(location.declaringType().name().replace('$', '.'), location.lineNumber());
            req.setEnabled(breakpoint.isActive());
        }
        ArrayList<ExceptionRequest> exceptionRequests = new ArrayList<ExceptionRequest>(erm.exceptionRequests());
        for (ExceptionRequest req : exceptionRequests) {
            if (mute) {
                req.setEnabled(false);
                continue;
            }
            breakpoint = this._bpm.getExceptionBreakpoint(req.exception().name());
            req.setEnabled(breakpoint.isActive());
        }
    }

    private void run() {
        EventQueue eventQueue = this._vm.eventQueue();
        while (!this._vmExit) {
            try {
                this._eventSet = eventQueue.remove();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this._eventIterator = this._eventSet.eventIterator();
            while (this._eventIterator.hasNext()) {
                Event event = (Event)this._eventIterator.next();
                this._eventName = event.getClass().getSimpleName();
                if (event instanceof StepEvent) {
                    this.handleStepEvent((StepEvent)event);
                    continue;
                }
                if (event instanceof BreakpointEvent) {
                    this.handleBreakpointEvent((BreakpointEvent)event);
                    continue;
                }
                if (event instanceof ExceptionEvent) {
                    this.handleExceptionEvent((ExceptionEvent)event);
                    continue;
                }
                if (event instanceof ClassPrepareEvent) {
                    this.handleClassPrepareEvent((ClassPrepareEvent)event);
                    continue;
                }
                if (event instanceof VMStartEvent) {
                    this.handleVMStartEvent();
                    continue;
                }
                if (event instanceof VMDisconnectEvent) {
                    this.handleVMDisconnectEvent();
                    continue;
                }
                if (event instanceof VMDeathEvent) {
                    this.handleVMDeathEvent();
                    continue;
                }
                this.resumeProgram(true);
            }
            this._eventSet = null;
        }
        this.stopDebugging(false);
    }

    private void handleStepEvent(StepEvent event) {
        this.assignSuspendedState(event, true);
        String fqn = Debugger.getOutermostType(event.location().declaringType());
        EventRequest request = event.request();
        this.getEventRequestManager().deleteEventRequest(request);
        if (FileTreeUtil.find(fqn) != null) {
            Location backOutLoc = (Location)request.getProperty(BACK_OUT_LOCATION);
            if (backOutLoc != null && backOutLoc.lineNumber() == event.location().lineNumber()) {
                if (this.createStep(event.thread(), 1) == null) {
                    throw new IllegalStateException();
                }
                this.resumeProgram(false);
            } else {
                this.consumeRemainingEvents();
                this.handleSuspendLocatableEvent(event);
            }
        } else {
            if (((StepRequest)request).depth() == 1) {
                StepRequest step = this.createStep(event.thread(), 3);
                step.putProperty(BACK_OUT_LOCATION, request.getProperty(FROM_LOCATION));
            }
            this.resumeProgram(false);
        }
    }

    private EventRequestManager getEventRequestManager() {
        return this._vm.eventRequestManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBreakpointEvent(LocatableEvent event) {
        Location loc = event.location();
        String fqn = Debugger.getOutermostType(loc.declaringType());
        int line = loc.lineNumber();
        Boolean temporary = (Boolean)event.request().getProperty(TEMPORARY);
        if (temporary != null && temporary.booleanValue()) {
            this.getEventRequestManager().deleteEventRequest(event.request());
            this.handleSuspendLocatableEvent(event);
        } else {
            Breakpoint breakpoint = null;
            for (Breakpoint bp : this._bpm.getLineBreakpoints()) {
                if (!bp.getFqn().equals(fqn) || bp.getLine() != line) continue;
                breakpoint = bp;
                break;
            }
            if (breakpoint == null) {
                EventRequest request = event.request();
                if (request instanceof ExceptionRequest) {
                    String exceptionName = ((ExceptionRequest)request).exception().name();
                    for (Breakpoint bp : this._bpm.getExceptionBreakpoints()) {
                        if (!bp.getFqn().equals(exceptionName)) continue;
                        breakpoint = bp;
                        break;
                    }
                } else {
                    throw new IllegalStateException("Did not find breakpoint for: " + loc + " Class: " + fqn + " Line: " + line);
                }
            }
            if (breakpoint != null) {
                this.assignSuspendedState(event, true);
                boolean suspend = true;
                try {
                    suspend = breakpoint.condition();
                }
                catch (VMDisconnectedException e) {
                    return;
                }
                finally {
                    this.clearSuspendedState();
                }
                if (suspend) {
                    this.consumeRemainingEvents();
                    this.handleSuspendLocatableEvent(event);
                } else {
                    if (this._eventIterator.hasNext()) {
                        return;
                    }
                    this.releaseRefs();
                    this.resumeProgram(true);
                }
            } else {
                this.resumeProgram(true);
            }
        }
    }

    private void consumeRemainingEvents() {
        while (this._eventIterator.hasNext()) {
            Event event = (Event)this._eventIterator.next();
            if (!(event instanceof StepEvent)) continue;
            this.getEventRequestManager().deleteEventRequest(event.request());
        }
        this.getEventRequestManager().deleteEventRequests(this.getEventRequestManager().stepRequests());
    }

    private void handleExceptionEvent(ExceptionEvent event) {
        this.handleBreakpointEvent(event);
    }

    private void handleVMStartEvent() {
        this.addBreakpoints();
        this.resumeProgram(false);
    }

    private void handleClassPrepareEvent(ClassPrepareEvent event) {
        String className = event.referenceType().name();
        this.addPendingBreakpointFor(className);
        if (this._eventIterator.hasNext()) {
            return;
        }
        this.resumeProgram(true);
    }

    private void handleVMDeathEvent() {
        this.quit();
    }

    private void handleVMDisconnectEvent() {
        this.quit();
    }

    private void quit() {
        this.clearSuspendedState();
        this._vmExit = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSuspendLocatableEvent(LocatableEvent event) {
        this.assignSuspendedState(event, false);
        Object object = this._monitor;
        synchronized (object) {
            this.suspended();
            try {
                this._monitor.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.resumeProgram(false);
    }

    public boolean isSuspended() {
        return this._location != null && !this._temporarilySuspended;
    }

    public void stepOver() {
        this.step(2);
    }

    public void stepInto() {
        this.step(1);
    }

    public void stepOut() {
        this.step(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step(int depth) {
        StepRequest step = this.createStep(this._eventThread, depth);
        if (step == null) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._monitor.notifyAll();
        }
    }

    private StepRequest createStep(ThreadReference eventThread, int depth) {
        if (this.getEventRequestManager().stepRequests().size() > 0) {
            return null;
        }
        StepRequest req = this.getEventRequestManager().createStepRequest(eventThread, -2, depth);
        req.addClassExclusionFilter("sun.*");
        req.addClassExclusionFilter("com.sun.*");
        req.addClassExclusionFilter("gw.*");
        req.addCountFilter(1);
        req.putProperty(FROM_LOCATION, this._location);
        req.enable();
        return req;
    }

    public boolean isPaused() {
        return this._bPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this._monitor;
        synchronized (object) {
            this._vm.suspend();
            this._bPaused = true;
        }
        this.notifyListeners();
    }

    public void dropToFrame(StackFrame frame) {
        if (frame == null) {
            return;
        }
        try {
            if (this.isFirstFrame(frame)) {
                return;
            }
            this.getSuspendedThread().popFrames(frame);
            StackFrame currentFrame = this.getSuspendedThread().frame(0);
            this._location = currentFrame.location();
            this.notifyListeners();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
    }

    private boolean isFirstFrame(StackFrame frame) throws IncompatibleThreadStateException {
        List<StackFrame> frames = this.getSuspendedThread().frames();
        return frame.equals(frames.get(frames.size() - 1));
    }

    private void addBreakpoints() {
        this._bpm.getLineBreakpoints().forEach(this::addBreakpointJdi);
        this._bpm.getExceptionBreakpoints().forEach(this::addBreakpointJdi);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addBreakpointJdi(Breakpoint bp) {
        if (this._vm == null) {
            return;
        }
        List<ReferenceType> list = this._vm.classesByName(bp.getDeclaringFqn_Java());
        if (list.size() > 0) {
            try {
                if (bp.isLineBreakpoint()) {
                    List<Location> locations = list.get(0).locationsOfLine(bp.getLine());
                    if (locations.size() <= 0) return;
                    EventRequestManager erm = this.getEventRequestManager();
                    BreakpointRequest req = erm.createBreakpointRequest(locations.get(0));
                    req.putProperty(TEMPORARY, bp.isTemporary());
                    req.setEnabled(bp.isActive() && (bp.isActiveWhenMuted() || !this._bpm.isMuted()));
                    return;
                }
                EventRequestManager erm = this.getEventRequestManager();
                ExceptionRequest req = erm.createExceptionRequest(list.get(0), bp.isCaughtException(), bp.isUncaughtException());
                req.setEnabled(bp.isActive() && (bp.isActiveWhenMuted() || !this._bpm.isMuted()));
                return;
            }
            catch (AbsentInformationException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.deferAddVmBreakpoint(bp);
        }
    }

    private void deferAddVmBreakpoint(Breakpoint bp) {
        String className = bp.getDeclaringFqn_Java();
        if (this._classPrepareRequests.containsKey(className)) {
            return;
        }
        ClassPrepareRequest request = this.getEventRequestManager().createClassPrepareRequest();
        request.addClassFilter(className);
        request.enable();
        this._classPrepareRequests.put(className, request);
    }

    public void removeBreakpointJdi(Breakpoint bp) {
        if (this._vm == null) {
            return;
        }
        if (bp.isLineBreakpoint()) {
            EventRequestManager erm = this.getEventRequestManager();
            ArrayList<BreakpointRequest> bpRequests = new ArrayList<BreakpointRequest>(erm.breakpointRequests());
            for (BreakpointRequest req : bpRequests) {
                Location location = req.location();
                if (!Debugger.getOutermostType(location.declaringType()).equals(bp.getFqn()) || location.lineNumber() != bp.getLine()) continue;
                erm.deleteEventRequest(req);
            }
        } else {
            EventRequestManager erm = this.getEventRequestManager();
            ArrayList<ExceptionRequest> bpRequests = new ArrayList<ExceptionRequest>(erm.exceptionRequests());
            for (ExceptionRequest req : bpRequests) {
                String fqn = req.exception().name();
                if (!bp.getFqn().equals(fqn)) continue;
                erm.deleteEventRequest(req);
            }
        }
    }

    private void addPendingBreakpointFor(String className) {
        ClassPrepareRequest pendingReq = this._classPrepareRequests.get(className);
        if (pendingReq == null) {
            return;
        }
        Map<Integer, Breakpoint> byLine = this._bpm.getBreakpointsByType(className.replace('$', '.'));
        if (byLine != null) {
            EventRequestManager erm = this.getEventRequestManager();
            ArrayList<BreakpointRequest> bpRequests = new ArrayList<BreakpointRequest>(erm.breakpointRequests());
            block0: for (Breakpoint bp : byLine.values()) {
                for (BreakpointRequest req : bpRequests) {
                    Location location = req.location();
                    if (!Debugger.getOutermostType(location.declaringType()).equals(bp.getFqn()) || location.lineNumber() != bp.getLine()) continue;
                    continue block0;
                }
                this.addBreakpointJdi(bp);
            }
            erm.deleteEventRequest(this._classPrepareRequests.get(className));
        } else {
            Breakpoint bp = this._bpm.getExceptionBreakpoint(className);
            if (bp != null) {
                this.addBreakpointJdi(bp);
                EventRequestManager erm = this.getEventRequestManager();
                erm.deleteEventRequest(this._classPrepareRequests.get(className));
            }
        }
    }

    private void resumeProgram(boolean silent) {
        this.clearSuspendedState();
        this.resumed(silent);
        if (this._eventSet != null) {
            this._eventSet.resume();
        }
    }

    private void stopDebugging(boolean bKill) {
        if (this._vm == null) {
            return;
        }
        try {
            if (bKill) {
                this._vm.exit(1);
            } else {
                this._vm.dispose();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._vm = null;
        this.getGosuPanel().clearDebugger();
    }

    private void suspended() {
        this.notifyListeners();
    }

    private void resumed(boolean silent) {
        this.releaseRefs();
        if (!silent) {
            this.notifyListeners();
        }
    }

    public void retain(ObjectReference ref) {
        if (this._refs.add(ref)) {
            try {
                ref.disableCollection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void releaseRefs() {
        for (ObjectReference objectReference : this._refs) {
            try {
                objectReference.enableCollection();
            }
            catch (Exception exception) {}
        }
        this._refs.clear();
    }

    public static String getOutermostType(ReferenceType type) {
        String name = type.name();
        if (name.contains("$ProxyFor_")) {
            return name;
        }
        int iDollar = name.indexOf(36);
        if (iDollar > 0) {
            name = name.substring(0, iDollar);
        }
        return name;
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    public List<ThreadReference> getThreads() {
        return this._vm.allThreads();
    }

    public ExperimentBuild getClassRedefiner() {
        return this._classRedefiner;
    }

    public void redefineClasses(List<CompiledClass> listCompiledClasses) {
        HashMap<ReferenceType, byte[]> classes = new HashMap<ReferenceType, byte[]>();
        for (CompiledClass cc : listCompiledClasses) {
            List<ReferenceType> referenceTypes = this._vm.classesByName(cc.getType().getName());
            if (referenceTypes.size() <= 0) continue;
            classes.put(referenceTypes.get(0), cc.getBytes());
        }
        try {
            this._vm.redefineClasses(classes);
            EditorUtilities.invokeNowOrLater(() -> JOptionPane.showMessageDialog(LabFrame.instance(), "Reloaded " + classes.size() + " classes"));
        }
        catch (UnsupportedOperationException e) {
            EditorUtilities.invokeNowOrLater(() -> JOptionPane.showMessageDialog(LabFrame.instance(), "Could not reload classes"));
        }
    }
}

