/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import com.sun.jdi.VirtualMachine;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.LabFrame;
import editor.TextComponentWriter;
import editor.run.FqnRunConfig;
import editor.run.IProcessRunner;
import editor.run.RunState;
import editor.util.EditorUtilities;
import editor.util.TaskQueue;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.lang.Gosu;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import manifold.internal.runtime.Bootstrap;

public class InProcessRunner
implements IProcessRunner<FqnRunConfig> {
    private FqnRunConfig _runConfig;

    @Override
    public FqnRunConfig getRunConfig() {
        return this._runConfig;
    }

    @Override
    public Process getProcess() {
        return null;
    }

    @Override
    public RunState getRunState() {
        return RunState.Run;
    }

    @Override
    public VirtualMachine getVm() {
        return null;
    }

    @Override
    public void execute(FqnRunConfig runConfig) {
        try {
            this._runConfig = runConfig;
            ClassLoader loader = InProcessRunner.class.getClassLoader();
            URLClassLoader runLoader = new URLClassLoader(this.getAllUrlsAboveGosuclassProtocol((URLClassLoader)loader), loader.getParent());
            TaskQueue queue = TaskQueue.getInstance("_execute_gosu");
            GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
            gosuPanel.addBusySignal(RunState.Run);
            queue.postTask(() -> {
                GosuEditor.getParserTaskQueue().waitUntilAllCurrentTasksFinish();
                IGosuClass program = (IGosuClass)TypeSystem.getByFullName((String)runConfig.getFqn());
                try {
                    String programResults;
                    Class<?> runnerClass = Class.forName("editor.InProcessRunner", true, runLoader);
                    String fqn = program.getName();
                    this.printRunningMessage(runConfig.getName());
                    String result = null;
                    try {
                        programResults = result = (String)runnerClass.getMethod("run", String.class, List.class).invoke(null, fqn, gosuPanel.getExperiment().getSourcePath().stream().map(File::new).collect(Collectors.toList()));
                    }
                    catch (Throwable throwable) {
                        String programResults2 = result;
                        EventQueue.invokeLater(() -> {
                            gosuPanel.removeBusySignal();
                            if (programResults2 != null) {
                                System.out.print(programResults2);
                            }
                        });
                        manifold.util.ReflectUtil.method(Bootstrap.class, (String)"addOurProtocolHandler", (Class[])new Class[0]).invokeStatic(new Object[0]);
                        throw throwable;
                    }
                    EventQueue.invokeLater(() -> {
                        gosuPanel.removeBusySignal();
                        if (programResults2 != null) {
                            System.out.print(programResults2);
                        }
                    });
                    manifold.util.ReflectUtil.method(Bootstrap.class, (String)"addOurProtocolHandler", (Class[])new Class[0]).invokeStatic(new Object[0]);
                }
                catch (Exception e) {
                    Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
                    throw GosuExceptionUtil.forceThrow((Throwable)cause);
                }
            });
        }
        catch (Throwable t) {
            EditorUtilities.handleUncaughtException(t);
        }
    }

    private void printRunningMessage(String runConfigName) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute(StyleConstants.Foreground, new Color(192, 192, 192));
        TextComponentWriter out = (TextComponentWriter)System.out;
        out.setAttributes(attr);
        System.out.println("Running: " + runConfigName + "...\n");
        out.setAttributes(null);
    }

    private URL[] getAllUrlsAboveGosuclassProtocol(URLClassLoader loader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        boolean bAdd = true;
        for (URL url : loader.getURLs()) {
            if (bAdd && !url.getProtocol().contains("gosu")) {
                urls.add(url);
                continue;
            }
            bAdd = false;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public String run(String typeName, List<IDirectory> classpath) throws Exception {
        Gosu.init(classpath);
        Bootstrap.init();
        IGosuClass gsType = (IGosuClass)TypeSystem.getByFullNameIfValid((String)typeName);
        if (gsType instanceof IGosuProgram) {
            Object result = ((IGosuProgram)gsType).evaluate(null);
            return (String)CommonServices.getCoercionManager().convertValue(result, (IType)JavaTypes.STRING());
        }
        IMethodInfo mainMethod = this.hasStaticMain(gsType);
        if (mainMethod != null) {
            ReflectUtil.invokeStaticMethod((String)gsType.getName(), (String)"main", (Object[])new Object[]{new String[0]});
            return null;
        }
        Gosu.runTest((IGosuClass)gsType);
        return null;
    }

    private IMethodInfo hasStaticMain(IGosuClass gsType) {
        IMethodInfo main = gsType.getTypeInfo().getMethod((CharSequence)"main", new IType[]{JavaTypes.STRING().getArrayType()});
        if (main != null && main.isStatic() && main.getReturnType() == JavaTypes.pVOID()) {
            return main;
        }
        return null;
    }
}

