/*
 * Decompiled with CFR 0.152.
 */
package editor.run;

import editor.run.AbstractRunConfig;
import editor.run.DebugTransport;
import editor.run.IProcessRunner;
import editor.run.OutOfProcessRemote;
import editor.run.RemoteConfigPanel;
import editor.run.RemoteRunConfigParameters;
import editor.util.EditorUtilities;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RemoteRunConfig
extends AbstractRunConfig<RemoteRunConfigParameters> {
    public RemoteRunConfig(RemoteRunConfigParameters params) {
        super(params);
    }

    public RemoteRunConfig() {
    }

    public DebugTransport getTransport() {
        return ((RemoteRunConfigParameters)this.getParams()).getTransport();
    }

    public String getHost() {
        return ((RemoteRunConfigParameters)this.getParams()).getHost();
    }

    public String getPort() {
        return ((RemoteRunConfigParameters)this.getParams()).getPort();
    }

    public String getAddress() {
        return ((RemoteRunConfigParameters)this.getParams()).getAddress();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Icon getIcon() {
        return EditorUtilities.loadIcon("images/remote.png");
    }

    @Override
    public JComponent makePanel(RemoteRunConfigParameters params, Consumer<RemoteRunConfigParameters> changeListener) {
        return new RemoteConfigPanel(params, changeListener);
    }

    @Override
    public boolean isRunnable() {
        return false;
    }

    @Override
    public boolean isDebuggable() {
        return true;
    }

    @Override
    public IProcessRunner run() {
        throw new UnsupportedOperationException("Attempted to run a remote config, only debugging supported");
    }

    @Override
    public IProcessRunner debug() {
        OutOfProcessRemote processRunner = new OutOfProcessRemote();
        processRunner.execute(this);
        return processRunner;
    }
}

