/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.EditorHost;
import editor.LabFrame;
import editor.Scheme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class LabStatusBar
extends JPanel {
    private final CaretHandler _caretListener = new CaretHandler();
    private JLabel _selectionInfo;
    private JLabel _coords;
    private JLabel _status;
    private EditorHost _editor;

    public LabStatusBar() {
        this.configUi();
        EventQueue.invokeLater(() -> LabFrame.instance().getGosuPanel().getEditorTabPane().addSelectionListener(e -> this.update()));
    }

    protected void configUi() {
        this.setBackground(Scheme.active().getMenu());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int iX = 0;
        c.anchor = 13;
        c.fill = 2;
        c.gridx = iX++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 2, 0, 10);
        this._status = new JLabel();
        this.add((Component)this._status, c);
        c.anchor = 13;
        c.fill = 0;
        c.gridx = iX++;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 2, 0, 2);
        this._selectionInfo = new JLabel();
        this._selectionInfo.setMinimumSize(new Dimension(20, this._selectionInfo.getFontMetrics(this.getFont()).getHeight() + this._selectionInfo.getInsets().top * 2));
        this._selectionInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Scheme.active().getControlShadow()), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
        this._selectionInfo.setToolTipText("Selection length");
        this.add((Component)this._selectionInfo, c);
        c.anchor = 13;
        c.fill = 0;
        c.gridx = iX;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 2, 0, 2);
        this._coords = new JLabel();
        this._coords.setMinimumSize(new Dimension(20, this._coords.getFontMetrics(this.getFont()).getHeight() + this._coords.getInsets().top * 2));
        this._coords.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, Scheme.active().getControlShadow()), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
        this._coords.setToolTipText("Line:Column location");
        this.add((Component)this._coords, c);
        EventQueue.invokeLater(this::update);
    }

    public void setStatus(String status) {
        this._status.setText(status);
        this._status.revalidate();
        this._status.repaint();
    }

    private void update() {
        if (this._editor != null) {
            this._editor.getEditor().removeCaretListener(this._caretListener);
            this._editor.getEditor().removeMouseMotionListener(this._caretListener);
        }
        this._editor = LabFrame.instance().getGosuPanel().getCurrentEditor();
        if (this._editor == null) {
            this._coords.setText("");
            this._selectionInfo.setText("");
        } else {
            this._editor.getEditor().addCaretListener(this._caretListener);
            this._editor.getEditor().addMouseMotionListener(this._caretListener);
            this.updateCaret(this._editor);
        }
    }

    private void updateCaret(EditorHost editor) {
        this._coords.setText(this.makeCoords(editor));
        this._selectionInfo.setText(this.makeSelectionInfo(editor));
    }

    private String makeSelectionInfo(EditorHost editor) {
        int start = this._editor.getEditor().getSelectionStart();
        int end = editor.getEditor().getSelectionEnd();
        int len = end - start;
        if (len == 0) {
            return "";
        }
        String chars = String.valueOf(len) + " char" + (len > 1 ? "s" : "");
        int startLine = editor.getEditor().getDocument().getDefaultRootElement().getElementIndex(start);
        int endLine = editor.getEditor().getDocument().getDefaultRootElement().getElementIndex(end);
        int numLines = endLine - startLine + 1;
        String lines = numLines == 1 ? "" : ", " + numLines + " lines";
        return chars + lines;
    }

    private String makeCoords(EditorHost editor) {
        int line = editor.getLineNumberAtCaret();
        int column = editor.getEditor().getCaretPosition() - editor.getLineOffset(line - 1);
        return String.valueOf(line) + ":" + String.valueOf(column + 1);
    }

    private class CaretHandler
    extends MouseAdapter
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.caretUpdate(null);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            LabStatusBar.this.updateCaret(LabFrame.instance().getGosuPanel().getCurrentEditor());
        }
    }
}

