/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import editor.actions.UpdateNotifier;
import gw.util.GosuObjectUtil;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import javax.swing.plaf.basic.BasicButtonUI;

public class LabToolbarButton
extends JButton {
    private static final int DEFAULT_MARGIN = 3;
    private boolean _bConstantBorder;
    private boolean _bShowText;
    private Supplier<String> _tooltip;

    public LabToolbarButton(String text, Icon icon, int iMargin) {
        this(text, icon, iMargin, iMargin);
    }

    public LabToolbarButton(String text, Icon icon, int iMarginW, int iMarginH) {
        super(text, icon);
        this.setUI(BasicButtonUI.createUI(this));
        this.setBorderPainted(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setBackground(Scheme.active().getControl());
        this.setContentAreaFilled(false);
        this.setOpaque(true);
        EventQueue.invokeLater(() -> this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getXpBorderColor()), BorderFactory.createEmptyBorder(iMarginH, iMarginW, iMarginH, iMarginW))));
        this._bShowText = false;
        this.addMouseListener(this.createMouseListener());
    }

    public LabToolbarButton(Action action) {
        this();
        EventQueue.invokeLater(() -> this.setAction(action));
    }

    public LabToolbarButton(String text, Icon icon) {
        this(text, icon, 3);
    }

    public LabToolbarButton(Icon icon, int iMargin) {
        this(null, icon, iMargin);
    }

    public LabToolbarButton(Icon icon) {
        this(icon, 3);
    }

    public LabToolbarButton(String text) {
        this(text, null);
    }

    public LabToolbarButton() {
        this(null, null);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setBackground(this.getParent().getBackground());
    }

    public void setToolTipSupplier(Supplier<String> tooltip) {
        this._tooltip = tooltip;
    }

    protected MouseListener createMouseListener() {
        return new MouseAdapter(){
            Color _bkColor;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (LabToolbarButton.this.isEnabled()) {
                    this._bkColor = LabToolbarButton.this.getBackground();
                    LabToolbarButton.this.setBorderPainted(true);
                    if (LabToolbarButton.this.getModel().isArmed()) {
                        LabToolbarButton.this.setBackground(Scheme.active().getXpHighlightSelectedColor());
                    } else {
                        LabToolbarButton.this.setBackground(Scheme.active().getXpHighlightColor());
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LabToolbarButton.this.setBorderPainted(LabToolbarButton.this.isBorderConstant());
                LabToolbarButton.this.setBackground(this._bkColor != null ? this._bkColor : LabToolbarButton.this.getParent().getBackground());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                LabToolbarButton.this.setBackground(Scheme.active().getXpHighlightSelectedColor());
            }
        };
    }

    @Override
    public void setAction(Action a) {
        super.setAction(a);
        UpdateNotifier.instance().addActionComponent(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public boolean isText() {
        return this._bShowText;
    }

    public void setShowText(boolean bShowText) {
        this._bShowText = bShowText;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        JComponent separator = (JComponent)this.getClientProperty("_separatorComp");
        if (separator != null) {
            separator.setVisible(bVisible);
        }
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(this.isBorderConstant());
    }

    @Override
    public String getText() {
        return this._bShowText ? super.getText() : null;
    }

    @Override
    public String getToolTipText() {
        if (this.getAction() != null) {
            String tip;
            if (this._tooltip != null) {
                tip = this._tooltip.get();
            } else {
                tip = GosuObjectUtil.toString((Object)this.getAction().getValue("ShortDescription"));
                if (tip == null || tip.isEmpty()) {
                    tip = GosuObjectUtil.toString((Object)this.getAction().getValue("Name"));
                }
            }
            String value = (String)this.getAction().getValue("AcceleratorKey");
            if (value != null && !value.isEmpty()) {
                tip = tip + " (" + value + ")";
            }
            return tip;
        }
        return super.getToolTipText();
    }

    public boolean isBorderConstant() {
        return this._bConstantBorder;
    }

    public void setBorderConstant(boolean bConstantBorder) {
        this._bConstantBorder = bConstantBorder;
        this.setBorderPainted(this._bConstantBorder);
    }
}

