/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.Scheme;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class SmartMenu
extends JMenu
implements MenuListener {
    public SmartMenu(String strLabel) {
        super(strLabel);
        this.init();
    }

    private void init() {
        this.setBorderPainted(false);
        this.setOpaque(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addMenuListener(this);
        this.addItemListener(this.createMouseListener());
    }

    protected ItemListener createMouseListener() {
        return new ItemListener(){
            Color _bkColor;

            @Override
            public void itemStateChanged(ItemEvent e) {
                switch (e.getStateChange()) {
                    case 1: {
                        if (!SmartMenu.this.isEnabled()) break;
                        this._bkColor = SmartMenu.this.getBackground();
                        SmartMenu.this.setBorderPainted(true);
                        if (SmartMenu.this.getModel().isArmed()) {
                            SmartMenu.this.setBackground(Scheme.active().getXpHighlightSelectedColor());
                            break;
                        }
                        SmartMenu.this.setBackground(Scheme.active().getXpHighlightColor());
                        break;
                    }
                    case 2: {
                        SmartMenu.this.setBorderPainted(false);
                        SmartMenu.this.setBackground(this._bkColor != null ? this._bkColor : Scheme.active().getMenu());
                    }
                }
            }
        };
    }

    @Override
    public void menuSelected(MenuEvent e) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem item = this.getItem(i);
            if (item == null || item.getAction() == null) continue;
            item.setEnabled(item.getAction().isEnabled());
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }
}

