/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class VerticalLabelUI
extends BasicLabelUI {
    private static Rectangle g_paintIconR = new Rectangle();
    private static Rectangle g_paintTextR = new Rectangle();
    private static Rectangle g_paintViewR = new Rectangle();
    private static Insets g_paintViewInsets = new Insets(0, 0, 0, 0);
    protected boolean _bClockwise;

    public VerticalLabelUI(boolean bClockwise) {
        this._bClockwise = bClockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        Insets insets = c.getInsets();
        dim.width -= insets.left + insets.right;
        dim.height -= insets.top + insets.bottom;
        dim.width += insets.top + insets.bottom;
        dim.height += insets.left + insets.right;
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        g_paintViewInsets = c.getInsets(g_paintViewInsets);
        VerticalLabelUI.g_paintViewR.x = VerticalLabelUI.g_paintViewInsets.top;
        VerticalLabelUI.g_paintViewR.y = VerticalLabelUI.g_paintViewInsets.left;
        VerticalLabelUI.g_paintViewR.height = c.getWidth();
        VerticalLabelUI.g_paintViewR.width = c.getHeight();
        VerticalLabelUI.g_paintViewR.width -= VerticalLabelUI.g_paintViewInsets.top + VerticalLabelUI.g_paintViewInsets.bottom;
        VerticalLabelUI.g_paintViewR.height -= VerticalLabelUI.g_paintViewInsets.left + VerticalLabelUI.g_paintViewInsets.right;
        VerticalLabelUI.g_paintIconR.height = 0;
        VerticalLabelUI.g_paintIconR.width = 0;
        VerticalLabelUI.g_paintIconR.y = 0;
        VerticalLabelUI.g_paintIconR.x = 0;
        VerticalLabelUI.g_paintTextR.height = 0;
        VerticalLabelUI.g_paintTextR.width = 0;
        VerticalLabelUI.g_paintTextR.y = 0;
        VerticalLabelUI.g_paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, g_paintViewR, g_paintIconR, g_paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this._bClockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, VerticalLabelUI.g_paintIconR.x, VerticalLabelUI.g_paintIconR.y);
        }
        if (text != null) {
            int textX = VerticalLabelUI.g_paintTextR.x;
            int textY = VerticalLabelUI.g_paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }

    static {
        labelUI = new VerticalLabelUI(true);
    }
}

