/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class Launcher {
    public static final String JAR_REPO_DIR = "JAR-REPO";
    public static final String JAR_REPO_TXT = "jar-repo.txt";
    private static final String URL_TO_LATEST_GOSU_RELEASE = "https://repository.sonatype.org/service/local/artifact/maven/redirect?r=central-proxy&g=org.gosu-lang.gosu&a=gosu&c=full&e=zip&v=RELEASE";

    public static void main(String[] args) throws IOException {
        try {
            String jarLoc = new File(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
            File appRepo = Launcher.cacheJars(jarLoc);
            Properties props = new Properties();
            ClassLoader loader = Launcher.class.getClassLoader();
            InputStream inProps = loader.getResource("main.properties").openStream();
            props.load(inProps);
            String strProgram = props.getProperty("Program");
            String strBundled = props.getProperty("BundledGosu");
            inProps.close();
            Launcher.addRepoJarPaths(appRepo);
            if (!(strBundled != null && strBundled.equalsIgnoreCase("true") || Launcher.addGosuJarsToLoader())) {
                return;
            }
            List<String> progArgs = Arrays.asList(args);
            URL progClass = loader.getResource(strProgram.replace('.', '/') + ".class");
            if (progClass != null) {
                Class<?> prog = Class.forName(strProgram);
                Method main = prog.getMethod("main", String[].class);
                main.invoke(null, new Object[]{progArgs.toArray(new String[progArgs.size()])});
            } else {
                String jarPaths = Launcher.getRepoJarPaths(appRepo);
                List<String> gosuArgs = Arrays.asList("-classpath", "\"" + jarLoc + jarPaths + "\"", "-fqn", strProgram);
                ArrayList<String> concat = new ArrayList<String>(gosuArgs);
                concat.addAll(progArgs);
                Launcher.launchGosuMain(concat);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    private static void launchGosuMain(List<String> args) throws Exception {
        Class<?> gosuClass = Class.forName("gw.lang.Gosu");
        Method main = gosuClass.getMethod("main", String[].class);
        main.invoke(null, new Object[]{args.toArray(new String[args.size()])});
    }

    private static boolean addGosuJarsToLoader() throws Exception {
        List<File> gosuJars;
        File recentGosu = Launcher.findRecentGosu();
        if (recentGosu == null) {
            int res = JOptionPane.showConfirmDialog(null, "This application requires the Gosu Runtime Environment. Would you like to install it?", "Gosu", 0);
            if (res == 0) {
                Launcher.installGosu();
            } else {
                return false;
            }
        }
        if ((recentGosu = Launcher.findRecentGosu()) != null && !(gosuJars = Launcher.getGosuJars(recentGosu)).isEmpty()) {
            URLClassLoader loader = (URLClassLoader)Launcher.class.getClassLoader();
            Method addUrl = Launcher.getAddUrlMethod();
            for (File csr : gosuJars) {
                addUrl.invoke((Object)loader, csr.toURI().toURL());
            }
            return true;
        }
        return false;
    }

    private static List<File> getGosuJars(File gosuInstallDir) {
        List<File> jars = Collections.emptyList();
        for (File csr : gosuInstallDir.listFiles()) {
            if (csr.isFile() && (csr.getName().contains("gosu-core") || csr.getName().contains("asm") || csr.getName().contains("manifold") || csr.getName().endsWith("tools.jar")) && csr.getName().endsWith(".jar")) {
                if (jars.isEmpty()) {
                    jars = new ArrayList<File>();
                }
                jars.add(csr);
            }
            if (!csr.isDirectory() || (jars = Launcher.getGosuJars(csr)).isEmpty()) continue;
            return jars;
        }
        return jars;
    }

    private static void installGosu() {
        ProgressMonitor progress = new ProgressMonitor(null, "Installing Gosu...", "", 1, 3);
        progress.setProgress(1);
        progress.setNote("Downloading latest Gosu release");
        try {
            URL url = new URL(URL_TO_LATEST_GOSU_RELEASE);
            File outDir = new File(new File(Launcher.getHomeDir(), File.separatorChar + ".Gosu"), "Gosu-" + System.currentTimeMillis());
            Launcher.extractGosu(url, outDir, progress);
            progress.setProgress(3);
            progress.setNote("Finishing up");
            Launcher.writeRecentGosuFile(outDir.getAbsolutePath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void extractGosu(URL url, File to, ProgressMonitor progress) throws Exception {
        try (ZipInputStream ji = new ZipInputStream(url.openStream());){
            String outPath = to.getAbsolutePath();
            byte[] buffer = new byte[2048];
            progress.setProgress(2);
            progress.setNote("Storing Gosu runtime files");
            ZipEntry entry = ji.getNextEntry();
            while (entry != null) {
                String outpath = outPath + "/" + entry.getName();
                if (entry.isDirectory()) {
                    new File(outpath).mkdirs();
                } else {
                    try (FileOutputStream output = new FileOutputStream(outpath);){
                        int len;
                        while ((len = ji.read(buffer)) > 0) {
                            output.write(buffer, 0, len);
                        }
                    }
                }
                entry = ji.getNextEntry();
            }
        }
    }

    private static void writeRecentGosuFile(String dirName) throws IOException {
        File recent = Launcher.getRecentFile();
        recent.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(recent);
        writer.write(dirName + "\n");
        writer.close();
    }

    private static String getHomeDir() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null || !new File(homeDir).exists()) {
            homeDir = System.getenv("USERPROFILE");
        }
        return homeDir;
    }

    private static File findRecentGosu() {
        File file;
        File recent = Launcher.getRecentFile();
        if (!recent.isFile()) {
            return null;
        }
        FileReader reader = new FileReader(recent);
        try {
            int len;
            char[] data = new char[1024];
            Object path = "";
            while ((len = reader.read(data)) > 0) {
                path = (String)path + new String(data, 0, len);
            }
            file = new File(((String)path).trim());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return file;
    }

    private static File getRecentFile() {
        return new File(Launcher.getHomeDir() + File.separatorChar + ".Gosu" + File.separatorChar + "most.recent");
    }

    private static String getRepoJarPaths(File appRepo) {
        StringBuilder sb = new StringBuilder();
        for (File csr : appRepo.listFiles()) {
            String lowerName = csr.getName().toLowerCase();
            if (!lowerName.endsWith(".jar") && !lowerName.endsWith(".zip")) continue;
            sb.append(File.pathSeparator);
            sb.append(csr.getAbsolutePath());
        }
        return sb.toString();
    }

    private static void addRepoJarPaths(File appRepo) throws Exception {
        URLClassLoader loader = (URLClassLoader)Launcher.class.getClassLoader();
        Method addUrl = Launcher.getAddUrlMethod();
        for (File csr : appRepo.listFiles()) {
            String lowerName = csr.getName().toLowerCase();
            if (!lowerName.endsWith(".jar") && !lowerName.endsWith(".zip")) continue;
            addUrl.invoke((Object)loader, csr.toURI().toURL());
        }
    }

    private static Method getAddUrlMethod() throws NoSuchMethodException {
        Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addUrl.setAccessible(true);
        return addUrl;
    }

    private static File cacheJars(String jarLoc) throws IOException {
        File appRepoDir = Launcher.makeAppRepoDir(jarLoc);
        File repoTextFile = new File(appRepoDir, JAR_REPO_TXT);
        if (Launcher.isAlreadyCached(repoTextFile)) {
            return appRepoDir;
        }
        Launcher.deleteDir(appRepoDir);
        appRepoDir.mkdirs();
        try (InputStream in = Launcher.class.getResourceAsStream("JAR-REPO/jar-repo.txt");
             FileOutputStream out = new FileOutputStream(repoTextFile);){
            Launcher.copy(in, out);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Launcher.class.getResourceAsStream("JAR-REPO/jar-repo.txt")));){
            String jar;
            reader.readLine();
            while ((jar = reader.readLine()) != null) {
                if (jar.trim().isEmpty()) {
                    break;
                }
                InputStream in = Launcher.class.getResourceAsStream("JAR-REPO/" + jar);
                try (FileOutputStream out = new FileOutputStream(new File(appRepoDir, jar));){
                    Launcher.copy(in, out);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        return appRepoDir;
    }

    static void deleteDir(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                Launcher.deleteDir(child);
            }
        }
        fileOrDirectory.delete();
    }

    private static boolean isAlreadyCached(File repoTextFile) throws IOException {
        if (repoTextFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(repoTextFile));){
                UUID existingUid = UUID.fromString(reader.readLine());
                try (BufferedReader readFromJar = new BufferedReader(new InputStreamReader(Launcher.class.getResourceAsStream("JAR-REPO/jar-repo.txt")));){
                    UUID jarUid = UUID.fromString(readFromJar.readLine());
                    if (existingUid.equals(jarUid)) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    private static File makeAppRepoDir(String jarLoc) {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null || !new File(homeDir).exists()) {
            homeDir = System.getenv("USERPROFILE");
        }
        File home = new File(homeDir);
        String appName = Launcher.getAppName(jarLoc);
        File repoDir = new File(home, ".Gosu" + File.separatorChar + JAR_REPO_DIR + File.separatorChar + appName);
        repoDir.mkdirs();
        return repoDir;
    }

    private static String getAppName(String jarLoc) {
        String appName = new File(jarLoc).getName();
        int iDot = appName.lastIndexOf(46);
        if (iDot >= 0) {
            appName = appName.substring(0, iDot);
        }
        appName = Launcher.maybeRemoveAppendage(appName);
        return appName;
    }

    private static String maybeRemoveAppendage(String appName) {
        int iSpace = appName.lastIndexOf(32);
        if (iSpace >= 0) {
            String duplicate = appName.substring(iSpace + 1, appName.length());
            char open = duplicate.charAt(0);
            char close = duplicate.charAt(duplicate.length() - 1);
            if (open == '(' && close == ')' && duplicate.length() > 2) {
                String dupNumber = appName.substring(iSpace + 2, appName.length() - 1);
                try {
                    Integer.parseInt(dupNumber);
                    appName = appName.substring(0, iSpace);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return appName;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buf = new byte[1024];
        while ((count = in.read(buf)) >= 0) {
            out.write(buf, 0, count);
        }
        out.flush();
    }
}

