/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.TypeInPackageType;
import editor.util.EditorUtilities;
import gw.lang.reflect.IBlockType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IFunctionType;
import gw.lang.reflect.IType;

public class BeanInfoNode
implements Comparable<BeanInfoNode> {
    protected static final int PRIMARY = 0;
    protected static final int SECONDARY = 1;
    private IType _type;
    private String _strDisplayName;

    public BeanInfoNode(IType type, String strDisplayName) {
        this._type = type;
        this._strDisplayName = strDisplayName;
    }

    public BeanInfoNode(IType type) {
        this._type = type;
    }

    public BeanInfoNode(String strDisplayName) {
        this._strDisplayName = strDisplayName;
    }

    public IType getType() {
        return this._type;
    }

    public String getDisplayName() {
        return this._strDisplayName;
    }

    public void setDisplayName(String strDisplayName) {
        this._strDisplayName = strDisplayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getValue() {
        return null;
    }

    public void setValue(String strValue) {
        throw new RuntimeException("not implemented");
    }

    public IFeatureInfo getFeatureInfo() {
        return null;
    }

    public static String getTypeName(IType type) {
        Object strType = type.isArray() ? BeanInfoNode.getTypeName(type.getComponentType()) + "[]" : type.getRelativeName();
        return strType;
    }

    public String getPathComponent(boolean bFeatureLiteralCompletion) {
        if (this._type instanceof IFunctionType && !(this._type instanceof IBlockType)) {
            return EditorUtilities.buildFunctionIntellisenseString(bFeatureLiteralCompletion, (IFunctionType)this._type);
        }
        if (this._type instanceof TypeInPackageType) {
            return this.getName().replaceAll("\\$", ".");
        }
        return this.getName();
    }

    protected int getTypePriority() {
        return 0;
    }

    @Override
    public int compareTo(BeanInfoNode o) {
        if (this.getTypePriority() != o.getTypePriority()) {
            return this.getTypePriority() > o.getTypePriority() ? 1 : -1;
        }
        String myDisplayName = this.getDisplayName();
        String otherDisplayName = o.getDisplayName();
        int result = Boolean.valueOf(myDisplayName.startsWith("$")).compareTo(otherDisplayName.startsWith("$"));
        if (result == 0) {
            result = myDisplayName.compareToIgnoreCase(otherDisplayName);
        }
        return result;
    }
}

