/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.util.TextComponentUtil;
import gw.lang.parser.IParseTree;
import gw.lang.parser.expressions.IStringLiteralExpression;
import gw.lang.parser.statements.IStatementList;
import gw.util.GosuStringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class DynamicSelectionManager
implements CaretListener {
    private int _start;
    private boolean _updating;
    private GosuEditor _gsEditor;
    private ArrayList<Point> _expansionList;
    private int _expansionIndex;

    public DynamicSelectionManager(GosuEditor parent) {
        parent.getEditor().addCaretListener(this);
        this._gsEditor = parent;
    }

    public void expandSelection() {
        this.expandSelection(true);
    }

    public void expandSelection(boolean updateIndex) {
        this._updating = true;
        try {
            ArrayList<Point> expansionsList = this.getExpansionsList();
            if (updateIndex && this._expansionIndex == 0) {
                this.updateIndexBasedOnCurrentSelection(true);
            }
            this._expansionIndex = Math.min(this._expansionIndex + 1, expansionsList.size() - 1);
            this.setSelection(expansionsList.get(this._expansionIndex));
        }
        finally {
            this._updating = false;
        }
    }

    public void reduceSelection() {
        this._updating = true;
        try {
            ArrayList<Point> expansionsList = this.getExpansionsList();
            if (this._expansionIndex == 0) {
                this.updateIndexBasedOnCurrentSelection(false);
            }
            this._expansionIndex = Math.max(this._expansionIndex - 1, 0);
            this.setSelection(expansionsList.get(this._expansionIndex));
        }
        finally {
            this._updating = false;
        }
    }

    private void updateIndexBasedOnCurrentSelection(boolean expanding) {
        int selectionEnd;
        int selectionStart = this._gsEditor.getEditor().getSelectionStart();
        if (selectionStart != (selectionEnd = this._gsEditor.getEditor().getSelectionEnd())) {
            Point point;
            Point currentSelectionPoint = new Point(selectionStart, selectionEnd);
            while (this._expansionIndex < this._expansionList.size() && this.contains(currentSelectionPoint, point = this._expansionList.get(this._expansionIndex))) {
                ++this._expansionIndex;
            }
            if (expanding && this._expansionIndex > 0) {
                --this._expansionIndex;
            }
        }
    }

    private void setSelection(Point point) {
        Rectangle visibleRect = this._gsEditor.getEditor().getVisibleRect();
        this._gsEditor.getEditor().getCaret().setDot(point.x);
        this._gsEditor.getEditor().getCaret().moveDot(point.y);
        this._gsEditor.getEditor().scrollRectToVisible(visibleRect);
    }

    private ArrayList<Point> getExpansionsList() {
        if (this._expansionList == null) {
            this._expansionList = new ArrayList();
            Point initialPoint = new Point(this._start, this._start);
            this._expansionList.add(initialPoint);
            this.addNextSelection(this._expansionList);
        }
        return this._expansionList;
    }

    private void addNextSelection(ArrayList<Point> expansionList) {
        Point boundingPoint;
        Point initialPoint = expansionList.get(expansionList.size() - 1);
        if (initialPoint.x == 0 && initialPoint.y >= this._gsEditor.getText().length() || initialPoint.x < 0 || initialPoint.y > this._gsEditor.getText().length() + 1) {
            while (initialPoint.x < 0 || initialPoint.y > this._gsEditor.getText().length() + 1) {
                expansionList.remove(expansionList.size() - 1);
                initialPoint = expansionList.get(expansionList.size() - 1);
            }
            return;
        }
        IParseTree spanningLocation = this._gsEditor.getDeepestLocationSpanning(initialPoint.x, initialPoint.y);
        if (spanningLocation != null) {
            int offset = spanningLocation.getOffset() + this.getOffsetShift();
            if (offset < initialPoint.x || initialPoint.y <= spanningLocation.getExtent() + this.getOffsetShift()) {
                boundingPoint = this.makePoint(spanningLocation);
            } else {
                IParseTree newParent;
                IParseTree parent = spanningLocation.getParent();
                while (parent != null && parent.getOffset() + this.getOffsetShift() == offset && parent.getExtent() == spanningLocation.getExtent() && parent != (newParent = parent.getParent())) {
                    parent = newParent;
                }
                spanningLocation = parent;
                if (parent != null) {
                    int lineAtEnd;
                    Point point = this.makePoint(parent);
                    int lineAtStart = TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), point.x);
                    if (lineAtStart != (lineAtEnd = TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), point.y))) {
                        int newX = TextComponentUtil.getLineStart(this._gsEditor.getText(), point.x);
                        if (GosuStringUtil.isWhitespace((String)this._gsEditor.getText().substring(newX, point.x))) {
                            point.x = newX;
                        }
                    }
                    boundingPoint = point;
                } else {
                    boundingPoint = new Point(0, this._gsEditor.getText().length() + 1);
                }
            }
        } else {
            boundingPoint = new Point(0, this._gsEditor.getText().length() + 1);
        }
        int lineAtx = TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), initialPoint.x);
        int lineAty = TextComponentUtil.getLineAtPosition(this._gsEditor.getEditor(), initialPoint.y);
        if (!(lineAtx != lineAty || initialPoint.x != initialPoint.y && GosuStringUtil.isWhitespace((String)this._gsEditor.getText().substring(initialPoint.x, initialPoint.y - 1)))) {
            Point lineEndSelection;
            int start = TextComponentUtil.getLineStart(this._gsEditor.getText(), initialPoint.x);
            int end = TextComponentUtil.getLineEnd(this._gsEditor.getText(), initialPoint.y);
            if (end < this._gsEditor.getText().length()) {
                ++end;
            }
            if (this.contains(boundingPoint, lineEndSelection = new Point(start, end)) && !this.contains(initialPoint, lineEndSelection) && !GosuStringUtil.isWhitespace((String)this._gsEditor.getText().substring(lineEndSelection.x, lineEndSelection.y))) {
                boundingPoint = lineEndSelection;
            }
            if (initialPoint.x == initialPoint.y) {
                int wordEnd;
                int wordStart = this.getWordStart(this._gsEditor.getEditor(), initialPoint.x);
                if (wordStart < (wordEnd = this.getWordEnd(this._gsEditor.getEditor(), initialPoint.y))) {
                    Point wordSelection = new Point(wordStart, wordEnd);
                    String possibleWord = this._gsEditor.getText().substring(wordStart, wordEnd - 1);
                    if (this.contains(boundingPoint, wordSelection) && !this.contains(initialPoint, wordSelection) && this.isIdentifier(possibleWord)) {
                        boundingPoint = wordSelection;
                    }
                } else {
                    wordStart = this.getWordStart(this._gsEditor.getEditor(), initialPoint.x - 1);
                    if (wordStart < (wordEnd = this.getWordEnd(this._gsEditor.getEditor(), initialPoint.y - 1))) {
                        Point wordSelection = new Point(wordStart, wordEnd);
                        String possibleWord = this._gsEditor.getText().substring(wordStart, wordEnd - 1);
                        if (this.contains(boundingPoint, wordSelection) && !this.contains(initialPoint, wordSelection) && this.isIdentifier(possibleWord)) {
                            boundingPoint = wordSelection;
                        }
                    }
                }
            }
        }
        if (spanningLocation != null) {
            Point withinStmtList;
            if (spanningLocation.getParsedElement() instanceof IStatementList && this.contains(boundingPoint, withinStmtList = this.findNewLineWithinStatementList(spanningLocation)) && !this.contains(initialPoint, withinStmtList)) {
                boundingPoint = withinStmtList;
            }
            if (spanningLocation.getParsedElement() instanceof IStringLiteralExpression) {
                Point justInsideStringLiteral = this.makePoint(spanningLocation);
                ++justInsideStringLiteral.x;
                --justInsideStringLiteral.y;
                if (this.contains(boundingPoint, justInsideStringLiteral) && !this.contains(initialPoint, justInsideStringLiteral) && this.contains(justInsideStringLiteral, initialPoint)) {
                    boundingPoint = justInsideStringLiteral;
                }
            }
        }
        if (!expansionList.contains(boundingPoint)) {
            expansionList.add(boundingPoint);
            this.addNextSelection(expansionList);
        }
    }

    private Point findNewLineWithinStatementList(IParseTree spanningLocation) {
        int start = spanningLocation.getOffset() + this.getOffsetShift();
        int end = spanningLocation.getExtent() + this.getOffsetShift();
        int startEnd = TextComponentUtil.getLineEnd(this._gsEditor.getText(), start);
        int endStart = TextComponentUtil.getLineStart(this._gsEditor.getText(), end);
        ++startEnd;
        List list = spanningLocation.getChildren();
        if (list != null) {
            for (IParseTree parseTree : list) {
                if (parseTree.getOffset() + this.getOffsetShift() < startEnd) {
                    startEnd = parseTree.getOffset() + this.getOffsetShift();
                }
                if (parseTree.getExtent() + this.getOffsetShift() + 1 <= endStart) continue;
                endStart = parseTree.getExtent() + this.getOffsetShift() + 1;
            }
        }
        return new Point(startEnd, endStart);
    }

    private boolean isIdentifier(String possibleWord) {
        char[] chars;
        for (char aChar : chars = possibleWord.toCharArray()) {
            if (Character.isJavaIdentifierPart(aChar)) continue;
            return false;
        }
        return true;
    }

    private int getWordEnd(JTextComponent editor, int y) {
        try {
            while (y < editor.getText().length() && Character.isJavaIdentifierPart(editor.getText(y, 1).charAt(0))) {
                ++y;
            }
            return y;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private int getWordStart(JTextComponent editor, int x) {
        try {
            while (x >= 0 && Character.isJavaIdentifierPart(editor.getText(x, 1).charAt(0))) {
                --x;
            }
            return x + 1;
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    private boolean contains(Point point1, Point point2) {
        return point1.x <= point2.x && point1.y >= point2.y;
    }

    private Point makePoint(IParseTree spanningLocation) {
        return new Point(Math.max(0, spanningLocation.getOffset() + this.getOffsetShift()), Math.min(this._gsEditor.getText().length() + 1, spanningLocation.getExtent() + this.getOffsetShift() + 1));
    }

    private int getOffsetShift() {
        return this._gsEditor.getParser().getOffsetShift();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this._updating) {
            this._start = e.getDot();
            this._expansionList = null;
            this._expansionIndex = 0;
        }
    }
}

