/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.CodeRefactorManager;
import editor.ContextHelpUtil;
import editor.CopyBuffer;
import editor.DefaultContextMenuHandler;
import editor.DynamicSelectionManager;
import editor.EditorHost;
import editor.EditorHostTextPane;
import editor.EditorScrollPane;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuDocument;
import editor.GosuEditorKit;
import editor.GosuPanel;
import editor.IContextMenuHandler;
import editor.IGosuPanel;
import editor.ILineInfoManager;
import editor.IScriptEditor;
import editor.JavadocPopup;
import editor.LabFrame;
import editor.MouseInEditorHandler;
import editor.ParameterInfoPopup;
import editor.ParseExceptionResolver;
import editor.ParserFeedbackPanel;
import editor.PathCompletionIntellisense;
import editor.Scheme;
import editor.ScopeHighlighter;
import editor.ScriptEditorMouseWheelHandler;
import editor.ScriptEditorPopupHandler;
import editor.ScrollableEditorRootPane;
import editor.SmartFixManager;
import editor.SourceType;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointManager;
import editor.search.SearchElement;
import editor.search.SearchLocation;
import editor.search.UsageSearcher;
import editor.search.UsageTarget;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import editor.util.IReplaceWordCallback;
import editor.util.LabToolbarButton;
import editor.util.SettleModalEventQueue;
import editor.util.TaskQueue;
import editor.util.TextComponentUtil;
import gw.lang.GosuShop;
import gw.lang.IIssueContainer;
import gw.lang.gosuc.GosuIssueContainer;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IExpression;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IGosuValidator;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IImplicitTypeAsExpression;
import gw.lang.parser.expressions.IInferredNewExpression;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.INameInDeclaration;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.IParameterDeclaration;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IClassDeclaration;
import gw.lang.parser.statements.IClassFileStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IMethodCallStatement;
import gw.lang.parser.statements.INamespaceStatement;
import gw.lang.parser.statements.IPropertyStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.parser.statements.IUsesStatement;
import gw.lang.parser.statements.IUsesStatementList;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.undo.CompoundEdit;

public class GosuEditor
extends EditorHost
implements IScriptEditor,
IGosuPanel,
ITypeLoaderListener {
    public static final int MIN_LINENUMBER_WIDTH = 16;
    private JLabel _labelCaption;
    private ParserFeedbackPanel _panelFeedback;
    private EditorHostTextPane _editor;
    private GosuDocumentHandler _docHandler;
    private IContextMenuHandler<IScriptEditor> _contextMenuHandler;
    private volatile IGosuParser _parser;
    private boolean _bStatement;
    private boolean _bProgram;
    private boolean _bClass;
    private boolean _bEnhancement;
    private boolean _bEmptyTextOk;
    private ISymbolTable _symTable;
    private IReplaceWordCallback _replaceWordCallback;
    private boolean _bTemplate;
    private IScriptabilityModifier _scriptabilityModifier;
    private AtomicUndoManager _undoMgr;
    private EditorScrollPane _scroller;
    private ParseResultsException _pe;
    private boolean _bTestResource;
    private boolean _bAcceptUses;
    private IGosuClass _parsedGosuClass;
    private Map<Integer, IFunctionStatement> _functionStmtsByLineNumber;
    private IGosuValidator _validator;
    private SmartFixManager _smartFixManager;
    private ScopeHighlighter _ctxHighlighter;
    private DynamicSelectionManager _selectionManager;
    private CodeRefactorManager _codeManager;
    private static final Rectangle TEST_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private ITypeUsesMap _typeUsesMap;
    private ITypeUsesMap _typeUsesMapFromMostRecentParse;
    private JavadocPopup _javadocPopup;
    private IType _programSuperType;
    private boolean _bAccessPrivateMembers;
    private IType _expectedType;

    public GosuEditor(ILineInfoManager lineInfoRenderer, AtomicUndoManager undoMgr, IScriptabilityModifier scriptabilityConstraint, IContextMenuHandler<IScriptEditor> contextMenuHandler, boolean bStatement, boolean bEmptyTextOk) {
        this(null, lineInfoRenderer, undoMgr, scriptabilityConstraint, contextMenuHandler, bStatement, bEmptyTextOk);
    }

    public GosuEditor(ISymbolTable symTable, ILineInfoManager lineInfoRenderer, AtomicUndoManager undoMgr, IScriptabilityModifier scriptabilityConstraint, IContextMenuHandler<IScriptEditor> contextMenuHandler, boolean bStatement, boolean bEmptyTextOk) {
        super(undoMgr);
        if (lineInfoRenderer != null) {
            lineInfoRenderer.setEditor(this);
        }
        this._symTable = symTable;
        this._undoMgr = undoMgr;
        this._contextMenuHandler = contextMenuHandler == null ? new DefaultContextMenuHandler() : contextMenuHandler;
        this._bStatement = bStatement;
        this._bEmptyTextOk = bEmptyTextOk;
        this._bAcceptUses = true;
        this._docHandler = new GosuDocumentHandler();
        this._parser = null;
        this._scriptabilityModifier = scriptabilityConstraint;
        this._replaceWordCallback = new ReplaceWordCallback();
        this._ctxHighlighter = new ScopeHighlighter(this);
        this.configureLayout(lineInfoRenderer);
        this._smartFixManager = new SmartFixManager(this);
        this._selectionManager = new DynamicSelectionManager(this);
        this._codeManager = new CodeRefactorManager(this);
    }

    void configureLayout(ILineInfoManager lineInfoRenderer) {
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setLayout(new BorderLayout());
        this._editor = this.createEditorPane();
        ToolTipManager.sharedInstance().registerComponent(this._editor);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        ScrollableEditorRootPane editorRootPane = new ScrollableEditorRootPane(this._editor);
        editorRootPane.setContentPane(this._editor);
        editorRootPane.setBorder(null);
        GosuEditorKit kit = new GosuEditorKit();
        this._editor.setEditorKitForContentType("text/gosu", kit);
        this._editor.setContentType("text/gosu");
        this._editor.setMargin(new Insets(3, 3, 3, 3));
        this._editor.setFont(new Font(GosuEditorKit.getStylePreferences().getFontFamily(), 0, GosuEditorKit.getStylePreferences().getFontSize()));
        this._editor.setBackground(Scheme.active().getWindow());
        this._editor.setForeground(Scheme.active().getWindowText());
        this._editor.putClientProperty("caretWidth", 2);
        this._editor.setCaretColor(Scheme.active().getWindowText());
        this._editor.setEditable(true);
        this._editor.addKeyListener(new EditorHost.EditorKeyHandler());
        this._editor.addMouseListener(new ScriptEditorPopupHandler(this, this._contextMenuHandler));
        this._editor.addMouseWheelListener(new ScriptEditorMouseWheelHandler(this));
        this._editor.addCaretListener(new ErrorAtCaretHandler());
        this._editor.addCaretListener(this._ctxHighlighter);
        this._editor.addFocusListener(this._ctxHighlighter);
        this._editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GosuEditor.this._smartFixManager.updateState();
            }
        });
        TypeSystem.addTypeLoaderListenerAsWeakRef((ITypeLoaderListener)this);
        MouseInEditorHandler mouseInEditorHandler = new MouseInEditorHandler(this);
        this._editor.addMouseListener(mouseInEditorHandler);
        this._editor.addMouseMotionListener(mouseInEditorHandler);
        this._editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }
        });
        this.addDocumentListener();
        this.addKeyHandlers();
        EventQueue.invokeLater(() -> this._editor.setSize(1000, this._editor.getHeight()));
        this._scroller = new EditorScrollPane(lineInfoRenderer, this._editor, editorRootPane);
        this._scroller.setBorder(null);
        JViewport vp = this._scroller.getViewport();
        vp.setScrollMode(1);
        this.add("Center", this._scroller);
        this._labelCaption = new JLabel("<Script Part>");
        this._labelCaption.setBackground(Scheme.active().getControl());
        this._labelCaption.setOpaque(true);
        this._labelCaption.setFont(this.getFont().deriveFont(1));
        this._labelCaption.setBorder(new EmptyBorder(0, 4 + 16 * (lineInfoRenderer != null ? 2 : 1), 0, 0));
        this.add("North", this._labelCaption);
        this._panelFeedback = new ParserFeedbackPanel();
        this.add("East", this._panelFeedback);
    }

    @Override
    public void setLabel(String label) {
        this._labelCaption.setText(label);
    }

    @Override
    public DocumentListener getDocHandler() {
        return this._docHandler;
    }

    @Override
    public JComponent getFeedbackPanel() {
        return this._panelFeedback;
    }

    @Override
    public IIssueContainer getIssues() {
        return new GosuIssueContainer(this.getParseResultsException());
    }

    @Override
    protected void addKeyHandlers() {
        super.addKeyHandlers();
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " T"), "_typeInfo");
        this._editor.getActionMap().put("_typeInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.displayTypeInfoAtCurrentLocation();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift T"), "_clipCopyTypeInfo");
        this._editor.getActionMap().put("_clipCopyTypeInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.clipCopyTypeInfoAtCurrentLocation();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " W"), "_selectWord");
        this._editor.getActionMap().put("_selectWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.selectWord();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift W"), "_narrowSelectWord");
        this._editor.getActionMap().put("_narrowSelectWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.narrowSelectWord();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " P"), "_parameterInfo");
        this._editor.getActionMap().put("_parameterInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuEditor.this.isCompletionPopupShowing()) {
                    GosuEditor.this.displayParameterInfoPopup(GosuEditor.this._editor.getCaretPosition());
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " B"), "_declaration");
        this._editor.getActionMap().put("_declaratino", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.gotoDeclaration();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke("F1"), "_javadocHelp");
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " Q"), "_javadocHelp");
        this._editor.getActionMap().put("_javadocHelp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.displayJavadocHelp(GosuEditor.this.getDeepestLocationAtCaret());
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift F7"), "_highlightUsagesInView");
        this._editor.getActionMap().put("_highlightUsagesInView", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuEditor.this.getScriptPart() != null && GosuEditor.this.getScriptPart().getContainingType() != null) {
                    GosuEditor.this.highlightUsagesOfFeatureUnderCaret();
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " alt V"), "_extractVariable");
        this._editor.getActionMap().put("_extractVariable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.extractVariable();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(38, EditorUtilities.CONTROL_KEY_MASK | 0x40), "_moveSelectionUp");
        this._editor.getActionMap().put("_moveSelectionUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.moveSelectionUp();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(40, EditorUtilities.CONTROL_KEY_MASK | 0x40), "_moveSelectionDown");
        this._editor.getActionMap().put("_moveSelectionDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.moveSelectionDown();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(10, 512), "_smartFix");
        this._editor.getActionMap().put("_smartFix", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.smartFix();
            }
        });
    }

    public boolean isAccessAll() {
        return this._bAccessPrivateMembers;
    }

    public void setAccessAll(boolean accessPrivateMembers) {
        this._bAccessPrivateMembers = accessPrivateMembers;
    }

    public IType getExpectedType() {
        return this._expectedType;
    }

    public void setExpectedType(IType type) {
        this._expectedType = type;
    }

    @Override
    public String getLineCommentDelimiter() {
        return "//";
    }

    public void highlightUsagesOfFeatureUnderCaret() {
        UsageTarget target;
        this.setHighlightMode(EditorHost.HighlightMode.USAGES);
        this.removeAllHighlights();
        IParseTree deepestLocationAtCaret = this.getDeepestLocationAtCaret();
        if (deepestLocationAtCaret != null && (target = UsageTarget.makeTargetFromCaret()) != null) {
            List<SearchLocation> locations = new UsageSearcher(target, true, false).searchLocal();
            for (SearchLocation loc : locations) {
                try {
                    this.getEditor().getHighlighter().addHighlight(loc._iOffset, loc._iOffset + loc._iLength, EditorHost.LabHighlighter.USAGE);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        this._panelFeedback.repaint();
    }

    @Override
    protected void hideMiscPopups() {
        super.hideMiscPopups();
        this._smartFixManager.resetSmartHelpState();
    }

    public void selectWord() {
        if (!this.isCompletionPopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.expandSelection();
        }
    }

    public void selectWordForMouseClick() {
        if (!this.isCompletionPopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.expandSelection(false);
        }
    }

    public void narrowSelectWord() {
        if (!this.isCompletionPopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.reduceSelection();
        }
    }

    private boolean isCaretInEditor() {
        return this._editor.getSelectionStart() <= this._editor.getDocument().getLength();
    }

    @Override
    public void gotoDeclaration() {
        if (!this.isCompletionPopupShowing()) {
            this.gotoDeclarationAtCursor();
        }
    }

    protected EditorHostTextPane createEditorPane() {
        return new EditorHostTextPane(this);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public SourceType getSourceType() {
        if (this.isProgram()) {
            return SourceType.PROGRAM;
        }
        if (this.isClass() || this.isEnhancement()) {
            return SourceType.CLASS;
        }
        if (this.isTemplate()) {
            return SourceType.TEMPLATE;
        }
        if (this.isStatement()) {
            return SourceType.STATEMENT;
        }
        return SourceType.EXPRESSION;
    }

    public void setProgram(boolean bProgram) {
        this._bProgram = bProgram;
    }

    public void setClass(boolean bClass) {
        this._bClass = bClass;
    }

    public void setEnhancement(boolean bExtension) {
        this._bEnhancement = bExtension;
    }

    public boolean isProgram() {
        return this._bProgram;
    }

    public boolean isClass() {
        return this._bClass;
    }

    public boolean isEnhancement() {
        return this._bEnhancement;
    }

    public boolean isStatement() {
        return this._bStatement;
    }

    public void setStatement(boolean bStatement) {
        this._bStatement = bStatement;
    }

    public void setTemplate(boolean bTemplate) {
        this._bTemplate = bTemplate;
    }

    public boolean isTemplate() {
        return this._bTemplate;
    }

    @Override
    public EditorHostTextPane getEditor() {
        return this._editor;
    }

    public IScriptabilityModifier getScriptabilityModifier() {
        return this._scriptabilityModifier;
    }

    public ParseResultsException getParseResultsException() {
        return this._pe;
    }

    public boolean hasParseResultsException() {
        return this._pe != null;
    }

    @Override
    public void refresh(String content) {
        content = GosuStringUtil.replace((String)content, (String)"\r\n", (String)"\n");
        this.getEditor().setText(content);
        EventQueue.invokeLater(() -> this.getUndoManager().discardAllEdits());
    }

    @Override
    protected void addDocumentListener() {
        AbstractDocument doc = (AbstractDocument)this._editor.getDocument();
        if (doc != null) {
            doc.addDocumentListener(this._docHandler);
            doc.addDocumentListener(this._ctxHighlighter);
        }
    }

    public void setTestResource(boolean testResource) {
        this._bTestResource = testResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(String strText, boolean forceCodeCompletion, boolean changed) {
        if (this.isParserSuspended()) {
            return;
        }
        if (this.isAccessAll()) {
            TypeSystem.pushIncludeAll();
        }
        try {
            ITypeRef containingType;
            if (this._parser == null) {
                this._parser = GosuParserFactory.createParser((ISymbolTable)this.getSymbolTable(), (IScriptabilityModifier)this._scriptabilityModifier);
                this._parser.setThrowParseExceptionForWarnings(true);
                this._parser.setDontOptimizeStatementLists(true);
                this._parser.setValidator(this._validator);
                this._parser.setWarnOnCaseIssue(true);
                this._parser.setEditorParser(true);
                if (this._typeUsesMap != null) {
                    this._parser.setTypeUsesMap(this._typeUsesMap);
                }
            } else if (this._parser.getSymbolTable() != this.getSymbolTable()) {
                this._parser.setSymbolTable(this.getSymbolTable());
            }
            if (changed && this.getScriptPart() != null && !this.areMoreThanOneParserTasksGoingToUpdateContainingType() && (containingType = (ITypeRef)this.getScriptPart().getContainingType()) != null) {
                try {
                    TypeSystem.refresh((ITypeRef)containingType);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (!this._bEmptyTextOk || strText != null && strText.length() > 0) {
                ClassType classType;
                this._parser.setScript((CharSequence)strText);
                if (this.getClassType() == ClassType.Template) {
                    this._parser.setTokenizerInstructor(GosuShop.createTemplateInstructor((ISourceCodeTokenizer)this._parser.getTokenizer()));
                }
                if (this._parser.getSymbolTable() != null) {
                    this._parser.putDfsDeclsInTable(this._parser.getSymbolTable());
                }
                if ((classType = this.getClassType()) != null) {
                    this._parsedGosuClass = this._parser.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)strText, this._bTestResource, classType), true, true);
                } else if (this._bStatement) {
                    this._parser.parseStatements(this.getScriptPart());
                } else {
                    IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
                    ParserOptions options = new ParserOptions().withParser(this._parser).withSuperType(this._programSuperType);
                    if (this._expectedType != null) {
                        options.withExpectedType(this._expectedType);
                    }
                    IParseResult result = programParser.parseExpressionOrProgram(strText, this._parser.getSymbolTable(), options);
                    this._parsedGosuClass = result.getProgram();
                    ParseResultsException parseRes = this._parsedGosuClass.getParseResultsException();
                    if (parseRes != null) {
                        throw parseRes;
                    }
                }
            } else if (this._parser != null) {
                this._parser.setScript((CharSequence)"");
            }
            this.clearParseException();
        }
        catch (ParseResultsException ex) {
            IClassFileStatement classFileStmt;
            IClassStatement classStatement;
            if (ex.getParsedElement() instanceof IClassFileStatement && (classStatement = (classFileStmt = (IClassFileStatement)ex.getParsedElement()).getClassStatement()) != null) {
                this._parsedGosuClass = classStatement.getGosuClass();
            }
            if (this.areMoreThanOneParserTasksPendingForThisEditor() && !forceCodeCompletion) {
                return;
            }
            this._pe = ex;
            this.handleParseException(forceCodeCompletion);
            return;
        }
        finally {
            if (this.isAccessAll()) {
                TypeSystem.popIncludeAll();
            }
            if (!this.areMoreThanOneParserTasksPendingForThisEditor() && this._parser != null) {
                this._functionStmtsByLineNumber = this.storeFunctionsByLineNumber(this._parsedGosuClass, null);
                this._typeUsesMapFromMostRecentParse = this._parser.getTypeUsesMap().copy();
                List locations = this._parser.getLocations();
                EventQueue.invokeLater(() -> {
                    if (this.getDocument().getLocations() == null) {
                        this._editor.repaint();
                    }
                    this.getDocument().setLocations(locations);
                    this.getDocument().setLocationsOffset(this._parser.getOffsetShift());
                });
            }
        }
        if (this.areMoreThanOneParserTasksPendingForThisEditor()) {
            return;
        }
        EventQueue.invokeLater(() -> this._panelFeedback.update(this));
    }

    public void showFeedback(boolean show) {
        this._panelFeedback.setVisible(show);
        this.revalidate();
    }

    private ClassType getClassType() {
        ClassType classType = null;
        if (this.isTemplate()) {
            classType = ClassType.Template;
        } else if (this.isClass()) {
            classType = ClassType.Class;
        } else if (this.isProgram()) {
            classType = ClassType.Program;
        } else if (this.isEnhancement()) {
            classType = ClassType.Enhancement;
        }
        return classType;
    }

    public ITypeUsesMap getTypeUsesMapFromMostRecentParse() {
        return this._typeUsesMapFromMostRecentParse;
    }

    private Map<Integer, IFunctionStatement> storeFunctionsByLineNumber(IGosuClass gsClass, Map<Integer, IFunctionStatement> functionStmtsByLineNumber) {
        if (gsClass == null || this._parsedGosuClass instanceof IGosuEnhancement) {
            return null;
        }
        if (functionStmtsByLineNumber == null) {
            functionStmtsByLineNumber = new HashMap<Integer, IFunctionStatement>();
        }
        ArrayList functionStatements = new ArrayList();
        gsClass.getClassStatement().getContainedParsedElementsByType(IFunctionStatement.class, functionStatements);
        for (IFunctionStatement fs : functionStatements) {
            functionStmtsByLineNumber.put(fs.getLocation().getLineNum(), fs);
        }
        return functionStmtsByLineNumber;
    }

    public Map<Integer, IFunctionStatement> getFunctionsByLineNumber() {
        return this._functionStmtsByLineNumber == null ? Collections.emptyMap() : this._functionStmtsByLineNumber;
    }

    protected void clearParseException() {
        this._pe = null;
        EventQueue.invokeLater(() -> this.getDocument().setParseResultsException(null));
    }

    public void setValidator(IGosuValidator validator) {
        this._validator = validator;
        if (this._parser != null) {
            this._parser.setValidator(this._validator);
        }
    }

    private void handleParseException(boolean forceCodeCompletion) {
        EventQueue.invokeLater(() -> this.handleParseException(this._pe, forceCodeCompletion));
    }

    protected void handleParseException(ParseResultsException e, boolean bForceCodeCompletion) {
        this.handleCodeCompletion(bForceCodeCompletion);
        this.getDocument().setParseResultsException(e);
        this._panelFeedback.update(this);
    }

    private void handleCodeCompletion(boolean bForceCodeCompletion) {
        if (this._parser == null) {
            return;
        }
        if (bForceCodeCompletion) {
            this.handleCompleteCode();
        }
    }

    public IType findExpectedTypeErrorAtCaret() {
        List errors = this.getIssuesNearPos(this._editor.getCaretPosition());
        if (errors == null || errors.isEmpty()) {
            IParseTree location = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(this._editor.getCaretPosition() - this._parser.getOffsetShift()), (boolean)false);
            if (location != null && location.getParsedElement().hasParseExceptions()) {
                errors = location.getParsedElement().getParseIssues();
            } else {
                return null;
            }
        }
        IType typeExpected = null;
        for (IParseIssue issue : errors) {
            if (issue instanceof ParseException && (typeExpected = issue.getExpectedType()) != null) break;
        }
        if (typeExpected == null) {
            typeExpected = ParseExceptionResolver.resolvePossibleContextTypesFromEmptyMethodCalls(this.getExpressionAtCaret(), this._editor);
        }
        return typeExpected;
    }

    @Override
    public IGosuParser getParser() {
        return this._parser;
    }

    @Override
    public GosuDocument getDocument() {
        return (GosuDocument)this._editor.getDocument();
    }

    @Override
    public EditorScrollPane getScroller() {
        return this._scroller;
    }

    public IReplaceWordCallback getReplaceWordCallback() {
        return this._replaceWordCallback;
    }

    @Override
    public ISymbolTable getSymbolTable() {
        if (this._symTable == null) {
            this._symTable = new StandardSymbolTable(true);
        }
        return this._symTable;
    }

    public void resetSymbolTable(ISymbolTable newSymbols) {
        this.setSymbolTable(newSymbols);
        this._parser = null;
        this.parse();
    }

    public void setSymbolTable(ISymbolTable newSymbols) {
        this._symTable = newSymbols;
    }

    @Override
    public AtomicUndoManager getUndoManager() {
        return this._undoMgr;
    }

    @Override
    public void gotoNextError() {
        ParseResultsException pre = this.getParseResultsException();
        if (pre == null) {
            return;
        }
        int iPos = this._editor.getCaretPosition();
        List pes = pre.getParseExceptions();
        IParseIssue first = null;
        for (IParseIssue pe : pes) {
            if (pe.getTokenStart() <= iPos || first != null && pe.getTokenStart() >= first.getTokenStart()) continue;
            first = pe;
        }
        if (first != null) {
            this.getEditor().requestFocusInWindow();
            this.getEditor().setCaretPosition(first.getTokenStart());
        }
    }

    @Override
    protected void handleDot(ISymbolTable transientSymTable) {
        if (transientSymTable == null) {
            return;
        }
        if (this.isCompletionPopupShowing()) {
            return;
        }
        String strWordAtCaret = TextComponentUtil.getWordAtCaret(this._editor);
        if (strWordAtCaret == null || strWordAtCaret.length() == 0 || !Character.isLetterOrDigit(strWordAtCaret.charAt(0))) {
            strWordAtCaret = TextComponentUtil.getPartialWordBeforeCaret(this._editor);
        }
        if (this.isCompleteCode() || strWordAtCaret.equals(".") || strWordAtCaret.equals("#") || strWordAtCaret.equals(":")) {
            this.handleDotNow(transientSymTable);
        }
    }

    void handleDotNow(ISymbolTable transientSymTable) {
        this.dismissCompletionPopup();
        this.displayPathCompletion(transientSymTable);
    }

    void displayPathCompletion(ISymbolTable transientSymTable) {
        if (this._bTemplate) {
            transientSymTable.putSymbol(GosuShop.createSymbol((CharSequence)"printContent", (IType)new FunctionType("printContent", (IType)JavaTypes.pVOID(), new IType[]{JavaTypes.STRING(), JavaTypes.pBOOLEAN()}), null));
        }
        PathCompletionIntellisense.instance().complete(this, transientSymTable);
    }

    void displayPathCompletionPopup(boolean bFeatureLiteralCompletion) {
        JPopupMenu completionPopup = this.getCompletionPopup();
        if (((BeanInfoPopup)completionPopup).isDOA()) {
            return;
        }
        ((BeanInfoPopup)completionPopup).addNodeChangeListener(e -> {
            CompoundEdit undoAtom = this._undoMgr.getUndoAtom();
            if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Text Change")) {
                this._undoMgr.endUndoAtom();
            }
            undoAtom = this.getUndoManager().beginUndoAtom("Code Completion");
            try {
                BeanTree completionSelection = (BeanTree)e.getSource();
                String strRef = completionSelection.makePath(bFeatureLiteralCompletion);
                int dotPosition = this._editor.getCaretPosition() - 1;
                String s = this._editor.getText();
                dotPosition = TextComponentUtil.findCharacterPositionOnLine(dotPosition, s, '.', TextComponentUtil.Direction.BACKWARD);
                if (dotPosition == -1 && (dotPosition = TextComponentUtil.findCharacterPositionOnLine(this._editor.getCaretPosition() - 1, s, '#', TextComponentUtil.Direction.BACKWARD)) == -1) {
                    return;
                }
                TextComponentUtil.replaceWordAtCaretDynamic(this.getEditor(), strRef, this.getReplaceWordCallback(), true, ((BeanInfoPopup)completionPopup).isReplaceWholeWord());
                if (e instanceof BeanInfoPopup.DotWasTypedChangeEvent) {
                    return;
                }
                this._editor.requestFocus();
                EditorUtilities.fixSwingFocusBugWhenPopupCloses(this);
                this._editor.repaint();
            }
            finally {
                this.getUndoManager().endUndoAtom(undoAtom);
            }
        });
        this.displayCompletionPopup(this._editor.getCaretPosition());
    }

    public void clipCopyTypeInfoAtCurrentLocation() {
        IType type = this.getTypeAtCaretPosition();
        if (type == null) {
            return;
        }
        LabFrame.instance().getGosuPanel().getClipboard().setContents(new StringSelection(type.getName()), null);
    }

    public void displayTypeInfoAtCurrentLocation() {
        Object displayHTML;
        IType type = this.getTypeAtCaretPosition();
        IExpression expr = this.getExpressionAtCaret();
        if (expr != null && expr.getParent() instanceof IImplicitTypeAsExpression) {
            type = ((IImplicitTypeAsExpression)expr.getParent()).getType();
        }
        IType typeAtCursor = type;
        final JPopupMenu popup = new JPopupMenu();
        popup.setLayout(new BorderLayout());
        boolean foundType = true;
        Color typeColor = Scheme.active().getCodeTypeLiteral();
        String hexTypeColor = String.format("#%02x%02x%02x", typeColor.getRed(), typeColor.getGreen(), typeColor.getBlue());
        if (typeAtCursor != null) {
            displayHTML = typeAtCursor instanceof IMetaType ? "<html>Type:&nbsp;<span style=\"font-family: monospaced; color: " + hexTypeColor + "\"><b>Type&lt;</b>" + HTMLEscapeUtil.escape(((IMetaType)type).getType().getName()) + "<b>&gt;</b></span></html>" : "<html>Type:&nbsp;<span style=\"font-family: monospaced; color: " + hexTypeColor + "\"><b>" + HTMLEscapeUtil.escape(type.getName()) + "</b></span></html>";
        } else {
            displayHTML = "No type found at point";
            foundType = false;
        }
        final JLabel label = new JLabel((String)displayHTML);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Scheme.active().getTooltipBackground());
        panel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 1));
        panel.add((Component)label, "Center");
        if (foundType) {
            final IType finalType = type;
            LabToolbarButton copyBtn = new LabToolbarButton(new AbstractAction("copy", EditorUtilities.loadIcon("images/Copy.png")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorUtilities.getClipboard().setContents(new StringSelection(finalType.getName()), null);
                    CopyBuffer.instance().captureState();
                }
            });
            panel.add((Component)copyBtn, "East");
        }
        panel.setPreferredSize(new Dimension(panel.getPreferredSize().width + 20, panel.getPreferredSize().height + 4));
        popup.add((Component)panel, "Center");
        try {
            Rectangle rectangle = this.getCaretLocation();
            popup.show(this, rectangle.x + 15, rectangle.y - 20);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.requestFocus();
                    label.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            label.removeKeyListener(this);
                            popup.setVisible(false);
                        }
                    });
                }
            });
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Rectangle getCaretLocation() throws BadLocationException {
        Rectangle rectangle = this.getEditor().modelToView(this.getEditor().getCaretPosition());
        return SwingUtilities.convertRectangle(this.getEditor(), rectangle, this);
    }

    public void extractVariable() {
        this._codeManager.extractVariable();
    }

    public IType getTypeAtCaretPosition() {
        String atCaret = TextComponentUtil.getWordAtCaret(this.getEditor());
        if (GosuStringUtil.isEmpty((String)atCaret)) {
            return null;
        }
        IParseTree deepest = this.getDeepestLocationAtCaret();
        if (deepest == null) {
            return null;
        }
        IParsedElement parsedElement = deepest.getParsedElement();
        return this.getTypeFrom(parsedElement);
    }

    private IType getTypeFrom(IParsedElement pe) {
        if (pe instanceof IClassDeclaration) {
            return ((IClassDeclaration)pe).getGSClass();
        }
        if (pe instanceof INameInDeclaration) {
            if ((pe = pe.getParent()) instanceof IVarStatement) {
                IVarStatement varStmt = (IVarStatement)pe;
                return varStmt.getType();
            }
            if (pe instanceof IParameterDeclaration) {
                return this.getTypeFrom(pe);
            }
        } else {
            if (pe instanceof ILocalVarDeclaration) {
                ILocalVarDeclaration local = (ILocalVarDeclaration)pe;
                return local.getSymbol().getType();
            }
            if (pe instanceof IExpression) {
                return ((IExpression)pe).getType();
            }
        }
        return null;
    }

    void replaceLocationAtCaret(String strReplacement) {
        IParseTree deepest = this.getDeepestLocationAtCaret();
        if (deepest == null) {
            return;
        }
        this.replaceLocation(deepest, strReplacement);
    }

    void replaceLocation(IParseTree location, String strReplacement) {
        this._editor.setCaretPosition(location.getOffset());
        this._editor.moveCaretPosition(location.getOffset() + location.getLength());
        this._editor.replaceSelection(strReplacement);
    }

    IExpression getExpressionAtCaret() {
        return this.getExpressionAtPos(this._editor.getCaretPosition());
    }

    IExpression getExpressionAtPos(int iPos) {
        IParsedElement pe;
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(iPos - this._parser.getOffsetShift()), (boolean)true);
        if (locationBeforeDot != null && (pe = locationBeforeDot.getParsedElement()) instanceof IExpression) {
            return (IExpression)pe;
        }
        return null;
    }

    int getPositionAtStartOfExpressionAtCaret() {
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(this._editor.getCaretPosition() - this._parser.getOffsetShift()), (boolean)true);
        return locationBeforeDot.getOffset();
    }

    public IExpression getExpressionContainingCharacterBeforeCaret() {
        IParsedElement pe;
        int iPos = this._editor.getCaretPosition() - this._parser.getOffsetShift();
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(iPos - 1), (int)iPos, (boolean)true);
        if (locationBeforeDot != null && (pe = locationBeforeDot.getParsedElement()) instanceof IExpression) {
            return (IExpression)pe;
        }
        return null;
    }

    @Override
    public ISymbolTable getSymbolTableAtCursor() {
        return this.getSymbolTableAtOffset(this._editor.getCaretPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISymbolTable getSymbolTableAtOffset(int offset) {
        block16: {
            StringBuffer sb = new StringBuffer(this._editor.getText());
            sb.insert(offset, "; +yennikcm ;");
            IGosuParser parserJavadoc = GosuParserFactory.createParser((ISymbolTable)this.getSymbolTable(), (IScriptabilityModifier)this._scriptabilityModifier);
            parserJavadoc.setEditorParser(true);
            parserJavadoc.setScript((CharSequence)sb.toString());
            try {
                TypeSystem.lock();
                try {
                    if (this.isProgram()) {
                        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
                        ParserOptions options = new ParserOptions().withParser(parserJavadoc);
                        IParseResult result = programParser.parseExpressionOrProgram(sb.toString(), parserJavadoc.getSymbolTable(), options);
                        IGosuProgram parsedGosuClass = result.getProgram();
                        ParseResultsException parseResultsException = parsedGosuClass.getParseResultsException();
                        if (parseResultsException != null) {
                            throw parseResultsException;
                        }
                    } else if (this.isClass()) {
                        parserJavadoc.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)sb, this._bTestResource, ClassType.Class), true, true);
                    } else if (this.isEnhancement()) {
                        parserJavadoc.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)sb, this._bTestResource, ClassType.Enhancement), true, true);
                    } else if (this._bStatement) {
                        parserJavadoc.parseStatements(this.getScriptPart());
                    } else {
                        parserJavadoc.parseExpOrProgram(this.getScriptPart());
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }
            catch (ParseResultsException pe) {
                List errors = pe.getIssuesFromPos(offset + 2);
                if (errors.isEmpty()) {
                    errors = pe.getIssuesFromPos(offset);
                }
                if (errors.isEmpty()) break block16;
                for (IParseIssue error : errors) {
                    if (error.getSymbolTable() == null) continue;
                    return error.getSymbolTable();
                }
            }
        }
        return this.getSymbolTable();
    }

    protected void displayCompletionPopup(int iPosition) {
        if (!this._editor.isShowing()) {
            return;
        }
        if (this.isResultOfUndo()) {
            return;
        }
        try {
            Rectangle rcBounds = this.getPositionFromPoint(iPosition);
            if (rcBounds != TEST_RECTANGLE) {
                this.getCompletionPopup().show(this._editor, rcBounds.x, rcBounds.y + rcBounds.height);
            }
            EventQueue.invokeLater(() -> {
                this._editor.requestFocus();
                this._editor.repaint();
            });
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    private Rectangle getPositionFromPoint(int iPosition) throws BadLocationException {
        Rectangle rectangle = this._editor.modelToView(iPosition);
        if (rectangle == null) {
            rectangle = TEST_RECTANGLE;
        }
        return rectangle;
    }

    private boolean isResultOfUndo() {
        return Math.abs(this.getUndoManager().getLastUndoTime() - System.currentTimeMillis()) < 400L;
    }

    public ParameterInfoPopup displayParameterInfoPopup(int iPosition) {
        return ParameterInfoPopup.invoke(this, iPosition);
    }

    @Override
    public void gotoDeclarationAtCursor() {
        IParseTree deepestParseTree = this.getDeepestLocationAtCaret();
        if (deepestParseTree == null) {
            return;
        }
        IParsedElement deepestParsedElementAtCaret = deepestParseTree.getParsedElement();
        this.gotoDeclaration(deepestParsedElementAtCaret);
    }

    public void gotoDeclaration(IParsedElement pe) {
        UsageTarget target = UsageTarget.makeTarget(pe);
        if (target != null) {
            SearchElement targetPe = target.getTargetElement();
            if (targetPe == null) {
                return;
            }
            int prevCaretPos = this.getEditor().getCaretPosition();
            IType type = targetPe.getEnclosingType();
            if (type != this.getParsedClass()) {
                while (type.isParameterizedType()) {
                    type = type.getGenericType();
                }
                FileTree fileTree = FileTreeUtil.find(type.getName());
                if (fileTree != null) {
                    Path sourceFile = fileTree.getFileOrDir();
                    if (sourceFile != null) {
                        LabFrame.instance().getGosuPanel().openFile(sourceFile, true);
                        SettleModalEventQueue.instance().run();
                    }
                } else {
                    return;
                }
            }
            LabFrame.instance().getGosuPanel().getCurrentEditor().getEditor().setCaretPosition(targetPe.getOffset());
            GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
            EditorHost currentEditor = gosuPanel.getCurrentEditor();
            int currentCaretPos = currentEditor.getEditor().getCaretPosition();
            if (currentEditor == this && currentCaretPos != prevCaretPos) {
                gosuPanel.getTabSelectionHistory().addNavigationHistory(this, prevCaretPos, currentCaretPos);
            }
        }
    }

    @Override
    public String getSelectedText() {
        return this._editor.getSelectedText();
    }

    void displayJavadocHelp(IParseTree parseTree) {
        String strHelpText = this.getContextHelp(parseTree);
        if (strHelpText == null) {
            return;
        }
        try {
            this.dismissCompletionPopup();
            Rectangle rcCaretBounds = this._editor.modelToView(parseTree.getOffset() + this._parser.getOffsetShift());
            this._javadocPopup = new JavadocPopup(strHelpText, this);
            if (rcCaretBounds != TEST_RECTANGLE) {
                this._javadocPopup.show(this._editor, rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
            }
            EventQueue.invokeLater(() -> {
                this._editor.requestFocus();
                this._editor.repaint();
            });
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    String getContextHelp(IParseTree parseTree) {
        return ContextHelpUtil.getContextHelp(parseTree);
    }

    @Override
    public String getTooltipMessage(MouseEvent event) {
        if (this._parser == null) {
            return null;
        }
        int iPos = this.getEditor().viewToModel(event.getPoint());
        return this.getErrorMessagesAt(this.getIssuesFromPos(iPos));
    }

    private List<IParseIssue> getIssuesFromPos(int iPos) {
        if (this._editor == null) {
            return null;
        }
        ParseResultsException pe = this.getParseResultsException();
        if (pe == null) {
            return null;
        }
        List parseIssues = pe.getIssuesFromPos(iPos);
        try {
            int backwardPos = iPos;
            while (Character.isWhitespace(this._editor.getText(--backwardPos, 1).charAt(0))) {
                parseIssues.addAll(pe.getIssuesFromPos(backwardPos));
            }
            if (parseIssues.isEmpty()) {
                int forwardPos = iPos;
                while (Character.isWhitespace(this._editor.getText(++forwardPos, 1).charAt(0))) {
                    parseIssues.addAll(pe.getIssuesFromPos(forwardPos));
                }
                if (parseIssues.isEmpty()) {
                    parseIssues.addAll(pe.getIssuesFromPos(forwardPos + 1));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parseIssues;
    }

    private List<IParseIssue> getIssuesNearPos(int iPos) {
        List<IParseIssue> issues = this.getIssuesFromPos(iPos);
        if (issues != null && !issues.isEmpty()) {
            return issues;
        }
        if (this._editor == null) {
            return null;
        }
        ParseResultsException pe = this.getParseResultsException();
        if (pe == null) {
            return null;
        }
        int iDelta = Integer.MAX_VALUE;
        IParseIssue error = null;
        for (IParseIssue e : pe.getParseExceptions()) {
            Element root = this._editor.getDocument().getRootElements()[0];
            int iLine = root.getElementIndex(iPos) + 1;
            int iCurrentDelta = iPos - e.getTokenEnd();
            if (iCurrentDelta < 0 || iLine != e.getLine()) continue;
            try {
                String strTextBetweenPosAndError = this._editor.getText(e.getTokenEnd(), iPos - e.getTokenEnd());
                if (strTextBetweenPosAndError.trim().length() > 0) {
                }
            }
            catch (BadLocationException e1) {}
            continue;
            if (iCurrentDelta >= iDelta && (iCurrentDelta != iDelta || e.getTokenStart() < error.getTokenStart() || e.getExpectedType() == null)) continue;
            iDelta = iCurrentDelta;
            error = e;
        }
        if (error != null) {
            issues = new ArrayList<IParseIssue>(2);
            issues.add(error);
            return issues;
        }
        return null;
    }

    private String getErrorMessagesAt(List parseExceptions) {
        if (parseExceptions == null || parseExceptions.isEmpty()) {
            return null;
        }
        Object strFeedback = "<html>";
        for (int i = 0; i < parseExceptions.size(); ++i) {
            String strTypeExpected;
            ParseException pe;
            IType typeExpected;
            if (i > 0) {
                strFeedback = (String)strFeedback + "<br><hr>";
            }
            IParseIssue pi = (IParseIssue)parseExceptions.get(i);
            strFeedback = (String)strFeedback + HTMLEscapeUtil.escape(pi.getUIMessage());
            if (!(pi instanceof ParseException) || (typeExpected = (pe = (ParseException)pi).getExpectedType()) == null || (strTypeExpected = ParseResultsException.getExpectedTypeName((IType)typeExpected)).length() <= 0) continue;
            strFeedback = (String)strFeedback + "<br>Expected Type:" + HTMLEscapeUtil.escape(strTypeExpected);
        }
        return strFeedback;
    }

    public boolean acceptsUses() {
        return this._bAcceptUses;
    }

    public void setAcceptUses(boolean acceptUses) {
        this._bAcceptUses = acceptUses;
    }

    @Override
    public boolean canAddBreakpoint(int line) {
        IParseTree location = this.getStatementAtLine(line);
        if (location == null) {
            return false;
        }
        IParsedElement parsedElement = location.getParsedElement();
        return !(parsedElement instanceof IStatementList) && !(parsedElement instanceof IFunctionStatement) && !(parsedElement instanceof IPropertyStatement) && !(parsedElement instanceof IClassStatement) && !(parsedElement instanceof IClassFileStatement) && !(parsedElement instanceof IUsesStatement) && !(parsedElement instanceof IUsesStatementList) && !(parsedElement instanceof INamespaceStatement) && (!(parsedElement instanceof IVarStatement) || ((IVarStatement)parsedElement).getHasInitializer());
    }

    @Override
    public IParseTree getDeepestLocationAtCaret() {
        this.waitForParser();
        return this.getDeepestLocation(this._editor.getCaretPosition(), true);
    }

    IParseTree getDeepestLocation(Point pt) {
        int iOffset = this._editor.viewToModel(pt);
        if (iOffset < 0) {
            return null;
        }
        return this.getDeepestLocation(iOffset, true);
    }

    IParseTree getDeepestLocation(int iPos, boolean strict) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)strict);
    }

    IParseTree getDeepestLocationSpanning(int start, int end) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestLocationSpanning((List)locations, (int)(start - this._parser.getOffsetShift()), (int)(end - this._parser.getOffsetShift()), (boolean)true);
    }

    @Override
    public int getOffsetOfDeepestStatementLocationAtPos(int caretPosition, boolean strict) {
        IParseTree stmt = this.getDeepestStatementLocationAtPos(caretPosition, strict);
        if (stmt == null) {
            return -1;
        }
        return stmt.getOffset();
    }

    @Override
    public IParseTree getDeepestStatementLocationAtCaret() {
        return this.getDeepestStatementLocationAtPos(this._editor.getCaretPosition());
    }

    public IParseTree getDeepestStatementLocationAtPos(int iPos, boolean bStrict) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestStatementLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)bStrict);
    }

    public IParseTree getDeepestStatementLocationAtPos(int iPos) {
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestStatementLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)false);
    }

    @Override
    public IParseTree getStatementAtLineAtCaret() {
        int iLineNum = this._editor.getDocument().getDefaultRootElement().getElementIndex(this._editor.getCaretPosition()) + 1;
        return this.getStatementAtLine(iLineNum);
    }

    @Override
    public IParseTree getStatementAtLine(int iLineNum) {
        if (this._parser != null) {
            List locations = this._parser.getLocations();
            return IParseTree.Search.getStatementAtLine((List)locations, (int)(iLineNum - this._parser.getLineNumShift()), IStatementList.class);
        }
        return null;
    }

    @Override
    public String getTypeAtLine(int line) {
        IParseTree statementAtLine = this.getStatementAtLine(line);
        return statementAtLine == null ? null : (statementAtLine.getParsedElement().getGosuClass() == null ? this.getScriptPart().getContainingType().getName() : statementAtLine.getParsedElement().getGosuClass().getName());
    }

    @Override
    public IParseTree getStatementAtLineOrExpression(int iLine) {
        IParseTree statement = this.getStatementAtLine(iLine);
        return this.returnStatementOrExpression(statement);
    }

    @Override
    public IParseTree getStatementAtLineAtCaretOrExpression() {
        IParseTree statement = this.getStatementAtLineAtCaret();
        return this.returnStatementOrExpression(statement);
    }

    private IParseTree returnStatementOrExpression(IParseTree statement) {
        if (statement != null) {
            return statement;
        }
        if (this._parser.getLocations().size() == 1 && ((IParseTree)this._parser.getLocations().get(0)).getParsedElement() instanceof IExpression) {
            return (IParseTree)this._parser.getLocations().get(0);
        }
        return null;
    }

    public IParsedElement getFunctionCallAtCaret() {
        IParseTree location = this.getDeepestLocationAtCaret();
        if (location == null) {
            return null;
        }
        IParsedElement parsedElement = location.getParsedElement();
        return this.findFunction(parsedElement);
    }

    public IParsedElement findFunction(IParsedElement parsedElement) {
        if (parsedElement == null) {
            return null;
        }
        while (!(parsedElement instanceof IMethodCallExpression || parsedElement instanceof IMethodCallStatement || parsedElement instanceof IBeanMethodCallExpression || parsedElement instanceof INewExpression && !(parsedElement instanceof IInferredNewExpression))) {
            if (parsedElement.getParent() == null) {
                return null;
            }
            parsedElement = parsedElement.getParent();
        }
        return parsedElement;
    }

    public IParsedElement getRootParsedElement() {
        IParseTree location = this.getDeepestLocationAtCaret();
        if (location == null) {
            return null;
        }
        IParsedElement parsedElement = location.getParsedElement();
        while (parsedElement.getParent() != null) {
            parsedElement = parsedElement.getParent();
        }
        return parsedElement;
    }

    void moveSelectionUp() {
        this._codeManager.moveSelectionUp();
    }

    void moveSelectionDown() {
        this._codeManager.moveSelectionDown();
    }

    private void smartFix() {
        this._smartFixManager.performFix();
    }

    public void addToUses(String strType) {
        this._codeManager.addToUses(strType, this._bTemplate, this._bProgram);
    }

    public void makeReadOnly(boolean bReadOnly) {
        this._editor.setEditable(!bReadOnly);
    }

    @Override
    public void setTypeUsesMap(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap;
    }

    @Override
    public void setProgramSuperType(IType baseClass) {
        this._programSuperType = baseClass;
    }

    public IGosuClass getParsedClass() {
        return this._parsedGosuClass;
    }

    public JavadocPopup getJavadocPopup() {
        return this._javadocPopup;
    }

    public void refreshed() {
        this.parse();
    }

    public void refreshedTypes(RefreshRequest refreshRequest) {
        if (refreshRequest.types != null) {
            for (String name : refreshRequest.types) {
                if (this.getParsedClass() == null || !name.equals(this.getParsedClass().getName())) continue;
                return;
            }
        }
    }

    @Override
    public JComponent asJComponent() {
        return this;
    }

    class ReplaceWordCallback
    implements IReplaceWordCallback {
        ReplaceWordCallback() {
        }

        @Override
        public boolean shouldReplace(String strWord) {
            return Character.isJavaIdentifierPart(strWord.charAt(0));
        }
    }

    class ErrorAtCaretHandler
    implements CaretListener {
        ErrorAtCaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            if (TaskQueue.getInstance("_intellisenseParser").size() == 0) {
                GosuEditor.this.handleCodeCompletion(false);
            }
        }
    }

    class GosuDocumentHandler
    implements DocumentListener {
        GosuDocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.resizeEditor();
            GosuEditor.this.parse();
            this.updateBreakpoints(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.resizeEditor();
            GosuEditor.this.parse();
            this.updateBreakpoints(e);
        }

        private void updateBreakpoints(DocumentEvent e) {
            int linesInserted;
            if (GosuEditor.this._scroller.getLineInfoMgr() == null) {
                return;
            }
            DocumentEvent.ElementChange change = e.getChange(e.getDocument().getDefaultRootElement());
            if (change != null && (linesInserted = change.getChildrenAdded().length - change.getChildrenRemoved().length) != 0 && GosuEditor.this.getScriptPart() != null) {
                BreakpointManager bpm = LabFrame.instance().getGosuPanel().getBreakpointManager();
                ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>(bpm.getLineBreakpoints());
                String fqn = GosuEditor.this.getScriptPart().getContainingTypeName();
                for (Breakpoint bp : breakpoints) {
                    if (!fqn.equals(bp.getFqn())) continue;
                    bpm.removeBreakpoint(bp);
                    bp = this.updateBreakpoint(bp, linesInserted, e);
                    bpm.toggleLineBreakpoint(GosuEditor.this, bp.getFqn(), bp.getDeclaringFqn(), bp.getLine());
                }
                GosuEditor.this._scroller.getAdviceColumn().repaint();
            }
        }

        private Breakpoint updateBreakpoint(Breakpoint bp, int linesInserted, DocumentEvent e) {
            int firstLine = e.getDocument().getDefaultRootElement().getElementIndex(e.getOffset()) + 1;
            int line = bp.getLine();
            if (bp.getLine() > firstLine) {
                line = bp.getLine() + linesInserted;
            }
            return new Breakpoint(bp.getFqn(), bp.getDeclaringFqn(), line);
        }

        private void resizeEditor() {
            Dimension dim = GosuEditor.this._editor.getPreferredSize();
            if (GosuEditor.this._editor.getWidth() != dim.width) {
                GosuEditor.this._editor.setSize(dim);
                GosuEditor.this.validate();
            }
        }
    }
}

