/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.sun.jdi.Location;
import com.sun.jdi.VirtualMachine;
import editor.ClasspathDialog;
import editor.CommonMenus;
import editor.EditorFactory;
import editor.EditorHost;
import editor.EditorTabHistoryHandler;
import editor.ExperimentView;
import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuDocument;
import editor.GosuEditor;
import editor.GosuPanelDocumentFilter;
import editor.GotoTypePopup;
import editor.ITabHistoryContext;
import editor.LabFrame;
import editor.MessagesPanel;
import editor.NavigationHistory;
import editor.NewFilePopup;
import editor.ReopenExperimentPopup;
import editor.RunMe;
import editor.Scheme;
import editor.ScriptChangeHandler;
import editor.SystemPanel;
import editor.TypeNameCache;
import editor.debugger.BreakpointManager;
import editor.debugger.DebugPanel;
import editor.debugger.Debugger;
import editor.run.IProcessRunner;
import editor.run.IRunConfig;
import editor.run.RunState;
import editor.search.SearchPanel;
import editor.shipit.ExperimentBuild;
import editor.shipit.ShipIt;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.undo.AtomicUndoManager;
import editor.util.BrowserUtil;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.GosuTextifier;
import editor.util.LabStatusBar;
import editor.util.LabToolbarButton;
import editor.util.LabelListPopup;
import editor.util.SettleModalEventQueue;
import editor.util.SmartMenu;
import editor.util.SmartMenuItem;
import editor.util.SourceFileCreator;
import editor.util.ToolBar;
import editor.util.TypeNameUtil;
import gw.fs.IFile;
import gw.fs.IResource;
import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.util.Printer;
import gw.internal.ext.org.objectweb.asm.util.TraceClassVisitor;
import gw.lang.Gosu;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.module.IModule;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.undo.CompoundEdit;

public class GosuPanel
extends JPanel {
    private static final int MAX_TABS = 12;
    private SystemPanel _consolePanel;
    private CollapsibleSplitPane _outerSplitPane;
    private CollapsibleSplitPane _splitPane;
    private ExperimentView _experimentView;
    private JFrame _parentFrame;
    private RunState _runState;
    private TabPane _editorTabPane;
    private TabPane _bottomTabPane;
    private AtomicUndoManager _defaultUndoMgr;
    private NavigationHistory _history;
    private LabStatusBar _statusBar;
    private boolean _initialFile;
    private TypeNameCache _typeNamesCache;
    private Experiment _experiment;
    private OutputStreamWriter _inWriter;
    private SysInListener _sysInListener;
    private InputStream _oldIn;
    private MessagesPanel _messages;
    private SearchPanel _searches;
    private DebugPanel _debugPanel;
    private IProcessRunner _processRunner;
    private BreakpointManager _breakpointManager;
    private Debugger _debugger;

    public GosuPanel(JFrame frame) {
        this._parentFrame = frame;
        this._defaultUndoMgr = new AtomicUndoManager(10);
        this._typeNamesCache = new TypeNameCache();
        this._runState = RunState.None;
        this._breakpointManager = new BreakpointManager();
        this.configUI();
    }

    public NavigationHistory getTabSelectionHistory() {
        return this._history;
    }

    void configUI() {
        this.setLayout(new BorderLayout());
        JPanel bottom = new JPanel(new BorderLayout());
        this._bottomTabPane = new TabPane(29);
        bottom.add((Component)this._bottomTabPane, "Center");
        this._editorTabPane = new TabPane(TabPosition.TOP, 15);
        this._history = new NavigationHistory(this._editorTabPane);
        this.getTabSelectionHistory().setTabHistoryHandler(new EditorTabHistoryHandler());
        this._editorTabPane.addSelectionListener(e -> {
            if (!this._editorTabPane.isVisible()) {
                return;
            }
            this.savePreviousTab();
            this.updateTitle();
            if (this.getCurrentEditor() == null) {
                return;
            }
            this.parse();
            this.storeExperimentState();
        });
        this._experimentView = new ExperimentView();
        this._experimentView.setBackground(Scheme.active().getWindow());
        TabPane experimentViewTabPane = new TabPane(TabPosition.TOP, 21);
        experimentViewTabPane.addTab("Experiment", null, this._experimentView);
        this._splitPane = new CollapsibleSplitPane(0, experimentViewTabPane, this._editorTabPane);
        this._outerSplitPane = new CollapsibleSplitPane(1, this._splitPane, bottom);
        this.add((Component)this._outerSplitPane, "Center");
        JPanel statPanel = this.makeStatusBar();
        this.add((Component)statPanel, "South");
        ToolBar toolbar = this.makeMainToolbar();
        this.add((Component)toolbar, "North");
        JMenuBar menuBar = this.makeMenuBar();
        this._parentFrame.setJMenuBar(menuBar);
        this.handleMacStuff();
        EventQueue.invokeLater(() -> this._outerSplitPane.collapseBottom(this._bottomTabPane));
        EventQueue.invokeLater(this::mapKeystrokes);
    }

    private ToolBar makeMainToolbar() {
        ToolBar toolbar = new ToolBar();
        toolbar.setDynamicBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Scheme.active().getControlLigthShadow()), BorderFactory.createEmptyBorder(1, 1, 2, 1)));
        LabToolbarButton item = new LabToolbarButton(new CommonMenus.OpenProjectActionHandler());
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.SaveActionHandler());
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.UndoActionHandler());
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.RedoActionHandler());
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.CutActionHandler(this::getCurrentEditor));
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.CopyActionHandler(this::getCurrentEditor));
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.PasteActionHandler(this::getCurrentEditor));
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.FindActionHandler(this::getCurrentEditor));
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.ReplaceActionHandler(this::getCurrentEditor));
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.GoBackActionHandler());
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.GoForwardActionHandler());
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.MakeActionHandler());
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.ClearAndRunActionHandler(this::getRunConfig));
        item.setToolTipSupplier(() -> {
            IRunConfig rc = this.getRunConfig();
            return rc == null ? "Run..." : "Run '" + rc.getName() + "'";
        });
        toolbar.add(item);
        item = new LabToolbarButton(new CommonMenus.ClearAndDebugActionHandler(this::getRunConfig));
        item.setToolTipSupplier(() -> {
            IRunConfig rc = this.getRunConfig();
            return rc == null ? "Debug..." : "Debug '" + rc.getName() + "'";
        });
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.ShipItActionHandler());
        toolbar.add(item);
        toolbar.add(this.makeSeparator());
        item = new LabToolbarButton(new CommonMenus.SettingsActionHandler());
        toolbar.add(item);
        return toolbar;
    }

    private JComponent makeSeparator() {
        JPanel separator = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Scheme.active().getSeparator2());
                g.drawLine(this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight() - 1);
            }
        };
        separator.setMaximumSize(new Dimension(9, 20));
        separator.setBackground(Scheme.active().getMenu());
        return separator;
    }

    public ExperimentView getExperimentView() {
        return this._experimentView;
    }

    public MessagesPanel getMessagesPanel() {
        return this._messages;
    }

    public SearchPanel getSearchPanel() {
        return this._searches;
    }

    public SystemPanel getConsolePanel() {
        return this._consolePanel;
    }

    public DebugPanel getDebugPanel() {
        return this._debugPanel;
    }

    public MessagesPanel showMessages(boolean bShow) {
        this._messages = this.showTab(bShow, "Messages", null, this._messages, MessagesPanel::new);
        return this._messages;
    }

    public SearchPanel showSearches(boolean bShow) {
        this._searches = this.showTab(bShow, "Search", null, this._searches, SearchPanel::new);
        return this._searches;
    }

    public SystemPanel showConsole(boolean bShow) {
        this._consolePanel = this.showTab(bShow, "Console", EditorUtilities.loadIcon("images/console.png"), this._consolePanel, SystemPanel::new);
        return this._consolePanel;
    }

    public <P extends JComponent> P showTab(boolean bShow, String title, Icon icon, P panel, Supplier<P> creator) {
        if (bShow) {
            EventQueue.invokeLater(this._outerSplitPane::restorePane);
            ITab tab = this._bottomTabPane.findTabWithContent((JComponent)panel);
            if (tab == null) {
                panel = (JComponent)creator.get();
                this._bottomTabPane.addTab(title, icon, (JComponent)panel);
                return panel;
            }
            this._bottomTabPane.selectTab(tab, false);
            return panel;
        }
        this._bottomTabPane.removeTabWithContent((JComponent)panel);
        EventQueue.invokeLater(() -> {
            SettleModalEventQueue.instance().run();
            if (this._bottomTabPane.getTabCount() == 0 && !this._outerSplitPane.isMin()) {
                this._outerSplitPane.toggleCollapse(this._bottomTabPane);
            }
        });
        return null;
    }

    private void handleMacStuff() {
    }

    public void clearTabs() {
        this._editorTabPane.setVisible(false);
        try {
            this._editorTabPane.removeAllTabs();
        }
        finally {
            this._editorTabPane.setVisible(true);
        }
        this.showMessages(false);
        this.showSearches(false);
        SettleModalEventQueue.instance().run();
        this.getTabSelectionHistory().dispose();
    }

    private void storeExperimentState() {
        if (this._initialFile) {
            return;
        }
        this.getExperiment().save();
        LabFrame.instance().saveLabState(this._experiment);
    }

    public Experiment getExperiment() {
        return this._experiment;
    }

    public void restoreExperimentState(Experiment experiment) {
        this._experiment = experiment;
        RunMe.reinitializeGosu(experiment);
        TypeSystem.refresh((IModule)TypeSystem.getGlobalModule());
        LabFrame.instance().addExperiment(experiment);
        this._experimentView.load(this._experiment);
        for (String openFile : experiment.getOpenFiles()) {
            Path file = PathUtil.create((String)openFile, (String[])new String[0]);
            if (!PathUtil.isFile((Path)file, (LinkOption[])new LinkOption[0])) continue;
            this.openFile(file, false);
        }
        String activeFile = experiment.getActiveFile();
        if (activeFile == null) {
            EventQueue.invokeLater(() -> SourceFileCreator.instance().getOrMakeUntitledProgram(experiment));
        } else {
            this.openTab(PathUtil.create((String)activeFile, (String[])new String[0]), true);
        }
        SettleModalEventQueue.instance().run();
        EventQueue.invokeLater(() -> {
            this.parse();
            EditorHost currentEditor = this.getCurrentEditor();
            if (currentEditor != null) {
                currentEditor.getEditor().requestFocus();
            }
        });
    }

    private JPanel makeStatusBar() {
        this._statusBar = new LabStatusBar();
        return this._statusBar;
    }

    public void setStatus(String status) {
        this._statusBar.setStatus(status);
    }

    private void parse() {
        EventQueue.invokeLater(() -> {
            if (this.getCurrentEditor() != null) {
                this.getCurrentEditor().parse();
            }
        });
    }

    private void savePreviousTab() {
        EditorHost editor = this.getTabSelectionHistory().getPreviousEditor();
        if (editor != null) {
            if (this.isDirty(editor)) {
                this.save((Path)editor.getClientProperty("_file"), editor);
            } else if (editor.getParsedClass() != null) {
                TypeSystem.refresh((ITypeRef)((ITypeRef)editor.getParsedClass()));
            }
        }
    }

    private EditorHost createEditor(Path file, IScriptPartId partId) {
        EditorHost editorHost = EditorFactory.createEditor(file, partId);
        editorHost.setBorder(BorderFactory.createEmptyBorder());
        this.addDirtyListener(editorHost);
        EventQueue.invokeLater(() -> ((AbstractDocument)editorHost.getEditor().getDocument()).setDocumentFilter(new GosuPanelDocumentFilter(editorHost)));
        return editorHost;
    }

    private void addDirtyListener(final EditorHost editor) {
        editor.getUndoManager().addChangeListener(new ChangeListener(){
            private ChangeEvent _lastChangeEvent;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e != this._lastChangeEvent) {
                    this._lastChangeEvent = e;
                    GosuPanel.this.setDirty(editor, true);
                }
            }
        });
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.makeFileMenu(menuBar);
        this.makeEditMenu(menuBar);
        this.makeSearchMenu(menuBar);
        this.makeCodeMenu(menuBar);
        this.makeBuildMenu(menuBar);
        this.makeRunMenu(menuBar);
        this.makeWindowMenu(menuBar);
        this.makeHelpMenu(menuBar);
        return menuBar;
    }

    private void makeHelpMenu(JMenuBar menuBar) {
        SmartMenu helpMenu = new SmartMenu("Help");
        helpMenu.setMnemonic('H');
        menuBar.add(helpMenu);
        SmartMenuItem gosuItem = new SmartMenuItem(new AbstractAction("Gosu Online"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.org");
            }
        });
        gosuItem.setMnemonic('G');
        helpMenu.add(gosuItem);
        helpMenu.addSeparator();
        SmartMenuItem helpItem = new SmartMenuItem(new AbstractAction("The Basics"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/docs.html");
            }
        });
        helpItem.setMnemonic('B');
        helpMenu.add(helpItem);
        helpMenu.addSeparator();
        SmartMenuItem playItem = new SmartMenuItem(new AbstractAction("Web Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/play.html");
            }
        });
        playItem.setMnemonic('W');
        helpMenu.add(playItem);
        helpMenu.addSeparator();
        SmartMenuItem discussItem = new SmartMenuItem(new AbstractAction("Discuss"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://groups.google.com/group/gosu-lang");
            }
        });
        discussItem.setMnemonic('D');
        helpMenu.add(discussItem);
        helpMenu.addSeparator();
        SmartMenuItem plugin = new SmartMenuItem(new AbstractAction("IntelliJ Plugin"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/intellij.html");
            }
        });
        plugin.setMnemonic('I');
        helpMenu.add(plugin);
    }

    private void makeWindowMenu(JMenuBar menuBar) {
        SmartMenu windowMenu = new SmartMenu("Window");
        windowMenu.setMnemonic('W');
        menuBar.add(windowMenu);
        SmartMenuItem backItem = new SmartMenuItem(new CommonMenus.GoBackActionHandler());
        backItem.setMnemonic('B');
        backItem.setAccelerator(KeyStroke.getKeyStroke("alt LEFT"));
        windowMenu.add(backItem);
        SmartMenuItem forwardItem = new SmartMenuItem(new CommonMenus.GoForwardActionHandler());
        forwardItem.setMnemonic('F');
        forwardItem.setAccelerator(KeyStroke.getKeyStroke("alt RIGHT"));
        windowMenu.add(forwardItem);
        windowMenu.addSeparator();
        SmartMenuItem recentItem = new SmartMenuItem(new AbstractAction("Recent Files"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.displayRecentViewsPopup();
            }
        });
        recentItem.setMnemonic('R');
        recentItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " E"));
        windowMenu.add(recentItem);
        windowMenu.addSeparator();
        SmartMenuItem closeActiveItem = new SmartMenuItem(new AbstractAction("Close Active Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.saveIfDirty();
                GosuPanel.this.closeActiveEditor();
            }
        });
        closeActiveItem.setMnemonic('C');
        closeActiveItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F4"));
        windowMenu.add(closeActiveItem);
        SmartMenuItem closeOthersItem = new SmartMenuItem(new AbstractAction("Close Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.closeOthers();
            }
        });
        closeOthersItem.setMnemonic('O');
        windowMenu.add(closeOthersItem);
    }

    private void makeCodeMenu(JMenuBar menuBar) {
        SmartMenu codeMenu = new SmartMenu("Code");
        codeMenu.setMnemonic('d');
        menuBar.add(codeMenu);
        codeMenu.add(CommonMenus.makeCodeComplete(this::getCurrentGosuEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeParameterInfo(this::getCurrentGosuEditor));
        codeMenu.add(CommonMenus.makeExpressionType(this::getCurrentGosuEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeGotoDeclaration(this::getCurrentGosuEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeShowFileInTree(this::getCurrentEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeQuickDocumentation(this::getCurrentGosuEditor));
        codeMenu.addSeparator();
        SmartMenuItem openTypeItem = new SmartMenuItem(new AbstractAction("Open Type..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GotoTypePopup.display();
            }
        });
        openTypeItem.setMnemonic('O');
        openTypeItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " N"));
        codeMenu.add(openTypeItem);
        if ("true".equals(System.getProperty("spec"))) {
            codeMenu.addSeparator();
            SmartMenuItem markItem = new SmartMenuItem(new AbstractAction("Mark Errors For Gosu Language Test"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GosuPanel.this.markErrorsForGosuLanguageTest();
                }
            });
            markItem.setMnemonic('M');
            markItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " M"));
            codeMenu.add(markItem);
        }
        codeMenu.addSeparator();
        SmartMenuItem viewBytecodeItem = new SmartMenuItem(new AbstractAction("View Bytecode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.dumpBytecode();
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentGosuEditor() != null && GosuPanel.this.getCurrentEditor().getScriptPart() != null && GosuPanel.this.getCurrentEditor().getScriptPart().getContainingType() != null;
            }
        });
        codeMenu.add(viewBytecodeItem);
    }

    public GosuEditor getCurrentGosuEditor() {
        EditorHost editor = this.getCurrentEditor();
        return editor instanceof GosuEditor ? (GosuEditor)editor : null;
    }

    private void makeBuildMenu(JMenuBar menuBar) {
        SmartMenu buildMenu = new SmartMenu("Build");
        buildMenu.setMnemonic('b');
        menuBar.add(buildMenu);
        SmartMenuItem make = new SmartMenuItem(new CommonMenus.MakeActionHandler());
        make.setMnemonic('m');
        make.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F9"));
        buildMenu.add(make);
        SmartMenuItem rebuild = new SmartMenuItem(new CommonMenus.RebuildActionHandler());
        rebuild.setMnemonic('b');
        buildMenu.add(rebuild);
        buildMenu.addSeparator();
        SmartMenuItem shipIt = new SmartMenuItem(new CommonMenus.ShipItActionHandler());
        shipIt.setMnemonic('p');
        shipIt.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F10"));
        buildMenu.add(shipIt);
    }

    public EditorHost getCurrentEditor() {
        ITab selectedTab = this._editorTabPane.getSelectedTab();
        return selectedTab == null ? null : (EditorHost)selectedTab.getContentPane();
    }

    public IRunConfig getRunConfig() {
        IType type;
        IType iType = this.getCurrentEditor() == null ? null : (type = this.getCurrentEditor().getScriptPart() == null ? null : this.getCurrentEditor().getScriptPart().getContainingType());
        if (!EditorUtilities.isRunnable(type)) {
            IRunConfig mruRunConfig;
            type = null;
            IRunConfig iRunConfig = mruRunConfig = this.getExperiment() == null ? null : this.getExperiment().getMruRunConfig();
            if (mruRunConfig != null && mruRunConfig.isValid()) {
                return mruRunConfig;
            }
        }
        return type == null ? null : (this.getExperiment() == null ? null : this.getExperiment().getOrCreateRunConfig(type));
    }

    private void makeRunMenu(JMenuBar menuBar) {
        SmartMenu runMenu = new SmartMenu("Run");
        runMenu.setMnemonic('R');
        menuBar.add(runMenu);
        runMenu.add(CommonMenus.makeRun(this::getRunConfig));
        runMenu.add(CommonMenus.makeDebug(this::getRunConfig));
        runMenu.add(CommonMenus.makeRunConfig());
        runMenu.add(CommonMenus.makeDebugConfig());
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeStop(() -> this));
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeStepOver(this::getDebugger));
        runMenu.add(CommonMenus.makeStepInto(this::getDebugger));
        runMenu.add(CommonMenus.makeStepOut(this::getDebugger));
        runMenu.add(CommonMenus.makeRunToCursor(this::getDebugger, this::getBreakpointManager, this::getCurrentGosuEditor));
        runMenu.add(CommonMenus.makeDropFrame(this::getDebugger, () -> this._debugPanel.getDropToFrame()));
        runMenu.add(CommonMenus.makePause(this::getDebugger));
        runMenu.add(CommonMenus.makeResume(this::getDebugger));
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeEvaluateExpression(this::getDebugger));
        runMenu.add(CommonMenus.makeShowExecutionPoint(this::getDebugger));
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeToggleBreakpoint(this::getBreakpointManager, this::getCurrentGosuEditor));
        runMenu.add(CommonMenus.makeViewBreakpoints(() -> null));
        runMenu.add(CommonMenus.makeMuteBreakpoints(this::getBreakpointManager));
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeClear(() -> this));
    }

    private void makeSearchMenu(JMenuBar menuBar) {
        SmartMenu searchMenu = new SmartMenu("Search");
        searchMenu.setMnemonic('S');
        menuBar.add(searchMenu);
        SmartMenuItem findItem = new SmartMenuItem(new CommonMenus.FindActionHandler(this::getCurrentEditor));
        findItem.setMnemonic('F');
        findItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " F"));
        searchMenu.add(findItem);
        SmartMenuItem replaceItem = new SmartMenuItem(new CommonMenus.ReplaceActionHandler(this::getCurrentEditor));
        replaceItem.setMnemonic('R');
        replaceItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " R"));
        searchMenu.add(replaceItem);
        SmartMenuItem nextItem = new SmartMenuItem(new AbstractAction("Next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isEnabled()) {
                    GosuPanel.this.getCurrentEditor().gotoNextUsageHighlight();
                }
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentEditor() != null && GosuPanel.this.getCurrentEditor().getEditor().getHighlighter().getHighlights().length > 0;
            }
        });
        nextItem.setMnemonic('N');
        nextItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        searchMenu.add(nextItem);
        SmartMenuItem previousItem = new SmartMenuItem(new AbstractAction("Previous"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.isEnabled()) {
                    GosuPanel.this.getCurrentEditor().gotoPrevUsageHighlight();
                }
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentEditor() != null && GosuPanel.this.getCurrentEditor().getEditor().getHighlighter().getHighlights().length > 0;
            }
        });
        previousItem.setMnemonic('P');
        previousItem.setAccelerator(KeyStroke.getKeyStroke("shift F3"));
        searchMenu.add(previousItem);
        searchMenu.addSeparator();
        SmartMenuItem findIInPathItem = new SmartMenuItem(new CommonMenus.FindInPathActionHandler(FileTreeUtil::getRoot));
        findIInPathItem.setMnemonic('P');
        findIInPathItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift F"));
        searchMenu.add(findIInPathItem);
        SmartMenuItem replaceInPathItem = new SmartMenuItem(new CommonMenus.ReplaceInPathActionHandler(FileTreeUtil::getRoot));
        replaceInPathItem.setMnemonic('A');
        replaceInPathItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift R"));
        searchMenu.add(replaceInPathItem);
        searchMenu.addSeparator();
        searchMenu.add(CommonMenus.makeFindUsages(FileTreeUtil::getRoot));
        searchMenu.add(CommonMenus.makeFindUsagesInFile());
        searchMenu.add(CommonMenus.makeHighlightFindUsagesInFile());
        searchMenu.addSeparator();
        searchMenu.add(CommonMenus.makePrevOccurrent(() -> this.getGosuPanel() == null ? null : this.getGosuPanel().getSearchPanel()));
        searchMenu.add(CommonMenus.makeNextOccurrent(() -> this.getGosuPanel() == null ? null : this.getGosuPanel().getSearchPanel()));
        searchMenu.addSeparator();
        SmartMenuItem gotoLineItem = new SmartMenuItem(new AbstractAction("Go To Line"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().displayGotoLinePopup();
            }
        });
        gotoLineItem.setMnemonic('G');
        gotoLineItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " G"));
        searchMenu.add(gotoLineItem);
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private void makeEditMenu(JMenuBar menuBar) {
        SmartMenu editMenu = new SmartMenu("Edit");
        editMenu.setMnemonic('E');
        menuBar.add(editMenu);
        SmartMenuItem undoItem = new SmartMenuItem(new CommonMenus.UndoActionHandler());
        undoItem.setMnemonic('U');
        undoItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " Z"));
        editMenu.add(undoItem);
        SmartMenuItem redoItem = new SmartMenuItem(new CommonMenus.RedoActionHandler());
        redoItem.setMnemonic('R');
        redoItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift Z"));
        editMenu.add(redoItem);
        editMenu.addSeparator();
        editMenu.add(CommonMenus.makeCut(this::getCurrentEditor));
        editMenu.add(CommonMenus.makeCopy(this::getCurrentEditor));
        editMenu.add(CommonMenus.makePaste(this::getCurrentEditor));
        editMenu.add(CommonMenus.makePasteJavaAsGosu(this::getCurrentGosuEditor));
        editMenu.addSeparator();
        SmartMenuItem deleteItem = new SmartMenuItem(new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuPanel.this.getCurrentEditor() != null && EditorUtilities.containsFocus(GosuPanel.this.getCurrentEditor())) {
                    GosuPanel.this.getCurrentEditor().delete();
                }
            }
        });
        deleteItem.setMnemonic('D');
        deleteItem.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        editMenu.add(deleteItem);
        SmartMenuItem deletewordItem = new SmartMenuItem(new AbstractAction("Delete Word"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteWord();
            }
        });
        deletewordItem.setMnemonic('e');
        deletewordItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " BACKSPACE"));
        editMenu.add(deletewordItem);
        SmartMenuItem deleteWordForwardItem = new SmartMenuItem(new AbstractAction("Delete Word Forward"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteWordForwards();
            }
        });
        deleteWordForwardItem.setMnemonic('F');
        deleteWordForwardItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " DELETE"));
        editMenu.add(deleteWordForwardItem);
        SmartMenuItem deleteLine = new SmartMenuItem(new AbstractAction("Delete Line"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteLine();
            }
        });
        deleteLine.setMnemonic('L');
        deleteLine.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " Y"));
        editMenu.add(deleteLine);
        editMenu.addSeparator();
        SmartMenuItem selectWord = new SmartMenuItem(new AbstractAction("Select Word"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentGosuEditor().selectWord();
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentGosuEditor() != null;
            }
        });
        selectWord.setMnemonic('W');
        selectWord.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " W"));
        editMenu.add(selectWord);
        SmartMenuItem narraowSelection = new SmartMenuItem(new AbstractAction("Narrow Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentGosuEditor().narrowSelectWord();
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentGosuEditor() != null;
            }
        });
        narraowSelection.setMnemonic('N');
        narraowSelection.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " shift W"));
        editMenu.add(narraowSelection);
        editMenu.addSeparator();
        SmartMenuItem duplicateItem = new SmartMenuItem(new AbstractAction("Duplicate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().duplicate();
            }
        });
        duplicateItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " D"));
        editMenu.add(duplicateItem);
        SmartMenuItem joinItem = new SmartMenuItem(new AbstractAction("Join Lines"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().joinLines();
            }
        });
        joinItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " J"));
        editMenu.add(joinItem);
        SmartMenuItem indentItem = new SmartMenuItem(new AbstractAction("Indent Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuPanel.this.getCurrentEditor().isCompletionPopupShowing()) {
                    GosuPanel.this.getCurrentEditor().handleBulkIndent(false);
                }
            }
        });
        indentItem.setMnemonic('I');
        indentItem.setAccelerator(KeyStroke.getKeyStroke("TAB"));
        editMenu.add(indentItem);
        SmartMenuItem outdentItem = new SmartMenuItem(new AbstractAction("Outdent Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuPanel.this.getCurrentEditor().isCompletionPopupShowing()) {
                    GosuPanel.this.getCurrentEditor().handleBulkIndent(true);
                }
            }
        });
        outdentItem.setMnemonic('O');
        outdentItem.setAccelerator(KeyStroke.getKeyStroke("shift TAB"));
        editMenu.add(outdentItem);
    }

    private void makeFileMenu(JMenuBar menuBar) {
        SmartMenu fileMenu = new SmartMenu("File");
        fileMenu.setMnemonic('F');
        menuBar.add(fileMenu);
        SmartMenuItem newExperimentItem = new SmartMenuItem(new AbstractAction("New Experiment..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.newExperiment();
            }
        });
        newExperimentItem.setMnemonic('P');
        fileMenu.add(newExperimentItem);
        SmartMenuItem openExperimentItem = new SmartMenuItem(new CommonMenus.OpenProjectActionHandler());
        openExperimentItem.setMnemonic('O');
        fileMenu.add(openExperimentItem);
        fileMenu.addSeparator();
        SmartMenu reopenExperiment = new SmartMenu("Reopen Experiment");
        ReopenExperimentPopup.initialize(reopenExperiment);
        fileMenu.add(reopenExperiment);
        fileMenu.addSeparator();
        SmartMenu newItem = new SmartMenu("New");
        NewFilePopup.addMenuItems(newItem);
        fileMenu.add(newItem);
        SmartMenuItem openItem = new SmartMenuItem(new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.openFile();
            }
        });
        openItem.setMnemonic('O');
        fileMenu.add(openItem);
        SmartMenuItem saveItem = new SmartMenuItem(new CommonMenus.SaveActionHandler());
        saveItem.setMnemonic('S');
        saveItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " S"));
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        SmartMenuItem settings = new SmartMenuItem(new CommonMenus.SettingsActionHandler());
        saveItem.setMnemonic('G');
        saveItem.setAccelerator(KeyStroke.getKeyStroke(EditorUtilities.CONTROL_KEY_NAME + " alt S"));
        fileMenu.add(settings);
        SmartMenuItem classpathItem = new SmartMenuItem(new AbstractAction("Dependencies..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.displayClasspath();
            }
        });
        classpathItem.setMnemonic('d');
        fileMenu.add(classpathItem);
        fileMenu.addSeparator();
        SmartMenuItem exitItem = new SmartMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.exit();
            }
        });
        exitItem.setMnemonic('x');
        fileMenu.add(exitItem);
    }

    private void closeActiveEditor() {
        if (this._editorTabPane.getTabCount() > 1) {
            this._editorTabPane.removeTab(this._editorTabPane.getSelectedTab());
        } else {
            this.exit();
        }
    }

    private void closeOthers() {
        this._editorTabPane.setVisible(false);
        try {
            for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
                if (this._editorTabPane.getSelectedTabIndex() == i) continue;
                this._editorTabPane.removeTab(this._editorTabPane.getTabAt(i));
            }
        }
        finally {
            this._editorTabPane.setVisible(true);
        }
    }

    private void displayClasspath() {
        ClasspathDialog dlg = new ClasspathDialog(new File("."));
        dlg.setVisible(true);
    }

    public void shipIt() {
        ShipIt.instance().shipIt(this.getExperiment());
    }

    public boolean make() {
        SettleModalEventQueue.instance().run();
        this.saveIfDirty();
        if (this.getMessagesPanel() != null) {
            this.getMessagesPanel().clear();
        }
        this.showMessages(true);
        Debugger debugger = this.getDebugger();
        ExperimentBuild expBuild = debugger != null ? debugger.getClassRedefiner() : ExperimentBuild.instance();
        return expBuild.make(c -> true);
    }

    public boolean compile(Set<IType> types) {
        SettleModalEventQueue.instance().run();
        this.saveIfDirty();
        if (this.getMessagesPanel() != null) {
            this.getMessagesPanel().clear();
        }
        this.showMessages(true);
        Debugger debugger = this.getDebugger();
        ExperimentBuild expBuild = debugger != null ? debugger.getClassRedefiner() : ExperimentBuild.instance();
        return expBuild.compile(c -> true, types);
    }

    public boolean rebuild() {
        SettleModalEventQueue.instance().run();
        this.saveIfDirty();
        if (this.getMessagesPanel() != null) {
            this.getMessagesPanel().clear();
        }
        this.showMessages(true);
        return ExperimentBuild.instance().rebuild(c -> true);
    }

    public void exit() {
        if (this.saveIfDirty()) {
            System.exit(0);
        }
    }

    public void setEditorSplitPosition(int iPos) {
        if (this._splitPane != null) {
            this._splitPane.setPosition(iPos);
        }
    }

    public void setExperimentSplitPosition(int iPos) {
        if (this._outerSplitPane != null) {
            this._outerSplitPane.setPosition(iPos);
        }
    }

    public EditorHost getGosuEditor() {
        return this.getCurrentEditor();
    }

    private void mapKeystrokes() {
        this.mapKeystroke(KeyStroke.getKeyStroke(90, EditorUtilities.CONTROL_KEY_MASK), "Undo", new UndoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(90, EditorUtilities.CONTROL_KEY_MASK | 1), "Redo", new RedoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(8, 8), "UndoOldStyle", new UndoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(8, 9), "RetoOldStyle", new RedoActionHandler());
    }

    private void mapKeystroke(KeyStroke ks, String strCmd, Action action) {
        this.enableInputMethods(true);
        this.enableEvents(8L);
        InputMap imap = this.getInputMap(1);
        Object key = imap.get(ks);
        if (key == null) {
            key = strCmd;
            imap.put(ks, key);
        }
        this.getActionMap().put(key, action);
    }

    void resetChangeHandler() {
        ScriptChangeHandler handler = new ScriptChangeHandler(this.getUndoManager());
        handler.establishUndoableEditListener(this.getCurrentEditor());
    }

    public void openFile() {
        JFileChooser fc = new JFileChooser(this.getCurrentFile().getParent().toFile());
        fc.setDialogTitle("Open Gosu Path");
        fc.setDialogType(0);
        fc.setCurrentDirectory(this.getCurrentFile().getParent().toFile());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f.toPath());
            }

            @Override
            public String getDescription() {
                return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            this.openFile(fc.getSelectedFile().toPath(), true);
        }
    }

    public void openFile(Path file, boolean bFocus) {
        this.openFile(GosuPanel.makePartId(file), file, bFocus);
    }

    public boolean openType(String fqn, boolean bFocus) {
        FileTree fileTree = FileTreeUtil.find(fqn);
        if (fileTree != null) {
            this.openFile(fileTree.getFileOrDir(), bFocus);
            return true;
        }
        return false;
    }

    public static IScriptPartId makePartId(Path file) {
        TypeSystem.pushGlobalModule();
        try {
            if (file == null) {
                ScriptPartId scriptPartId = new ScriptPartId("New Program", null);
                return scriptPartId;
            }
            String classNameForFile = TypeNameUtil.getTypeNameForFile(file);
            ScriptPartId scriptPartId = new ScriptPartId(classNameForFile, null);
            return scriptPartId;
        }
        finally {
            TypeSystem.popGlobalModule();
        }
    }

    public void openInitialFile(IScriptPartId partId, Path file) {
        this._initialFile = true;
        try {
            if (file != null || this._editorTabPane.getTabCount() == 0) {
                this.openFile(partId, file, true);
            }
        }
        finally {
            this._initialFile = false;
        }
    }

    private void openFile(IScriptPartId partId, Path file, boolean bFocus) {
        String strSource;
        if (this.openTab(file, bFocus)) {
            return;
        }
        EditorHost editor = this.createEditor(file, partId);
        if (partId == null) {
            throw new IllegalArgumentException("partId should be non-null");
        }
        file = file == null ? SourceFileCreator.instance().getOrMakeUntitledProgram(this._experiment) : file;
        editor.putClientProperty("_file", file);
        this.removeLruTab();
        String classNameForFile = TypeNameUtil.getTypeNameForFile(file);
        IType type = TypeSystem.getByFullNameIfValid((String)classNameForFile);
        if (type != null) {
            this._editorTabPane.addTab(type.getRelativeName(), EditorUtilities.findIcon(type), editor);
        } else {
            this._editorTabPane.addTab(PathUtil.getName((Path)file), EditorUtilities.findIcon(file), editor);
        }
        this._editorTabPane.selectTab(this._editorTabPane.findTabWithContent(editor), true);
        if (!PathUtil.exists((Path)file, (LinkOption[])new LinkOption[0])) {
            strSource = "";
        } else {
            try (InputStream in = PathUtil.createInputStream((Path)file, (OpenOption[])new OpenOption[0]);){
                strSource = StreamUtil.getContent((Reader)StreamUtil.getInputStreamReader((InputStream)in));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._parentFrame != null) {
            this.updateTitle();
        }
        try {
            editor.read(partId, strSource);
            this.resetChangeHandler();
            if (bFocus) {
                EventQueue.invokeLater(() -> editor.getEditor().requestFocus());
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void removeLruTab() {
        if (this._editorTabPane.getTabCount() < 12) {
            return;
        }
        List<ITabHistoryContext> mruList = this.getTabSelectionHistory().getTabMruList();
        for (int i = mruList.size() - 1; i >= 0; --i) {
            ITabHistoryContext tabCtx = mruList.get(i);
            Path file = (Path)tabCtx.getContentId();
            EditorHost editor = this.findTab(file);
            if (editor == null) continue;
            this.closeTab(file);
        }
    }

    private void updateTitle() {
        Path file = this.getCurrentFile();
        Experiment experiment = this.getExperiment();
        String currentFilePath = file == null ? "  " : " - ..." + File.separator + experiment.makeExperimentRelativePath(file) + " - ";
        String title = experiment.getName() + " - [" + PathUtil.getAbsolutePathName((Path)experiment.getExperimentDir()) + "]" + currentFilePath + "Gosu Lab " + Gosu.getVersion();
        this._parentFrame.setTitle(title);
    }

    private boolean openTab(Path file, boolean bFocus) {
        EditorHost editor = this.findTab(file);
        if (editor != null) {
            this._editorTabPane.selectTab(this._editorTabPane.findTabWithContent(editor), bFocus);
            return true;
        }
        return false;
    }

    public EditorHost findTab(Path file) {
        if (file == null) {
            return null;
        }
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            EditorHost editor = (EditorHost)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !file.equals(editor.getClientProperty("_file"))) continue;
            return editor;
        }
        return null;
    }

    private void setCurrentFile(Path file) {
        this.getCurrentEditor().putClientProperty("_file", file);
        this.openFile(file, false);
    }

    public Path getCurrentFile() {
        EditorHost currentEditor = this.getCurrentEditor();
        return currentEditor == null ? null : (Path)currentEditor.getClientProperty("_file");
    }

    public boolean save() {
        if (this.getCurrentFile() == null) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Save Gosu Path");
            fc.setDialogType(1);
            fc.setCurrentDirectory(new File("."));
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f.toPath());
                }

                @Override
                public String getDescription() {
                    return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
                }
            });
            int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
            if (returnVal == 0) {
                this.setCurrentFile(fc.getSelectedFile().toPath());
            } else {
                return false;
            }
        }
        if (!PathUtil.exists((Path)this.getCurrentFile(), (LinkOption[])new LinkOption[0])) {
            String msg = "";
            if (!PathUtil.createNewFile((Path)this.getCurrentFile(), (FileAttribute[])new FileAttribute[0])) {
                JOptionPane.showMessageDialog(this, "Could not create file " + PathUtil.getName((Path)this.getCurrentFile()) + msg);
                return false;
            }
        }
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        return true;
    }

    public boolean save(Path file, EditorHost editor) {
        if (!PathUtil.exists((Path)file, (LinkOption[])new LinkOption[0])) {
            String msg = "";
            if (!PathUtil.createNewFile((Path)file, (FileAttribute[])new FileAttribute[0])) {
                JOptionPane.showMessageDialog(this, "Could not create file " + PathUtil.getName((Path)file) + msg);
                return false;
            }
        }
        this.saveAndReloadType(file, editor);
        return true;
    }

    private void saveAndReloadType(Path file, EditorHost editor) {
        if (!PathUtil.canWrite((Path)file)) {
            return;
        }
        FileTree fileTree = FileTreeUtil.getRoot().find(file);
        if (fileTree != null) {
            fileTree.setLastModified();
        }
        try (BufferedWriter out = PathUtil.createWriter((Path)file);){
            StreamUtil.copy((Reader)new StringReader(editor.getText()), (Writer)out);
            this.setDirty(editor, false);
            this.reload(editor.getScriptPart().getContainingType());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    void reload(IType type) {
        if (type == null) {
            return;
        }
        for (IFile file : type.getSourceFiles()) {
            TypeSystem.refreshed((IResource)file);
        }
    }

    public boolean saveIfDirty() {
        if (this.isDirty(this.getCurrentEditor())) {
            return this.save();
        }
        return true;
    }

    public void refresh(Path file) {
        IType type;
        FileTree root;
        FileTree node;
        EditorHost editor = this.findTab(file);
        if (editor != null) {
            try (BufferedReader reader = PathUtil.createReader((Path)file);){
                editor.refresh(StreamUtil.getContent((Reader)reader));
                this.setDirty(editor, false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((node = (root = FileTreeUtil.getRoot()).find(file)) != null && (type = node.getType()) != null) {
            this.reload(type);
        }
    }

    public void newExperiment() {
        Path untitled = PathUtil.create((Path)this.getExperiment().getExperimentDir().getParent(), (String)"Untitled");
        PathUtil.mkdirs((Path)untitled);
        JFileChooser fc = new JFileChooser(untitled.toFile());
        fc.setDialogTitle("New Experiment");
        fc.setDialogType(0);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !new File(f, f.getName() + ".prj").exists();
            }

            @Override
            public String getDescription() {
                return "Gosu Experiment Directory (directory name is your experiment name)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal != 0) {
            return;
        }
        Path selectedFile = fc.getSelectedFile().toPath();
        Experiment experiment = new Experiment(PathUtil.getName((Path)selectedFile), selectedFile, this);
        this.clearTabs();
        EventQueue.invokeLater(() -> this.restoreExperimentState(experiment));
    }

    public void openExperiment() {
        Path prjFile;
        FileDialog fc = new FileDialog(EditorUtilities.frameForComponent(this), "Open Experiment", 0);
        fc.setDirectory(PathUtil.getAbsolutePathName((Path)this.getExperiment().getExperimentDir()));
        fc.setMultipleMode(false);
        fc.setFile("*.prj");
        fc.setVisible(true);
        String selectedFile = fc.getFile();
        if (selectedFile != null && PathUtil.isFile((Path)(prjFile = PathUtil.create((String)fc.getDirectory(), (String[])new String[]{selectedFile})), (LinkOption[])new LinkOption[0])) {
            Path experimentDir = prjFile.getParent();
            this.openExperiment(experimentDir);
        }
    }

    public void openExperiment(Path experimentDir) {
        this.storeExperimentState();
        this.clearTabs();
        EventQueue.invokeLater(() -> this.restoreExperimentState(new Experiment(experimentDir, this)));
    }

    private boolean isValidGosuSourceFile(Path file) {
        if (file == null) {
            return false;
        }
        String strName = PathUtil.getName((Path)file).toLowerCase();
        return strName.endsWith(".gs") || strName.endsWith(".gsx") || strName.endsWith(".gst") || strName.endsWith(".gsp");
    }

    public void saveAs() {
        JFileChooser fc = new JFileChooser(this.getCurrentFile().toFile());
        fc.setDialogTitle("Save Gosu Path");
        fc.setDialogType(1);
        fc.setCurrentDirectory(this.getCurrentFile() != null ? this.getCurrentFile().getParent().toFile() : PathUtil.create((String)".", (String[])new String[0]).toFile());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f.toPath());
            }

            @Override
            public String getDescription() {
                return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            this.setCurrentFile(fc.getSelectedFile().toPath());
            this.save();
        }
    }

    public void dumpBytecode() {
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        this.showConsole(true);
        this.clearOutput();
        byte[] bytes = TypeSystem.getGosuClassLoader().getBytes((ICompilableType)this.getClassAtCaret());
        ClassReader cr = new ClassReader(bytes);
        int flags = 0;
        StringWriter out = new StringWriter();
        cr.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new GosuTextifier(), new PrintWriter(out)), flags);
        System.out.println(out);
    }

    private IGosuClass getClassAtCaret() {
        IParsedElement elemAtCaret;
        IParseTree locAtCaret = this.getCurrentGosuEditor().getDeepestLocationAtCaret();
        if (locAtCaret == null) {
            return this.getCurrentGosuEditor().getParsedClass();
        }
        for (elemAtCaret = locAtCaret.getParsedElement(); elemAtCaret != null && !(elemAtCaret instanceof IClassStatement) && !(elemAtCaret instanceof IBlockExpression); elemAtCaret = elemAtCaret.getParent()) {
        }
        if (elemAtCaret == null) {
            return this.getCurrentGosuEditor().getParsedClass();
        }
        if (elemAtCaret instanceof IClassStatement) {
            return elemAtCaret.getGosuClass();
        }
        if (elemAtCaret instanceof IBlockExpression) {
            return ((IBlockExpression)elemAtCaret).getBlockGosuClass();
        }
        throw new IllegalStateException("Unexpected parse element: " + elemAtCaret.getClass().getName());
    }

    public void execute(IRunConfig runConfig) {
        if (this._runState != RunState.None) {
            return;
        }
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        this.getExperiment().addRunConfig(runConfig);
        this._processRunner = runConfig.run();
    }

    public void debug(IRunConfig runConfig) {
        if (this._runState != RunState.None) {
            return;
        }
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        this.getExperiment().addRunConfig(runConfig);
        this._processRunner = runConfig.debug();
    }

    public boolean isRunning() {
        return this._runState == RunState.Run;
    }

    public boolean isDebugging() {
        return this._runState == RunState.Debug;
    }

    public TypeNameCache getTypeNamesCache() {
        return this._typeNamesCache;
    }

    public void addBusySignal(RunState runState) {
        this._runState = runState;
    }

    public void pipeInput() {
        EventQueue.invokeLater(() -> {
            try {
                this._oldIn = System.in;
                PipedInputStream sysIn = new PipedInputStream();
                Process process = this._processRunner.getProcess();
                if (process == null) {
                    this._inWriter = new OutputStreamWriter(new PipedOutputStream(sysIn));
                    System.setIn(sysIn);
                } else {
                    this._inWriter = new OutputStreamWriter(process.getOutputStream());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JTextPane outputPanel = this._consolePanel.getOutputPanel();
            outputPanel.setEditable(true);
            this._sysInListener = new SysInListener();
            outputPanel.addKeyListener(this._sysInListener);
        });
    }

    public void killProcess() {
        if (this._processRunner != null) {
            Process process;
            if (this._debugger != null && (this._debugger.isSuspended() || this._debugger.isPaused())) {
                this._debugger.resumeExecution();
            }
            if ((process = this._processRunner.getProcess()) != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    public Debugger getDebugger() {
        return this._debugger;
    }

    public void clearDebugger() {
        this._debugger = null;
        EventQueue.invokeLater(() -> {
            this.showDebugger(false);
            if (this.getConsolePanel() != null) {
                this.showConsole(true);
            }
        });
    }

    public void makeDebugger(VirtualMachine vm) {
        EventQueue.invokeLater(() -> {
            this._debugger = new Debugger(vm, this._breakpointManager);
            this._debugger.addChangeListener(dbg -> EventQueue.invokeLater(this::handleDebuggerStateChange));
            this.showDebugger(true);
            this.showConsole(true);
            this._debugger.startDebugging();
        });
    }

    private void handleDebuggerStateChange() {
        Location location;
        if (!EventQueue.isDispatchThread()) {
            throw new Error();
        }
        EditorHost editor = this.getCurrentEditor();
        if (editor != null) {
            editor.repaint();
        }
        if (this._debugger != null && this._debugger.isSuspended() && (location = this._debugger.getSuspendedLocation()) != null) {
            this.jumptToBreakpoint(location, false);
        }
    }

    public void jumptToBreakpoint(Location location, boolean bFocus) {
        String fqn = Debugger.getOutermostType(location.declaringType());
        int line = location.lineNumber();
        if (line <= 0) {
            return;
        }
        EventQueue.invokeLater(() -> {
            Debugger debugger;
            if (this.openType(fqn, bFocus)) {
                this.getCurrentEditor().gotoLine(line);
            }
            if ((debugger = this.getDebugger()) != null && debugger.getEventName() != null && (debugger.getEventName().contains("Breakpoint") || debugger.getEventName().contains("Exception"))) {
                this.showDebugger(true);
            }
        });
    }

    public void showDebugger(boolean bShow) {
        if (bShow) {
            if (this._debugPanel == null) {
                this._debugPanel = new DebugPanel(this._debugger);
                this._bottomTabPane.addTab(this._processRunner.getRunConfig().getName(), EditorUtilities.loadIcon("images/debug.png"), this._debugPanel);
                this._debugPanel.addLocationListener(loc -> this.jumptToBreakpoint((Location)loc, false));
            } else {
                ITab tab = this._bottomTabPane.findTabWithContent(this._debugPanel);
                this._bottomTabPane.selectTab(tab, false);
            }
        } else {
            this._bottomTabPane.removeTabWithContent(this._debugPanel);
            if (this._bottomTabPane.getTabCount() == 0) {
                this._outerSplitPane.collapseBottom(this._bottomTabPane);
            }
            this._debugPanel = null;
        }
    }

    public BreakpointManager getBreakpointManager() {
        return this._breakpointManager;
    }

    public TabPane getEditorTabPane() {
        return this._editorTabPane;
    }

    public List<FileTree> getOpenFilesInProject() {
        ArrayList<FileTree> files = new ArrayList<FileTree>();
        for (ITab tab : this.getEditorTabPane().getTabs()) {
            FileTree tree;
            Path file;
            EditorHost editor = (EditorHost)tab.getContentPane();
            if (editor == null || (file = (Path)editor.getClientProperty("_file")) == null || (tree = FileTreeUtil.getRoot().find(file)) == null) continue;
            files.add(tree);
        }
        return files;
    }

    public void removeBusySignal() {
        if (this._runState != RunState.None) {
            this._runState = RunState.None;
            if (this._consolePanel != null) {
                this._consolePanel.getOutputPanel().setEditable(false);
                this._consolePanel.getOutputPanel().removeKeyListener(this._sysInListener);
            }
            this._inWriter = null;
            System.setIn(this._oldIn);
        }
    }

    public void clearOutput() {
        this._consolePanel.clear();
    }

    public AtomicUndoManager getUndoManager() {
        return this.getCurrentEditor() != null ? this.getCurrentEditor().getUndoManager() : this._defaultUndoMgr;
    }

    public void selectTab(Path file) {
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            EditorHost editor = (EditorHost)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !editor.getClientProperty("_file").equals(file)) continue;
            this._editorTabPane.selectTab(this._editorTabPane.getTabAt(i), true);
            return;
        }
        this.openFile(file, true);
    }

    public void closeTab(Path file) {
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            EditorHost editor = (EditorHost)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !editor.getClientProperty("_file").equals(file)) continue;
            this._editorTabPane.removeTab(this._editorTabPane.getTabAt(i));
            return;
        }
    }

    public void goBackward() {
        this.getTabSelectionHistory().goBackward();
    }

    public boolean canGoBackward() {
        return this.getTabSelectionHistory().canGoBackward();
    }

    public void goForward() {
        this.getTabSelectionHistory().goForward();
    }

    public boolean canGoForward() {
        return this.getTabSelectionHistory().canGoForward();
    }

    public void displayRecentViewsPopup() {
        ArrayList<ITabHistoryContext> mruViewsList = new ArrayList<ITabHistoryContext>(this.getTabSelectionHistory().getTabMruList());
        for (int i = 0; i < mruViewsList.size(); ++i) {
            ITabHistoryContext ctx = (ITabHistoryContext)mruViewsList.get(i);
            if (ctx == null || !ctx.represents(this.getCurrentEditor())) continue;
            mruViewsList.remove(ctx);
        }
        LabelListPopup popup = new LabelListPopup("Recent Files", mruViewsList, "No recent files");
        popup.addNodeChangeListener(e -> {
            ITabHistoryContext context = (ITabHistoryContext)e.getSource();
            this.getTabSelectionHistory().getTabHistoryHandler().selectTab(context);
        });
        popup.show(this, this.getWidth() / 2 - 100, this.getHeight() / 2 - 200);
    }

    public boolean isDirty(EditorHost editor) {
        if (editor == null) {
            return false;
        }
        Boolean bDirty = (Boolean)editor.getClientProperty("_bDirty");
        return bDirty == null ? false : bDirty;
    }

    public void setDirty(EditorHost editor, boolean bDirty) {
        editor.putClientProperty("_bDirty", bDirty);
    }

    public Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    private void markErrorsForGosuLanguageTest() {
        GosuDocument document = this.getCurrentGosuEditor().getDocument();
        ParseResultsException pre = document.getParseResultsException();
        if (pre == null || !pre.hasParseExceptions() && !pre.hasParseWarnings()) {
            return;
        }
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        for (IParseIssue pi : pre.getParseIssues()) {
            ResourceKey messageKey = pi.getMessageKey();
            if (messageKey == null) continue;
            String issue = messageKey.getKey();
            int iLine = pi.getLine();
            ArrayList<String> issues = (ArrayList<String>)map.get(iLine);
            if (issues == null) {
                issues = new ArrayList<String>();
                map.put(iLine, issues);
            }
            issues.add(issue);
        }
        ArrayList<Integer> lines = new ArrayList<Integer>(map.keySet());
        Collections.sort(lines);
        try {
            String text = document.getText(0, document.getLength());
            String[] strLines = text.split("\n");
            this.removeOldIssueKeyMarkers(strLines);
            this.addIssueKeyMarkers(strLines, lines, map);
            CompoundEdit atom = this.getUndoManager().beginUndoAtom("Mark Phase");
            document.replace(0, text.length(), this.joinLines(strLines), null);
            this.getUndoManager().endUndoAtom(atom);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String joinLines(String[] strLines) {
        StringBuilder sb = new StringBuilder();
        for (String line : strLines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void removeOldIssueKeyMarkers(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            int issueIndex = lines[i].indexOf("  //## issuekeys:");
            if (issueIndex == -1) continue;
            lines[i] = lines[i].substring(0, issueIndex);
        }
    }

    private void addIssueKeyMarkers(String[] strLines, List<Integer> lines, Map<Integer, List<String>> map) {
        for (int iLine : lines) {
            String issues = this.makeIssueString(map.get(iLine));
            strLines[iLine - 1] = strLines[iLine - 1].concat(issues);
        }
    }

    private String makeIssueString(List<String> issues) {
        StringBuilder sb = new StringBuilder();
        for (String issue : issues) {
            sb.append(sb.length() != 0 ? ", " : "").append(issue);
        }
        sb.insert(0, "  //## issuekeys: ");
        return sb.toString();
    }

    class RedoActionHandler
    extends AbstractAction {
        RedoActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                GosuPanel.this.getUndoManager().redo();
            }
        }

        @Override
        public boolean isEnabled() {
            return GosuPanel.this.getUndoManager().canRedo();
        }
    }

    class UndoActionHandler
    extends AbstractAction {
        UndoActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                GosuPanel.this.getUndoManager().undo();
            }
        }

        @Override
        public boolean isEnabled() {
            return GosuPanel.this.getUndoManager().canUndo();
        }
    }

    class SysInListener
    extends KeyAdapter {
        SysInListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                JTextPane op = GosuPanel.this._consolePanel.getOutputPanel();
                Element elem = this.getElementAt(op.getCaretPosition() - 1);
                try {
                    String text = GosuPanel.this._consolePanel.getOutputPanel().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                    GosuPanel.this._inWriter.write(text);
                    GosuPanel.this._inWriter.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Element getElementAt(int offset) {
            return this.getElementAt(GosuPanel.this._consolePanel.getOutputPanel().getDocument().getDefaultRootElement(), offset);
        }

        private Element getElementAt(Element parent, int offset) {
            if (parent.isLeaf()) {
                return parent;
            }
            return this.getElementAt(parent.getElement(parent.getElementIndex(offset)), offset);
        }
    }
}

