/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.PackagePropertyInfo;
import editor.PackageType;
import editor.TypePropertyInfo;
import editor.util.EditorUtilities;
import gw.lang.reflect.BaseFeatureInfo;
import gw.lang.reflect.IAnnotationInfo;
import gw.lang.reflect.IConstructorInfo;
import gw.lang.reflect.IEventInfo;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IPropertyInfo;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.MethodList;
import gw.lang.reflect.TypeInfoUtil;
import gw.lang.reflect.TypeSystem;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackageTypeInfo
extends BaseFeatureInfo
implements ITypeInfo {
    private PackageType _packageType;
    private List<IPropertyInfo> _properties;
    private Map<CharSequence, IPropertyInfo> _propertiesByName;

    public PackageTypeInfo(PackageType packageType) {
        super((IType)packageType);
        this._packageType = packageType;
        this._propertiesByName = new HashMap<CharSequence, IPropertyInfo>();
    }

    public boolean isStatic() {
        return false;
    }

    public String getName() {
        return this._packageType.getName();
    }

    public List<? extends IPropertyInfo> getProperties() {
        this.makeProperties();
        return this._properties;
    }

    public IPropertyInfo getProperty(CharSequence propName) {
        this.makeProperties();
        return this._propertiesByName.get(propName);
    }

    public IMethodInfo getCallableMethod(CharSequence strMethod, IType ... params) {
        return null;
    }

    public IConstructorInfo getCallableConstructor(IType ... params) {
        return null;
    }

    private void makeProperties() {
        if (this._properties != null) {
            return;
        }
        String strNamePlusDot = this.getName() + ".";
        Set allTypeNames = TypeSystem.getAllTypeNames();
        Set<String> allInPackage = this.getAllInPackage(allTypeNames, strNamePlusDot);
        if (allInPackage == null) {
            return;
        }
        this.getPropertiesInPackage(allInPackage, strNamePlusDot.length());
    }

    private void getPropertiesInPackage(Set<String> allInPackage, int iPropertyOffset) {
        boolean bError = false;
        int i = 0;
        for (String strType : allInPackage) {
            int iPropertyEnd = strType.indexOf(46, iPropertyOffset);
            if (iPropertyEnd < 0) {
                try {
                    TypePropertyInfo pi = new TypePropertyInfo((IFeatureInfo)this, strType);
                    this._propertiesByName.put(pi.getFeatureType().getRelativeName(), pi);
                }
                catch (Exception e) {
                    EditorUtilities.handleUncaughtException(e);
                    if (!bError) {
                        bError = true;
                    }
                }
            } else {
                String strPackage = strType.substring(0, iPropertyEnd);
                String strSubPackage = strPackage.substring(iPropertyOffset);
                if (!this._propertiesByName.containsKey(strSubPackage)) {
                    PackagePropertyInfo pi = new PackagePropertyInfo((IFeatureInfo)this, strPackage);
                    this._propertiesByName.put(pi.getFeatureType().getRelativeName(), pi);
                }
            }
            ++i;
        }
        this._properties = TypeInfoUtil.makeSortedUnmodifiableRandomAccessListFromFeatures(this._propertiesByName);
    }

    private Set<String> getAllInPackage(Set<? extends CharSequence> allTypeNames, String strNamePlusDot) {
        HashSet<String> allInPackage = new HashSet<String>();
        for (CharSequence charSequence : allTypeNames) {
            String strType = ((Object)charSequence).toString();
            if (!strType.startsWith(strNamePlusDot) || strType.endsWith(".PLACEHOLDER")) continue;
            allInPackage.add(strType);
        }
        return allInPackage;
    }

    public MethodList getMethods() {
        return MethodList.EMPTY;
    }

    public IMethodInfo getMethod(CharSequence methodName, IType ... params) {
        return null;
    }

    public List<IConstructorInfo> getConstructors() {
        return Collections.emptyList();
    }

    public IConstructorInfo getConstructor(IType ... params) {
        return null;
    }

    public List<IEventInfo> getEvents() {
        return Collections.emptyList();
    }

    public IEventInfo getEvent(CharSequence strEvent) {
        return null;
    }

    public List<IAnnotationInfo> getDeclaredAnnotations() {
        return Collections.emptyList();
    }
}

