/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorHost;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import gw.lang.IIssue;
import gw.lang.IIssueContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.text.Highlighter;

public class ParserFeedbackPanel
extends JPanel {
    private JLabel _icon;
    private FeedbackMargin _feedback;
    private EditorHost _editor;

    public ParserFeedbackPanel() {
        this.configureUI();
    }

    public void update(EditorHost editor) {
        this._editor = editor;
        this._icon.setIcon(this.findIconForResults());
        this._feedback.repaint();
        this.repaint();
        editor.repaint();
    }

    private Icon findIconForResults() {
        IIssueContainer issues = this._editor.getIssues();
        if (issues.isEmpty()) {
            return EditorUtilities.loadIcon("images/rule_green.gif");
        }
        if (!issues.getErrors().isEmpty()) {
            return EditorUtilities.loadIcon("images/rule_red.gif");
        }
        return EditorUtilities.loadIcon("images/rule_yellow.gif");
    }

    void configureUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(Scheme.active().getControl());
        this.setBorder(null);
        this._icon = new JLabel();
        this._icon.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)this._icon, "North");
        this._feedback = new FeedbackMargin();
        ToolTipManager.sharedInstance().registerComponent(this._feedback);
        this.add((Component)this._feedback, "Center");
    }

    private class FeedbackMargin
    extends JPanel {
        private Point _iMousePos;

        FeedbackMargin() {
            MarkMouseHandler errorMarkMouser = new MarkMouseHandler();
            this.addMouseMotionListener(errorMarkMouser);
            this.addMouseListener(errorMarkMouser);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (ParserFeedbackPanel.this._editor == null) {
                return;
            }
            int iLineCount = this.getLineCount();
            this.paintHighlightMarks(g, iLineCount);
            this.paintIssueMarks(g, iLineCount);
        }

        private void paintIssueMarks(Graphics g, int iLineCount) {
            IIssueContainer pe = ParserFeedbackPanel.this._editor.getIssues();
            if (pe != null) {
                List warnings = pe.getWarnings();
                for (IIssue issue : warnings) {
                    this.paintWarningMark(g, issue, iLineCount);
                }
                List errors = pe.getErrors();
                for (IIssue issue : errors) {
                    this.paintErrorMark(g, issue, iLineCount);
                }
            }
        }

        private void paintHighlightMarks(Graphics g, int iLineCount) {
            for (Highlighter.Highlight highlight : ParserFeedbackPanel.this._editor.getEditor().getHighlighter().getHighlights()) {
                Highlighter.HighlightPainter painter = highlight.getPainter();
                if (painter != EditorHost.LabHighlighter.TEXT && painter != EditorHost.LabHighlighter.USAGE) continue;
                int line = ParserFeedbackPanel.this._editor.getEditor().getDocument().getDefaultRootElement().getElementIndex(highlight.getStartOffset());
                this.paintHighlightMark(g, line, iLineCount);
            }
        }

        private void paintWarningMark(Graphics g, IIssue w, int iLineCount) {
            int iMark = this.getMarkForLine(w.getLine(), iLineCount);
            g.setColor(Scheme.active().getColorWarning());
            g.fillRect(1, iMark - 1, this.getWidth() - 2, 3);
            g.setColor(Scheme.active().getColorWarningShadow());
            g.drawLine(2, iMark + 1, this.getWidth() - 2, iMark + 1);
            g.drawLine(this.getWidth() - 2, iMark - 1, this.getWidth() - 2, iMark + 1);
        }

        private void paintErrorMark(Graphics g, IIssue e, int iLineCount) {
            int iMark = this.getMarkForLine(e.getLine(), iLineCount);
            g.setColor(Scheme.active().getColorError());
            g.fillRect(1, iMark - 1, this.getWidth() - 2, 3);
            g.setColor(Scheme.active().getColorErrorShadow());
            g.drawLine(2, iMark + 1, this.getWidth() - 2, iMark + 1);
            g.drawLine(this.getWidth() - 2, iMark - 1, this.getWidth() - 2, iMark + 1);
        }

        private void paintHighlightMark(Graphics g, int line, int iLineCount) {
            int iMark = this.getMarkForLine(line, iLineCount);
            g.setColor(Scheme.active().usageReadHighlightColor());
            g.fillRect(1, iMark - 1, this.getWidth() - 2, 3);
            g.setColor(Scheme.active().usageReadHighlightShadowColor());
            g.drawLine(2, iMark + 1, this.getWidth() - 2, iMark + 1);
            g.drawLine(this.getWidth() - 2, iMark - 1, this.getWidth() - 2, iMark + 1);
        }

        @Override
        public String getToolTipText() {
            if (this._iMousePos == null) {
                return null;
            }
            return this.makeToolTipText(this.getErrorsFromCursorPos());
        }

        private String makeToolTipText(List<IIssue> issues) {
            if (issues == null || issues.isEmpty()) {
                return null;
            }
            Object strFeedback = "";
            for (int i = issues.size() - 1; i >= 0; --i) {
                strFeedback = ((String)strFeedback).length() > 0 ? (String)strFeedback + "<br><hr>" : "<html>";
                IIssue pi = issues.get(i);
                strFeedback = (String)strFeedback + "&nbsp;" + HTMLEscapeUtil.escape(pi.getMessage());
            }
            return strFeedback;
        }

        private List<IIssue> getErrorsFromCursorPos() {
            if (ParserFeedbackPanel.this._editor == null) {
                return Collections.emptyList();
            }
            ArrayList<IIssue> matches = new ArrayList<IIssue>();
            IIssueContainer pe = ParserFeedbackPanel.this._editor.getIssues();
            if (pe == null) {
                return matches;
            }
            int iLineCount = this.getLineCount();
            List pes = pe.getIssues();
            for (int i = pes.size() - 1; i >= 0; --i) {
                IIssue e = (IIssue)pes.get(i);
                int iMark = this.getMarkForLine(e.getLine(), iLineCount);
                if (iMark < this._iMousePos.y - 3 || iMark > this._iMousePos.y + 3) continue;
                matches.add(e);
            }
            return matches;
        }

        private List<Highlighter.Highlight> getHighlightsFromCursorPos() {
            if (ParserFeedbackPanel.this._editor == null) {
                return Collections.emptyList();
            }
            ArrayList<Highlighter.Highlight> matches = new ArrayList<Highlighter.Highlight>();
            int iLineCount = this.getLineCount();
            for (Highlighter.Highlight highlight : ParserFeedbackPanel.this._editor.getEditor().getHighlighter().getHighlights()) {
                int line;
                int iMark;
                Highlighter.HighlightPainter painter = highlight.getPainter();
                if (painter != EditorHost.LabHighlighter.TEXT && painter != EditorHost.LabHighlighter.USAGE || (iMark = this.getMarkForLine(line = ParserFeedbackPanel.this._editor.getEditor().getDocument().getDefaultRootElement().getElementIndex(highlight.getStartOffset()), iLineCount)) < this._iMousePos.y - 3 || iMark > this._iMousePos.y + 3) continue;
                matches.add(highlight);
            }
            return matches;
        }

        private int getMarkForLine(int line, int iLineCount) {
            if (--iLineCount == 0) {
                return this.getHeight() / 2;
            }
            int iLine = line - 1;
            float fOffset = (float)iLine / (float)iLineCount;
            return (int)((float)(this.getHeight() - 10) * fOffset) + 5;
        }

        public int getLineCount() {
            int iLinesOfCode = ParserFeedbackPanel.this._editor.getEditor().getDocument().getDefaultRootElement().getElementCount();
            int iViewHeight = ParserFeedbackPanel.this._editor.getScroller().getViewport().getHeight();
            FontMetrics fm = ParserFeedbackPanel.this._editor.getEditor().getFontMetrics(ParserFeedbackPanel.this._editor.getEditor().getFont());
            int iLineHeight = fm.getHeight();
            int iViewLines = iViewHeight / iLineHeight;
            return Math.max(iViewLines, iLinesOfCode);
        }

        private class MarkMouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private MarkMouseHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                FeedbackMargin.this._iMousePos = e.getPoint();
                List<IIssue> errors = FeedbackMargin.this.getErrorsFromCursorPos();
                if (!errors.isEmpty()) {
                    FeedbackMargin.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    List<Highlighter.Highlight> highlights = FeedbackMargin.this.getHighlightsFromCursorPos();
                    if (!highlights.isEmpty()) {
                        FeedbackMargin.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        FeedbackMargin.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                List<IIssue> errors = FeedbackMargin.this.getErrorsFromCursorPos();
                if (!errors.isEmpty()) {
                    ParserFeedbackPanel.this._editor.getEditor().requestFocusInWindow();
                    ParserFeedbackPanel.this._editor.getEditor().setCaretPosition(errors.get(0).getStartOffset());
                } else {
                    List<Highlighter.Highlight> highlights = FeedbackMargin.this.getHighlightsFromCursorPos();
                    if (!highlights.isEmpty()) {
                        ParserFeedbackPanel.this._editor.getEditor().requestFocusInWindow();
                        ParserFeedbackPanel.this._editor.getEditor().setCaretPosition(highlights.get(0).getStartOffset());
                    }
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        }
    }
}

