/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CopyBuffer;
import editor.splitpane.SplitPane;
import editor.util.EditorUtilities;
import editor.util.LabButton;
import gw.util.GosuStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class PasteBufferSelectDialog
extends JDialog
implements ListSelectionListener,
ClipboardOwner {
    private JTextArea _textArea;
    private List<String> _copyBuffer;
    private JTextComponent _textComponent;
    private JList<String> _selectionList;
    private SplitPane _splitPane;

    public PasteBufferSelectDialog(JTextComponent textComponent) throws HeadlessException {
        super(EditorUtilities.frameForComponent(textComponent), "Choose content to paste");
        this._textComponent = textComponent;
        this._copyBuffer = CopyBuffer.instance().getCopyBuffer();
        this.initUI();
    }

    private void initUI() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.installKeys(contentPanel);
        this._textArea = new JTextArea();
        this._textArea.setEditable(false);
        this._textArea.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane bottom = new JScrollPane(this._textArea);
        List<String> strings = this._copyBuffer;
        this._selectionList = new JList<String>(this.truncateList(strings));
        this._selectionList.setBorder(BorderFactory.createEmptyBorder());
        this._selectionList.setSelectionMode(0);
        this._selectionList.addListSelectionListener(this);
        this._selectionList.setFont(this._textArea.getFont());
        this._selectionList.setCellRenderer(new CustomListCellRenderer());
        JScrollPane top = new JScrollPane(this._selectionList);
        this._splitPane = new SplitPane(0, top, bottom);
        contentPanel.add((Component)this._splitPane, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        buttonPane.add(new LabButton(new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.doPaste();
            }
        }));
        buttonPane.add(new LabButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.setVisible(false);
            }
        }));
        contentPanel.add((Component)buttonPane, "South");
        this.setSize(400, 500);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setContentPane(contentPanel);
    }

    private void installKeys(JPanel contentPanel) {
        InputMap inputMap = contentPanel.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "close-window");
        contentPanel.getActionMap().put("close-window", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.setVisible(false);
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "paste-selection");
        contentPanel.getActionMap().put("paste-selection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.doPaste();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "up-arrow");
        contentPanel.getActionMap().put("up-arrow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.selectPrevious();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "down-arrow");
        contentPanel.getActionMap().put("down-arrow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteBufferSelectDialog.this.selectNext();
            }
        });
    }

    private void doPaste() {
        Clipboard clipboard = EditorUtilities.getClipboard();
        int index = this._selectionList.getSelectedIndex();
        String selection = this._copyBuffer.get(index);
        CopyBuffer.instance().notifyOfPaste(index);
        clipboard.setContents(new StringSelection(selection), this);
        this._textComponent.paste();
        this.setVisible(false);
    }

    private void selectNext() {
        if (this._selectionList.getModel().getSize() > 0) {
            this._selectionList.setSelectedIndex(Math.min(this._selectionList.getModel().getSize() - 1, this._selectionList.getSelectedIndex() + 1));
        }
    }

    private void selectPrevious() {
        if (this._selectionList.getModel().getSize() > 0) {
            this._selectionList.setSelectedIndex(Math.max(0, this._selectionList.getSelectedIndex() - 1));
        }
    }

    private String[] truncateList(List<String> strings) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String s : strings) {
            String str;
            String string = str = GosuStringUtil.isWhitespace((String)s) ? s : GosuStringUtil.strip((String)s);
            if (str.contains("\n")) {
                String[] strings1 = str.split("\n");
                str = strings1.length > 0 ? strings1[0] : " ";
            }
            returnList.add(this.elide(str));
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    private String elide(String str) {
        return str.length() > 50 ? str.substring(0, 50) + "..." : str;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this._selectionList.getSelectedIndex();
        String string = this._copyBuffer.get(index);
        this._textArea.setText(string);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this._splitPane.setPosition(50.0);
            if (this._selectionList.getModel().getSize() > 0) {
                this._selectionList.setSelectedIndex(0);
            }
        }
        super.setVisible(visible);
    }

    private static class CustomListCellRenderer
    extends DefaultListCellRenderer {
        private CustomListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent cellRendererComponent = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            cellRendererComponent.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            return cellRendererComponent;
        }
    }
}

