/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IContextMenuHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class PopupHandler<E>
extends MouseAdapter {
    protected E _owner;
    private IContextMenuHandler<E> _contextMenuHandler;

    public PopupHandler(E owner, IContextMenuHandler<E> contextMenuHandler) {
        this._owner = owner;
        this._contextMenuHandler = contextMenuHandler;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handleContextMenu(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handleContextMenu(e);
    }

    private void handleContextMenu(MouseEvent e) {
        int iXPos = e.getX();
        int iYPos = e.getY();
        if (e.isPopupTrigger()) {
            this.handleRightClick(iXPos, iYPos, e.getComponent());
        }
    }

    protected void handleRightClick(int iXPos, int iYPos, Component component) {
        EventQueue.invokeLater(() -> this._contextMenuHandler.displayContextMenu(this._owner, iXPos, iYPos, component));
    }
}

