/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.util.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public abstract class SimpleDocumentFilter
extends DocumentFilter {
    private final Object _promptLock = new Object();
    private List<Pair<Integer, Integer>> _offsetMods = new ArrayList<Pair<Integer, Integer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(final DocumentFilter.FilterBypass fb, final int offset, final int length) throws BadLocationException {
        if (this.isPromptingForEdit()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SimpleDocumentFilter.this._promptLock;
                        synchronized (object) {
                            SimpleDocumentFilter.this._promptLock.wait();
                        }
                        if (SimpleDocumentFilter.this.wasLastPromptAccepted()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int realOffset = SimpleDocumentFilter.this.getRealOffset(offset);
                                    try {
                                        SimpleDocumentFilter.super.remove(fb, realOffset, length);
                                    }
                                    catch (BadLocationException e) {
                                        throw new RuntimeException(e);
                                    }
                                    SimpleDocumentFilter.this._offsetMods.add(new Pair<Integer, Integer>(realOffset, -length));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }.start();
        } else {
            this._offsetMods.clear();
            if (this.acceptEdit(null)) {
                super.remove(fb, offset, length);
                this._offsetMods.add(new Pair<Integer, Integer>(offset, -length));
            }
            Object object = this._promptLock;
            synchronized (object) {
                this._promptLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void replace(final DocumentFilter.FilterBypass fb, final int offset, final int length, final String text, final AttributeSet attrs) throws BadLocationException {
        if (this.isPromptingForEdit()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SimpleDocumentFilter.this._promptLock;
                        synchronized (object) {
                            SimpleDocumentFilter.this._promptLock.wait();
                        }
                        if (SimpleDocumentFilter.this.wasLastPromptAccepted()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int realOffset = SimpleDocumentFilter.this.getRealOffset(offset);
                                    try {
                                        SimpleDocumentFilter.super.replace(fb, realOffset, length, text, attrs);
                                    }
                                    catch (BadLocationException e) {
                                        throw new RuntimeException(e);
                                    }
                                    SimpleDocumentFilter.this._offsetMods.add(new Pair<Integer, Integer>(realOffset, text.length() - length));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }.start();
        } else {
            this._offsetMods.clear();
            if (this.acceptEdit(text)) {
                super.replace(fb, offset, length, text, attrs);
                this._offsetMods.add(new Pair<Integer, Integer>(offset, text == null ? 0 : text.length() - length));
            }
            Object object = this._promptLock;
            synchronized (object) {
                this._promptLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertString(final DocumentFilter.FilterBypass fb, final int offset, final String string, final AttributeSet attr) throws BadLocationException {
        if (this.isPromptingForEdit()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = SimpleDocumentFilter.this._promptLock;
                        synchronized (object) {
                            SimpleDocumentFilter.this._promptLock.wait();
                        }
                        if (SimpleDocumentFilter.this.wasLastPromptAccepted()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    int realOffset = SimpleDocumentFilter.this.getRealOffset(offset);
                                    try {
                                        SimpleDocumentFilter.super.insertString(fb, realOffset, string, attr);
                                    }
                                    catch (BadLocationException e) {
                                        throw new RuntimeException(e);
                                    }
                                    SimpleDocumentFilter.this._offsetMods.add(new Pair<Integer, Integer>(realOffset, string.length()));
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }.start();
        } else {
            this._offsetMods.clear();
            if (this.acceptEdit(string)) {
                super.insertString(fb, offset, string, attr);
                this._offsetMods.add(new Pair<Integer, Integer>(offset, string.length()));
            }
            Object object = this._promptLock;
            synchronized (object) {
                this._promptLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPrompt() {
        Object object = this._promptLock;
        synchronized (object) {
            try {
                this._promptLock.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public abstract boolean acceptEdit(String var1);

    protected boolean isPromptingForEdit() {
        return false;
    }

    protected boolean wasLastPromptAccepted() {
        return true;
    }

    private int getRealOffset(int offset) {
        int realOffset = offset;
        for (Pair<Integer, Integer> offsetMod : this._offsetMods) {
            if (realOffset < offsetMod.getFirst()) continue;
            realOffset += offsetMod.getSecond().intValue();
        }
        return realOffset;
    }
}

