/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.IValuePopup;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import editor.util.EditorUtilities;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuEscapeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;

public class StringPopup
extends JPopupMenu
implements IValuePopup {
    private JPanel _pane = new JPanel();
    private EventListenerList _nodeListenerList = new EventListenerList();
    private JTextComponent _editor;
    private String _strValue;
    private boolean _escapeForJava;
    private JTextArea _field;
    private String _strLabel;

    public StringPopup(String strValue, String strLabel, JTextComponent editor) {
        this(strValue, strLabel, editor, true, 1, 26);
    }

    public StringPopup(String strValue, String strLabel, JTextComponent editor, boolean escapeForJava, int rows, int columns) {
        this._editor = editor;
        this._strValue = strValue;
        this._strLabel = strLabel;
        this._escapeForJava = escapeForJava;
        this.initLayout(rows, columns);
    }

    protected void initLayout(int rows, int columns) {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        this._pane.setLayout(new BorderLayout());
        this._field = new JTextArea(rows, columns);
        this._field.setLineWrap(true);
        JTextArea sample = new JTextArea(1, 26);
        final int iPrefHeight = sample.getPreferredSize().height < 5 ? 22 : sample.getPreferredSize().height;
        this._field.setText(this._strValue);
        this._field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (StringPopup.this._field.getHeight() > iPrefHeight * 2 - 2 && !e.isControlDown()) {
                        return;
                    }
                    StringPopup.this.fireNodeChanged(StringPopup.this._nodeListenerList, new ChangeEvent(StringPopup.this._escapeForJava ? GosuEscapeUtil.escapeForJava((String)StringPopup.this._field.getText()) : StringPopup.this._field.getText()));
                    StringPopup.this.setVisible(false);
                }
            }
        });
        this._field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    StringPopup.this.setVisible(false);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._field);
        Dimension dimPref = this._field.getPreferredSize();
        dimPref.width += 20;
        dimPref.height = this._field.getPreferredSize().height;
        scrollPane.setPreferredSize(dimPref);
        this._pane.add("Center", scrollPane);
        content.add((Component)this._pane, "Center");
        this.add(content);
        Object title = this._strLabel == null ? JavaTypes.STRING().getRelativeName() : this._strLabel;
        title = "<html><b>" + (String)title + "</b>   (Ctrl+Enter to apply)";
        JLabel labelTypeName = new JLabel((String)title);
        labelTypeName.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        content.add((Component)labelTypeName, "North");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            EditorUtilities.removePopupBorder(this);
        }
        if (this._editor == null) {
            return;
        }
        if (!bVisible) {
            this._editor.requestFocus();
        } else {
            this._field.requestFocus();
        }
    }

    @Override
    public void show(Component invoker, int iX, int iY) {
        super.show(invoker, iX, iY);
        EventQueue.invokeLater(() -> EventQueue.invokeLater(() -> {
            this._field.requestFocus();
            this._field.selectAll();
        }));
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringPopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }
}

