/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import editor.EditorHost;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.LabFrame;
import editor.debugger.Breakpoint;
import editor.debugger.Debugger;
import editor.debugger.RunToCursorBreakpoint;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BreakpointManager {
    private Map<String, Map<Integer, Breakpoint>> _lineBreakpointsByType = new HashMap<String, Map<Integer, Breakpoint>>();
    private Map<String, Breakpoint> _exceptionBreakpoints = new HashMap<String, Breakpoint>();
    private Set<Runnable> _listeners;
    private boolean _muted;

    public BreakpointManager() {
        this._exceptionBreakpoints.put(((Breakpoint)Breakpoint.ANY_EXCEPTION.get()).getFqn(), (Breakpoint)Breakpoint.ANY_EXCEPTION.get());
        this._listeners = new HashSet<Runnable>();
    }

    public void addChangeListener(Runnable listener) {
        this._listeners.add(listener);
    }

    public void removeChangeLisener(Runnable listener) {
        this._listeners.remove(listener);
    }

    private void notifyListeners() {
        EventQueue.invokeLater(() -> this._listeners.forEach(Runnable::run));
    }

    public boolean isMuted() {
        return this._muted;
    }

    public void setMuted(boolean mute) {
        this._muted = mute;
        Debugger debugger = this.getDebugger();
        if (debugger != null) {
            debugger.muteBreakpoints(mute);
        }
        this.repaintEditor();
    }

    public Breakpoint getBreakpoint(Breakpoint bp) {
        return this.getBreakpointAtEditorLine(bp.getDeclaringFqn(), bp.getLine());
    }

    public Breakpoint getBreakpoint(String exceptionFqn) {
        return this._exceptionBreakpoints.get(exceptionFqn);
    }

    public Breakpoint findBreakpoint(String fqnDeclaring, int line) {
        Map<Integer, Breakpoint> byLine = this._lineBreakpointsByType.get(fqnDeclaring);
        if (byLine != null) {
            return byLine.get(line);
        }
        return null;
    }

    public void toggleLineBreakpoint(EditorHost editor, String fqn, String fqnDeclaring, int line) {
        Breakpoint bp = this.getBreakpointAtEditorLine(fqnDeclaring, line);
        if (bp == null) {
            if (this.canAddBreakpoint(editor, line)) {
                this.addBreakpoint(fqn, fqnDeclaring, line);
            }
        } else {
            this.removeBreakpoint(bp);
        }
    }

    public Breakpoint addExceptionBreakpoint(String fqnException) {
        Debugger debugger;
        Breakpoint bp = new Breakpoint(fqnException, true, true);
        if (this._exceptionBreakpoints.putIfAbsent(fqnException, bp) == null && (debugger = this.getDebugger()) != null) {
            debugger.addBreakpointJdi(bp);
        }
        return this._exceptionBreakpoints.get(fqnException);
    }

    public void runToCursor(GosuEditor editor) {
        Debugger debugger;
        int line = editor.getLineNumberAtCaret();
        if (this.canAddBreakpoint(editor, line) && (debugger = this.getDebugger()) != null) {
            String fqn = editor.getScriptPart().getContainingTypeName();
            RunToCursorBreakpoint runToCursorBp = new RunToCursorBreakpoint(fqn, editor.getTypeAtLine(line), line);
            debugger.addBreakpointJdi(runToCursorBp);
            debugger.resumeExecution();
        }
    }

    public boolean canAddBreakpoint(EditorHost editor, int line) {
        return editor.canAddBreakpoint(line);
    }

    public List<Breakpoint> getLineBreakpoints() {
        ArrayList<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
        this._lineBreakpointsByType.values().stream().forEach(m -> m.values().forEach(breakpoints::add));
        return breakpoints;
    }

    public Map<Integer, Breakpoint> getBreakpointsByType(String fqnDeclaring) {
        return this._lineBreakpointsByType.get(fqnDeclaring);
    }

    public void removeBreakpoint(Breakpoint bp) {
        if (bp.isLineBreakpoint()) {
            Map<Integer, Breakpoint> byLine = this._lineBreakpointsByType.get(bp.getDeclaringFqn());
            if (byLine == null) {
                return;
            }
            Breakpoint breakpoint = byLine.get(bp.getLine());
            if (breakpoint != null) {
                byLine.remove(bp.getLine());
                this.removeFromDebuggerAndNotify(bp);
            }
        } else {
            Breakpoint removed = this._exceptionBreakpoints.remove(bp.getFqn());
            if (removed != null) {
                this.removeFromDebuggerAndNotify(bp);
            }
        }
    }

    private void removeFromDebuggerAndNotify(Breakpoint bp) {
        Debugger debugger = this.getDebugger();
        if (debugger != null) {
            debugger.removeBreakpointJdi(bp);
        }
        this.notifyListeners();
    }

    public Breakpoint getBreakpointAtEditorLine(String fqnDeclaring, int line) {
        Map<Integer, Breakpoint> byLine = this._lineBreakpointsByType.get(fqnDeclaring);
        if (byLine == null) {
            return null;
        }
        return byLine.get(line);
    }

    public Collection<Breakpoint> getExceptionBreakpoints() {
        return this._exceptionBreakpoints.values();
    }

    public Breakpoint getExceptionBreakpoint(String fqnException) {
        return this._exceptionBreakpoints.get(fqnException);
    }

    public Breakpoint getExecPointAtEditorLine(String fqn, String fqnDeclaring, int line) {
        Debugger debugger = this.getDebugger();
        if (debugger == null || !debugger.isSuspended() && !debugger.isPaused() || fqn == null) {
            return null;
        }
        Location location = debugger.getSuspendedLocation();
        if (location == null) {
            return null;
        }
        if (line == location.lineNumber() && fqn.equals(Debugger.getOutermostType(location.declaringType()))) {
            return new Breakpoint(fqn, fqnDeclaring, line);
        }
        return null;
    }

    public Breakpoint getFramePointAtEditorLine(String fqn, String fqnDeclaring, int line) {
        Debugger debugger = this.getDebugger();
        if (debugger == null || !debugger.isSuspended() && !debugger.isPaused() || fqn == null) {
            return null;
        }
        ThreadReference thread = this.getGosuPanel().getDebugPanel().getSelectedThread();
        if (thread == null) {
            return null;
        }
        try {
            for (StackFrame frame : thread.frames()) {
                Location location = frame.location();
                if (line != location.lineNumber() || !fqn.equals(Debugger.getOutermostType(location.declaringType()))) continue;
                return new Breakpoint(fqn, fqnDeclaring, line);
            }
        }
        catch (IncompatibleThreadStateException | VMDisconnectedException exception) {
            // empty catch block
        }
        return null;
    }

    private void addBreakpoint(String fqn, String fqnDeclaring, int line) {
        Map<Integer, Breakpoint> byLine = this._lineBreakpointsByType.get(fqnDeclaring);
        if (byLine == null) {
            byLine = new HashMap<Integer, Breakpoint>();
            this._lineBreakpointsByType.put(fqnDeclaring, byLine);
        }
        Breakpoint bp = new Breakpoint(fqn, fqnDeclaring, line);
        byLine.put(line, bp);
        Debugger debugger = this.getDebugger();
        if (debugger != null) {
            debugger.addBreakpointJdi(bp);
        }
        this.notifyListeners();
    }

    private EditorHost getCurrentEditor() {
        return this.getGosuPanel().getCurrentEditor();
    }

    private Debugger getDebugger() {
        return this.getGosuPanel().getDebugger();
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }

    private void repaintEditor() {
        EditorHost editor = this.getCurrentEditor();
        if (editor != null) {
            editor.repaint();
        }
    }
}

