/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Value;
import editor.DefaultContextMenuHandler;
import editor.GosuEditor;
import editor.GosuPanel;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.debugger.Debugger;
import editor.debugger.DebuggerExpression;
import editor.debugger.VarTree;
import editor.debugger.VarTreeCellRenderer;
import editor.search.StringUtil;
import editor.splitpane.CollapsibleSplitPane;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import gw.lang.GosuShop;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.Keyword;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.TypelessScriptPartId;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.util.ContextSymbolTableUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class EvaluateDialog
extends JDialog
implements IHandleCancel {
    private final String _expr;
    private GosuEditor _fieldExpr;
    private JTree _varTree;
    private int _offset;
    private String _immediateClass;
    private String _fqn;

    public EvaluateDialog(String expr) {
        super((Frame)LabFrame.instance(), "Evaluate Script");
        this._expr = expr;
        this.configUi();
        this.setDefaultCloseOperation(2);
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setBackground(Scheme.active().getMenu());
        contentPane.setLayout(new BorderLayout());
        CollapsibleSplitPane splitPane = new CollapsibleSplitPane(1, this.makeExpressionPanel(), this.makeResultPane());
        this.add((Component)splitPane, "Center");
        contentPane.add((Component)splitPane, "Center");
        splitPane.setPosition(6.0);
        this.mapCancelKeystroke("Close", this::close);
        this.setSize(500, 500);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private JScrollPane makeResultPane() {
        this._varTree = new JTree(this.makeEmptyModel());
        this._varTree.setBorder(null);
        this._varTree.setBackground(Scheme.active().getWindow());
        this._varTree.setRootVisible(true);
        this._varTree.setShowsRootHandles(true);
        this._varTree.setRowHeight(22);
        this._varTree.getSelectionModel().setSelectionMode(1);
        this._varTree.setVisibleRowCount(20);
        this._varTree.setCellRenderer(new VarTreeCellRenderer(this._varTree));
        return new JScrollPane(this._varTree);
    }

    private JComponent makeExpressionPanel() {
        Location loc = this.getSuspendedLocation();
        this._fieldExpr = this.createFieldExpr(loc);
        this.addKeyHandler(this._fieldExpr);
        this._fieldExpr.setAccessAll(true);
        try {
            this._fieldExpr.read((IScriptPartId)new TypelessScriptPartId("debugger condition"), this._expr);
            if (!this._expr.isEmpty()) {
                this._fieldExpr.getEditor().selectAll();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(30, 30));
        panel.add((Component)this._fieldExpr, "Center");
        return panel;
    }

    private GosuEditor createFieldExpr(Location loc) {
        if (loc == null) {
            return new GosuEditor((ISymbolTable)new StandardSymbolTable(true), null, new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
        }
        String outermostTypeName = Debugger.getOutermostType(loc.declaringType());
        IType outermostType = TypeSystem.getByFullNameIfValidNoJava((String)outermostTypeName);
        return new GosuEditor(this.makeSymTable(loc, outermostType), null, new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
    }

    private ISymbolTable makeSymTable(Location loc, IType outermostType) {
        if (outermostType instanceof IGosuClass) {
            return ContextSymbolTableUtil.getSymbolTableAtOffset((IGosuClass)((IGosuClass)outermostType), (int)StringUtil.getLineOffset(((IGosuClass)outermostType).getSource(), loc.lineNumber()));
        }
        StandardSymbolTable symTable = new StandardSymbolTable();
        IType thisType = TypeSystem.getByFullNameIfValid((String)loc.declaringType().name().replace('$', '.'));
        if (thisType != null) {
            symTable.putSymbol(GosuShop.createSymbol((CharSequence)Keyword.KW_this.getName(), (IType)thisType, null));
        }
        return symTable;
    }

    private Location getSuspendedLocation() {
        Debugger debugger = this.getGosuPanel().getDebugger();
        return debugger.isSuspended() ? debugger.getSuspendedLocation() : null;
    }

    private void updateResult() {
        DefaultTreeModel model;
        String script = this._fieldExpr.getText();
        if (this.locate() && script != null && script.length() > 0) {
            try {
                Value value = new DebuggerExpression(script, this._fqn, this._immediateClass, this._offset).evaluate(this.getGosuPanel().getDebugger());
                model = new DefaultTreeModel(new VarTree("Result", value == null ? "null" : value.type().name(), value));
            }
            catch (InvocationException e) {
                model = new DefaultTreeModel(new VarTree("Result", e.exception().referenceType().name(), e.exception()));
            }
        } else {
            model = this.makeEmptyModel();
        }
        this._varTree.setModel(model);
    }

    private DefaultTreeModel makeEmptyModel() {
        return new DefaultTreeModel(new VarTree("Result", "void", null));
    }

    private boolean locate() {
        Location suspendedLoc = this.getSuspendedLocation();
        if (suspendedLoc == null) {
            return false;
        }
        this._fqn = Debugger.getOutermostType(suspendedLoc.declaringType());
        IType topLevelClass = TypeSystem.getByFullName((String)this._fqn);
        if (!(topLevelClass instanceof IGosuClass)) {
            this._immediateClass = suspendedLoc.declaringType().name().replace('$', '.');
            return true;
        }
        IGosuClass topLevelGosuClass = (IGosuClass)topLevelClass;
        this._offset = StringUtil.getLineOffset(topLevelGosuClass.getSource(), suspendedLoc.lineNumber());
        topLevelClass.isValid();
        IParseTree loc = topLevelGosuClass.getClassStatement().getLocation().getDeepestLocation(this._offset, false);
        if (loc == null) {
            return false;
        }
        int i = 0;
        while (loc != null && loc.getOffset() < this._offset) {
            loc = topLevelGosuClass.getClassStatement().getLocation().getDeepestLocation(this._offset + ++i, true);
        }
        if (loc == null) {
            return false;
        }
        this._offset = loc.getOffset();
        this._immediateClass = loc.getParsedElement().getGosuClass().getName();
        return true;
    }

    private void addKeyHandler(final GosuEditor gosuEditor) {
        gosuEditor.getEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && !gosuEditor.isCompletionPopupShowing()) {
                    EvaluateDialog.this.close();
                } else if (e.getKeyCode() == 10 && (this.isOneLine() || e.isControlDown()) && !gosuEditor.isCompletionPopupShowing()) {
                    EvaluateDialog.this.updateResult();
                    e.consume();
                }
            }

            private boolean isOneLine() {
                return EvaluateDialog.this._fieldExpr.getHeight() < EvaluateDialog.this._fieldExpr.getFontMetrics(EvaluateDialog.this._fieldExpr.getFont()).getHeight() * 2;
            }
        });
    }

    protected void close() {
        this.dispose();
    }

    private GosuPanel getGosuPanel() {
        return LabFrame.instance().getGosuPanel();
    }
}

