/*
 * Decompiled with CFR 0.152.
 */
package editor.plugin.typeloader.java;

import editor.EditorHost;
import editor.plugin.typeloader.INewFileParams;
import editor.plugin.typeloader.ITypeFactory;
import editor.plugin.typeloader.java.JavaDocument;
import editor.plugin.typeloader.java.JavaEditorKit;
import editor.plugin.typeloader.java.JavaFileParams;
import gw.lang.IIssueContainer;
import gw.lang.javac.JavaIssueContainer;
import gw.lang.javac.StringJavaFileObject;
import gw.lang.reflect.IType;
import gw.lang.reflect.java.IJavaClassInfo;
import gw.lang.reflect.java.IJavaType;
import java.awt.EventQueue;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import manifold.internal.host.RuntimeManifoldHost;

public class JavaTypeFactory
implements ITypeFactory {
    @Override
    public boolean canCreate() {
        return false;
    }

    @Override
    public String getFileExtension() {
        return ".java";
    }

    @Override
    public String getName() {
        return "Class";
    }

    @Override
    public String getIcon() {
        return "images/javaclass.png";
    }

    @Override
    public INewFileParams makeDefaultParams(String fqn) {
        return new JavaFileParams(fqn);
    }

    @Override
    public JComponent makePanel(INewFileParams params) {
        return null;
    }

    @Override
    public CharSequence createNewFileContents(INewFileParams params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaEditorKit makeEditorKit() {
        return new JavaEditorKit();
    }

    @Override
    public void parse(IType type, String strText, boolean forceCodeCompletion, boolean changed, EditorHost editor) {
        DiagnosticCollector errorHandler = new DiagnosticCollector();
        StringJavaFileObject fileObj = new StringJavaFileObject(type.getName(), strText);
        RuntimeManifoldHost.get().getJavaParser().compile((JavaFileObject)fileObj, type.getName(), Arrays.asList("-source", "8", "-g", "-nowarn", "-Xlint:none", "-proc:none", "-parameters"), errorHandler);
        EventQueue.invokeLater(() -> {
            ((JavaDocument)editor.getDocument()).setErrorHandler(errorHandler);
            editor.getEditor().repaint();
        });
    }

    @Override
    public String getTypeAtOffset(IType type, int offset) {
        IJavaClassInfo classInfo = ((IJavaType)type).getBackingClassInfo();
        IJavaClassInfo deepestClass = classInfo.getDeepestClassAtOffset(offset);
        if (deepestClass != null) {
            return deepestClass.getName();
        }
        return null;
    }

    @Override
    public boolean canAddBreakpoint(IType type, int line) {
        return true;
    }

    @Override
    public String getTooltipMessage(int iPos, EditorHost editor) {
        return ((JavaDocument)editor.getDocument()).findErrorMessage(iPos);
    }

    @Override
    public IIssueContainer getIssueContainer(EditorHost editor) {
        return new JavaIssueContainer(((JavaDocument)editor.getDocument()).getErrorHandler());
    }
}

