/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.FileTree;
import editor.FileTreeUtil;
import editor.GosuPanel;
import editor.LabFrame;
import editor.NodeKind;
import editor.search.AbstractSearcher;
import editor.search.RegExStringUtil;
import editor.search.SearchLocation;
import editor.search.SearchTree;
import editor.search.StringUtil;
import gw.util.GosuStringUtil;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class TextSearcher
extends AbstractSearcher {
    private final String _pattern;
    private final boolean _caseSensitive;
    private final boolean _wholeWords;
    private final boolean _regEx;

    public TextSearcher(String pattern, boolean caseSensitive, boolean wholeWords, boolean regEx) {
        this._pattern = pattern;
        this._caseSensitive = caseSensitive;
        this._wholeWords = wholeWords;
        this._regEx = regEx;
    }

    @Override
    public boolean search(FileTree tree, SearchTree results) {
        String content;
        if (this.isExcluded(tree)) {
            return false;
        }
        Path file = tree.getFileOrDir();
        try (BufferedReader reader = PathUtil.createReader((Path)file);){
            content = StreamUtil.getContent((Reader)reader);
            content = GosuStringUtil.replace((String)content, (String)"\r\n", (String)"\n");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<SearchLocation> locations = this._regEx ? RegExStringUtil.search(content, this._pattern, !this._caseSensitive) : StringUtil.search(content, this._pattern, !this._caseSensitive, this._wholeWords);
        if (locations.isEmpty()) {
            return false;
        }
        SearchTree searchTree = this.getOrMakePath(tree, results);
        for (SearchLocation loc : locations) {
            SearchTree.SearchTreeNode node = new SearchTree.SearchTreeNode(tree, loc);
            SearchTree res = new SearchTree(NodeKind.Info, node);
            searchTree.addViaModel(res);
        }
        return true;
    }

    public List<SearchLocation> searchLocal() {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        FileTree tree = FileTreeUtil.find(gosuPanel.getCurrentFile(), gosuPanel.getCurrentEditor().getParsedClass().getName());
        SearchTree results = new SearchTree("root", NodeKind.Directory, SearchTree.empty());
        this.searchTree(tree, results, this::isTextFile, null);
        return this.findLocations(results, new ArrayList<SearchLocation>());
    }

    private boolean isTextFile(FileTree ft) {
        return FileTreeUtil.isSupportedTextFile(ft);
    }

    private List<SearchLocation> findLocations(SearchTree tree, List<SearchLocation> locations) {
        if (tree == null) {
            return locations;
        }
        SearchTree.SearchTreeNode node = (SearchTree.SearchTreeNode)tree.getNode();
        if (node != null && node.getLocation() != null) {
            locations.add(node.getLocation());
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                this.findLocations((SearchTree)tree.getChildAt(i), locations);
            }
        }
        return locations;
    }
}

