/*
 * Decompiled with CFR 0.152.
 */
package editor.shipit;

import editor.GotoProgramTypePopup;
import editor.IHandleCancel;
import editor.LabFrame;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.LabButton;
import editor.util.LabCheckbox;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuProgram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ShipItDialog
extends JDialog
implements IHandleCancel {
    private String _strProgramName;
    private boolean _bBundleGosu;
    private Experiment _experiment;
    private LabCheckbox _cbBundleGosu;
    private LabCheckbox _cbPrecompile;
    private JTextField _fieldProgramName;
    private JButton _btnOk;
    private JLabel _errorMsg;

    public ShipItDialog(Experiment experiment) {
        super(LabFrame.instance(), "Ship It!", true);
        this.setIconImage(EditorUtilities.loadIcon("images/shipit.png").getImage());
        this._experiment = experiment;
        this.configUi();
    }

    public boolean isBundleGosu() {
        return this._bBundleGosu;
    }

    public String getProgramName() {
        return this._strProgramName;
    }

    protected void configUi() {
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints c = new GridBagConstraints();
        int iY = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 2, 12, 0);
        mainPanel.add((Component)new JLabel("<html>Ready to release your experiment? Create an all-in-one <i>executable</i> Jar! Your entire experiment, including dependencies, is bundled up in a single Jar file. The file directly executes on any machine with Java 8 or later installed."), c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        mainPanel.add((Component)new JLabel("What program do you want to launch from the Jar?", EditorUtilities.loadIcon("images/program.png"), 2), c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        this._fieldProgramName = new JTextField();
        mainPanel.add((Component)this._fieldProgramName, c);
        this._fieldProgramName.getDocument().addDocumentListener(new DocListener());
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        LabButton btn = new LabButton("...");
        btn.setToolTipText("Find program");
        btn.addActionListener(e -> this.displayProgramPopup());
        mainPanel.add((Component)btn, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        this._errorMsg = new JLabel(" ");
        mainPanel.add((Component)this._errorMsg, c);
        this._errorMsg.setForeground(new Color(100, 0, 0));
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        this._cbBundleGosu = new LabCheckbox("Bundle Gosu runtime", true);
        mainPanel.add((Component)this._cbBundleGosu, c);
        this._cbBundleGosu.setToolTipText("<html>This option bundles a copy of Gosu in your jar.  Without this option your jar<br>uses a compatible version of Gosu installed on the user's machine, if one <br>exits.  Otherwise, the jar automatically installs Gosu after prompting for <br>approval.  Subsequent execution of the jar uses the newly installed Gosu.");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 0, 0);
        this._cbPrecompile = new LabCheckbox("Precompile Source", true);
        mainPanel.add((Component)this._cbPrecompile, c);
        this._cbPrecompile.setToolTipText("<html>This option fully compiles your experiment and includes resulting .class files<br>in your jar.  The upside: your experiment may load faster; the downside: your<br>jar file will be a little larger.  Note precompilation is optional since Gosu's<br>runtime <i>dynamically compiles</i> source if not already compiled.");
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(20, 2, 8, 0);
        mainPanel.add((Component)new JLabel("<html>The resulting <b>" + this.getExperiment().getName() + ".jar</b> file will be placed in the experiment's root folder.<br>You can run the file by typing the following on a command line:<br>&nbsp;&nbsp;&nbsp;&nbsp;<pre>java -jar " + this.getExperiment().getName() + ".jar</pre><br>You can also run the jar directly from your file manager or command shell.  Note<br>you can distribute your jar on the web using a file hosting service like Dropbox,<br>Google Drive, etc."), c);
        c.anchor = 17;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(2, 2, 0, 0);
        mainPanel.add((Component)new JPanel(), c);
        contentPane.add((Component)mainPanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel filler = new JPanel();
        south.add((Component)filler, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this._btnOk = new LabButton("Make Executable Jar");
        this._btnOk.setMnemonic('M');
        this._btnOk.addActionListener(e -> {
            this.doOKAction();
            this.close();
        });
        buttonPanel.add(this._btnOk);
        this.getRootPane().setDefaultButton(this._btnOk);
        this._btnOk.setEnabled(false);
        LabButton btnCancel = new LabButton("Cancel");
        btnCancel.addActionListener(e -> this.close());
        buttonPanel.add(btnCancel);
        south.add((Component)buttonPanel, "East");
        contentPane.add((Component)south, "South");
        this.mapCancelKeystroke("Cancel", this::close);
        this.setSize(540, 465);
        EditorUtilities.centerWindowInFrame(this, this.getOwner());
    }

    private void displayProgramPopup() {
        GotoProgramTypePopup.display(this._fieldProgramName, this._fieldProgramName.getText(), this::updateProgramName);
    }

    private void updateProgramName(String fqn) {
        this._fieldProgramName.setText(fqn);
    }

    private Experiment getExperiment() {
        return this._experiment;
    }

    protected void doOKAction() {
        this._strProgramName = this._fieldProgramName.getText();
        this._bBundleGosu = this._cbBundleGosu.isSelected();
    }

    private void close() {
        this.dispose();
    }

    public boolean isPrecompiled() {
        return this._cbPrecompile.isSelected();
    }

    private class DocListener
    implements DocumentListener {
        private DocListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(ShipItDialog.this._fieldProgramName.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(ShipItDialog.this._fieldProgramName.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(ShipItDialog.this._fieldProgramName.getText());
        }

        private void update(String fqn) {
            if (fqn == null || fqn.isEmpty()) {
                ShipItDialog.this._btnOk.setEnabled(false);
                ShipItDialog.this._errorMsg.setText(" ");
            } else {
                IType type = TypeSystem.getByFullNameIfValid((String)fqn);
                if (type instanceof IGosuProgram) {
                    ShipItDialog.this._fieldProgramName.setForeground(Scheme.active().getWindowText());
                    ShipItDialog.this._btnOk.setEnabled(true);
                    ShipItDialog.this._errorMsg.setText(" ");
                } else {
                    ShipItDialog.this._fieldProgramName.setForeground(new Color(200, 0, 0));
                    ShipItDialog.this._btnOk.setEnabled(false);
                    ShipItDialog.this._errorMsg.setText("<html>Please enter a valid <b><i>program</i></b> name");
                }
            }
            ShipItDialog.this.revalidate();
        }
    }
}

