/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.IContextMenuHandler;
import editor.Scheme;
import editor.splitpane.ICaptionBar;
import editor.splitpane.ICaptionedPanel;
import editor.tabpane.ContentContainer;
import editor.tabpane.ITab;
import editor.tabpane.SimpleLabel;
import editor.tabpane.StandardTab;
import editor.tabpane.TabAndToolContainer;
import editor.tabpane.TabContainer;
import editor.tabpane.TabPosition;
import editor.tabpane.ToolContainer;
import editor.util.EditorUtilities;
import editor.util.ILabel;
import editor.util.SettleModalEventQueue;
import editor.util.SmartMenuItem;
import gw.util.GosuObjectUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabPane
extends JPanel
implements ICaptionedPanel {
    private static final int HEADER_MARGIN = 5;
    static final String TAB_PANE = "_tabPaneProperty";
    public static final int MINIMIZABLE = 1;
    public static final int MAXIMIZABLE = 2;
    public static final int RESTORABLE = 4;
    public static final int MIN_MAX_REST = 7;
    public static final int DYNAMIC = 8;
    public static final int TOP_BORDER_ONLY = 16;
    private TabContainer _tabContainer;
    private ToolContainer _toolContainer;
    private TabAndToolContainer _tabAndToolContainer;
    private ContentContainer _contentContainer;
    private TabPosition _tabPosition;
    private boolean _bDynamic;
    private boolean _bTopBorderOnly;
    private boolean _bActive;
    private boolean _bMaximizable;
    private boolean _bMinimizable;
    private boolean _bRestorable;
    private FocusChangeListener _focusChangeListener;

    public TabPane() {
        this(TabPosition.TOP, 0);
    }

    public TabPane(int iDisplayOptions) {
        this(TabPosition.TOP, iDisplayOptions);
    }

    public TabPane(TabPosition tabPosition, int iDisplayOptions) {
        this._tabPosition = tabPosition;
        this._bDynamic = (iDisplayOptions & 8) != 0;
        this._bTopBorderOnly = (iDisplayOptions & 0x10) != 0;
        this._bMaximizable = (iDisplayOptions & 2) != 0;
        this._bMinimizable = (iDisplayOptions & 1) != 0;
        this._bRestorable = (iDisplayOptions & 4) != 0;
        this.configUi();
        this._focusChangeListener = new FocusChangeListener();
        this.addAncestorListener(new FocusChangeListenerAdderRemover());
    }

    @Override
    public ICaptionBar getCaption() {
        return this._tabAndToolContainer;
    }

    public void addTab(ILabel tabLabel, JComponent contentPane) {
        this._tabContainer.addTab(new StandardTab(this._tabContainer, tabLabel, contentPane, true));
    }

    public void addTabWithoutSelecting(ILabel tabLabel, JComponent contentPane) {
        this._tabContainer.addTabWithoutSelecting(new StandardTab(this._tabContainer, tabLabel, contentPane, true));
    }

    public ITab addTab(String strText, Icon icon, JComponent contentPane) {
        return this.insertTab(strText, icon, contentPane, -1);
    }

    public ITab insertTab(ILabel tabLabel, JComponent contentPane, int iIndex) {
        return this._tabContainer.insertTab(new StandardTab(this._tabContainer, tabLabel, contentPane, true), iIndex, true);
    }

    public ITab insertTab(String strText, Icon icon, JComponent contentPane, int iIndex) {
        return this._tabContainer.insertTab(new StandardTab(this._tabContainer, new SimpleLabel(strText, icon), contentPane, this.isDynamic()), iIndex, true);
    }

    public void removeTabWithContent(JComponent contentPane) {
        this._tabContainer.removeTabWithContent(contentPane);
    }

    public void removeTab(ITab tab) {
        this._tabContainer.removeTab(tab);
    }

    public void removeAllTabs() {
        this._tabContainer.removeAllTabs();
    }

    public void selectTabWithContent(JComponent contentPane, boolean bFocus) {
        this._tabContainer.selectTab(contentPane, bFocus);
    }

    public void selectTab(ITab tab, boolean bFocus) {
        this._tabContainer.selectTab(tab, bFocus);
    }

    public void selectTabWithLabel(String label) {
        ITab tab = this.findTabWithLabel(label);
        if (tab != null) {
            this._tabContainer.selectTab(tab, true);
        }
    }

    public ITab getTabAt(int iIndex) {
        return this._tabContainer.getTabAt(iIndex);
    }

    public ITab getSelectedTab() {
        return this._tabContainer.getSelectedTab();
    }

    public int getSelectedTabIndex() {
        return this._tabContainer.getSelectedTabIndex();
    }

    public int getTabCount() {
        return this._tabContainer.getTabCount();
    }

    public ITab[] getTabs() {
        return this._tabContainer.getTabs();
    }

    public ITab findTabWithContent(JComponent contentPane) {
        return this._tabContainer.findTabWithContent(contentPane);
    }

    public ITab findTabWithLabel(String label) {
        ITab tab = null;
        for (ITab iTab : this.getTabs()) {
            if (!GosuObjectUtil.equals((Object)iTab.getLabel().getDisplayName(), (Object)label)) continue;
            tab = iTab;
        }
        return tab;
    }

    public void addSelectionListener(ChangeListener l) {
        this._tabContainer.addSelectionListener(l);
    }

    public void removeSelectionListener(ChangeListener l) {
        this._tabContainer.removeSelectionListener(l);
    }

    public boolean isDynamic() {
        return this._bDynamic;
    }

    public boolean isTopBorderOnly() {
        return this._bTopBorderOnly;
    }

    public boolean isActive() {
        return this._bActive;
    }

    public void setActive(boolean bActive) {
        if (bActive != this._bActive) {
            this._bActive = bActive;
            this.repaint();
        }
    }

    public boolean isMaximizable() {
        return this._bMaximizable;
    }

    public boolean isMinimizable() {
        return this._bMinimizable;
    }

    public boolean isRestorable() {
        return this._bRestorable;
    }

    public boolean hasAtLeastOneOfMinMaxRestore() {
        return this.isMaximizable() || this.isMinimizable() || this.isRestorable();
    }

    public IContextMenuHandler<JComponent> getContextMenuHandler() {
        return this._tabContainer.getContextMenuHandler();
    }

    public void setContextMenuHandler(IContextMenuHandler<JComponent> handler) {
        this._tabContainer.setContextMenuHandler(handler);
    }

    public TabContainer getTabContainer() {
        return this._tabContainer;
    }

    public ToolContainer getToolContainer() {
        return this._toolContainer;
    }

    TabAndToolContainer getTabAndToolContainer() {
        return this._tabAndToolContainer;
    }

    private void configUi() {
        this.setLayout(new BorderLayout());
        this._contentContainer = new ContentContainer(this);
        this.add((Component)this._contentContainer, "Center");
        this._tabContainer = new TabContainer(this._tabPosition);
        this._tabContainer.putClientProperty(TAB_PANE, this);
        this._toolContainer = new ToolContainer(this);
        this._tabAndToolContainer = new TabAndToolContainer(this);
        if (this._tabPosition == TabPosition.TOP) {
            this.add((Component)this._tabAndToolContainer, "North");
        } else if (this._tabPosition == TabPosition.BOTTOM) {
            this.add((Component)this._tabAndToolContainer, "South");
        } else if (this._tabPosition == TabPosition.RIGHT) {
            this.add((Component)this._tabAndToolContainer, "East");
        } else if (this._tabPosition == TabPosition.LEFT) {
            this.add((Component)this._tabAndToolContainer, "West");
        } else {
            throw new IllegalStateException("Unknown TabPosition ");
        }
        this._tabContainer.addSelectionListener(new ContentDisplayHandler());
        this.setBorder();
        if (this.isDynamic()) {
            this._tabContainer.setContextMenuHandler(new DefaultContextMenuHandler());
        }
    }

    private void setBorder() {
        if (this._tabPosition == TabPosition.TOP) {
            if (!this.isTopBorderOnly()) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
            } else {
                this.setBorder(null);
                this._tabAndToolContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
            }
        } else if (this._tabPosition == TabPosition.BOTTOM) {
            if (!this.isTopBorderOnly()) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
            } else {
                this.setBorder(null);
                this._tabAndToolContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
            }
        } else if (this._tabPosition == TabPosition.RIGHT) {
            if (!this.isTopBorderOnly()) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            } else {
                this.setBorder(null);
                this._tabAndToolContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 0, 0, 5)));
            }
        } else if (this._tabPosition == TabPosition.LEFT) {
            if (!this.isTopBorderOnly()) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            } else {
                this.setBorder(null);
                this._tabAndToolContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, Scheme.active().getScrollbarBorderColor()), BorderFactory.createEmptyBorder(0, 5, 0, 0)));
            }
        }
    }

    private void addFocusOwnerListener() {
        KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (Arrays.asList(focusMgr.getPropertyChangeListeners()).contains(this._focusChangeListener)) {
            return;
        }
        focusMgr.addPropertyChangeListener("permanentFocusOwner", this._focusChangeListener);
    }

    private void removeFocusOwnerListener() {
        KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusMgr.removePropertyChangeListener("permanentFocusOwner", this._focusChangeListener);
    }

    public void localeChanged() {
        for (ITab tab : this.getTabs()) {
            tab.refresh();
        }
    }

    private class DefaultContextMenuHandler
    implements IContextMenuHandler<JComponent> {
        private DefaultContextMenuHandler() {
        }

        @Override
        public JPopupMenu getContextMenu(final JComponent editor) {
            JPopupMenu contextMenu = new JPopupMenu();
            contextMenu.add(new SmartMenuItem(new AbstractAction("Close This Tab"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultContextMenuHandler.this.closeTab(editor);
                }
            }));
            contextMenu.add(new SmartMenuItem(new AbstractAction("Close Other Tabs"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultContextMenuHandler.this.closeAll(editor);
                }
            }));
            contextMenu.add(new SmartMenuItem(new AbstractAction("Close All Tabs"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DefaultContextMenuHandler.this.closeAll(null);
                }
            }));
            return contextMenu;
        }

        @Override
        public void displayContextMenu(JComponent editor, int iX, int iY, Component eventSource) {
            this.getContextMenu(editor).show(editor, iX, iY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeAll(JComponent c) {
            Component root = EditorUtilities.showWaitCursor(true);
            try {
                ITab leaveOpen;
                ITab iTab = leaveOpen = c == null ? null : this.tabForComponent(c);
                if (leaveOpen == null) {
                    TabPane.this.setVisible(false);
                }
                try {
                    ITab[] tabs = TabPane.this.getTabs();
                    for (int i = tabs.length - 1; i >= 0; --i) {
                        ITab tab = tabs[i];
                        if (tab == leaveOpen) continue;
                        this.closeTab(tab.getComponent());
                    }
                }
                finally {
                    TabPane.this.setVisible(true);
                }
            }
            finally {
                EditorUtilities.showWaitCursor(false, root);
            }
        }

        private void closeTab(Component c) {
            ITab tab = this.tabForComponent(c);
            TabPane.this.getTabContainer().removeTab(tab);
            SettleModalEventQueue.instance().run();
        }

        private ITab tabForComponent(Component c) {
            if (c == null) {
                return null;
            }
            if (c instanceof ITab) {
                return (ITab)((Object)c);
            }
            return this.tabForComponent(c.getParent());
        }
    }

    class FocusChangeListenerAdderRemover
    implements AncestorListener {
        FocusChangeListenerAdderRemover() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            TabPane.this.addFocusOwnerListener();
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            TabPane.this.removeFocusOwnerListener();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    class FocusChangeListener
    implements PropertyChangeListener {
        FocusChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (focusMgr.getPermanentFocusOwner() == null) {
                return;
            }
            TabPane.this.setActive(EditorUtilities.containsFocus(TabPane.this));
        }
    }

    public class ContentDisplayHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            JComponent selectedContentPane;
            ITab tab = TabPane.this._tabContainer.getSelectedTab();
            JComponent jComponent = selectedContentPane = tab != null ? tab.getContentPane() : null;
            if (selectedContentPane != null) {
                if (!selectedContentPane.isVisible()) {
                    ((Component)selectedContentPane).setVisible(true);
                }
                if (selectedContentPane.getParent() != TabPane.this._contentContainer) {
                    TabPane.this._contentContainer.add(selectedContentPane);
                }
                TabPane.this._contentContainer.revalidate();
                tab.getContentPane().repaint();
            }
            for (int i = 0; i < TabPane.this._contentContainer.getComponentCount(); ++i) {
                JComponent comp = (JComponent)TabPane.this._contentContainer.getComponent(i);
                if (comp != selectedContentPane) {
                    comp.setVisible(false);
                }
                if (TabPane.this._tabContainer.findTabWithContent(comp) != null) continue;
                TabPane.this._contentContainer.removeDirect(comp);
            }
        }
    }
}

