/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.IValuePopup;
import editor.util.ILabel;
import editor.util.LabelListCellRenderer;
import editor.util.PopupContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class LabelListPopup
extends PopupContainer
implements IValuePopup {
    private JList<ILabel> _list;
    private List<? extends ILabel> _labelList;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private ILabel _emptyText;

    public LabelListPopup(String strTitle, List<? extends ILabel> labels, final String emptyText) {
        this._labelList = labels;
        this._emptyText = new ILabel(){

            @Override
            public String getDisplayName() {
                return emptyText;
            }

            @Override
            public Icon getIcon(int iTypeFlags) {
                return null;
            }
        };
        this.initLayout(strTitle);
    }

    @Override
    protected Component getContentPanel() {
        if (this._labelList.isEmpty()) {
            this._list = new JList<ILabel>(new ILabel[]{this._emptyText});
            this._list.setSelectionModel(new DefaultListSelectionModel(){

                @Override
                public void addSelectionInterval(int index0, int index1) {
                }

                @Override
                public void setSelectionInterval(int index0, int index1) {
                }
            });
            this._list.setForeground(new Color(150, 150, 150));
            this._list.setFont(this._list.getFont().deriveFont(2));
        } else {
            this._list = new JList<ILabel>(new LabelListModel(this._labelList));
            this._list.addMouseListener(new LabelListListener());
            this._list.setFixedCellHeight(22);
            this._list.setCellRenderer(new LabelListCellRenderer(this._list));
            this._list.addKeyListener(new LabelListKeyListener());
            this._list.getSelectionModel().setSelectionMode(0);
        }
        this._list.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        return scrollPane;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = Math.max(dim.width, 180);
        return dim;
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (bVisible) {
            if (this._labelList.size() > 0) {
                this._list.setSelectedIndex(0);
            }
            SwingUtilities.invokeLater(this._list::requestFocus);
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(EventListenerList list, ChangeEvent e) {
        EventQueue.invokeLater(() -> this.fireNodeChangedNow(list, e));
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    class LabelListKeyListener
    extends KeyAdapter {
        LabelListKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                ILabel label = LabelListPopup.this._list.getSelectedValue();
                if (label != null) {
                    LabelListPopup.this.fireNodeChanged(LabelListPopup.this._nodeListenerList, new ChangeEvent(label));
                }
                LabelListPopup.this.setVisible(false);
                e.consume();
            } else if (e.getKeyCode() == 27) {
                LabelListPopup.this.setVisible(false);
                e.consume();
            }
        }
    }

    class LabelListModel
    extends AbstractListModel<ILabel> {
        List<? extends ILabel> _labels;

        LabelListModel(List<? extends ILabel> labels) {
            this._labels = labels;
        }

        @Override
        public int getSize() {
            return this._labels.size();
        }

        @Override
        public ILabel getElementAt(int i) {
            return this._labels.size() == 0 ? null : this._labels.get(i);
        }
    }

    class LabelListListener
    extends MouseAdapter {
        LabelListListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int iIndex = LabelListPopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            LabelListPopup.this._list.setSelectedIndex(iIndex);
            ILabel label = LabelListPopup.this._list.getSelectedValue();
            LabelListPopup.this.fireNodeChanged(LabelListPopup.this._nodeListenerList, new ChangeEvent(label));
            LabelListPopup.this.setVisible(false);
        }
    }
}

