/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.FileTree;
import editor.GosuPanel;
import editor.LabFrame;
import editor.NewIdentifierDialog;
import editor.plugin.typeloader.ITypeFactory;
import editor.util.Experiment;
import editor.util.TypeNameUtil;
import gw.lang.reflect.gs.ClassType;
import gw.util.PathUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JOptionPane;

public class SourceFileCreator {
    private static final SourceFileCreator INSTANCE = new SourceFileCreator();
    private Path _created;

    public static SourceFileCreator instance() {
        return INSTANCE;
    }

    private SourceFileCreator() {
    }

    public Path getCreated() {
        return this._created;
    }

    public void clearCreated() {
        this._created = null;
    }

    public Path getOrMakeUntitledProgram(Experiment experiment) {
        Path srcDir = PathUtil.create((String)experiment.getSourcePath().get(0), (String[])new String[0]);
        PathUtil.mkdirs((Path)srcDir);
        Path scratchPackage = PathUtil.create((Path)srcDir, (String)"scratch");
        PathUtil.mkdirs((Path)scratchPackage);
        Path file = PathUtil.create((Path)scratchPackage, (String)"RunMe.gsp");
        try {
            if (PathUtil.createNewFile((Path)file, (FileAttribute[])new FileAttribute[0])) {
                try (BufferedWriter writer = PathUtil.createWriter((Path)file);){
                    writer.write("//\n// Run this from the Run menu or press F5\n//\nprint(\"Hello, World!\")\n");
                }
                this._created = file;
            }
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void create(ClassType classType) {
        NewIdentifierDialog dlg = new NewIdentifierDialog(classType);
        dlg.setVisible(true);
        if (dlg.getClassName() != null) {
            this.create(PathUtil.create((Path)this.getParentContext(), (String)(dlg.getClassName() + classType.getExt())), classType);
        }
    }

    public void create(ITypeFactory factory) {
        NewIdentifierDialog dlg = new NewIdentifierDialog(factory);
        dlg.setVisible(true);
        if (dlg.getClassName() != null) {
            Path file = PathUtil.create((Path)this.getParentContext(), (String)(dlg.getClassName() + factory.getFileExtension()));
            String fqn = TypeNameUtil.getTypeNameForFile(file);
            this.create(file, factory, fqn);
        }
    }

    public void createNamespace() {
        NewIdentifierDialog dlg = new NewIdentifierDialog();
        dlg.setVisible(true);
        if (dlg.getClassName() != null) {
            Path dir = PathUtil.create((Path)this.getParentContext(), (String)dlg.getClassName());
            PathUtil.mkdirs((Path)dir);
        }
    }

    public void createTextFile() {
        NewIdentifierDialog dlg = new NewIdentifierDialog(true);
        dlg.setVisible(true);
        if (dlg.getClassName() != null) {
            Path file = PathUtil.create((Path)this.getParentContext(), (String)dlg.getClassName());
            PathUtil.mkdirs((Path)file.getParent());
            if (PathUtil.createNewFile((Path)file, (FileAttribute[])new FileAttribute[0])) {
                this._created = file;
            }
        }
    }

    private Path getParentContext() {
        GosuPanel gosuPanel = LabFrame.instance().getGosuPanel();
        FileTree selection = gosuPanel.getExperimentView().getSelectedTree();
        Path parent = null;
        if (selection != null && selection.getParent() != null) {
            if (selection.isFile()) {
                selection = selection.getParent();
            }
            parent = selection.getFileOrDir();
        } else {
            Path currentEditor = gosuPanel.getCurrentFile();
            if (currentEditor != null) {
                parent = currentEditor.getParent();
            }
        }
        return parent;
    }

    public void create(Path file, ITypeFactory factory, String typeName) {
        if (PathUtil.createNewFile((Path)file, (FileAttribute[])new FileAttribute[0])) {
            try (BufferedWriter writer = PathUtil.createWriter((Path)file);){
                writer.write(factory.createNewFileContents(factory.makeDefaultParams(typeName)).toString());
            }
            catch (Exception e) {
                PathUtil.delete((Path)file);
                throw new RuntimeException(e);
            }
        }
        this._created = file;
    }

    public void create(Path selectedFile, ClassType classType) {
        if (PathUtil.createNewFile((Path)selectedFile, (FileAttribute[])new FileAttribute[0]) && !this.writeStub(selectedFile, classType)) {
            PathUtil.delete((Path)selectedFile);
            return;
        }
        this._created = selectedFile;
    }

    private boolean writeStub(Path file, ClassType classType) {
        String strFile = PathUtil.getName((Path)file).toLowerCase();
        if (strFile.endsWith(".gs")) {
            return this.writeClassStub(file, classType);
        }
        if (strFile.endsWith(".gsx")) {
            return this.writeEnhancementStub(file);
        }
        if (strFile.endsWith(".gst")) {
            return this.writeTempateStub(file);
        }
        if (strFile.endsWith(".java")) {
            return this.writeJavaStub(file, classType);
        }
        if (classType == null) {
            return PathUtil.mkdirs((Path)file);
        }
        return true;
    }

    private boolean writeClassStub(Path file, ClassType classType) {
        Object strName = TypeNameUtil.getTypeNameForFile(file);
        if (strName == null) {
            int iOption = this.displayTypeWarning(file);
            if (iOption != 0) {
                return false;
            }
            if (file.getParent() == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "A class must have a parent directory", "Gosu Lab", 0);
                return false;
            }
            strName = PathUtil.getName((Path)file.getParent()) + "." + PathUtil.getName((Path)file).substring(0, PathUtil.getName((Path)file).lastIndexOf(46));
        }
        int iLastDot = ((String)strName).lastIndexOf(46);
        String strRelativeName = ((String)strName).substring(iLastDot + 1);
        String strPackage = iLastDot > 0 ? ((String)strName).substring(0, iLastDot) : "";
        try {
            BufferedWriter writer = PathUtil.createWriter((Path)file);
            String eol = System.getProperty("line.separator");
            writer.write("package " + strPackage + eol + eol + classType.keyword() + " " + strRelativeName + " {" + eol + eol + "}");
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean writeJavaStub(Path file, ClassType classType) {
        Object strName = TypeNameUtil.getTypeNameForFile(file);
        if (strName == null) {
            int iOption = this.displayTypeWarning(file);
            if (iOption != 0) {
                return false;
            }
            if (file.getParent() == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "A class must have a parent directory", "Gosu Lab", 0);
                return false;
            }
            strName = PathUtil.getName((Path)file.getParent()) + "." + PathUtil.getName((Path)file).substring(0, PathUtil.getName((Path)file).lastIndexOf(46));
        }
        int iLastDot = ((String)strName).lastIndexOf(46);
        String strRelativeName = ((String)strName).substring(iLastDot + 1);
        String strPackage = iLastDot > 0 ? ((String)strName).substring(0, iLastDot) : "";
        try {
            BufferedWriter writer = PathUtil.createWriter((Path)file);
            String eol = System.getProperty("line.separator");
            writer.write("package " + strPackage + ";" + eol + eol + "public " + classType.keyword() + " " + strRelativeName + " {" + eol + eol + "}");
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private boolean writeTempateStub(Path file) {
        Object strName = TypeNameUtil.getTypeNameForFile(file);
        if (strName == null) {
            int iOption = this.displayTypeWarning(file);
            if (iOption != 0) {
                return false;
            }
            if (file.getParent() == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "A template must have a parent directory", "Gosu Lab", 0);
                return false;
            }
            strName = PathUtil.getName((Path)file.getParent()) + "." + PathUtil.getName((Path)file).substring(0, PathUtil.getName((Path)file).lastIndexOf(46));
        }
        int iLastDot = ((String)strName).lastIndexOf(46);
        String strRelativeName = ((String)strName).substring(iLastDot + 1);
        try {
            BufferedWriter writer = PathUtil.createWriter((Path)file);
            String eol = System.getProperty("line.separator");
            writer.write("<%@ params( myParam: String ) %>" + eol + eol + "The content of my param is: ${myParam}" + eol + eol + "Note you can render this template from a class or program" + eol + "simply by calling one of its render methods:" + eol + eol + "  " + strRelativeName + ".renderToString( \"wow\" )");
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private int displayTypeWarning(Path file) {
        return JOptionPane.showConfirmDialog(LabFrame.instance(), "<html>The class " + PathUtil.getName((Path)file) + " is not on the current classpath.  Create the class anyway and put it's parent directory in the classpath?  <br><br>WARNING!!!  Ensure that the parent directory does not cover other files and directories you don't want in your class path.<br><br>Consider creating a \"src\" directory and create package folders in there.", "Gosu Lab", 0);
    }

    private boolean writeEnhancementStub(Path file) {
        Object strName = TypeNameUtil.getTypeNameForFile(file);
        if (strName == null) {
            int iOption = this.displayTypeWarning(file);
            if (iOption != 0) {
                return false;
            }
            if (file.getParent() == null) {
                JOptionPane.showMessageDialog(LabFrame.instance(), "A class must have a parent directory", "Gosu Lab", 0);
                return false;
            }
            strName = PathUtil.getName((Path)file.getParent()) + "." + PathUtil.getName((Path)file).substring(0, PathUtil.getName((Path)file).lastIndexOf(46));
        }
        int iLastDot = ((String)strName).lastIndexOf(46);
        String strRelativeName = ((String)strName).substring(iLastDot + 1);
        String strPackage = iLastDot > 0 ? ((String)strName).substring(0, iLastDot) : "";
        try {
            BufferedWriter writer = PathUtil.createWriter((Path)file);
            String eol = System.getProperty("line.separator");
            writer.write("package " + strPackage + eol + eol + "enhancement " + strRelativeName + " : Object //## todo: change me " + eol + "{" + eol + eol + "}");
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }
}

