/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CommonMenus;
import editor.GosuEditor;
import editor.IContextMenuHandler;
import editor.IScriptEditor;
import gw.lang.reflect.gs.IGosuProgram;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.text.BadLocationException;

public class DefaultContextMenuHandler
implements IContextMenuHandler<IScriptEditor> {
    @Override
    public JPopupMenu getContextMenu(IScriptEditor editor) {
        JPopupMenu menu = new JPopupMenu();
        Supplier<GosuEditor> contextEditor = () -> (GosuEditor)editor;
        menu.add(CommonMenus.makeCut(contextEditor));
        menu.add(CommonMenus.makeCopy(contextEditor));
        menu.add(CommonMenus.makePaste(contextEditor));
        menu.add(CommonMenus.makePasteJavaAsGosu(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeCodeComplete(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeParameterInfo(contextEditor));
        menu.add(CommonMenus.makeExpressionType(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeGotoDeclaration(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeShowFileInTree(contextEditor));
        menu.add(new JSeparator());
        menu.add(CommonMenus.makeQuickDocumentation(contextEditor));
        if (editor.getScriptPart() != null && editor.getScriptPart().getContainingType() != null) {
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeViewBytecode());
        }
        if (editor.getScriptPart() != null && editor.getScriptPart().getContainingType() instanceof IGosuProgram) {
            menu.add(new JSeparator());
            menu.add(CommonMenus.makeRun(() -> editor.getScriptPart().getContainingType()));
        }
        return menu;
    }

    @Override
    public void displayContextMenu(IScriptEditor editor, int iXPos, int iYPos, Component eventSource) {
        editor.getEditor().requestFocus();
        try {
            Rectangle rcCaretBounds = editor.getEditor().modelToView(editor.getEditor().getCaretPosition());
            this.getContextMenu(editor).show(editor.getEditor(), rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

