/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuEditor;
import editor.ITabHistoryContext;
import editor.ITabHistoryHandler;
import editor.RunMe;
import editor.util.EditorUtilities;
import java.io.File;
import javax.swing.Icon;

public class EditorTabHistoryHandler
implements ITabHistoryHandler {
    @Override
    public ITabHistoryContext makeTabContext(GosuEditor tab) {
        return new EditorTabContext(tab);
    }

    @Override
    public void selectTab(ITabHistoryContext tabContext) {
        if (tabContext == null) {
            return;
        }
        RunMe.getEditorFrame().selectTab(tabContext.getContentId());
    }

    @Override
    public void closeTab(ITabHistoryContext tabContext) {
        if (tabContext == null) {
            return;
        }
        RunMe.getEditorFrame().closeTab(tabContext.getContentId());
    }

    static class EditorTabContext
    implements ITabHistoryContext {
        private File _contentId;

        public EditorTabContext(GosuEditor editor) {
            this._contentId = (File)editor.getClientProperty("_file");
        }

        @Override
        public String getDisplayName() {
            return this._contentId.getName();
        }

        @Override
        public Icon getIcon(int iTypeFlags) {
            return EditorUtilities.findIcon(this._contentId);
        }

        @Override
        public boolean represents(GosuEditor editor) {
            return editor != null && this._contentId.equals(editor.getClientProperty("_file"));
        }

        @Override
        public boolean equals(ITabHistoryContext other) {
            return this.equals((Object)other);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EditorTabContext that = (EditorTabContext)o;
            return this._contentId.equals(that._contentId);
        }

        @Override
        public int hashCode() {
            int result = this._contentId.hashCode();
            return result;
        }

        @Override
        public File getContentId() {
            return this._contentId;
        }
    }
}

