/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ExperimentView;
import editor.FileWatcher;
import editor.IFileWatcherListener;
import editor.search.MessageDisplay;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTree
implements MutableTreeNode,
IFileWatcherListener {
    private String _name;
    private File _fileOrDir;
    private FileTree _parent;
    private List<FileTree> _children;
    private Experiment _experiment;
    private Icon _icon;

    public FileTree(Experiment experiment) {
        this._fileOrDir = experiment.getExperimentDir();
        this._experiment = experiment;
        this._name = experiment.getName();
        this.addSourcePaths(experiment);
    }

    private FileTree(File fileOrDir, FileTree parent, Experiment experiment) {
        this._fileOrDir = fileOrDir;
        this._parent = parent;
        this._experiment = experiment;
        this._name = this._fileOrDir.getName();
        if (this._fileOrDir.isDirectory()) {
            this.makeSourcePathChildren();
            FileWatcher.instance(this._experiment).register(this);
        } else {
            this._children = Collections.emptyList();
        }
    }

    public String getName() {
        return this._name;
    }

    private void setName(String name) {
        this._name = name;
    }

    private void addSourcePaths(Experiment experiment) {
        List<String> sourcePath = experiment.getSourcePath();
        this._children = new ArrayList<FileTree>();
        for (String path : sourcePath) {
            String experimentDir;
            File srcPath = new File(path);
            String srcPathAbsolute = srcPath.getAbsolutePath();
            if (!srcPathAbsolute.startsWith((experimentDir = experiment.getExperimentDir().getAbsolutePath()) + File.separator)) continue;
            String srcPathName = srcPathAbsolute.substring(experimentDir.length());
            FileTree tree = new FileTree(srcPath, this, experiment);
            tree.setName(srcPathName);
            this._children.add(tree);
        }
    }

    private void makeSourcePathChildren() {
        this.makeSourcePathChildren(this._fileOrDir);
    }

    private void makeSourcePathChildren(File fileOrDir) {
        ArrayList<FileTree> children = new ArrayList<FileTree>();
        File[] files = fileOrDir.listFiles();
        if (files != null) {
            for (File path : files) {
                FileTree insert = new FileTree(path, this, this._experiment);
                children.add(this.getSortedIndex(children, insert), insert);
            }
        }
        this._children = children;
    }

    private int getSortedIndex(List<FileTree> children, FileTree insert) {
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            FileTree tree = children.get(i);
            if ((tree.isDirectory() != insert.isDirectory() || insert.getName().toLowerCase().compareTo(tree.getName().toLowerCase()) > 0) && (!tree.isFile() || !insert.isDirectory())) continue;
            return i;
        }
        return count;
    }

    private boolean isInSourcePath(File path) {
        for (String sp : this._experiment.getSourcePath()) {
            sp = new File(sp).getAbsolutePath();
            String absolutePath = path.getAbsolutePath();
            if (!absolutePath.contains(sp)) continue;
            return true;
        }
        return false;
    }

    public FileTree find(File file) {
        if (this.getFileOrDir().equals(file)) {
            return this;
        }
        for (FileTree tree : this.getChildren()) {
            FileTree found = tree.find(file);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public File getFileOrDir() {
        return this._fileOrDir;
    }

    public boolean isDirectory() {
        return this._fileOrDir.isDirectory();
    }

    public boolean isFile() {
        return this._fileOrDir.isFile();
    }

    public List<FileTree> getChildren() {
        return this._children;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.getChildren().add(index, (FileTree)child);
        child.setParent(this);
    }

    @Override
    public void remove(int index) {
        this.remove(this.getChildren().get(index));
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.getChildren().remove(node);
        if (((FileTree)node).isDirectory()) {
            FileWatcher.instance(this._experiment).unregister((FileTree)node);
        }
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void removeFromParent() {
        this._parent.remove(this);
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this._parent = (FileTree)newParent;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.getChildren().get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public FileTree getParent() {
        return this._parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getChildren().indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory() && this.isInSourcePath(this._fileOrDir);
    }

    @Override
    public boolean isLeaf() {
        return this.isFile();
    }

    public Enumeration children() {
        final Iterator<FileTree> iter = this.getChildren().iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            public Object nextElement() {
                return iter.next();
            }
        };
    }

    public String toString() {
        return this._name;
    }

    @Override
    public void fireCreate(String dir, String file) {
        File newFileOrDir = new File(dir, file);
        EventQueue.invokeLater(() -> {
            FileTree fileTree = new FileTree(newFileOrDir, this, this._experiment);
            ((DefaultTreeModel)this.getExperimentView().getTree().getModel()).insertNodeInto(fileTree, this, this.getSortedIndex(this.getChildren(), fileTree));
            if (fileTree.getType() != null) {
                EventQueue.invokeLater(() -> {
                    File currentFile = this.getExperiment().getGosuPanel().getCurrentFile();
                    if (currentFile != null && currentFile.equals(newFileOrDir)) {
                        fileTree.select();
                    }
                });
            }
        });
    }

    @Override
    public void fireDelete(String dir, String file) {
        File newFileOrDir = new File(dir, file);
        FileTree fileTree = this.find(newFileOrDir);
        if (fileTree != null) {
            EventQueue.invokeLater(() -> ((DefaultTreeModel)this.getExperimentView().getTree().getModel()).removeNodeFromParent(fileTree));
            this.getExperiment().getGosuPanel().closeTab(newFileOrDir);
        }
    }

    public void select() {
        JTree tree = this.getExperimentView().getTree();
        TreePath path = this.getPath();
        tree.expandPath(path);
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public TreePath getPath() {
        List<FileTree> path = this.makePath(new ArrayList<FileTree>());
        return new TreePath(path.toArray(new FileTree[path.size()]));
    }

    private List<FileTree> makePath(List<FileTree> path) {
        if (this.getParent() != null) {
            this.getParent().makePath(path);
        }
        path.add(this);
        return path;
    }

    private ExperimentView getExperimentView() {
        return this._experiment.getGosuPanel().getExperimentView();
    }

    public Experiment getExperiment() {
        return this._experiment;
    }

    public boolean isSourcePathRoot() {
        return this.isDirectory() && this.getExperiment().getSourcePath().contains(this.getFileOrDir().getAbsolutePath());
    }

    public FileTree getSourcePathRoot() {
        FileTree srcPathRoot;
        for (srcPathRoot = this; srcPathRoot != null && !srcPathRoot.isSourcePathRoot(); srcPathRoot = srcPathRoot.getParent()) {
        }
        return srcPathRoot;
    }

    public IType getType() {
        FileTree sourcePathRoot = this.getSourcePathRoot();
        if (this.isDirectory() || this.isSourcePathRoot() || sourcePathRoot == null || this.getFileOrDir().getName().indexOf(46) < 0) {
            return null;
        }
        String fqn = this.getFileOrDir().getAbsolutePath().substring(sourcePathRoot.getFileOrDir().getAbsolutePath().length() + 1);
        fqn = fqn.substring(0, fqn.lastIndexOf(46)).replace(File.separatorChar, '.');
        return TypeSystem.getByFullNameIfValid((String)fqn);
    }

    public boolean canDelete() {
        return !this.isSourcePathRoot() && this.getParent() != null;
    }

    public void delete() {
        if (this.canDelete()) {
            if (this.isFile() ? MessageDisplay.displayConfirmation("Delete file \"" + this.getName() + "\"?", 2) != 0 : MessageDisplay.displayConfirmation("<html>Delete directory \"" + this.getName() + "\"?<br>All files and subdirectories in \"" + this.getName() + "\" will be deleted!", 2) != 0) {
                return;
            }
            EditorUtilities.delete(this.getFileOrDir());
        }
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = this.findIcon();
        }
        return this._icon;
    }

    private Icon findIcon() {
        if (this.getParent() == null) {
            return EditorUtilities.loadLabIcon();
        }
        if (this.isDirectory()) {
            if (this.getSourcePathRoot() != null && !this.isSourcePathRoot()) {
                return EditorUtilities.loadIcon("images/folder.png");
            }
            return EditorUtilities.loadIcon("images/srcfolder.png");
        }
        if (this.getType() != null) {
            return EditorUtilities.findIcon(this.getType());
        }
        return FileSystemView.getFileSystemView().getSystemIcon(this.getFileOrDir());
    }
}

