/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.AbstractPopup;
import editor.BeanInfoPopup;
import editor.BeanTree;
import editor.CodeRefactorManager;
import editor.ContextHelpUtil;
import editor.ContextHighlighter;
import editor.CopyBuffer;
import editor.DefaultContextMenuHandler;
import editor.DynamicSelectionManager;
import editor.EditorScrollPane;
import editor.FileTree;
import editor.GosuDocument;
import editor.GosuEditorFeedbackPanel;
import editor.GosuEditorKit;
import editor.GosuEditorPane;
import editor.GosuPanel;
import editor.IContextMenuHandler;
import editor.IGosuPanel;
import editor.ILineInfoManager;
import editor.IScriptEditor;
import editor.IValuePopup;
import editor.JavadocPopup;
import editor.MouseInEditorHandler;
import editor.ParameterInfoPopup;
import editor.ParseExceptionIntellisense;
import editor.ParseListener;
import editor.PathCompletionIntellisense;
import editor.RunMe;
import editor.ScriptEditorMouseWheelHandler;
import editor.ScriptEditorPopupHandler;
import editor.ScrollableEditorRootPane;
import editor.SimpleDocumentFilter;
import editor.SmartFixManager;
import editor.SourceType;
import editor.StringPopup;
import editor.ValueCompletionIntellisense;
import editor.undo.AtomicUndoManager;
import editor.util.EditorUtilities;
import editor.util.HTMLEscapeUtil;
import editor.util.IReplaceWordCallback;
import editor.util.PlatformUtil;
import editor.util.SettleModalEventQueue;
import editor.util.TaskQueue;
import editor.util.TextComponentUtil;
import editor.util.XPToolbarButton;
import editor.util.transform.java.JavaToGosu;
import gw.fs.IFile;
import gw.lang.GosuShop;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IDynamicFunctionSymbol;
import gw.lang.parser.IDynamicPropertySymbol;
import gw.lang.parser.IDynamicSymbol;
import gw.lang.parser.IExpression;
import gw.lang.parser.IFunctionSymbol;
import gw.lang.parser.IGosuParser;
import gw.lang.parser.IGosuProgramParser;
import gw.lang.parser.IGosuValidator;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseResult;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IParsedElementWithAtLeastOneDeclaration;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ISourceCodeTokenizer;
import gw.lang.parser.ISymbol;
import gw.lang.parser.ISymbolTable;
import gw.lang.parser.ITokenizerInstructor;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.parser.Keyword;
import gw.lang.parser.ParserOptions;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.StandardSymbolTable;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.exceptions.ParseWarning;
import gw.lang.parser.expressions.IBeanMethodCallExpression;
import gw.lang.parser.expressions.IIdentifierExpression;
import gw.lang.parser.expressions.IImplicitTypeAsExpression;
import gw.lang.parser.expressions.IInferredNewExpression;
import gw.lang.parser.expressions.ILocalVarDeclaration;
import gw.lang.parser.expressions.IMemberAccessExpression;
import gw.lang.parser.expressions.IMethodCallExpression;
import gw.lang.parser.expressions.INewExpression;
import gw.lang.parser.expressions.ITypeLiteralExpression;
import gw.lang.parser.expressions.IVarStatement;
import gw.lang.parser.statements.IClassDeclaration;
import gw.lang.parser.statements.IClassFileStatement;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.parser.statements.IForEachStatement;
import gw.lang.parser.statements.IFunctionStatement;
import gw.lang.parser.statements.IMethodCallStatement;
import gw.lang.parser.statements.IPropertyStatement;
import gw.lang.parser.statements.IStatementList;
import gw.lang.reflect.FunctionType;
import gw.lang.reflect.IFeatureInfo;
import gw.lang.reflect.IMetaType;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeInfo;
import gw.lang.reflect.ITypeLoaderListener;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.RefreshRequest;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.ClassType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuClassTypeInfo;
import gw.lang.reflect.gs.IGosuEnhancement;
import gw.lang.reflect.gs.IGosuMethodInfo;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.gs.IGosuPropertyInfo;
import gw.lang.reflect.gs.IGosuVarPropertyInfo;
import gw.lang.reflect.gs.ISourceFileHandle;
import gw.lang.reflect.gs.StringSourceFileHandle;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeModel;
import javax.swing.undo.CompoundEdit;

public class GosuEditor
extends JPanel
implements IScriptEditor,
IGosuPanel,
ITypeLoaderListener {
    public static final String CONTROL_KEY_NAME;
    public static final int CONTROL_KEY_MASK;
    public static final String INTELLISENSE_TASK_QUEUE = "_intellisenseParser";
    public static final int RESCODE_VALID = 0;
    public static final int RESCODE_WARNINGS = 1;
    public static final int RESCODE_ERRORS = 2;
    public static final int RESCODE_PENDING = 4;
    static int COMPLETION_DELAY;
    public static final int MIN_LINENUMBER_WIDTH = 16;
    public static final int TAB_SIZE = 2;
    private JLabel _labelCaption;
    private GosuEditorFeedbackPanel _panelFeedback;
    private GosuEditorPane _editor;
    private GosuDocumentHandler _docHandler;
    private IContextMenuHandler<IScriptEditor> _contextMenuHandler;
    private volatile IGosuParser _parser;
    private boolean _bStatement;
    private boolean _bProgram;
    private boolean _bClass;
    private boolean _bEnhancement;
    private boolean _bEmptyTextOk;
    private ISymbolTable _symTable;
    private UndoableEditListener _uel;
    BeanInfoPopup _beanInfoPopup;
    JPopupMenu _valuePopup;
    private XPToolbarButton _btnAdvice;
    private Runnable _adviceRunner;
    private IReplaceWordCallback _replaceWordCallback;
    private boolean _bTemplate;
    private boolean _bCompleteCode;
    private IScriptabilityModifier _scriptabilityModifier;
    private AtomicUndoManager _undoMgr;
    private IScriptPartId _partId;
    private EditorScrollPane _scroller;
    private boolean _bAltDown;
    private ParseResultsException _pe;
    boolean _bEnterPressedConsumed;
    private boolean _bTestResource;
    private boolean _bAcceptUses;
    private int _iTimerCount;
    private boolean _bParserSuspended;
    private IGosuClass _parsedGosuClass;
    private String _enhancedTypeName;
    private Map<Integer, IFunctionStatement> _functionStmtsByLineNumber;
    private volatile List<IDynamicFunctionSymbol> _overriddenFunctions;
    private IGosuValidator _validator;
    private HighlightMode _highlightMode = HighlightMode.SEARCH;
    private IGosuParser.ParseType _parseType;
    private List<ParseListener> _parseListeners = new ArrayList<ParseListener>();
    private SmartFixManager _smartFixManager;
    private ContextHighlighter _ctxHighlighter;
    private DynamicSelectionManager _selectionManager;
    private CodeRefactorManager _codeManager;
    private static final Rectangle TEST_RECTANGLE;
    private List<IDynamicFunctionSymbol> _specialFunctions = new ArrayList<IDynamicFunctionSymbol>();
    private Map<IFunctionSymbol, Runnable> _specialFunctionGotoDeclHandlers = new HashMap<IFunctionSymbol, Runnable>();
    private ITokenizerInstructor _tokenizerInstructor;
    private ITypeUsesMap _typeUsesMap;
    private ITypeUsesMap _typeUsesMapFromMostRecentParse;
    private JavadocPopup _javadocPopup;
    private AbstractPopup _spinnerPopup;
    private static TimerPool _timerPool;
    private IType _programSuperType;

    public GosuEditor(ILineInfoManager lineInfoRenderer, AtomicUndoManager undoMgr, IScriptabilityModifier scriptabilityConstraint, IContextMenuHandler<IScriptEditor> contextMenuHandler, boolean bStatement, boolean bEmptyTextOk) {
        this._undoMgr = undoMgr;
        this._contextMenuHandler = contextMenuHandler == null ? new DefaultContextMenuHandler() : contextMenuHandler;
        this._bStatement = bStatement;
        this._bEmptyTextOk = bEmptyTextOk;
        this._bAcceptUses = true;
        this._docHandler = new GosuDocumentHandler();
        this._parser = null;
        this._scriptabilityModifier = scriptabilityConstraint;
        this._replaceWordCallback = new ReplaceWordCallback();
        this._parseType = IGosuParser.ParseType.EXPRESSION_OR_PROGRAM;
        this._ctxHighlighter = new ContextHighlighter(this);
        this.configureLayout(lineInfoRenderer);
        this._smartFixManager = new SmartFixManager(this);
        this._selectionManager = new DynamicSelectionManager(this);
        this._codeManager = new CodeRefactorManager(this);
    }

    void configureLayout(ILineInfoManager lineInfoRenderer) {
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setLayout(new BorderLayout());
        this._editor = this.createEditorPane();
        ToolTipManager.sharedInstance().registerComponent(this._editor);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        ScrollableEditorRootPane editorRootPane = new ScrollableEditorRootPane(this._editor);
        editorRootPane.setContentPane(this._editor);
        editorRootPane.setBorder(null);
        GosuEditorKit kit = new GosuEditorKit();
        this._editor.setEditorKitForContentType("text/gosu", kit);
        this._editor.setContentType("text/gosu");
        this._editor.setMargin(new Insets(3, 3, 3, 3));
        this._editor.setFont(new Font(GosuEditorKit.getStylePreferences().getFontFamily(), 0, GosuEditorKit.getStylePreferences().getFontSize()));
        this._editor.setBackground(EditorUtilities.WINDOW);
        this._editor.setForeground(Color.black);
        this._editor.putClientProperty("caretWidth", 2);
        this._editor.setCaretColor(StyleConstants.getForeground(kit.getViewFactory().getStyle("Caret")));
        this._editor.setEditable(true);
        this._editor.addKeyListener(new EditorKeyHandler());
        this._editor.addMouseListener(new ScriptEditorPopupHandler(this, this._contextMenuHandler));
        this._editor.addMouseWheelListener(new ScriptEditorMouseWheelHandler(this));
        this._editor.addCaretListener(new ErrorAtCaretHandler());
        this._editor.addCaretListener(this._ctxHighlighter);
        this._editor.addFocusListener(this._ctxHighlighter);
        this._editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GosuEditor.this._smartFixManager.updateState();
            }
        });
        TypeSystem.addTypeLoaderListenerAsWeakRef((ITypeLoaderListener)this);
        MouseInEditorHandler mouseInEditorHandler = new MouseInEditorHandler(this);
        this._editor.addMouseListener(mouseInEditorHandler);
        this._editor.addMouseMotionListener(mouseInEditorHandler);
        this._editor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GosuEditor.this.setCompleteCode(false);
            }
        });
        this.addDocumentListener();
        this.addKeyHandlers();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GosuEditor.this._editor.setSize(1000, GosuEditor.this._editor.getHeight());
            }
        });
        this._scroller = new EditorScrollPane(lineInfoRenderer, this._editor, editorRootPane);
        this._scroller.setBorder(null);
        JViewport vp = this._scroller.getViewport();
        vp.setScrollMode(1);
        this._btnAdvice = new XPToolbarButton(EditorUtilities.loadIcon("images/advice.png"));
        this._btnAdvice.setToolTipText("Display Smart Help");
        this._btnAdvice.setBorderConstant(true);
        this._btnAdvice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuEditor.this._adviceRunner != null) {
                    GosuEditor.this._adviceRunner.run();
                }
            }
        });
        this._btnAdvice.setVisible(false);
        editorRootPane.getLayeredPane().add((Component)this._btnAdvice, JLayeredPane.PALETTE_LAYER);
        this.add("Center", this._scroller);
        this._labelCaption = new JLabel("<Script Part>");
        this._labelCaption.setBackground(EditorUtilities.CONTROL);
        this._labelCaption.setOpaque(true);
        this._labelCaption.setFont(this.getFont().deriveFont(1));
        this._labelCaption.setBorder(new EmptyBorder(0, 4 + 16 * (lineInfoRenderer != null ? 2 : 1), 0, 0));
        this.add("North", this._labelCaption);
        this._panelFeedback = new GosuEditorFeedbackPanel();
        this.add("East", this._panelFeedback);
        this._spinnerPopup = new AbstractPopup(this.getEditor()){

            @Override
            public void setValue(Object value) {
            }

            @Override
            public void refresh() {
            }

            @Override
            protected void registerListeners() {
            }

            @Override
            protected void unregisterListeners() {
            }
        };
        this._spinnerPopup.setFocusable(false);
        this._spinnerPopup.add(new JLabel(EditorUtilities.loadIcon("com/guidewire/studio/resources/images/wait.gif")));
    }

    private void addKeyHandlers() {
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " T"), "_typeInfo");
        this._editor.getActionMap().put("_typeInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.displayTypeInfoAtCurrentLocation();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " shift T"), "_clipCopyTypeInfo");
        this._editor.getActionMap().put("_clipCopyTypeInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.clipCopyTypeInfoAtCurrentLocation();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " SLASH"), "_bulkComment");
        this._editor.getActionMap().put("_bulkComment", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuEditor.this.isIntellisensePopupShowing()) {
                    GosuEditor.this.handleBulkComment();
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "_bulkIndent");
        this._editor.getActionMap().put("_bulkIndent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuEditor.this.isIntellisensePopupShowing()) {
                    GosuEditor.this.handleBulkIndent(false);
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke("shift TAB"), "_bulkOutdent");
        this._editor.getActionMap().put("_bulkOutdent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuEditor.this.isIntellisensePopupShowing()) {
                    GosuEditor.this.handleBulkIndent(true);
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " W"), "_selectWord");
        this._editor.getActionMap().put("_selectWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.selectWord();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " shift W"), "_narrowSelectWord");
        this._editor.getActionMap().put("_narrowSelectWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.narrowSelectWord();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " shift J"), "_joinLines");
        this._editor.getActionMap().put("_joinLines", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.joinLines();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " G"), "_gotoLine");
        this._editor.getActionMap().put("_gotoLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.displayGotoLinePopup();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " P"), "_parameterInfo");
        this._editor.getActionMap().put("_parameterInfo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuEditor.this.isIntellisensePopupShowing()) {
                    GosuEditor.this.displayParameterInfoPopup(GosuEditor.this._editor.getCaretPosition());
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " B"), "_declaration");
        this._editor.getActionMap().put("_declaratino", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.gotoDeclaration();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke("F1"), "_javadocHelp");
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " Q"), "_javadocHelp");
        this._editor.getActionMap().put("_javadocHelp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.displayJavadocHelp(GosuEditor.this.getDeepestLocationAtCaret());
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke("alt F1"), "_selectFileInTree");
        this._editor.getActionMap().put("_selectFileInTree", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.showFileInTree();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(8, CONTROL_KEY_MASK), "_deleteWord");
        this._editor.getActionMap().put("_deleteWord", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.deleteWord();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(127, CONTROL_KEY_MASK), "_deleteWordForward");
        this._editor.getActionMap().put("_deleteWordForward", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.deleteWordForwards();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(89, CONTROL_KEY_MASK), "_deleteLine");
        this._editor.getActionMap().put("_deleteLine", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.deleteLine();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(9, 64), "_unindent");
        this._editor.getActionMap().put("_unindent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.unindent();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " Z"), "_undo");
        this._editor.getActionMap().put("_undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomicUndoManager undoManager = GosuEditor.this.getUndoManager();
                if (undoManager.canUndo()) {
                    undoManager.undo();
                }
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " alt V"), "_extractVariable");
        this._editor.getActionMap().put("_extractVariable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.extractVariable();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(38, CONTROL_KEY_MASK | 0x40), "_moveSelectionUp");
        this._editor.getActionMap().put("_moveSelectionUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.moveSelectionUp();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(40, CONTROL_KEY_MASK | 0x40), "_moveSelectionDown");
        this._editor.getActionMap().put("_moveSelectionDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.moveSelectionDown();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(10, 512), "_smartFix");
        this._editor.getActionMap().put("_smartFix", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.smartFix();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(76, CONTROL_KEY_MASK), "_centerView");
        this._editor.getActionMap().put("_centerView", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.centerView();
            }
        });
        this._editor.getInputMap().put(KeyStroke.getKeyStroke(CONTROL_KEY_NAME + " D"), "_duplicate");
        this._editor.getActionMap().put("_duplicate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this.duplicate();
            }
        });
        TextComponentUtil.fixTextComponentKeyMap(this._editor);
    }

    public void showFileInTree() {
        GosuPanel gosuPanel = RunMe.getEditorFrame().getGosuPanel();
        File file = gosuPanel.getCurrentFile();
        TreeModel model = RunMe.getEditorFrame().getGosuPanel().getExperimentView().getTree().getModel();
        FileTree root = (FileTree)model.getRoot();
        FileTree fileTree = root.find(file);
        if (fileTree != null) {
            fileTree.select();
        }
    }

    public void centerView() {
        try {
            Point caretPos = this.getEditor().modelToView(this.getEditor().getCaretPosition()).getLocation();
            Dimension size = this.getScroller().getBounds().getSize();
            this._editor.scrollRectToVisible(new Rectangle(caretPos.x, caretPos.y - size.height / 2, 0, size.height));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void doSmartHelp() {
        if (this._adviceRunner != null) {
            this._adviceRunner.run();
        } else {
            this.displayValueCompletionAtCurrentLocation();
        }
    }

    void jumpRight() {
        TextComponentUtil.jumpRight(this._editor);
    }

    public void displayGotoLinePopup() {
        this.dismissBeanInfoPopup();
        StringPopup popup = new StringPopup("", "Line number:", this.getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    int iLine = Integer.parseInt(e.getSource().toString());
                    if (iLine > 0) {
                        GosuEditor.this.gotoLine(iLine);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                GosuEditor.this.getEditor().requestFocus();
                GosuEditor.this.fixSwingFocusBugWhenPopupCloses();
                GosuEditor.this.getEditor().repaint();
            }
        });
        popup.show(this, 0, 0);
        EditorUtilities.centerWindowInFrame(popup, EditorUtilities.getWindow());
    }

    public void gotoLine(int iLine) {
        Element root = this._editor.getDocument().getRootElements()[0];
        iLine = root.getElementCount() < iLine ? root.getElementCount() : iLine;
        Element line = root.getElement(iLine - 1);
        this._editor.setCaretPosition(line.getStartOffset());
    }

    public void highlightUsagesOfFeatureUnderCaret() {
        this.highlightUsages(this);
    }

    public void highlightUsages(IScriptEditor scriptEditor) {
        IParseTree deepestLocationAtCaret = scriptEditor.getDeepestLocationAtCaret();
    }

    public void gotoNextUsageHighlight() {
    }

    public void removeAllHighlights() {
        if (!this.isIntellisensePopupShowing()) {
            GosuEditorPane editor = this.getEditor();
            this.removeHightlights();
            ((JTextComponent)editor).setCaretPosition(editor.getCaretPosition());
            this.hideMiscPopups();
        }
    }

    private void removeHightlights() {
        Highlighter highlighter = this.getEditor().getHighlighter();
        for (Highlighter.Highlight highlight : highlighter.getHighlights()) {
            highlighter.removeHighlight(highlight);
        }
    }

    private void hideMiscPopups() {
        EditorUtilities.hideToolTip(this.getEditor());
        this._smartFixManager.resetSmartHelpState();
    }

    public void selectWord() {
        if (!this.isIntellisensePopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.expandSelection();
        }
    }

    public void selectWordForMouseClick() {
        if (!this.isIntellisensePopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.expandSelection(false);
        }
    }

    public void narrowSelectWord() {
        if (!this.isIntellisensePopupShowing() && this.isCaretInEditor()) {
            this._selectionManager.reduceSelection();
        }
    }

    private boolean isCaretInEditor() {
        return this._editor.getSelectionStart() <= this._editor.getDocument().getLength();
    }

    public void joinLines() {
        DocumentFilter documentFilter = this.getGosuDocument().getDocumentFilter();
        if (documentFilter == null || ((SimpleDocumentFilter)documentFilter).acceptEdit("")) {
            CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Join Lines");
            try {
                this._joinLines();
            }
            finally {
                this.getUndoManager().endUndoAtom(undoAtom);
            }
        }
    }

    private void _joinLines() {
        block6: {
            try {
                Document document = this._editor.getDocument();
                int start = this._editor.getSelectionStart();
                int end = this._editor.getSelectionEnd();
                if (start == end) {
                    for (int i = this._editor.getCaret().getDot(); i < document.getLength(); ++i) {
                        if (!document.getText(i, 1).equals("\n")) continue;
                        document.remove(i, 1);
                        this.swallowSpaces(document, i);
                        break block6;
                    }
                    break block6;
                }
                while (start < end) {
                    if (document.getText(start, 1).equals("\n")) {
                        document.remove(start, 1);
                        --end;
                        int spacesRemoved = this.swallowSpaces(document, start);
                        end -= spacesRemoved;
                        start -= spacesRemoved;
                        continue;
                    }
                    ++start;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private int swallowSpaces(Document document, int i) throws BadLocationException {
        int removedChars = 0;
        while (i < document.getLength() && document.getText(i, 1).equals(" ")) {
            document.remove(i, 1);
            ++removedChars;
        }
        if (!document.getText(i, 1).equals(".") && !document.getText(i, 1).equals("#")) {
            document.insertString(i, " ", null);
            --removedChars;
        }
        return removedChars;
    }

    public void gotoDeclaration() {
        if (!this.isIntellisensePopupShowing()) {
            this.gotoDeclarationAtCursor();
        }
    }

    protected GosuEditorPane createEditorPane() {
        return new GosuEditorPane(this);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public SourceType getSourceType() {
        if (this.isProgram()) {
            return SourceType.PROGRAM;
        }
        if (this.isClass() || this.isEnhancement()) {
            return SourceType.CLASS;
        }
        if (this.isTemplate()) {
            return SourceType.TEMPLATE;
        }
        if (this.isStatement()) {
            return SourceType.STATEMENT;
        }
        return SourceType.EXPRESSION;
    }

    @Override
    public String getText() {
        return this._editor.getText();
    }

    public void setProgram(boolean bProgram) {
        this._bProgram = bProgram;
    }

    public void setClass(boolean bClass) {
        this._bClass = bClass;
    }

    public void setEnhancement(boolean bExtension) {
        this._bEnhancement = bExtension;
    }

    public boolean isProgram() {
        return this._bProgram;
    }

    public boolean isClass() {
        return this._bClass;
    }

    public boolean isEnhancement() {
        return this._bEnhancement;
    }

    public boolean isStatement() {
        return this._bStatement;
    }

    public void setStatement(boolean bStatement) {
        this._bStatement = bStatement;
    }

    public void setTemplate(boolean bTemplate) {
        this._bTemplate = bTemplate;
    }

    public boolean isTemplate() {
        return this._bTemplate;
    }

    @Override
    public GosuEditorPane getEditor() {
        return this._editor;
    }

    public IScriptabilityModifier getScriptabilityModifier() {
        return this._scriptabilityModifier;
    }

    public ParseResultsException getParseResultsException() {
        return this._pe;
    }

    public boolean hasParseResultsException() {
        return this._pe != null;
    }

    @Override
    public IScriptPartId getScriptPart() {
        return this._partId;
    }

    @Override
    public void read(IScriptPartId partId, String strSource, String strDescription) throws IOException {
        this._partId = partId;
        this._labelCaption.setText(strDescription);
        AbstractDocument doc = (AbstractDocument)this._editor.getDocument();
        if (doc != null) {
            doc.removeDocumentListener(this._docHandler);
        }
        strSource = GosuStringUtil.replace((String)strSource, (String)"\r\n", (String)"\n");
        this._editor.read(new StringReader(strSource), (Object)strDescription);
        this.addDocumentListener();
        this.parse();
    }

    private void addDocumentListener() {
        AbstractDocument doc = (AbstractDocument)this._editor.getDocument();
        if (doc != null) {
            doc.addDocumentListener(this._docHandler);
            doc.addDocumentListener(this._ctxHighlighter);
        }
    }

    public void setTestResource(boolean testResource) {
        this._bTestResource = testResource;
    }

    @Override
    public void parse() {
        this.parse(false);
    }

    private void parse(boolean forceCodeCompletion) {
        GosuEditor.postTaskInParserThread(this.getParseTask(forceCodeCompletion));
    }

    public static void postTaskInParserThread(Runnable task) {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        tq.postTask(task);
    }

    public static TaskQueue getParserTaskQueue() {
        return TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
    }

    public boolean isParserSuspended() {
        return this._bParserSuspended;
    }

    public void setParserSuspended(boolean bParserSuspended) {
        this._bParserSuspended = bParserSuspended;
    }

    private ParseTask getParseTask(boolean forceCodeCompletion) {
        return new ParseTask(this._editor.getText(), forceCodeCompletion, true);
    }

    public void duplicate() {
        DocumentFilter documentFilter = this.getGosuDocument().getDocumentFilter();
        if (documentFilter == null || ((SimpleDocumentFilter)documentFilter).acceptEdit("")) {
            CompoundEdit undoAtom = this._undoMgr.getUndoAtom();
            if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Script Change")) {
                this._undoMgr.endUndoAtom();
            }
            undoAtom = this.getUndoManager().beginUndoAtom("Duplicate Line");
            try {
                this._duplicate();
            }
            finally {
                this.getUndoManager().endUndoAtom(undoAtom);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _duplicate() {
        String selectedText = this._editor.getSelectedText();
        if (GosuStringUtil.isEmpty((String)selectedText)) {
            String currentText = this._editor.getText();
            int initialCaretPosition = this._editor.getCaretPosition();
            int lineStart = TextComponentUtil.getLineStart(this._editor.getText(), initialCaretPosition);
            int lineEnd = TextComponentUtil.getLineEnd(this._editor.getText(), initialCaretPosition);
            try {
                this.recordCaretPositionForUndo();
                String insertedLine = "\n" + currentText.substring(lineStart, lineEnd);
                this._editor.getDocument().insertString(lineEnd, insertedLine, null);
                if (initialCaretPosition >= lineEnd) return;
                this._editor.setCaretPosition(this._editor.getCaretPosition() + insertedLine.length());
                this.recordCaretPositionForUndo();
                return;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            int initialSelectionEnd = this._editor.getSelectionEnd();
            this._editor.getDocument().insertString(initialSelectionEnd, selectedText, null);
            this._editor.getCaret().setDot(initialSelectionEnd);
            this._editor.getCaret().moveDot(initialSelectionEnd + selectedText.length());
            this.recordCaretPositionForUndo();
            return;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void recordCaretPositionForUndo() throws BadLocationException {
        this._editor.getDocument().insertString(this._editor.getCaretPosition(), "8", null);
        this._editor.getDocument().remove(this._editor.getCaretPosition() - 1, 1);
    }

    public void delete() {
        TextComponentUtil.expandSelectionIfNeeded(this._editor);
        this.getEditor().replaceSelection("");
    }

    public String getExpandedSelection() {
        TextComponentUtil.expandSelectionIfNeeded(this._editor);
        return this.getEditor().getSelectedText();
    }

    void deleteWord() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Word");
        try {
            if (!GosuStringUtil.isEmpty((String)this.getEditor().getSelectedText())) {
                this.delete();
            } else {
                try {
                    TextComponentUtil.deleteWordAtCaret(this.getEditor());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteWordForwards() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Word");
        try {
            if (!GosuStringUtil.isEmpty((String)this.getEditor().getSelectedText())) {
                this.delete();
            } else {
                int start = this.getEditor().getCaretPosition();
                this.jumpRight();
                int end = this.getEditor().getCaretPosition();
                this.getEditor().select(start, end);
                this.getEditor().replaceSelection("");
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void deleteLine() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Delete Line");
        try {
            this.recordCaretPositionForUndo();
            TextComponentUtil.selectLineAtCaret(this._editor);
            this.getEditor().replaceSelection("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void unindent() {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom("Unindent");
        try {
            try {
                TextComponentUtil.unindentLineAtCaret(this.getEditor());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _parseNow(String strText, boolean forceCodeCompletion, boolean changed) {
        block27: {
            if (this.isParserSuspended()) {
                return;
            }
            try {
                Object containingType;
                if (this._parser == null) {
                    this._parser = GosuParserFactory.createParser((ISymbolTable)this.getSymbolTable(), (IScriptabilityModifier)this._scriptabilityModifier);
                    this._parser.setThrowParseExceptionForWarnings(true);
                    this._parser.setDontOptimizeStatementLists(true);
                    this._parser.setValidator(this._validator);
                    this._parser.setWarnOnCaseIssue(true);
                    this._parser.setEditorParser(true);
                    if (this._typeUsesMap != null) {
                        this._parser.setTypeUsesMap(this._typeUsesMap);
                    }
                } else if (this._parser.getSymbolTable() != this.getSymbolTable()) {
                    this._parser.setSymbolTable(this.getSymbolTable());
                }
                if (changed && this.getScriptPart() != null && !this.areMoreThanOneParserTasksGoingToUpdateContainingType() && (containingType = (ITypeRef)this.getScriptPart().getContainingType()) != null) {
                    try {
                        TypeSystem.refresh((ITypeRef)containingType);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                if (!this._bEmptyTextOk || strText != null && strText.length() > 0) {
                    this._parser.setScript((CharSequence)strText);
                    if (this.getClassType() == ClassType.Template) {
                        this._parser.setTokenizerInstructor(GosuShop.createTemplateInstructor((ISourceCodeTokenizer)this._parser.getTokenizer()));
                    }
                    if (this._parser.getSymbolTable() != null) {
                        this._parser.putDfsDeclsInTable(this._parser.getSymbolTable());
                    }
                    for (IDynamicFunctionSymbol specialFunction : this._specialFunctions) {
                        this._parser.putDfsDeclInSetByName(specialFunction);
                    }
                    ClassType classType = this.getClassType();
                    if (classType != null) {
                        this._parsedGosuClass = this._parser.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)strText, this._bTestResource, classType), true, true);
                    } else if (this._bStatement) {
                        this._parser.parseStatements(this.getScriptPart());
                    } else {
                        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
                        ParserOptions options = new ParserOptions().withParser(this._parser).withSuperType(this._programSuperType);
                        IParseResult result = programParser.parseExpressionOrProgram(strText, this._parser.getSymbolTable(), options);
                        this._parsedGosuClass = result.getProgram();
                        ParseResultsException parseRes = this._parsedGosuClass.getParseResultsException();
                        if (parseRes != null) {
                            throw parseRes;
                        }
                    }
                } else if (this._parser != null) {
                    this._parser.setScript((CharSequence)"");
                    this._parser.setTokenizerInstructor(this._tokenizerInstructor);
                }
                this.clearParseException();
                if (this.areMoreThanOneParserTasksPendingForThisEditor() || this._parser == null) break block27;
                this._functionStmtsByLineNumber = this.storeFunctionsByLineNumber(this._parsedGosuClass, null);
            }
            catch (ParseResultsException ex) {
                block30: {
                    List locations;
                    block28: {
                        block29: {
                            try {
                                IClassFileStatement classFileStmt;
                                IClassStatement classStatement;
                                if (ex.getParsedElement() instanceof IClassFileStatement && (classStatement = (classFileStmt = (IClassFileStatement)ex.getParsedElement()).getClassStatement()) != null) {
                                    this._parsedGosuClass = classStatement.getGosuClass();
                                }
                                if (!this.areMoreThanOneParserTasksPendingForThisEditor() || forceCodeCompletion) break block28;
                                if (this.areMoreThanOneParserTasksPendingForThisEditor() || this._parser == null) break block29;
                                this._functionStmtsByLineNumber = this.storeFunctionsByLineNumber(this._parsedGosuClass, null);
                            }
                            catch (Throwable throwable) {
                                if (!this.areMoreThanOneParserTasksPendingForThisEditor() && this._parser != null) {
                                    this._functionStmtsByLineNumber = this.storeFunctionsByLineNumber(this._parsedGosuClass, null);
                                    this._typeUsesMapFromMostRecentParse = this._parser.getTypeUsesMap().copy();
                                    List locations2 = this._parser.getLocations();
                                    EventQueue.invokeLater(new Runnable(locations2){
                                        final /* synthetic */ List val$locations;
                                        {
                                            this.val$locations = list;
                                        }

                                        @Override
                                        public void run() {
                                            if (GosuEditor.this.getGosuDocument().getLocations() == null) {
                                                GosuEditor.this._editor.repaint();
                                            }
                                            GosuEditor.this.getGosuDocument().setLocations(this.val$locations);
                                            GosuEditor.this.getGosuDocument().setLocationsOffset(GosuEditor.this._parser.getOffsetShift());
                                        }
                                    });
                                }
                                throw throwable;
                            }
                            this._typeUsesMapFromMostRecentParse = this._parser.getTypeUsesMap().copy();
                            locations = this._parser.getLocations();
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        return;
                    }
                    this._pe = ex;
                    this.handleParseException(forceCodeCompletion);
                    if (this.areMoreThanOneParserTasksPendingForThisEditor() || this._parser == null) break block30;
                    this._functionStmtsByLineNumber = this.storeFunctionsByLineNumber(this._parsedGosuClass, null);
                    this._typeUsesMapFromMostRecentParse = this._parser.getTypeUsesMap().copy();
                    locations = this._parser.getLocations();
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                return;
            }
            this._typeUsesMapFromMostRecentParse = this._parser.getTypeUsesMap().copy();
            List locations = this._parser.getLocations();
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        if (this.areMoreThanOneParserTasksPendingForThisEditor()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GosuEditor.this._panelFeedback.update(0, GosuEditor.this);
            }
        });
    }

    private ClassType getClassType() {
        ClassType classType = null;
        if (this.isTemplate()) {
            classType = ClassType.Template;
        } else if (this.isClass()) {
            classType = ClassType.Class;
        } else if (this.isProgram()) {
            classType = ClassType.Program;
        } else if (this.isEnhancement()) {
            classType = ClassType.Enhancement;
        }
        return classType;
    }

    public ITypeUsesMap getTypeUsesMapFromMostRecentParse() {
        return this._typeUsesMapFromMostRecentParse;
    }

    private Map<Integer, IFunctionStatement> storeFunctionsByLineNumber(IGosuClass gsClass, Map<Integer, IFunctionStatement> functionStmtsByLineNumber) {
        if (gsClass == null || this._parsedGosuClass instanceof IGosuEnhancement) {
            return null;
        }
        if (functionStmtsByLineNumber == null) {
            functionStmtsByLineNumber = new HashMap<Integer, IFunctionStatement>();
        }
        ArrayList functionStatements = new ArrayList();
        gsClass.getClassStatement().getContainedParsedElementsByType(IFunctionStatement.class, functionStatements);
        for (IFunctionStatement fs : functionStatements) {
            functionStmtsByLineNumber.put(fs.getLocation().getLineNum(), fs);
        }
        return functionStmtsByLineNumber;
    }

    private void storeOverriddenFunctions() {
    }

    public Map<Integer, IFunctionStatement> getFunctionsByLineNumber() {
        return this._functionStmtsByLineNumber == null ? Collections.emptyMap() : this._functionStmtsByLineNumber;
    }

    public List<IDynamicFunctionSymbol> getOverriddenFunctions() {
        return this._overriddenFunctions == null ? Collections.emptyList() : this._overriddenFunctions;
    }

    protected void clearParseException() {
        this._pe = null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GosuEditor.this.getGosuDocument().setParseResultsException(null);
                GosuEditor.this.displayAdvice(null);
            }
        });
    }

    public void setValidator(IGosuValidator validator) {
        this._validator = validator;
        if (this._parser != null) {
            this._parser.setValidator(this._validator);
        }
    }

    public static boolean areAnyParserTasksPending() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            Runnable task = task1;
            if (!(task instanceof ParseTask)) continue;
            return true;
        }
        return false;
    }

    private boolean areMoreThanOneParserTasksPendingForThisEditor() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        int iCount = 0;
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            Runnable task = task1;
            if (!(task instanceof ParseTask) || ((ParseTask)task).getEditor() != this) continue;
            if (iCount > 0) {
                return true;
            }
            ++iCount;
        }
        return false;
    }

    private boolean areMoreThanOneParserTasksGoingToUpdateContainingType() {
        TaskQueue tq = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        int iCount = 0;
        List<Runnable> tasks = tq.getTasks();
        for (Runnable task1 : tasks) {
            GosuEditor otherEditor;
            Runnable task = task1;
            if (!(task instanceof ParseTask) || (otherEditor = ((ParseTask)task).getEditor()) != this && (otherEditor.getScriptPart() == null || this.getScriptPart() == null || this.getScriptPart().getContainingType() != otherEditor.getScriptPart().getContainingType())) continue;
            if (iCount > 0) {
                return true;
            }
            ++iCount;
        }
        return false;
    }

    private void handleParseException(final boolean forceCodeCompletion) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GosuEditor.this.handleParseException(GosuEditor.this._pe, forceCodeCompletion);
            }
        });
    }

    protected void handleParseException(ParseResultsException e, boolean bForceCodeCompletion) {
        this.handleCodeCompletion(bForceCodeCompletion);
        this.getGosuDocument().setParseResultsException(e);
        if (e != null) {
            boolean hasError = false;
            boolean hasWarning = false;
            for (IParseIssue issue : e.getParseIssues()) {
                if (issue.getTokenEnd() <= 0 || issue.getTokenStart() >= this._editor.getDocument().getLength()) continue;
                if (issue instanceof ParseWarning) {
                    hasWarning = true;
                    continue;
                }
                hasError = true;
            }
            if (!hasError) {
                if (hasWarning) {
                    this._panelFeedback.update(1, this);
                } else {
                    this._panelFeedback.update(0, this);
                }
            } else {
                this._panelFeedback.update(2, this);
            }
        }
    }

    private void handleCodeCompletion(boolean bForceCodeCompletion) {
        if (this._parser == null) {
            return;
        }
        this.displayAdvice(null);
        if (bForceCodeCompletion) {
            this.handleCompleteCode();
        }
    }

    private void handleCompleteValue() {
        List errors = this.getIssuesNearPos(this._editor.getCaretPosition());
        if (errors == null || errors.isEmpty()) {
            IParseTree location = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(this._editor.getCaretPosition() - this._parser.getOffsetShift()), (boolean)false);
            if (location != null && location.getParsedElement().hasParseExceptions()) {
                errors = location.getParsedElement().getParseIssues();
            } else {
                return;
            }
        }
        ParseException e = null;
        IType typeExpected = null;
        for (IParseIssue issue : errors) {
            if (issue instanceof ParseException && (typeExpected = (e = (ParseException)issue).getExpectedType()) != null) break;
        }
        final ParseException error = e;
        boolean emptyMethodCall = false;
        if (typeExpected == null) {
            typeExpected = AbstractParseExceptionResolver.resolvePossibleContextTypesFromEmptyMethodCalls(this.getExpressionAtCaret(), this._editor);
            emptyMethodCall = true;
        }
        if (typeExpected != null) {
            String strTypesExpected = ParseResultsException.getExpectedTypeName(typeExpected);
            try {
                if (strTypesExpected.length() > 0 && !TextComponentUtil.getWordBeforeCaret(this._editor).equals(".") && !TextComponentUtil.getWordBeforeCaret(this._editor).equals("#") && error != null && (emptyMethodCall || error.appliesToPosition(this._editor.getCaretPosition()) || this._editor.getCaretPosition() < error.getTokenStart() && this._editor.getDocument().getText(this._editor.getCaretPosition(), error.getTokenStart() - this._editor.getCaretPosition()).matches(" *") || this._editor.getCaretPosition() > error.getTokenEnd() && this._editor.getDocument().getText(error.getTokenEnd(), this._editor.getCaretPosition() - error.getTokenEnd()).matches(" *"))) {
                    this._adviceRunner = new Runnable(){

                        @Override
                        public void run() {
                            GosuEditor.this.setCaretPositionForValueCompletion((IParseIssue)error);
                            GosuEditor.this.displayValueCompletion(error);
                        }
                    };
                    this.displayAdvice(e);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public IGosuParser getParser() {
        return this._parser;
    }

    GosuDocument getGosuDocument() {
        return (GosuDocument)this._editor.getDocument();
    }

    @Override
    public EditorScrollPane getScroller() {
        return this._scroller;
    }

    public IReplaceWordCallback getReplaceWordCallback() {
        return this._replaceWordCallback;
    }

    @Override
    public ISymbolTable getSymbolTable() {
        if (this._symTable == null) {
            this._symTable = new StandardSymbolTable(true);
        }
        return this._symTable;
    }

    public void resetSymbolTable(ISymbolTable newSymbols) {
        this.setSymbolTable(newSymbols);
        this._parser = null;
        this.parse();
    }

    public void setSymbolTable(ISymbolTable newSymbols) {
        this._symTable = newSymbols;
    }

    void handleEnter() {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("New Line");
        try {
            this._handleEnter();
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
            undoAtom = this._undoMgr.getUndoAtom();
            if (undoAtom != null && undoAtom.getPresentationName().equals("Script Change")) {
                this._undoMgr.endUndoAtom();
            }
        }
    }

    void _handleEnter() {
        this.revalidate();
        Element root = this._editor.getDocument().getRootElements()[0];
        int index = root.getElementIndex(this._editor.getCaretPosition() - 1);
        Element line = root.getElement(index);
        int iStart = line.getStartOffset();
        int iEnd = line.getEndOffset();
        try {
            char c;
            String strLine = line.getDocument().getText(iStart, iEnd - iStart);
            StringBuilder strbIndent = new StringBuilder();
            for (int iIndent = 0; iIndent < strLine.length() && ((c = strLine.charAt(iIndent)) == ' ' || c == '\t'); ++iIndent) {
                strbIndent.append(c);
            }
            if (strbIndent.length() > 0) {
                this._editor.replaceSelection(strbIndent.toString());
            }
            this.indentIfOpenBracePrecedes(strLine);
            this.fixCloseBraceIfNecessary(strLine);
            if (strLine.trim().startsWith("/**")) {
                this._editor.replaceSelection(" * ");
                int caretPos = this._editor.getCaretPosition();
                this._editor.replaceSelection("\n" + strbIndent.toString() + " */");
                this._editor.setCaretPosition(caretPos);
            } else {
                boolean isJavadoc = false;
                while (strLine.trim().startsWith("*") && !strLine.contains("*/")) {
                    if (--index < 0) continue;
                    line = root.getElement(index);
                    iStart = line.getStartOffset();
                    iEnd = line.getEndOffset();
                    strLine = line.getDocument().getText(iStart, iEnd - iStart);
                    if (!strLine.trim().startsWith("/**")) continue;
                    isJavadoc = true;
                    break;
                }
                if (isJavadoc) {
                    this._editor.replaceSelection("* ");
                }
            }
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    private void fixCloseBraceIfNecessary(String previousLine) throws BadLocationException {
        String strLine;
        Element root = this._editor.getDocument().getRootElements()[0];
        int iStart = this._editor.getCaretPosition();
        Element line = root.getElement(root.getElementIndex(iStart));
        int iEnd = line.getEndOffset();
        if (iStart < this._editor.getDocument().getLength() && (strLine = line.getDocument().getText(iStart, iEnd - iStart)).trim().startsWith("}")) {
            int offset = strLine.indexOf(125);
            boolean previousLineWasOpenBrace = previousLine.trim().endsWith("{");
            if (previousLineWasOpenBrace) {
                this._editor.getDocument().insertString(iStart, "\n", null);
                ++offset;
            }
            this.parseAndWaitForParser();
            this._editor.setCaretPosition(iStart + offset);
            this._handleBraceRightNow(this._editor.getCaretPosition(), false);
            if (previousLineWasOpenBrace) {
                this._editor.setCaretPosition(iStart);
            }
        }
    }

    void handleBackspace() {
        int caretPosition = this.getEditor().getCaretPosition();
        try {
            if (caretPosition > 0 && (this.getEditor().getText(caretPosition - 1, 1).equals(".") || this.getEditor().getText(caretPosition - 1, 1).equals("#"))) {
                this.dismissBeanInfoPopup();
                this.dismissValuePopup();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void indentIfOpenBracePrecedes(String strLine) {
        if ((strLine = strLine.trim()).length() > 0 && strLine.charAt(strLine.length() - 1) == '{') {
            this._editor.replaceSelection(this.getIndentWhitespace());
        }
    }

    private String getIndentWhitespace() {
        return GosuStringUtil.repeat((String)" ", (int)2);
    }

    void handleBulkComment() {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Comment");
        try {
            this._handleBulkComment();
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
        }
    }

    void _handleBulkComment() {
        this.revalidate();
        int iSelectionStart = this._editor.getSelectionStart();
        int iSelectionEnd = this._editor.getSelectionEnd();
        Element root = this._editor.getDocument().getRootElements()[0];
        int iStartIndex = root.getElementIndex(iSelectionStart);
        int iEndIndex = root.getElementIndex(iSelectionEnd);
        if (iStartIndex != iEndIndex && root.getElement(iEndIndex).getStartOffset() == iSelectionEnd) {
            iEndIndex = root.getElementIndex(--iSelectionEnd);
        }
        try {
            String strLine;
            int iEnd;
            int iStart;
            Element line;
            int i;
            boolean bHasLineWithoutLeadingComment = false;
            for (i = iStartIndex; i <= iEndIndex; ++i) {
                line = root.getElement(i);
                iStart = line.getStartOffset();
                strLine = this._editor.getText(iStart, (iEnd = line.getEndOffset()) - iStart);
                String strLineTrimmed = strLine.trim();
                if (strLineTrimmed.length() <= 0 || strLineTrimmed.startsWith("//")) continue;
                bHasLineWithoutLeadingComment = true;
                break;
            }
            for (i = iStartIndex; i <= iEndIndex; ++i) {
                line = root.getElement(i);
                iStart = line.getStartOffset();
                iEnd = line.getEndOffset();
                strLine = this._editor.getText(iStart, iEnd - iStart);
                if (bHasLineWithoutLeadingComment) {
                    strLine = "//" + strLine;
                } else {
                    int iCommentIndex = strLine.indexOf("//");
                    if (iCommentIndex >= 0) {
                        strLine = strLine.substring(0, iCommentIndex) + strLine.substring(iCommentIndex + 2);
                    }
                }
                iEnd = line.getEndOffset();
                this._editor.select(iStart, iEnd);
                this._editor.replaceSelection(strLine);
                iSelectionEnd = this._editor.getSelectionEnd();
            }
            this._editor.select(iSelectionStart, iSelectionEnd);
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    void handleBulkIndent(boolean bOutdent) {
        CompoundEdit atom = this.getUndoManager().beginUndoAtom(bOutdent ? "Outdent" : "Indent");
        try {
            this._handleBulkIndent(bOutdent);
        }
        finally {
            this.getUndoManager().endUndoAtom(atom);
        }
    }

    void _handleBulkIndent(boolean bOutdent) {
        int iSelectionEnd;
        String strTabSpaces = this.getIndentWhitespace();
        int iSelectionStart = this._editor.getSelectionStart();
        if (iSelectionStart == (iSelectionEnd = this._editor.getSelectionEnd())) {
            this._editor.replaceSelection(strTabSpaces);
            return;
        }
        this.revalidate();
        Element root = this._editor.getDocument().getRootElements()[0];
        int iStartIndex = root.getElementIndex(iSelectionStart);
        int iEndIndex = root.getElementIndex(iSelectionEnd);
        if (iStartIndex != iEndIndex && root.getElement(iEndIndex).getStartOffset() == iSelectionEnd) {
            iEndIndex = root.getElementIndex(--iSelectionEnd);
        }
        try {
            for (int i = iStartIndex; i <= iEndIndex; ++i) {
                int iEnd;
                Element line = root.getElement(i);
                int iStart = line.getStartOffset();
                String strLine = this._editor.getText(iStart, (iEnd = line.getEndOffset()) - iStart);
                if (strLine.trim().length() == 0) continue;
                if (strLine.length() > 0 && bOutdent) {
                    if (strLine.startsWith(strTabSpaces)) {
                        strLine = strLine.substring(2);
                    } else if (Character.isWhitespace(strLine.charAt(0))) {
                        strLine = strLine.substring(1);
                    }
                } else {
                    strLine = strTabSpaces + strLine;
                }
                iEnd = line.getEndOffset();
                this._editor.select(iStart, iEnd);
                this._editor.replaceSelection(strLine);
                iSelectionEnd = this._editor.getSelectionEnd();
            }
            this._editor.select(iSelectionStart, iSelectionEnd);
        }
        catch (Exception ex) {
            EditorUtilities.handleUncaughtException(ex);
        }
    }

    void handleBraceRight() {
        final int caretPosition = this._editor.getCaretPosition();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GosuEditor.postTaskInParserThread(new Runnable(){

                    @Override
                    public void run() {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GosuEditor.this.handleBraceRightNow(caretPosition);
                            }
                        });
                    }
                });
            }
        });
    }

    private void handleBraceRightNow(int caretPosition) {
        CompoundEdit undoAtom = this.getUndoManager().beginUndoAtom("Right Brace");
        try {
            this._handleBraceRightNow(caretPosition, true);
        }
        finally {
            this.getUndoManager().endUndoAtom(undoAtom);
        }
    }

    private void _handleBraceRightNow(int caretPosition, boolean wasBraceTyped) {
        Document doc = this._editor.getDocument();
        Element root = doc.getRootElements()[0];
        Element line = root.getElement(root.getElementIndex(caretPosition));
        int iBraceLineStart = line.getStartOffset();
        int iBraceLineEnd = line.getEndOffset();
        try {
            char c;
            String strLine = line.getDocument().getText(iBraceLineStart, Math.min(iBraceLineEnd, doc.getLength()) - iBraceLineStart);
            iBraceLineEnd = strLine.endsWith("\n") ? iBraceLineEnd - 1 : iBraceLineEnd;
            strLine = strLine.trim();
            if (strLine.length() > 1) {
                return;
            }
            IParseTree stmtAtBrace = this.getDeepestStatementLocationAtPos(caretPosition, true);
            if (stmtAtBrace == null) {
                return;
            }
            line = root.getElement(root.getElementIndex(stmtAtBrace.getOffset()));
            int iStmtLineStart = line.getStartOffset();
            int iStmtLineEnd = line.getEndOffset();
            strLine = line.getDocument().getText(iStmtLineStart, iStmtLineEnd - iStmtLineStart);
            StringBuilder strbIndent = new StringBuilder();
            for (int iIndent = 0; iIndent < strLine.length() && ((c = strLine.charAt(iIndent)) == ' ' || c == '\t'); ++iIndent) {
                strbIndent.append(c);
            }
            String newText = strbIndent.toString() + '}';
            this._editor.select(iBraceLineStart, iBraceLineEnd);
            this._editor.replaceSelection(newText);
            if (this._editor.getCaretPosition() != caretPosition) {
                this._editor.setCaretPosition(iBraceLineStart + strbIndent.length() + (wasBraceTyped ? 1 : 0));
            }
            this.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setCaretPositionForParseIssue(IParseIssue e) {
        EditorUtilities.settleEventQueue();
        this._editor.setCaretPosition(e.getTokenStart());
    }

    void setCaretPositionForValueCompletion(IParseIssue e) {
        EditorUtilities.settleEventQueue();
        this._editor.setCaretPosition(this.getCaretPositionForValueCompletion(e));
    }

    int getCaretPositionForValueCompletion(IParseIssue e) {
        int iErrorPos = e.getSource().getLocation().getOffset();
        int iCaretPos = this._editor.getCaretPosition();
        if (this.getExpressionAtCaret() == null || !AbstractParseExceptionResolver.shouldPositionAtStartOfElement(this.getExpressionAtCaret().getLocation(), this._editor)) {
            return iCaretPos;
        }
        if (iErrorPos <= iCaretPos || TextComponentUtil.isNonWhitespaceBetween(this._editor, iCaretPos, iErrorPos)) {
            return iErrorPos;
        }
        return iCaretPos;
    }

    void displayAdvice(ParseException e) {
        if (this._editor.hasFocus()) {
            this._smartFixManager.updateState();
        }
        if (!this.isShowing() || !this.shouldDisplaySmartHelp(e)) {
            this._adviceRunner = null;
            this._btnAdvice.setVisible(false);
            return;
        }
        try {
            this._btnAdvice.setVisible(true);
            this._btnAdvice.setSize(this._btnAdvice.getPreferredSize());
            int iPos = this.getCaretPositionForValueCompletion((IParseIssue)e);
            Rectangle rcAdvice = this.getPositionFromPoint(iPos);
            rcAdvice = SwingUtilities.convertRectangle(this._editor, rcAdvice, this._btnAdvice.getParent());
            if (rcAdvice != null) {
                Rectangle visibleRect = this.getEditor().getVisibleRect();
                int adviceY = rcAdvice.y + rcAdvice.height + this._btnAdvice.getHeight() > visibleRect.y + visibleRect.height ? rcAdvice.y - this._btnAdvice.getHeight() : rcAdvice.y + rcAdvice.height;
                this._btnAdvice.setLocation(rcAdvice.x, adviceY);
            } else {
                this._adviceRunner = null;
                this._btnAdvice.setVisible(false);
            }
        }
        catch (Throwable t) {
            EditorUtilities.handleUncaughtException("ElementModel change listener error.", t);
        }
    }

    @Override
    public AtomicUndoManager getUndoManager() {
        return this._undoMgr;
    }

    public void setUndoableEditListener(UndoableEditListener uel) {
        if (this._uel != null) {
            this._editor.getDocument().removeUndoableEditListener(this._uel);
        }
        this._uel = uel;
        if (this._uel != null) {
            this._editor.getDocument().addUndoableEditListener(this._uel);
        }
    }

    void fixSwingFocusBugWhenPopupCloses() {
        EditorUtilities.rootPaneForComponent(this).dispatchEvent(new MouseEvent(this, 501, System.currentTimeMillis(), 0, 3, 3, 1, false));
    }

    @Override
    public void gotoNextError() {
        ParseResultsException pre = this.getParseResultsException();
        if (pre == null) {
            return;
        }
        int iPos = this._editor.getCaretPosition();
        List pes = pre.getParseExceptions();
        IParseIssue first = null;
        for (IParseIssue pe : pes) {
            if (pe.getTokenStart() <= iPos || first != null && pe.getTokenStart() >= first.getTokenStart()) continue;
            first = pe;
        }
        if (first != null) {
            this.setCaretPositionForParseIssue(first);
        }
    }

    @Override
    public void handleCompleteCode() {
        this.setCompleteCode(true);
        GosuEditor.postTaskInParserThread(new Runnable(){

            @Override
            public void run() {
                if (GosuEditor.this.isCompleteCode()) {
                    try {
                        final ISymbolTable atCursor = GosuEditor.this.getSymbolTableAtCursor();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (GosuEditor.this.isCompleteCode()) {
                                    try {
                                        GosuEditor.this.handleDot(atCursor);
                                    }
                                    finally {
                                        GosuEditor.this.setCompleteCode(false);
                                    }
                                }
                            }
                        });
                    }
                    catch (RuntimeException e) {
                        GosuEditor.this.setCompleteCode(false);
                        throw e;
                    }
                }
            }
        });
    }

    void setCompleteCode(final boolean bCompleteCode) {
        this._bCompleteCode = bCompleteCode;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bCompleteCode) {
                    Rectangle rcCaretBounds;
                    try {
                        rcCaretBounds = GosuEditor.this.getPositionFromPoint(GosuEditor.this.getEditor().getCaretPosition());
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                    if (rcCaretBounds != TEST_RECTANGLE && !GosuEditor.this.isIntellisensePopupShowing()) {
                        GosuEditor.this._spinnerPopup.show(GosuEditor.this._editor, rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
                    }
                } else {
                    GosuEditor.this._spinnerPopup.setVisible(false);
                }
            }
        });
    }

    boolean isCompleteCode() {
        return this._bCompleteCode;
    }

    void handleDot() {
        this.runIfNoKeyPressedInMillis(COMPLETION_DELAY, new Runnable(){

            @Override
            public void run() {
                GosuEditor.this.setCompleteCode(true);
                GosuEditor.this.parse(true);
            }
        });
    }

    void handleColon() {
        this.runIfNoKeyPressedInMillis(COMPLETION_DELAY, new Runnable(){

            @Override
            public void run() {
                GosuEditor.this.setCompleteCode(true);
                GosuEditor.this.parse(true);
            }
        });
    }

    void handleDot(ISymbolTable transientSymTable) {
        if (transientSymTable == null) {
            return;
        }
        if (this.isIntellisensePopupShowing()) {
            return;
        }
        this.displayAdvice(null);
        String strWordAtCaret = TextComponentUtil.getWordAtCaret(this._editor);
        if (strWordAtCaret == null || strWordAtCaret.length() == 0 || !Character.isLetterOrDigit(strWordAtCaret.charAt(0))) {
            strWordAtCaret = TextComponentUtil.getWordBeforeCaret(this._editor);
        }
        if (this.isCompleteCode() || strWordAtCaret.equals(".") || strWordAtCaret.equals("#") || strWordAtCaret.equals(":")) {
            this.dismissValuePopup();
            this.handleDotNow(transientSymTable);
        }
    }

    void handleDotNow(ISymbolTable transientSymTable) {
        this.dismissBeanInfoPopup();
        this.displayPathCompletion(transientSymTable);
    }

    void displayPathCompletion(ISymbolTable transientSymTable) {
        if (this._bTemplate) {
            transientSymTable.putSymbol(GosuShop.createSymbol((CharSequence)"printContent", (IType)new FunctionType("printContent", (IType)JavaTypes.pVOID(), new IType[]{JavaTypes.STRING(), JavaTypes.pBOOLEAN()}), null));
        }
        PathCompletionIntellisense.instance().complete(this, transientSymTable);
    }

    void displayPathCompletionBeanInfoPopup(final boolean bFeatureLiteralCompletion) {
        if (this._beanInfoPopup.isDOA()) {
            return;
        }
        this._beanInfoPopup.addNodeChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                CompoundEdit undoAtom = GosuEditor.this._undoMgr.getUndoAtom();
                if (undoAtom != null && ((CompoundEdit)undoAtom).getPresentationName().equals("Script Change")) {
                    GosuEditor.this._undoMgr.endUndoAtom();
                }
                undoAtom = GosuEditor.this.getUndoManager().beginUndoAtom("Code Completion");
                try {
                    int dotPosition;
                    String strRef;
                    block14: {
                        BeanTree beanInfoSelection = (BeanTree)e.getSource();
                        strRef = beanInfoSelection.makePath(bFeatureLiteralCompletion);
                        dotPosition = GosuEditor.this._editor.getCaretPosition() - 1;
                        String s = GosuEditor.this._editor.getText();
                        dotPosition = TextComponentUtil.findCharacterPositionOnLine(dotPosition, s, '.', TextComponentUtil.Direction.BACKWARD);
                        if (dotPosition != -1 || (dotPosition = TextComponentUtil.findCharacterPositionOnLine(GosuEditor.this._editor.getCaretPosition() - 1, s, '#', TextComponentUtil.Direction.BACKWARD)) != -1) break block14;
                        return;
                    }
                    GosuEditor.this._editor.getDocument().remove(dotPosition + 1, GosuEditor.this._editor.getCaretPosition() - (dotPosition + 1));
                    GosuEditor.this._editor.getDocument().insertString(GosuEditor.this._editor.getCaretPosition(), strRef, null);
                    if (e instanceof BeanInfoPopup.DotWasTypedChangeEvent) {
                        return;
                    }
                    try {
                        if (strRef.contains("(")) {
                            int wordStart;
                            String text = GosuEditor.this._editor.getText();
                            int closeParen = TextComponentUtil.findCharacterPositionOnLine(dotPosition, text, ')', TextComponentUtil.Direction.FORWARD);
                            for (wordStart = TextComponentUtil.findCharacterPositionOnLine(dotPosition, text, '(', TextComponentUtil.Direction.FORWARD); !Character.isJavaIdentifierPart(text.charAt(wordStart)) && wordStart < closeParen; ++wordStart) {
                            }
                            if (wordStart != closeParen) {
                                GosuEditor.this._editor.setCaretPosition(wordStart);
                                TextComponentUtil.selectWordAtCaret(GosuEditor.this._editor);
                            }
                        }
                        if (Character.isJavaIdentifierPart(GosuEditor.this._editor.getDocument().getText(GosuEditor.this._editor.getCaretPosition(), 1).charAt(0))) {
                            GosuEditor.this._editor.getDocument().insertString(GosuEditor.this._editor.getCaretPosition(), ".", null);
                        }
                    }
                    catch (BadLocationException ble) {
                        throw new RuntimeException(ble);
                    }
                    GosuEditor.this._editor.requestFocus();
                    GosuEditor.this.fixSwingFocusBugWhenPopupCloses();
                    GosuEditor.this._editor.repaint();
                }
                finally {
                    GosuEditor.this.getUndoManager().endUndoAtom(undoAtom);
                }
            }
        });
        this.displayBeanInfoPopup(this._editor.getCaretPosition());
    }

    void displayValueCompletion(ParseException pe) {
        ParseExceptionIntellisense.instance().resolve(this, pe);
    }

    @Override
    public boolean displayValueCompletionAtCurrentLocation() {
        return ValueCompletionIntellisense.instance().complete(this);
    }

    public void clipCopyTypeInfoAtCurrentLocation() {
        IType type = this.getTypeAtCaretPosition();
        if (type == null) {
            return;
        }
        RunMe.getEditorFrame().getGosuPanel().getClipboard().setContents(new StringSelection(type.getName()), null);
    }

    public void displayTypeInfoAtCurrentLocation() {
        String displayHTML;
        IType type = this.getTypeAtCaretPosition();
        IExpression expr = this.getExpressionAtCaret();
        if (expr != null && expr.getParent() instanceof IImplicitTypeAsExpression) {
            type = ((IImplicitTypeAsExpression)expr.getParent()).getType();
        }
        IType typeAtCursor = type;
        final JPopupMenu popup = new JPopupMenu();
        boolean foundType = true;
        if (typeAtCursor != null) {
            displayHTML = typeAtCursor instanceof IMetaType ? "<html><b>Type:</b>&nbsp;Type&lt;<i>" + HTMLEscapeUtil.escape(((IMetaType)type).getType().getName()) + "</i>&gt;</html>" : "<html><b>Type:</b>&nbsp;" + HTMLEscapeUtil.escape(type.getName()) + "</html>";
        } else {
            displayHTML = "No type found at point";
            foundType = false;
        }
        final JLabel label = new JLabel(displayHTML);
        label.setFocusable(true);
        JPanel panel = new JPanel(true);
        panel.setBackground(EditorUtilities.TOOLTIP_BACKGROUND);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        panel.add(label);
        if (foundType) {
            JButton copyBtn = new JButton("copy");
            final IType type1 = type;
            copyBtn.setAction(new AbstractAction("copy"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorUtilities.getClipboard().setContents(new StringSelection(type1.getName()), null);
                    CopyBuffer.instance().captureState();
                }
            });
            copyBtn.setFont(copyBtn.getFont().deriveFont(10.0f));
            panel.add(Box.createHorizontalStrut(4));
            panel.add(copyBtn);
        }
        popup.add(panel);
        try {
            Rectangle rectangle = this.getCaretLocation();
            popup.show(this, rectangle.x + 15, rectangle.y - 20);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.requestFocus();
                    label.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            label.removeKeyListener(this);
                            popup.setVisible(false);
                        }
                    });
                }
            });
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Rectangle getCaretLocation() throws BadLocationException {
        Rectangle rectangle = this.getEditor().modelToView(this.getEditor().getCaretPosition());
        return SwingUtilities.convertRectangle(this.getEditor(), rectangle, this);
    }

    public void extractVariable() {
        this._codeManager.extractVariable();
    }

    public IType getTypeAtCaretPosition() {
        String atCaret = TextComponentUtil.getWordAtCaret(this.getEditor());
        if (GosuStringUtil.isEmpty((String)atCaret)) {
            return null;
        }
        IParseTree deepest = this.getDeepestLocationAtCaret();
        if (deepest == null) {
            return null;
        }
        IParsedElement parsedElement = deepest.getParsedElement();
        if (parsedElement instanceof IClassDeclaration) {
            return ((IClassDeclaration)parsedElement).getGSClass();
        }
        if (parsedElement instanceof IExpression) {
            return ((IExpression)parsedElement).getType();
        }
        if (parsedElement instanceof IVarStatement) {
            IVarStatement varStmt = (IVarStatement)parsedElement;
            IParseTree location = varStmt.getLocation();
            int caret = this.getEditor().getCaretPosition();
            if (caret > location.getOffset() + Keyword.KW_var.length() && location.areAllChildrenAfterPosition(caret)) {
                return varStmt.getType();
            }
        } else if (parsedElement instanceof IForEachStatement) {
            IForEachStatement feStmt = (IForEachStatement)parsedElement;
            IParseTree location = feStmt.getLocation();
            int caret = this.getEditor().getCaretPosition();
            if (caret > location.getOffset() + Keyword.KW_for.length() && location.areAllChildrenAfterPosition(caret)) {
                return feStmt.getIdentifier().getType();
            }
        }
        return null;
    }

    void replaceLocationAtCaret(String strReplacement) {
        IParseTree deepest = this.getDeepestLocationAtCaret();
        if (deepest == null) {
            return;
        }
        this.replaceLocation(deepest, strReplacement);
    }

    void replaceLocation(IParseTree location, String strReplacement) {
        this._editor.setCaretPosition(location.getOffset());
        this._editor.moveCaretPosition(location.getOffset() + location.getLength());
        this._editor.replaceSelection(strReplacement);
    }

    boolean shouldDisplaySmartHelp(ParseException pe) {
        return pe != null && ParseExceptionIntellisense.instance().canResolve(this, pe);
    }

    IExpression getExpressionBeforeCaret() {
        return this.getExpressionAtPos(this._editor.getCaretPosition() - 1);
    }

    IExpression getExpressionAtCaret() {
        return this.getExpressionAtPos(this._editor.getCaretPosition());
    }

    IExpression getExpressionAtPos(int iPos) {
        IParsedElement pe;
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(iPos - this._parser.getOffsetShift()), (boolean)true);
        if (locationBeforeDot != null && (pe = locationBeforeDot.getParsedElement()) instanceof IExpression) {
            return (IExpression)pe;
        }
        return null;
    }

    int getPositionAtStartOfExpressionAtCaret() {
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(this._editor.getCaretPosition() - this._parser.getOffsetShift()), (boolean)true);
        return locationBeforeDot.getOffset();
    }

    public IExpression getExpressionContainingCharacterBeforeCaret() {
        IParsedElement pe;
        int iPos = this._editor.getCaretPosition() - this._parser.getOffsetShift();
        IParseTree locationBeforeDot = IParseTree.Search.getDeepestLocation((List)this._parser.getLocations(), (int)(iPos - 1), (int)iPos, (boolean)true);
        if (locationBeforeDot != null && (pe = locationBeforeDot.getParsedElement()) instanceof IExpression) {
            return (IExpression)pe;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISymbolTable getSymbolTableAtCursor() {
        block16: {
            int iCaretPos = this._editor.getCaretPosition();
            StringBuffer sb = new StringBuffer(this._editor.getText());
            sb.insert(iCaretPos, " +yennikcm ;");
            IGosuParser parserJavadoc = GosuParserFactory.createParser((ISymbolTable)this.getSymbolTable(), (IScriptabilityModifier)this._scriptabilityModifier);
            parserJavadoc.setEditorParser(true);
            parserJavadoc.setScript((CharSequence)sb.toString());
            try {
                TypeSystem.lock();
                try {
                    if (this.isProgram()) {
                        IGosuProgramParser programParser = GosuParserFactory.createProgramParser();
                        ParserOptions options = new ParserOptions().withParser(parserJavadoc);
                        IParseResult result = programParser.parseExpressionOrProgram(sb.toString(), parserJavadoc.getSymbolTable(), options);
                        IGosuProgram parsedGosuClass = result.getProgram();
                        ParseResultsException parseResultsException = parsedGosuClass.getParseResultsException();
                        if (parseResultsException != null) {
                            throw parseResultsException;
                        }
                    } else if (this.isClass()) {
                        parserJavadoc.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)sb, this._bTestResource, ClassType.Class), true, true);
                    } else if (this.isEnhancement()) {
                        parserJavadoc.parseClass(this.getScriptPart().getContainingTypeName(), (ISourceFileHandle)new StringSourceFileHandle(this.getScriptPart().getContainingTypeName(), (CharSequence)sb, this._bTestResource, ClassType.Enhancement), true, true);
                    } else if (this._bStatement) {
                        parserJavadoc.parseStatements(this.getScriptPart());
                    } else {
                        parserJavadoc.parseExpOrProgram(this.getScriptPart());
                    }
                }
                finally {
                    TypeSystem.unlock();
                }
            }
            catch (ParseResultsException pe) {
                List errors = pe.getIssuesFromPos(iCaretPos + 2);
                if (errors.isEmpty()) {
                    errors = pe.getIssuesFromPos(iCaretPos);
                }
                if (errors.isEmpty()) break block16;
                for (IParseIssue error : errors) {
                    if (error.getSymbolTable() == null) continue;
                    return error.getSymbolTable();
                }
            }
        }
        return this.getSymbolTable();
    }

    protected void displayBeanInfoPopup(int iPosition) {
        if (!this._editor.isShowing()) {
            return;
        }
        if (this.isResultOfUndo()) {
            return;
        }
        try {
            this.dismissValuePopup();
            Rectangle rcBounds = this.getPositionFromPoint(iPosition);
            if (rcBounds != TEST_RECTANGLE) {
                this._beanInfoPopup.show(this._editor, rcBounds.x, rcBounds.y + rcBounds.height);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GosuEditor.this._editor.requestFocus();
                    GosuEditor.this._editor.repaint();
                }
            });
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    private Rectangle getPositionFromPoint(int iPosition) throws BadLocationException {
        Rectangle rectangle = this._editor.modelToView(iPosition);
        if (rectangle == null) {
            rectangle = TEST_RECTANGLE;
        }
        return rectangle;
    }

    private boolean isResultOfUndo() {
        return Math.abs(this.getUndoManager().getLastUndoTime() - System.currentTimeMillis()) < 400L;
    }

    void displayValuePopup() {
        this.displayValuePopup(this.getEditor().getCaretPosition());
    }

    void displayValuePopup(int iPosition) {
        this.displayValuePopup(iPosition, true);
    }

    void displayValuePopup(int iPosition, boolean bFocusInEditor) {
        try {
            this.dismissBeanInfoPopup();
            Rectangle rcCaretBounds = this.getPositionFromPoint(iPosition);
            if (rcCaretBounds != TEST_RECTANGLE) {
                this._valuePopup.show(this._editor, rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
            }
            if (bFocusInEditor) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GosuEditor.this._editor.requestFocus();
                        GosuEditor.this._editor.repaint();
                    }
                });
            }
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    ParameterInfoPopup displayParameterInfoPopup(int iPosition) {
        return ParameterInfoPopup.invoke(this, iPosition);
    }

    void dismissBeanInfoPopup() {
        if (this._beanInfoPopup != null) {
            this._beanInfoPopup.setVisible(false);
            this._beanInfoPopup = null;
        }
    }

    public BeanInfoPopup getBeanInfoPopup() {
        return this._beanInfoPopup;
    }

    public void setBeanInfoPopup(BeanInfoPopup beanInfoPopup) {
        this._beanInfoPopup = beanInfoPopup;
    }

    public IValuePopup getValuePopup() {
        return (IValuePopup)((Object)this._valuePopup);
    }

    public void setValuePopup(IValuePopup valuePopup) {
        this._valuePopup = (JPopupMenu)((Object)valuePopup);
    }

    public boolean isIntellisensePopupShowing() {
        return this._beanInfoPopup != null && this._beanInfoPopup.isShowing() || this._valuePopup != null && this._valuePopup.isShowing();
    }

    private void dismissValuePopup() {
        if (this._valuePopup != null) {
            this._valuePopup.setVisible(false);
            this._valuePopup = null;
        }
    }

    @Override
    public void gotoDeclarationAtCursor() {
        IParseTree deepestParseTree = this.getDeepestLocationAtCaret();
        if (deepestParseTree == null) {
            return;
        }
        IParsedElement deepestParsedElementAtCaret = deepestParseTree.getParsedElement();
        this.gotoReference(deepestParsedElementAtCaret);
    }

    private void gotoReference(IParsedElement pe) {
        int prevCaretPos = this.getEditor().getCaretPosition();
        if (pe instanceof IMethodCallExpression) {
            IFunctionSymbol fs = ((IMethodCallExpression)pe).getFunctionSymbol();
            if (fs instanceof IDynamicFunctionSymbol) {
                this.handleGotoFeature((IFeatureInfo)((IDynamicFunctionSymbol)fs).getMethodOrConstructorInfo());
            }
        } else if (pe instanceof IBeanMethodCallExpression) {
            this.handleGotoFeature((IFeatureInfo)((IBeanMethodCallExpression)pe).getMethodDescriptor());
        } else if (pe instanceof IMemberAccessExpression) {
            this.handleGotoFeature((IFeatureInfo)((IMemberAccessExpression)pe).getPropertyInfo());
        } else if (pe instanceof IIdentifierExpression) {
            ISymbol symbol = ((IIdentifierExpression)pe).getSymbol();
            if (symbol instanceof IDynamicPropertySymbol) {
                this.handleGotoFeature(((IDynamicPropertySymbol)symbol).getPropertyInfo());
            } else if (symbol instanceof IDynamicSymbol) {
                this.handleGotoFeature((IFeatureInfo)symbol.getGosuClass().getTypeInfo().getProperty((IType)symbol.getGosuClass(), (CharSequence)symbol.getName()));
            } else if (symbol.isLocal()) {
                this.handleGotoLocal(symbol, pe);
            }
        } else if (pe instanceof ITypeLiteralExpression) {
            this.handleGotoFeature((IFeatureInfo)((ITypeLiteralExpression)pe).getType().getType().getTypeInfo());
        } else {
            this.displayJavadocHelp(pe.getLocation());
        }
        GosuPanel gosuPanel = RunMe.getEditorFrame().getGosuPanel();
        GosuEditor currentEditor = gosuPanel.getCurrentEditor();
        int currentCaretPos = currentEditor.getEditor().getCaretPosition();
        if (currentEditor == this && currentCaretPos != prevCaretPos) {
            gosuPanel.getTabSelectionHistory().addNavigationHistory(this, prevCaretPos, currentCaretPos);
        }
    }

    @Override
    public String getSelectedText() {
        return this._editor.getSelectedText();
    }

    public void handleGotoFeature(IFeatureInfo feature) {
        IFile sourceFile;
        if (feature == null) {
            return;
        }
        IType ownersType = feature.getOwnersType();
        if (!(ownersType instanceof IGosuClass)) {
            return;
        }
        IGosuClass gsClass = (IGosuClass)ownersType;
        int offset = 0;
        if (feature instanceof IGosuMethodInfo) {
            ArrayList res = new ArrayList();
            gsClass.getClassStatement().getContainedParsedElementsByType(IParsedElementWithAtLeastOneDeclaration.class, res);
            for (IParsedElementWithAtLeastOneDeclaration fs : res) {
                if (((IGosuMethodInfo)feature).isMethodForProperty() && fs instanceof IVarStatement && ((IVarStatement)fs).hasProperty() && ((IVarStatement)fs).hasProperty() && ((IVarStatement)fs).getPropertyName().equals(feature.getDisplayName().substring(1))) {
                    offset = fs.getNameOffset(((IVarStatement)fs).getPropertyName());
                } else {
                    if ((!(fs instanceof IFunctionStatement) || !feature.equals(((IFunctionStatement)fs).getDynamicFunctionSymbol().getMethodOrConstructorInfo())) && (!(fs instanceof IPropertyStatement) || !feature.equals(((IPropertyStatement)fs).getPropertyGetterOrSetter().getDynamicFunctionSymbol().getMethodOrConstructorInfo()))) continue;
                    offset = fs.getNameOffset(feature.getName());
                }
                break;
            }
        } else {
            if (feature instanceof IGosuPropertyInfo) {
                this.handleGotoFeature((IFeatureInfo)((IGosuPropertyInfo)feature).getReadMethodInfo());
                return;
            }
            if (feature instanceof IGosuVarPropertyInfo) {
                IGosuVarPropertyInfo varProp = (IGosuVarPropertyInfo)feature;
                offset = varProp.getOffset();
            } else if (feature instanceof ITypeInfo) {
                IGosuClass targetClass = ((IGosuClassTypeInfo)feature).getGosuClass();
                IClassDeclaration classDeclaration = targetClass.getClassStatement().getClassDeclaration();
                int n = offset = classDeclaration == null ? 0 : classDeclaration.getNameOffset(null);
            }
        }
        if (gsClass != this.getParsedClass() && (sourceFile = gsClass.getSourceFileHandle().getFile()) != null && sourceFile.isJavaFile()) {
            RunMe.getEditorFrame().getGosuPanel().openFile(sourceFile.toJavaFile());
            SettleModalEventQueue.instance().run();
        }
        RunMe.getEditorFrame().getGosuPanel().getCurrentEditor().getEditor().setCaretPosition(offset);
    }

    public void handleGotoLocal(ISymbol symbol, IParsedElement pe) {
        IParsedElement functionAtCaret = this.getRootParsedElement();
        if (functionAtCaret == null) {
            return;
        }
        ArrayList res = new ArrayList();
        IParsedElement root = this.getRootParsedElement();
        root.getContainedParsedElementsByType(ILocalVarDeclaration.class, res);
        for (ILocalVarDeclaration fs : res) {
            if (symbol != fs.getSymbol()) continue;
            int offset = fs.getNameOffset((String)fs.getLocalVarName());
            this.getEditor().setCaretPosition(offset);
            return;
        }
        ArrayList v = new ArrayList();
        root.getContainedParsedElementsByType(IVarStatement.class, v);
        for (IVarStatement fs : v) {
            if (!symbol.equals(fs.getSymbol())) continue;
            int offset = fs.getNameOffset(fs.getIdentifierName());
            this.getEditor().setCaretPosition(offset);
            return;
        }
    }

    void displayJavadocHelp(IParseTree parseTree) {
        String strHelpText = this.getContextHelp(parseTree);
        if (strHelpText == null) {
            return;
        }
        try {
            this.dismissBeanInfoPopup();
            this.dismissValuePopup();
            Rectangle rcCaretBounds = this._editor.modelToView(parseTree.getOffset() + this._parser.getOffsetShift());
            this._javadocPopup = new JavadocPopup(strHelpText, this);
            if (rcCaretBounds != TEST_RECTANGLE) {
                this._javadocPopup.show(this._editor, rcCaretBounds.x, rcCaretBounds.y + rcCaretBounds.height);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GosuEditor.this._editor.requestFocus();
                    GosuEditor.this._editor.repaint();
                }
            });
        }
        catch (BadLocationException e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    String getContextHelp(IParseTree parseTree) {
        return ContextHelpUtil.getContextHelp(parseTree);
    }

    String getTooltipMessage(MouseEvent event) {
        if (this._parser == null) {
            return null;
        }
        int iPos = this.getEditor().viewToModel(event.getPoint());
        return this.getErrorMessagesAt(this.getIssuesFromPos(iPos));
    }

    private List<IParseIssue> getIssuesFromPos(int iPos) {
        if (this._editor == null) {
            return null;
        }
        ParseResultsException pe = this.getParseResultsException();
        if (pe == null) {
            return null;
        }
        List parseIssues = pe.getIssuesFromPos(iPos);
        try {
            if (" ".equals(this._editor.getText(iPos - 1, 1))) {
                parseIssues.addAll(pe.getIssuesFromPos(iPos - 1));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return parseIssues;
    }

    private List<IParseIssue> getIssuesNearPos(int iPos) {
        List<IParseIssue> issues = this.getIssuesFromPos(iPos);
        if (issues != null && !issues.isEmpty()) {
            return issues;
        }
        if (this._editor == null) {
            return null;
        }
        ParseResultsException pe = this.getParseResultsException();
        if (pe == null) {
            return null;
        }
        int iDelta = Integer.MAX_VALUE;
        IParseIssue error = null;
        for (IParseIssue e : pe.getParseExceptions()) {
            Element root = this._editor.getDocument().getRootElements()[0];
            int iLine = root.getElementIndex(iPos) + 1;
            int iCurrentDelta = iPos - e.getTokenEnd();
            if (iCurrentDelta < 0 || iLine != e.getLine()) continue;
            try {
                String strTextBetweenPosAndError = this._editor.getText(e.getTokenEnd(), iPos - e.getTokenEnd());
                if (strTextBetweenPosAndError.trim().length() > 0) {
                }
            }
            catch (BadLocationException e1) {}
            continue;
            if (iCurrentDelta >= iDelta && (iCurrentDelta != iDelta || e.getTokenStart() < error.getTokenStart() || e.getExpectedType() == null)) continue;
            iDelta = iCurrentDelta;
            error = e;
        }
        if (error != null) {
            issues = new ArrayList<IParseIssue>(2);
            issues.add(error);
            return issues;
        }
        return null;
    }

    private String getErrorMessagesAt(List parseExceptions) {
        if (parseExceptions == null || parseExceptions.isEmpty()) {
            return null;
        }
        String strFeedback = "<html>";
        for (int i = 0; i < parseExceptions.size(); ++i) {
            String strTypeExpected;
            ParseException pe;
            IType typeExpected;
            if (i > 0) {
                strFeedback = strFeedback + "<br><hr>";
            }
            IParseIssue pi = (IParseIssue)parseExceptions.get(i);
            strFeedback = strFeedback + HTMLEscapeUtil.escape(pi.getUIMessage());
            if (!(pi instanceof ParseException) || (typeExpected = (pe = (ParseException)pi).getExpectedType()) == null || (strTypeExpected = ParseResultsException.getExpectedTypeName((IType)typeExpected)).length() <= 0) continue;
            strFeedback = strFeedback + "<br>Expected Type:" + HTMLEscapeUtil.escape(strTypeExpected);
        }
        return strFeedback;
    }

    public void addParseListener(ParseListener parseListener) {
        this._parseListeners.add(parseListener);
    }

    public boolean acceptsUses() {
        return this._bAcceptUses;
    }

    public void setAcceptUses(boolean acceptUses) {
        this._bAcceptUses = acceptUses;
    }

    public int getLineNumberAtCaret() {
        return this._editor.getDocument().getDefaultRootElement().getElementIndex(this._editor.getCaretPosition()) + 1;
    }

    public void parseAndWaitForParser() {
        this.parse();
        this.waitForParser();
    }

    public void waitForParser() {
        TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE).postTaskAndWait(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public IParseTree getDeepestLocationAtCaret() {
        this.waitForParser();
        return this.getDeepestLocation(this._editor.getCaretPosition(), true);
    }

    IParseTree getDeepestLocation(Point pt) {
        int iOffset = this._editor.viewToModel(pt);
        if (iOffset < 0) {
            return null;
        }
        return this.getDeepestLocation(iOffset, true);
    }

    IParseTree getDeepestLocation(int iPos, boolean strict) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)strict);
    }

    IParseTree getDeepestLocationSpanning(int start, int end) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestLocationSpanning((List)locations, (int)(start - this._parser.getOffsetShift()), (int)(end - this._parser.getOffsetShift()), (boolean)true);
    }

    @Override
    public IParseTree getDeepestStatementLocationAtCaret() {
        return this.getDeepestStatementLocationAtPos(this._editor.getCaretPosition());
    }

    public IParseTree getDeepestStatementLocationAtPos(int iPos, boolean bStrict) {
        if (this._parser == null) {
            return null;
        }
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestStatementLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)bStrict);
    }

    public IParseTree getDeepestStatementLocationAtPos(int iPos) {
        List locations = this._parser.getLocations();
        return IParseTree.Search.getDeepestStatementLocation((List)locations, (int)(iPos - this._parser.getOffsetShift()), (boolean)false);
    }

    @Override
    public IParseTree getStatementAtLineAtCaret() {
        int iLineNum = this._editor.getDocument().getDefaultRootElement().getElementIndex(this._editor.getCaretPosition()) + 1;
        return this.getStatementAtLine(iLineNum);
    }

    @Override
    public IParseTree getStatementAtLine(int iLineNum) {
        if (this._parser != null) {
            List locations = this._parser.getLocations();
            return IParseTree.Search.getStatementAtLine((List)locations, (int)(iLineNum - this._parser.getLineNumShift()), IStatementList.class);
        }
        return null;
    }

    @Override
    public IParseTree getStatementAtLineOrExpression(int iLine) {
        IParseTree statement = this.getStatementAtLine(iLine);
        return this.returnStatementOrExpression(statement);
    }

    @Override
    public IParseTree getStatementAtLineAtCaretOrExpression() {
        IParseTree statement = this.getStatementAtLineAtCaret();
        return this.returnStatementOrExpression(statement);
    }

    private IParseTree returnStatementOrExpression(IParseTree statement) {
        if (statement != null) {
            return statement;
        }
        if (this._parser.getLocations().size() == 1 && ((IParseTree)this._parser.getLocations().get(0)).getParsedElement() instanceof IExpression) {
            return (IParseTree)this._parser.getLocations().get(0);
        }
        return null;
    }

    public IParsedElement getFunctionCallAtCaret() {
        IParseTree location = this.getDeepestLocationAtCaret();
        if (location == null) {
            return null;
        }
        IParsedElement parsedElement = location.getParsedElement();
        return this.findFunction(parsedElement);
    }

    public IParsedElement findFunction(IParsedElement parsedElement) {
        if (parsedElement == null) {
            return null;
        }
        while (!(parsedElement instanceof IMethodCallExpression || parsedElement instanceof IMethodCallStatement || parsedElement instanceof IBeanMethodCallExpression || parsedElement instanceof INewExpression && !(parsedElement instanceof IInferredNewExpression))) {
            if (parsedElement.getParent() == null) {
                return null;
            }
            parsedElement = parsedElement.getParent();
        }
        return parsedElement;
    }

    public IParsedElement getRootParsedElement() {
        IParseTree location = this.getDeepestLocationAtCaret();
        if (location == null) {
            return null;
        }
        IParsedElement parsedElement = location.getParsedElement();
        while (parsedElement.getParent() != null) {
            parsedElement = parsedElement.getParent();
        }
        return parsedElement;
    }

    void runIfNoKeyPressedInMillis(long lMillis, final Runnable task) {
        final boolean[] bKeyPressed = new boolean[]{false};
        final KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                bKeyPressed[0] = true;
            }
        };
        this._editor.addKeyListener(keyListener);
        Timer timer = _timerPool.requestTimer((int)lMillis, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuEditor.this._editor.removeKeyListener(keyListener);
                if (!bKeyPressed[0]) {
                    EditorUtilities.invokeInDispatchThread(task);
                }
                GosuEditor.this._iTimerCount--;
            }
        });
        timer.setRepeats(false);
        ++this._iTimerCount;
        timer.start();
    }

    public int getTimerCount() {
        return this._iTimerCount;
    }

    public boolean isAltDown() {
        return this._bAltDown;
    }

    void moveSelectionUp() {
        this._codeManager.moveSelectionUp();
    }

    void moveSelectionDown() {
        this._codeManager.moveSelectionDown();
    }

    private void smartFix() {
        this._smartFixManager.performFix();
    }

    public SmartFixManager getSmartFixManager() {
        return this._smartFixManager;
    }

    public void addToUses(String strType) {
        this._codeManager.addToUses(strType, this._bTemplate, this._bProgram);
    }

    public void addSpecialFunction(IDynamicFunctionSymbol symbol) {
        this._specialFunctions.add(symbol);
    }

    public void addSpecialFunctionHandler(IDynamicFunctionSymbol symbol, Runnable handler) {
        this._specialFunctionGotoDeclHandlers.put((IFunctionSymbol)symbol, handler);
    }

    public void clearSpecialFunctions() {
        this._specialFunctions.clear();
        this._specialFunctionGotoDeclHandlers.clear();
    }

    public void makeReadOnly(boolean bReadOnly) {
        this._editor.setEditable(!bReadOnly);
    }

    public void setPartId(ScriptPartId scriptPartId) {
        this._partId = scriptPartId;
    }

    @Override
    public void setTypeUsesMap(ITypeUsesMap typeUsesMap) {
        this._typeUsesMap = typeUsesMap;
    }

    @Override
    public void setProgramSuperType(IType baseClass) {
        this._programSuperType = baseClass;
    }

    public IGosuClass getParsedClass() {
        return this._parsedGosuClass;
    }

    public static void waitOnParserThread() {
        TaskQueue queue = TaskQueue.getInstance(INTELLISENSE_TASK_QUEUE);
        queue.postTaskAndWait(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public JavadocPopup getJavadocPopup() {
        return this._javadocPopup;
    }

    public static void waitForIntellisenseTimers() {
        _timerPool.waitForAllTimersToFinish();
    }

    public void refreshed() {
        this.parse();
    }

    public void refreshedTypes(RefreshRequest refreshRequest) {
        if (refreshRequest.types != null) {
            for (String name : refreshRequest.types) {
                if (this.getParsedClass() == null || !name.equals(this.getParsedClass().getName())) continue;
                return;
            }
        }
    }

    @Override
    public JComponent asJComponent() {
        return this;
    }

    public void clipCut(Clipboard clipboard) {
        try {
            this.getUndoManager().beginUndoAtom("Cut");
            this.clipCopy(clipboard);
            this.delete();
        }
        finally {
            this.getUndoManager().endUndoAtom();
        }
    }

    public void clipCopy(Clipboard clipboard) {
        try {
            Transferable contents = this.getClipCopyContents();
            if (contents == null) {
                return;
            }
            clipboard.setContents(contents, null);
        }
        catch (Exception e) {
            EditorUtilities.handleUncaughtException(e);
        }
    }

    public void clipPaste(Clipboard clipboard, boolean asGosu) {
        Transferable t = clipboard.getContents(this);
        if (t == null) {
            return;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String strContents = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (asGosu && "".equals(strContents = JavaToGosu.convertString(strContents))) {
                    JOptionPane.showMessageDialog(this.getEditor(), "The copied Java code has errors, only valid Java 8 code can be transformed", "Paste Java as Gosu", 0);
                    return;
                }
                this.getEditor().replaceSelection(strContents);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Transferable getClipCopyContents() {
        StringSelection contents = null;
        String strSelection = this.getExpandedSelection();
        if (strSelection != null && strSelection.length() > 0) {
            contents = new StringSelection(strSelection);
        }
        return contents;
    }

    static {
        if (PlatformUtil.isMac()) {
            CONTROL_KEY_MASK = 256;
            CONTROL_KEY_NAME = "meta";
        } else {
            CONTROL_KEY_MASK = 128;
            CONTROL_KEY_NAME = "control";
        }
        COMPLETION_DELAY = 500;
        TEST_RECTANGLE = new Rectangle(0, 0, 0, 0);
        _timerPool = new TimerPool();
    }

    private static class TimerPool {
        List<Object> _activeTimers = new ArrayList<Object>();

        private TimerPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Timer requestTimer(int millis, final ActionListener action) {
            TimerPool timerPool = this;
            synchronized (timerPool) {
                final Object timerToken = new Object();
                Timer timer = new Timer(millis, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            action.actionPerformed(e);
                        }
                        finally {
                            TimerPool timerPool = this;
                            synchronized (timerPool) {
                                _activeTimers.remove(timerToken);
                                this.notify();
                            }
                        }
                    }
                });
                this._activeTimers.add(timerToken);
                return timer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForAllTimersToFinish() {
            TimerPool timerPool = this;
            synchronized (timerPool) {
                while (!this._activeTimers.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    class ReplaceWordCallback
    implements IReplaceWordCallback {
        ReplaceWordCallback() {
        }

        @Override
        public boolean shouldReplace(String strWord) {
            return Character.isJavaIdentifierPart(strWord.charAt(0));
        }
    }

    class ErrorAtCaretHandler
    implements CaretListener {
        ErrorAtCaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent ce) {
            if (TaskQueue.getInstance(GosuEditor.INTELLISENSE_TASK_QUEUE).size() == 0) {
                GosuEditor.this.handleCodeCompletion(false);
            }
        }
    }

    class GosuDocumentHandler
    implements DocumentListener {
        GosuDocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.resizeEditor();
            GosuEditor.this.parse();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.resizeEditor();
            GosuEditor.this.parse();
        }

        private void resizeEditor() {
            Dimension dim = GosuEditor.this._editor.getPreferredSize();
            if (GosuEditor.this._editor.getWidth() != dim.width) {
                GosuEditor.this._editor.setSize(dim);
                GosuEditor.this.validate();
            }
        }
    }

    class EditorKeyHandler
    extends KeyAdapter {
        EditorKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            GosuEditor.this.setCompleteCode(false);
            if (e.getKeyChar() == '\n' && e.getModifiers() == 0) {
                GosuEditor.this._bEnterPressedConsumed = e.isConsumed() || GosuEditor.this.isIntellisensePopupShowing();
            } else if (e.getKeyChar() == ' ' && (e.getModifiers() & 2) > 0) {
                GosuEditor.this._bAltDown = (e.getModifiers() & 8) > 0;
                if (!GosuEditor.this.isIntellisensePopupShowing()) {
                    GosuEditor.this.handleCompleteCode();
                    e.consume();
                }
            } else if (e.getKeyCode() == 8 || e.getKeyChar() == '\b') {
                GosuEditor.this.handleBackspace();
                if (e.getModifiers() == 1) {
                    GosuEditor.this._editor.dispatchEvent(new KeyEvent((Component)e.getSource(), e.getID(), e.getWhen(), 0, e.getKeyCode(), e.getKeyChar(), e.getKeyLocation()));
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            boolean consumed = e.isConsumed();
            if (consumed || !GosuEditor.this._editor.isEditable()) {
                return;
            }
            char keyChar = e.getKeyChar();
            int modifiers = e.getModifiers();
            this.postProcessKeystroke(consumed, keyChar, modifiers);
        }

        private void postProcessKeystroke(boolean consumed, char keyChar, int modifiers) {
            if (keyChar == '.') {
                GosuEditor.this.handleDot();
            }
            if (keyChar == ':') {
                GosuEditor.this.handleColon();
            }
            if (keyChar == '#') {
                GosuEditor.this.handleDot();
            } else if (keyChar == '\n' && modifiers == 0) {
                if (!(consumed || GosuEditor.this._bEnterPressedConsumed || GosuEditor.this.isIntellisensePopupShowing())) {
                    GosuEditor.this.handleEnter();
                }
            } else if (keyChar == '}' && !consumed && !GosuEditor.this.isIntellisensePopupShowing()) {
                GosuEditor.this.handleBraceRight();
            }
        }
    }

    class ParseTask
    implements Runnable {
        private String _strSource;
        private boolean _forceCodeCompletion;
        private boolean _changed;

        public ParseTask(String strSource, boolean forceCodeCompletion, boolean changed) {
            this._strSource = strSource;
            this._forceCodeCompletion = forceCodeCompletion;
            this._changed = changed;
        }

        GosuEditor getEditor() {
            return GosuEditor.this;
        }

        @Override
        public void run() {
            if (!this.getEditor().isShowing()) {
                return;
            }
            if (!GosuEditor.this.areMoreThanOneParserTasksPendingForThisEditor() || this._forceCodeCompletion) {
                TypeSystem.lock();
                try {
                    GosuEditor.this._parseNow(this._strSource, this._forceCodeCompletion, this._changed);
                }
                finally {
                    TypeSystem.unlock();
                    if (this._forceCodeCompletion) {
                        GosuEditor.this.setCompleteCode(false);
                    }
                }
                for (ParseListener parseListener : GosuEditor.this._parseListeners) {
                    parseListener.parseComplete();
                }
            }
        }
    }

    private static enum HighlightMode {
        SEARCH,
        USAGES;

    }
}

