/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.ClasspathDialog;
import editor.CommonMenus;
import editor.DefaultContextMenuHandler;
import editor.EditorTabHistoryHandler;
import editor.ExperimentView;
import editor.GosuDocument;
import editor.GosuEditor;
import editor.GosuPanelDocumentFilter;
import editor.GotoTypePopup;
import editor.ITabHistoryContext;
import editor.NavigationHistory;
import editor.NewFilePopup;
import editor.RunMe;
import editor.ScriptChangeHandler;
import editor.SystemPanel;
import editor.TypeNameCache;
import editor.search.StandardLocalSearch;
import editor.search.StudioUtilities;
import editor.splitpane.CollapsibleSplitPane;
import editor.tabpane.ITab;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.undo.AtomicUndoManager;
import editor.util.BrowserUtil;
import editor.util.EditorUtilities;
import editor.util.Experiment;
import editor.util.GosuTextifier;
import editor.util.LabelListPopup;
import editor.util.PlatformUtil;
import editor.util.SettleModalEventQueue;
import editor.util.SmartMenu;
import editor.util.TaskQueue;
import editor.util.TypeNameUtil;
import editor.util.XPToolbarButton;
import gw.config.CommonServices;
import gw.fs.IDirectory;
import gw.internal.ext.org.objectweb.asm.ClassReader;
import gw.internal.ext.org.objectweb.asm.ClassVisitor;
import gw.internal.ext.org.objectweb.asm.util.Printer;
import gw.internal.ext.org.objectweb.asm.util.TraceClassVisitor;
import gw.lang.Gosu;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.IScriptPartId;
import gw.lang.parser.ScriptPartId;
import gw.lang.parser.ScriptabilityModifiers;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.parser.expressions.IBlockExpression;
import gw.lang.parser.resources.ResourceKey;
import gw.lang.parser.statements.IClassStatement;
import gw.lang.reflect.IMethodInfo;
import gw.lang.reflect.IScriptabilityModifier;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.Modifier;
import gw.lang.reflect.ReflectUtil;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.GosuClassPathThing;
import gw.lang.reflect.gs.ICompilableType;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.gs.IGosuProgram;
import gw.lang.reflect.java.JavaTypes;
import gw.util.GosuExceptionUtil;
import gw.util.StreamUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;

public class GosuPanel
extends JPanel {
    private static final int MAX_TABS = 12;
    private SystemPanel _resultPanel;
    private CollapsibleSplitPane _outerSplitPane;
    private CollapsibleSplitPane _splitPane;
    private ExperimentView _experimentView;
    private JFrame _parentFrame;
    private boolean _bRunning;
    private TabPane _editorTabPane;
    private AtomicUndoManager _defaultUndoMgr;
    private NavigationHistory _history;
    private JLabel _status;
    private JPanel _statPanel;
    private boolean _initialFile;
    private TypeNameCache _typeNamesCache;
    private Experiment _experiment;

    public GosuPanel(JFrame basicGosuEditor) {
        this._parentFrame = basicGosuEditor;
        this._defaultUndoMgr = new AtomicUndoManager(10);
        this._typeNamesCache = new TypeNameCache();
        this.configUI();
    }

    public NavigationHistory getTabSelectionHistory() {
        return this._history;
    }

    void configUI() {
        this.setLayout(new BorderLayout());
        this._resultPanel = new SystemPanel();
        TabPane resultTabPane = new TabPane(5);
        resultTabPane.addTab("Runtime Output", null, this._resultPanel);
        this._editorTabPane = new TabPane(TabPosition.TOP, 15);
        this._history = new NavigationHistory(this._editorTabPane);
        this.getTabSelectionHistory().setTabHistoryHandler(new EditorTabHistoryHandler());
        this._editorTabPane.addSelectionListener(e -> {
            if (!this._editorTabPane.isVisible()) {
                return;
            }
            this.savePreviousTab();
            this.updateTitle();
            if (this.getCurrentEditor() == null) {
                return;
            }
            this.getCurrentEditor().getEditor().requestFocus();
            this.parse();
            this.storeExperimentState();
        });
        this._experimentView = new ExperimentView();
        this._experimentView.setBackground(Color.white);
        TabPane experimentViewTabPane = new TabPane(TabPosition.TOP, 21);
        experimentViewTabPane.addTab("Experiment", null, this._experimentView);
        this._splitPane = new CollapsibleSplitPane(0, experimentViewTabPane, this._editorTabPane);
        this._outerSplitPane = new CollapsibleSplitPane(1, this._splitPane, resultTabPane);
        this.add((Component)this._outerSplitPane, "Center");
        JPanel statPanel = this.makeStatusBar();
        this.add((Component)statPanel, "South");
        JMenuBar menuBar = this.makeMenuBar();
        this._parentFrame.setJMenuBar(menuBar);
        this.handleMacStuff();
        EventQueue.invokeLater(() -> {
            this.setExperimentSplitPosition(70);
            this.setEditorSplitPosition(20);
        });
        EventQueue.invokeLater(this::mapKeystrokes);
    }

    public ExperimentView getExperimentView() {
        return this._experimentView;
    }

    private void handleMacStuff() {
        if (PlatformUtil.isMac()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Gosu Editor");
        }
    }

    public void clearTabs() {
        this._editorTabPane.setVisible(false);
        try {
            this._editorTabPane.removeAllTabs();
        }
        finally {
            this._editorTabPane.setVisible(true);
        }
        SettleModalEventQueue.instance().run();
        this.getTabSelectionHistory().dispose();
    }

    private void storeExperimentState() {
        if (this._initialFile) {
            return;
        }
        this.getExperiment().save(this._editorTabPane);
        EditorUtilities.saveLayoutState(this._experiment);
    }

    private Experiment getExperiment() {
        return this._experiment;
    }

    static List<String> getLocalClasspath() {
        ArrayList<String> localPath = new ArrayList<String>();
        List classpath = TypeSystem.getGlobalModule().getSourcePath();
        for (int i = 0; i < classpath.size(); ++i) {
            File file = ((IDirectory)classpath.get(i)).toJavaFile();
            String filePath = file.getAbsolutePath().toLowerCase();
            if (GosuPanel.isUpperLevelClasspath(filePath)) continue;
            localPath.add(file.getAbsolutePath());
        }
        return localPath;
    }

    public static boolean isUpperLevelClasspath(String filePath) {
        String javaHome = System.getProperty("java.home").toLowerCase();
        if (filePath.replace('\\', '/').contains("gosu-lab/src/main/resources")) {
            return false;
        }
        return filePath.startsWith(javaHome) || filePath.contains(File.separator + "gosu-lang" + File.separator) || filePath.endsWith(File.separator + "tools.jar") || filePath.endsWith(File.separator + "idea_rt.jar");
    }

    public void restoreExperimentState(Experiment experiment) {
        this._experiment = experiment;
        if (experiment.getSourcePath().size() > 0) {
            RunMe.reinitializeGosu(experiment);
        }
        for (String openFile : experiment.getOpenFiles()) {
            File file = new File(openFile);
            if (!file.isFile()) continue;
            this.openFile(file);
        }
        String activeFile = experiment.getActiveFile();
        if (activeFile == null) {
            this.openFile(experiment.getOrMakeUntitledProgram());
        } else {
            this.openTab(new File(activeFile));
        }
        SettleModalEventQueue.instance().run();
        this._experimentView.load(this._experiment);
        EventQueue.invokeLater(() -> {
            this.parse();
            GosuEditor currentEditor = this.getCurrentEditor();
            if (currentEditor != null) {
                currentEditor.getEditor().requestFocus();
            }
        });
    }

    private JPanel makeStatusBar() {
        this._statPanel = new JPanel(new BorderLayout());
        this._status = new JLabel();
        XPToolbarButton btnStop = new XPToolbarButton("Stop");
        btnStop.addActionListener(new StopActionHandler());
        this._statPanel.add((Component)btnStop, "West");
        this._statPanel.add((Component)this._status, "Center");
        this._statPanel.setVisible(false);
        return this._statPanel;
    }

    private void parse() {
        EventQueue.invokeLater(() -> {
            if (this.getCurrentEditor() != null) {
                this.getCurrentEditor().parse();
            }
        });
    }

    private void savePreviousTab() {
        GosuEditor editor = this.getTabSelectionHistory().getPreviousEditor();
        if (editor != null) {
            if (this.isDirty(editor)) {
                this.save((File)editor.getClientProperty("_file"), editor);
            } else if (editor.getParsedClass() != null) {
                TypeSystem.refresh((ITypeRef)((ITypeRef)editor.getParsedClass()));
            }
        }
    }

    private GosuEditor createEditor() {
        GosuEditor editor = new GosuEditor(null, new AtomicUndoManager(10000), (IScriptabilityModifier)ScriptabilityModifiers.SCRIPTABLE, new DefaultContextMenuHandler(), false, true);
        editor.setBorder(BorderFactory.createEmptyBorder());
        this.addDirtyListener(editor);
        EventQueue.invokeLater(() -> ((AbstractDocument)editor.getEditor().getDocument()).setDocumentFilter(new GosuPanelDocumentFilter(editor)));
        return editor;
    }

    private void addDirtyListener(final GosuEditor editor) {
        editor.getUndoManager().addChangeListener(new ChangeListener(){
            private ChangeEvent _lastChangeEvent;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e != this._lastChangeEvent) {
                    this._lastChangeEvent = e;
                    GosuPanel.this.setDirty(editor, true);
                }
            }
        });
    }

    private GosuEditor initEditorMode(File file, GosuEditor editor) {
        if (file != null && file.getName() != null) {
            if (file.getName().endsWith(".gsx")) {
                editor.setProgram(false);
                editor.setTemplate(false);
                editor.setClass(false);
                editor.setEnhancement(true);
            } else if (file.getName().endsWith(".gs")) {
                editor.setProgram(false);
                editor.setTemplate(false);
                editor.setClass(true);
                editor.setEnhancement(false);
            } else if (file.getName().endsWith(".gst")) {
                editor.setProgram(false);
                editor.setTemplate(true);
                editor.setClass(false);
                editor.setEnhancement(false);
            } else {
                editor.setProgram(true);
                editor.setTemplate(false);
                editor.setClass(false);
                editor.setEnhancement(false);
            }
        }
        return editor;
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.makeFileMenu(menuBar);
        this.makeEditMenu(menuBar);
        this.makeSearchMenu(menuBar);
        this.makeCodeMenu(menuBar);
        this.makeRunMenu(menuBar);
        this.makeWindowMenu(menuBar);
        this.makeHelpMenu(menuBar);
        return menuBar;
    }

    private void makeHelpMenu(JMenuBar menuBar) {
        SmartMenu helpMenu = new SmartMenu("Help");
        helpMenu.setMnemonic('H');
        menuBar.add(helpMenu);
        JMenuItem gosuItem = new JMenuItem(new AbstractAction("Gosu Online"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.org");
            }
        });
        gosuItem.setMnemonic('G');
        helpMenu.add(gosuItem);
        helpMenu.addSeparator();
        JMenuItem helpItem = new JMenuItem(new AbstractAction("The Basics"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/docs.html");
            }
        });
        helpItem.setMnemonic('B');
        helpMenu.add(helpItem);
        helpMenu.addSeparator();
        JMenuItem playItem = new JMenuItem(new AbstractAction("Web Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/play.html");
            }
        });
        playItem.setMnemonic('W');
        helpMenu.add(playItem);
        helpMenu.addSeparator();
        JMenuItem discussItem = new JMenuItem(new AbstractAction("Discuss"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://groups.google.com/group/gosu-lang");
            }
        });
        discussItem.setMnemonic('D');
        helpMenu.add(discussItem);
        helpMenu.addSeparator();
        JMenuItem plugin = new JMenuItem(new AbstractAction("IntelliJ Plugin"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.openURL("http://gosu-lang.github.io/intellij.html");
            }
        });
        plugin.setMnemonic('I');
        helpMenu.add(plugin);
    }

    private void makeWindowMenu(JMenuBar menuBar) {
        SmartMenu windowMenu = new SmartMenu("Window");
        windowMenu.setMnemonic('W');
        menuBar.add(windowMenu);
        JMenuItem previousItem = new JMenuItem(new AbstractAction("Previous Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.goBackward();
            }
        });
        previousItem.setMnemonic('P');
        previousItem.setAccelerator(KeyStroke.getKeyStroke("alt LEFT"));
        windowMenu.add(previousItem);
        JMenuItem nextItem = new JMenuItem(new AbstractAction("Next Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.goForward();
            }
        });
        nextItem.setMnemonic('N');
        nextItem.setAccelerator(KeyStroke.getKeyStroke("alt RIGHT"));
        windowMenu.add(nextItem);
        windowMenu.addSeparator();
        JMenuItem recentItem = new JMenuItem(new AbstractAction("Recent Editors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.displayRecentViewsPopup();
            }
        });
        recentItem.setMnemonic('R');
        recentItem.setAccelerator(KeyStroke.getKeyStroke("control E"));
        windowMenu.add(recentItem);
        windowMenu.addSeparator();
        JMenuItem closeActiveItem = new JMenuItem(new AbstractAction("Close Active Editor"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.saveIfDirty();
                GosuPanel.this.closeActiveEditor();
            }
        });
        closeActiveItem.setMnemonic('C');
        closeActiveItem.setAccelerator(KeyStroke.getKeyStroke("control F4"));
        windowMenu.add(closeActiveItem);
        JMenuItem closeOthersItem = new JMenuItem(new AbstractAction("Close Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.closeOthers();
            }
        });
        closeOthersItem.setMnemonic('O');
        windowMenu.add(closeOthersItem);
    }

    private void makeCodeMenu(JMenuBar menuBar) {
        SmartMenu codeMenu = new SmartMenu("Code");
        codeMenu.setMnemonic('d');
        menuBar.add(codeMenu);
        codeMenu.add(CommonMenus.makeCodeComplete(this::getCurrentEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeParameterInfo(this::getCurrentEditor));
        codeMenu.add(CommonMenus.makeExpressionType(this::getCurrentEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeGotoDeclaration(this::getCurrentEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeShowFileInTree(this::getCurrentEditor));
        codeMenu.addSeparator();
        codeMenu.add(CommonMenus.makeQuickDocumentation(this::getCurrentEditor));
        codeMenu.addSeparator();
        JMenuItem openTypeItem = new JMenuItem(new AbstractAction("Open Type..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GotoTypePopup.display();
            }
        });
        openTypeItem.setMnemonic('O');
        openTypeItem.setAccelerator(KeyStroke.getKeyStroke("control N"));
        codeMenu.add(openTypeItem);
        if ("true".equals(System.getProperty("spec"))) {
            codeMenu.addSeparator();
            JMenuItem markItem = new JMenuItem(new AbstractAction("Mark Errors For Gosu Language Test"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GosuPanel.this.markErrorsForGosuLanguageTest();
                }
            });
            markItem.setMnemonic('M');
            markItem.setAccelerator(KeyStroke.getKeyStroke("control M"));
            codeMenu.add(markItem);
        }
        codeMenu.addSeparator();
        JMenuItem viewBytecodeItem = new JMenuItem(new AbstractAction("View Bytecode"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.dumpBytecode();
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getCurrentEditor() != null && GosuPanel.this.getCurrentEditor().getScriptPart() != null && GosuPanel.this.getCurrentEditor().getScriptPart().getContainingType() != null;
            }
        });
        codeMenu.add(viewBytecodeItem);
    }

    public GosuEditor getCurrentEditor() {
        ITab selectedTab = this._editorTabPane.getSelectedTab();
        return selectedTab == null ? null : (GosuEditor)selectedTab.getContentPane();
    }

    private void makeRunMenu(JMenuBar menuBar) {
        SmartMenu runMenu = new SmartMenu("Run");
        runMenu.setMnemonic('R');
        menuBar.add(runMenu);
        runMenu.add(CommonMenus.makeRun(() -> this.getCurrentEditor() == null ? null : (this.getCurrentEditor().getScriptPart() == null ? null : this.getCurrentEditor().getScriptPart().getContainingType())));
        JMenuItem runRecentItem = new JMenuItem(new RunRecentActionHandler());
        runRecentItem.setMnemonic('C');
        runRecentItem.setAccelerator(KeyStroke.getKeyStroke("F9"));
        runMenu.add(runRecentItem);
        runMenu.addSeparator();
        JMenuItem stopItem = new JMenuItem(new StopActionHandler());
        stopItem.setMnemonic('S');
        stopItem.setAccelerator(KeyStroke.getKeyStroke("control F2"));
        runMenu.add(stopItem);
        runMenu.addSeparator();
        runMenu.add(CommonMenus.makeClear(this::getCurrentEditor));
    }

    private void makeSearchMenu(JMenuBar menuBar) {
        SmartMenu searchMenu = new SmartMenu("Search");
        searchMenu.setMnemonic('S');
        menuBar.add(searchMenu);
        JMenuItem findItem = new JMenuItem(new AbstractAction("Find..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardLocalSearch.performLocalSearch(GosuPanel.this.getCurrentEditor(), false);
            }
        });
        findItem.setMnemonic('F');
        findItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        searchMenu.add(findItem);
        JMenuItem replaceItem = new JMenuItem(new AbstractAction("Replace..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                StandardLocalSearch.performLocalSearch(GosuPanel.this.getCurrentEditor(), true);
            }
        });
        replaceItem.setMnemonic('R');
        replaceItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        searchMenu.add(replaceItem);
        JMenuItem nextItem = new JMenuItem(new AbstractAction("Next"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StandardLocalSearch.canRepeatFind(GosuPanel.this.getCurrentEditor())) {
                    StandardLocalSearch.repeatFind(GosuPanel.this.getCurrentEditor());
                }
            }
        });
        nextItem.setMnemonic('N');
        nextItem.setAccelerator(KeyStroke.getKeyStroke("F3"));
        searchMenu.add(nextItem);
        JMenuItem previousItem = new JMenuItem(new AbstractAction("Previous"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StandardLocalSearch.canRepeatFind(GosuPanel.this.getCurrentEditor())) {
                    StandardLocalSearch.repeatFindBackwards(GosuPanel.this.getCurrentEditor());
                }
            }
        });
        previousItem.setMnemonic('P');
        previousItem.setAccelerator(KeyStroke.getKeyStroke("shift F3"));
        searchMenu.add(previousItem);
        searchMenu.addSeparator();
        JMenuItem gotoLineItem = new JMenuItem(new AbstractAction("Go To Line"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().displayGotoLinePopup();
            }
        });
        gotoLineItem.setMnemonic('G');
        gotoLineItem.setAccelerator(KeyStroke.getKeyStroke("control G"));
        searchMenu.add(gotoLineItem);
    }

    private void makeEditMenu(JMenuBar menuBar) {
        SmartMenu editMenu = new SmartMenu("Edit");
        editMenu.setMnemonic('E');
        menuBar.add(editMenu);
        JMenuItem undoItem = new JMenuItem(new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuPanel.this.getUndoManager().canUndo()) {
                    GosuPanel.this.getUndoManager().undo();
                }
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getUndoManager().canUndo();
            }
        });
        undoItem.setMnemonic('U');
        undoItem.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        editMenu.add(undoItem);
        JMenuItem redoItem = new JMenuItem(new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuPanel.this.getUndoManager().canRedo()) {
                    GosuPanel.this.getUndoManager().redo();
                }
            }

            @Override
            public boolean isEnabled() {
                return GosuPanel.this.getUndoManager().canRedo();
            }
        });
        redoItem.setMnemonic('R');
        redoItem.setAccelerator(KeyStroke.getKeyStroke("control shift Z"));
        editMenu.add(redoItem);
        editMenu.addSeparator();
        editMenu.add(CommonMenus.makeCut(this::getCurrentEditor));
        editMenu.add(CommonMenus.makeCopy(this::getCurrentEditor));
        editMenu.add(CommonMenus.makePaste(this::getCurrentEditor));
        editMenu.add(CommonMenus.makePasteJavaAsGosu(this::getCurrentEditor));
        editMenu.addSeparator();
        JMenuItem deleteItem = new JMenuItem(new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GosuPanel.this.getCurrentEditor() != null && StudioUtilities.containsFocus(GosuPanel.this.getCurrentEditor())) {
                    GosuPanel.this.getCurrentEditor().delete();
                }
            }
        });
        deleteItem.setMnemonic('D');
        deleteItem.setAccelerator(KeyStroke.getKeyStroke("DELETE"));
        editMenu.add(deleteItem);
        JMenuItem deletewordItem = new JMenuItem(new AbstractAction("Delete Word"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteWord();
            }
        });
        deletewordItem.setMnemonic('e');
        deletewordItem.setAccelerator(KeyStroke.getKeyStroke("control BACKSPACE"));
        editMenu.add(deletewordItem);
        JMenuItem deleteWordForwardItem = new JMenuItem(new AbstractAction("Delete Word Forward"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteWordForwards();
            }
        });
        deleteWordForwardItem.setMnemonic('F');
        deleteWordForwardItem.setAccelerator(KeyStroke.getKeyStroke("control DELETE"));
        editMenu.add(deleteWordForwardItem);
        JMenuItem deleteLine = new JMenuItem(new AbstractAction("Delete Line"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().deleteLine();
            }
        });
        deleteLine.setMnemonic('L');
        deleteLine.setAccelerator(KeyStroke.getKeyStroke("control Y"));
        editMenu.add(deleteLine);
        editMenu.addSeparator();
        JMenuItem selectWord = new JMenuItem(new AbstractAction("Select Word"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().selectWord();
            }
        });
        selectWord.setMnemonic('W');
        selectWord.setAccelerator(KeyStroke.getKeyStroke("control W"));
        editMenu.add(selectWord);
        JMenuItem narraowSelection = new JMenuItem(new AbstractAction("Narrow Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().narrowSelectWord();
            }
        });
        narraowSelection.setMnemonic('N');
        narraowSelection.setAccelerator(KeyStroke.getKeyStroke("control shift W"));
        editMenu.add(narraowSelection);
        editMenu.addSeparator();
        JMenuItem duplicateItem = new JMenuItem(new AbstractAction("Duplicate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().duplicate();
            }
        });
        duplicateItem.setAccelerator(KeyStroke.getKeyStroke("control D"));
        editMenu.add(duplicateItem);
        JMenuItem joinItem = new JMenuItem(new AbstractAction("Join Lines"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.getCurrentEditor().joinLines();
            }
        });
        joinItem.setAccelerator(KeyStroke.getKeyStroke("control J"));
        editMenu.add(joinItem);
        JMenuItem indentItem = new JMenuItem(new AbstractAction("Indent Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuPanel.this.getCurrentEditor().isIntellisensePopupShowing()) {
                    GosuPanel.this.getCurrentEditor().handleBulkIndent(false);
                }
            }
        });
        indentItem.setMnemonic('I');
        indentItem.setAccelerator(KeyStroke.getKeyStroke("TAB"));
        editMenu.add(indentItem);
        JMenuItem outdentItem = new JMenuItem(new AbstractAction("Outdent Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GosuPanel.this.getCurrentEditor().isIntellisensePopupShowing()) {
                    GosuPanel.this.getCurrentEditor().handleBulkIndent(true);
                }
            }
        });
        outdentItem.setMnemonic('O');
        outdentItem.setAccelerator(KeyStroke.getKeyStroke("shift TAB"));
        editMenu.add(outdentItem);
    }

    private void makeFileMenu(JMenuBar menuBar) {
        SmartMenu fileMenu = new SmartMenu("File");
        fileMenu.setMnemonic('F');
        menuBar.add(fileMenu);
        JMenuItem newExperimentItem = new JMenuItem(new AbstractAction("New Experiment..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.newExperiment();
            }
        });
        newExperimentItem.setMnemonic('P');
        fileMenu.add(newExperimentItem);
        JMenuItem openExperimentItem = new JMenuItem(new AbstractAction("Open Experiment..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.openExperiment();
            }
        });
        openExperimentItem.setMnemonic('J');
        fileMenu.add(openExperimentItem);
        fileMenu.addSeparator();
        JMenu newItem = new JMenu("New");
        NewFilePopup.addMenuItems(newItem);
        fileMenu.add(newItem);
        JMenuItem openItem = new JMenuItem(new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.openFile();
            }
        });
        openItem.setMnemonic('O');
        fileMenu.add(openItem);
        JMenuItem saveItem = new JMenuItem(new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.save();
            }
        });
        saveItem.setMnemonic('S');
        saveItem.setAccelerator(KeyStroke.getKeyStroke("control S"));
        fileMenu.add(saveItem);
        fileMenu.addSeparator();
        JMenuItem classpathItem = new JMenuItem(new AbstractAction("Classpath..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.displayClasspath();
            }
        });
        classpathItem.setMnemonic('h');
        fileMenu.add(classpathItem);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GosuPanel.this.exit();
            }
        });
        exitItem.setMnemonic('x');
        fileMenu.add(exitItem);
    }

    private void closeActiveEditor() {
        if (this._editorTabPane.getTabCount() > 1) {
            this._editorTabPane.removeTab(this._editorTabPane.getSelectedTab());
        } else {
            this.exit();
        }
    }

    private void closeOthers() {
        this._editorTabPane.setVisible(false);
        try {
            for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
                if (this._editorTabPane.getSelectedTabIndex() == i) continue;
                this._editorTabPane.removeTab(this._editorTabPane.getTabAt(i));
            }
        }
        finally {
            this._editorTabPane.setVisible(true);
        }
    }

    private void displayClasspath() {
        ClasspathDialog dlg = new ClasspathDialog(new File("."));
        dlg.setVisible(true);
    }

    public void exit() {
        if (this.saveIfDirty()) {
            System.exit(0);
        }
    }

    public void setEditorSplitPosition(int iPos) {
        if (this._splitPane != null) {
            this._splitPane.setPosition(iPos);
        }
    }

    public void setExperimentSplitPosition(int iPos) {
        if (this._outerSplitPane != null) {
            this._outerSplitPane.setPosition(iPos);
        }
    }

    public GosuEditor getGosuEditor() {
        return this.getCurrentEditor();
    }

    private void mapKeystrokes() {
        this.mapKeystroke(KeyStroke.getKeyStroke(90, 2), "Undo", new UndoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(90, 3), "Redo", new RedoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(8, 8), "UndoOldStyle", new UndoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(8, 9), "RetoOldStyle", new RedoActionHandler());
        this.mapKeystroke(KeyStroke.getKeyStroke(116, 0), "Run", new CommonMenus.ClearAndRunActionHandler("Run", () -> this.getCurrentEditor().getScriptPart().getContainingType()));
        this.mapKeystroke(KeyStroke.getKeyStroke(10, 2), "Run", new CommonMenus.ClearAndRunActionHandler("Run", () -> this.getCurrentEditor().getScriptPart().getContainingType()));
    }

    private void mapKeystroke(KeyStroke ks, String strCmd, Action action) {
        this.enableInputMethods(true);
        this.enableEvents(8L);
        InputMap imap = this.getInputMap(1);
        Object key = imap.get(ks);
        if (key == null) {
            key = strCmd;
            imap.put(ks, key);
        }
        this.getActionMap().put(key, action);
    }

    void resetChangeHandler() {
        ScriptChangeHandler handler = new ScriptChangeHandler(this.getUndoManager());
        handler.establishUndoableEditListener(this.getCurrentEditor());
    }

    public void openFile() {
        JFileChooser fc = new JFileChooser(this.getCurrentFile().getParentFile());
        fc.setDialogTitle("Open Gosu File");
        fc.setDialogType(0);
        fc.setCurrentDirectory(this.getCurrentFile().getParentFile());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f);
            }

            @Override
            public String getDescription() {
                return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            this.openFile(fc.getSelectedFile());
        }
    }

    public void openFile(File file) {
        this.openFile(GosuPanel.makePartId(file), file);
    }

    public static IScriptPartId makePartId(File file) {
        TypeSystem.pushGlobalModule();
        try {
            if (file == null) {
                ScriptPartId scriptPartId = new ScriptPartId("New Program", null);
                return scriptPartId;
            }
            if (file.getName().endsWith(".gs") || file.getName().endsWith(".gsx") || file.getName().endsWith(".gsp") || file.getName().endsWith(".gst")) {
                String classNameForFile = TypeNameUtil.getClassNameForFile(file);
                ScriptPartId scriptPartId = new ScriptPartId(classNameForFile, null);
                return scriptPartId;
            }
            ScriptPartId scriptPartId = new ScriptPartId("Unknown Resource Type", null);
            return scriptPartId;
        }
        finally {
            TypeSystem.popGlobalModule();
        }
    }

    public void openInitialFile(IScriptPartId partId, File file) {
        this._initialFile = true;
        try {
            if (file != null || this._editorTabPane.getTabCount() == 0) {
                this.openFile(partId, file);
            }
        }
        finally {
            this._initialFile = false;
        }
    }

    private void openFile(IScriptPartId partId, File file) {
        String strSource;
        if (this.openTab(file)) {
            return;
        }
        GosuEditor editor = this.createEditor();
        if (partId == null) {
            throw new IllegalArgumentException("partId should be non-null");
        }
        this.initEditorMode(file, editor);
        file = file == null ? this.getExperiment().getOrMakeUntitledProgram() : file;
        editor.putClientProperty("_file", file);
        this.removeLruTab();
        String classNameForFile = TypeNameUtil.getClassNameForFile(file);
        IType type = TypeSystem.getByFullNameIfValid((String)classNameForFile);
        if (type == null) {
            return;
        }
        this._editorTabPane.addTab(type.getRelativeName(), EditorUtilities.findIcon(type), editor);
        this._editorTabPane.selectTab(this._editorTabPane.findTabWithContent(editor), true);
        if (!file.exists()) {
            strSource = "";
        } else {
            try (FileInputStream in = new FileInputStream(file);){
                strSource = StreamUtil.getContent((Reader)StreamUtil.getInputStreamReader((InputStream)in));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this._parentFrame != null) {
            this.updateTitle();
        }
        try {
            editor.read(partId, strSource, "");
            this.resetChangeHandler();
            EventQueue.invokeLater(() -> editor.getEditor().requestFocus());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void removeLruTab() {
        if (this._editorTabPane.getTabCount() < 12) {
            return;
        }
        List<ITabHistoryContext> mruList = this.getTabSelectionHistory().getTabMruList();
        for (int i = mruList.size() - 1; i >= 0; --i) {
            ITabHistoryContext tabCtx = mruList.get(i);
            File file = (File)tabCtx.getContentId();
            GosuEditor editor = this.findTab(file);
            if (editor == null) continue;
            this.closeTab(file);
        }
    }

    private void updateTitle() {
        File file = this.getCurrentFile();
        Experiment experiment = this.getExperiment();
        String currentFilePath = file == null ? "  " : " - ..." + File.separator + experiment.makeExperimentRelativePath(file) + " - ";
        String title = experiment.getName() + " - [" + experiment.getExperimentDir().getAbsolutePath() + "]" + currentFilePath + "Gosu Lab " + Gosu.getVersion();
        this._parentFrame.setTitle(title);
    }

    private boolean openTab(File file) {
        GosuEditor editor = this.findTab(file);
        if (editor != null) {
            this._editorTabPane.selectTab(this._editorTabPane.findTabWithContent(editor), true);
            return true;
        }
        return false;
    }

    public GosuEditor findTab(File file) {
        if (file == null) {
            return null;
        }
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            GosuEditor editor = (GosuEditor)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !file.equals(editor.getClientProperty("_file"))) continue;
            return editor;
        }
        return null;
    }

    private void setCurrentFile(File file) {
        this.getCurrentEditor().putClientProperty("_file", file);
        this.openFile(file);
    }

    public File getCurrentFile() {
        GosuEditor currentEditor = this.getCurrentEditor();
        return currentEditor == null ? null : (File)currentEditor.getClientProperty("_file");
    }

    public boolean save() {
        if (this.getCurrentFile() == null) {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Save Gosu File");
            fc.setDialogType(1);
            fc.setCurrentDirectory(new File("."));
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f);
                }

                @Override
                public String getDescription() {
                    return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
                }
            });
            int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
            if (returnVal == 0) {
                this.setCurrentFile(fc.getSelectedFile());
            } else {
                return false;
            }
        }
        if (!this.getCurrentFile().exists()) {
            boolean created = false;
            String msg = "";
            try {
                created = this.getCurrentFile().createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = msg + " : " + e.getMessage();
            }
            if (!created) {
                JOptionPane.showMessageDialog(this, "Could not create file " + this.getCurrentFile().getName() + msg);
                return false;
            }
        }
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        return true;
    }

    public boolean save(File file, GosuEditor editor) {
        if (!file.exists()) {
            boolean created = false;
            String msg = "";
            try {
                created = file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                msg = msg + " : " + e.getMessage();
            }
            if (!created) {
                JOptionPane.showMessageDialog(this, "Could not create file " + file.getName() + msg);
                return false;
            }
        }
        this.saveAndReloadType(file, editor);
        return true;
    }

    private void saveAndReloadType(File file, GosuEditor editor) {
        try (FileOutputStream out = new FileOutputStream(file);){
            StreamUtil.copy((Reader)new StringReader(editor.getText()), (OutputStream)out);
            this.setDirty(editor, false);
            this.reload(editor.getScriptPart().getContainingType());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void reload(IType type) {
        if (type == null) {
            return;
        }
        TypeSystem.refresh((ITypeRef)((ITypeRef)type));
    }

    public boolean saveIfDirty() {
        if (this.isDirty(this.getCurrentEditor())) {
            return this.save();
        }
        return true;
    }

    public void newExperiment() {
        File untitled = new File(this.getExperiment().getExperimentDir().getParentFile(), "Untitled");
        untitled.mkdirs();
        JFileChooser fc = new JFileChooser(untitled);
        fc.setDialogTitle("New Experiment");
        fc.setDialogType(0);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !new File(f, f.getName() + ".prj").exists();
            }

            @Override
            public String getDescription() {
                return "Gosu Experiment Directory (directory name is your experiment name)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal != 0) {
            return;
        }
        File selectedFile = fc.getSelectedFile();
        Experiment experiment = new Experiment(selectedFile.getName(), selectedFile, this);
        this.clearTabs();
        EventQueue.invokeLater(() -> this.restoreExperimentState(experiment));
    }

    public void openExperiment() {
        File prjFile;
        FileDialog fc = new FileDialog(EditorUtilities.frameForComponent(this), "Open Experiment", 0);
        fc.setDirectory(this.getExperiment().getExperimentDir().getAbsolutePath());
        fc.setMultipleMode(false);
        fc.setFile("*.prj");
        fc.setVisible(true);
        String selectedFile = fc.getFile();
        if (selectedFile != null && (prjFile = new File(fc.getDirectory(), selectedFile)).isFile()) {
            File experimentDir = prjFile.getParentFile();
            this.openExperiment(experimentDir);
        }
    }

    public void openExperiment(File experimentDir) {
        this.storeExperimentState();
        this.clearTabs();
        EventQueue.invokeLater(() -> this.restoreExperimentState(new Experiment(experimentDir, this)));
    }

    private boolean isValidGosuSourceFile(File file) {
        if (file == null) {
            return false;
        }
        String strName = file.getName().toLowerCase();
        return strName.endsWith(".gs") || strName.endsWith(".gsx") || strName.endsWith(".gst") || strName.endsWith(".gsp");
    }

    public void saveAs() {
        JFileChooser fc = new JFileChooser(this.getCurrentFile());
        fc.setDialogTitle("Save Gosu File");
        fc.setDialogType(1);
        fc.setCurrentDirectory(this.getCurrentFile() != null ? this.getCurrentFile().getParentFile() : new File("."));
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || GosuPanel.this.isValidGosuSourceFile(f);
            }

            @Override
            public String getDescription() {
                return "Gosu source file (*.gsp; *.gs; *.gsx; *.gst)";
            }
        });
        int returnVal = fc.showOpenDialog(EditorUtilities.frameForComponent(this));
        if (returnVal == 0) {
            this.setCurrentFile(fc.getSelectedFile());
            this.save();
        }
    }

    public void dumpBytecode() {
        this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
        this.clearOutput();
        byte[] bytes = TypeSystem.getGosuClassLoader().getBytes((ICompilableType)this.getClassAtCaret());
        ClassReader cr = new ClassReader(bytes);
        int flags = 0;
        StringWriter out = new StringWriter();
        cr.accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new GosuTextifier(), new PrintWriter(out)), flags);
        this._resultPanel.setText(out.toString());
    }

    private IGosuClass getClassAtCaret() {
        IParsedElement elemAtCaret;
        IParseTree locAtCaret = this.getCurrentEditor().getDeepestLocationAtCaret();
        if (locAtCaret == null) {
            return this.getCurrentEditor().getParsedClass();
        }
        for (elemAtCaret = locAtCaret.getParsedElement(); elemAtCaret != null && !(elemAtCaret instanceof IClassStatement) && !(elemAtCaret instanceof IBlockExpression); elemAtCaret = elemAtCaret.getParent()) {
        }
        if (elemAtCaret == null) {
            return this.getCurrentEditor().getParsedClass();
        }
        if (elemAtCaret instanceof IClassStatement) {
            return elemAtCaret.getGosuClass();
        }
        if (elemAtCaret instanceof IBlockExpression) {
            return ((IBlockExpression)elemAtCaret).getBlockGosuClass();
        }
        throw new IllegalStateException("Unexpected parse element: " + elemAtCaret.getClass().getName());
    }

    public void execute(String typeName) {
        try {
            if (this._bRunning) {
                return;
            }
            this.saveAndReloadType(this.getCurrentFile(), this.getCurrentEditor());
            ClassLoader loader = this.getClass().getClassLoader();
            URLClassLoader runLoader = new URLClassLoader(this.getAllUrlsAboveGosuclassProtocol((URLClassLoader)loader), loader.getParent());
            TaskQueue queue = TaskQueue.getInstance("_execute_gosu");
            this.addBusySignal();
            queue.postTask(() -> {
                GosuEditor.getParserTaskQueue().waitUntilAllCurrentTasksFinish();
                IGosuClass program = (IGosuClass)TypeSystem.getByFullName((String)typeName);
                try {
                    String programResults;
                    Class<?> runnerClass = Class.forName("editor.GosuPanel$Runner", true, runLoader);
                    String fqn = program.getName();
                    System.out.println("Running: " + fqn + "...\n");
                    this.getExperiment().setRecentProgram(fqn);
                    String result = null;
                    try {
                        programResults = result = (String)runnerClass.getMethod("run", String.class, List.class).invoke(null, fqn, this.getExperiment().getSourcePath().stream().map(File::new).collect(Collectors.toList()));
                    }
                    catch (Throwable throwable) {
                        String programResults2 = result;
                        EventQueue.invokeLater(() -> {
                            this.removeBusySignal();
                            if (programResults2 != null) {
                                System.out.print(programResults2);
                            }
                        });
                        GosuClassPathThing.addOurProtocolHandler();
                        throw throwable;
                    }
                    EventQueue.invokeLater(() -> {
                        this.removeBusySignal();
                        if (programResults2 != null) {
                            System.out.print(programResults2);
                        }
                    });
                    GosuClassPathThing.addOurProtocolHandler();
                }
                catch (Exception e) {
                    Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
                    throw GosuExceptionUtil.forceThrow((Throwable)cause);
                }
            });
        }
        catch (Throwable t) {
            EditorUtilities.handleUncaughtException(t);
        }
    }

    private URL[] getAllUrlsAboveGosuclassProtocol(URLClassLoader loader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        boolean bAdd = true;
        for (URL url : loader.getURLs()) {
            if (bAdd && !url.getProtocol().contains("gosu")) {
                urls.add(url);
                continue;
            }
            bAdd = false;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public boolean isRunning() {
        return this._bRunning;
    }

    public TypeNameCache getTypeNamesCache() {
        return this._typeNamesCache;
    }

    private void addBusySignal() {
        this._bRunning = true;
        Timer t = new Timer(2000, e -> {
            if (this._bRunning) {
                this._status.setIcon(EditorUtilities.loadIcon("images/status_anim.gif"));
                this._status.setText("<html>Running <i>" + this.getCurrentFile().getName() + "</i></html>");
                this._statPanel.setVisible(true);
                this._statPanel.revalidate();
            }
        });
        t.setRepeats(false);
        t.start();
    }

    private void removeBusySignal() {
        if (this._bRunning) {
            this._bRunning = false;
            this._statPanel.setVisible(false);
            this._statPanel.revalidate();
        }
    }

    void executeTemplate() {
        try {
            System.out.println("Will prompt for args soon, for now run the template programmatically from a program");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void clearOutput() {
        this._resultPanel.clear();
    }

    public AtomicUndoManager getUndoManager() {
        return this.getCurrentEditor() != null ? this.getCurrentEditor().getUndoManager() : this._defaultUndoMgr;
    }

    public void selectTab(File file) {
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            GosuEditor editor = (GosuEditor)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !editor.getClientProperty("_file").equals(file)) continue;
            this._editorTabPane.selectTab(this._editorTabPane.getTabAt(i), true);
            return;
        }
        this.openFile(file);
    }

    public void closeTab(File file) {
        for (int i = 0; i < this._editorTabPane.getTabCount(); ++i) {
            GosuEditor editor = (GosuEditor)this._editorTabPane.getTabAt(i).getContentPane();
            if (editor == null || !editor.getClientProperty("_file").equals(file)) continue;
            this._editorTabPane.removeTab(this._editorTabPane.getTabAt(i));
            return;
        }
    }

    public void goBackward() {
        this.getTabSelectionHistory().goBackward();
    }

    public boolean canGoBackward() {
        return this.getTabSelectionHistory().canGoBackward();
    }

    public void goForward() {
        this.getTabSelectionHistory().goForward();
    }

    public boolean canGoForward() {
        return this.getTabSelectionHistory().canGoForward();
    }

    public void displayRecentViewsPopup() {
        ArrayList<ITabHistoryContext> mruViewsList = new ArrayList<ITabHistoryContext>(this.getTabSelectionHistory().getTabMruList());
        for (int i = 0; i < mruViewsList.size(); ++i) {
            ITabHistoryContext ctx = (ITabHistoryContext)mruViewsList.get(i);
            if (ctx == null || !ctx.represents(this.getCurrentEditor())) continue;
            mruViewsList.remove(ctx);
        }
        LabelListPopup popup = new LabelListPopup("Recent Views", mruViewsList, "No recent views");
        popup.addNodeChangeListener(e -> {
            ITabHistoryContext context = (ITabHistoryContext)e.getSource();
            this.getTabSelectionHistory().getTabHistoryHandler().selectTab(context);
        });
        popup.show(this, this.getWidth() / 2 - 100, this.getHeight() / 2 - 200);
    }

    public boolean isDirty(GosuEditor editor) {
        if (editor == null) {
            return false;
        }
        Boolean bDirty = (Boolean)editor.getClientProperty("_bDirty");
        return bDirty == null ? false : bDirty;
    }

    public void setDirty(GosuEditor editor, boolean bDirty) {
        editor.putClientProperty("_bDirty", bDirty);
    }

    public Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    private void markErrorsForGosuLanguageTest() {
        GosuDocument document = this.getCurrentEditor().getGosuDocument();
        ParseResultsException pre = document.getParseResultsException();
        if (pre == null || !pre.hasParseExceptions() && !pre.hasParseWarnings()) {
            return;
        }
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        for (IParseIssue pi : pre.getParseIssues()) {
            ResourceKey messageKey = pi.getMessageKey();
            if (messageKey == null) continue;
            String issue = messageKey.getKey();
            int iLine = pi.getLine();
            ArrayList<String> issues = (ArrayList<String>)map.get(iLine);
            if (issues == null) {
                issues = new ArrayList<String>();
                map.put(iLine, issues);
            }
            issues.add(issue);
        }
        ArrayList<Integer> lines = new ArrayList<Integer>(map.keySet());
        Collections.sort(lines);
        try {
            String text = document.getText(0, document.getLength());
            String[] strLines = text.split("\n");
            this.removeOldIssueKeyMarkers(strLines);
            this.addIssueKeyMarkers(strLines, lines, map);
            CompoundEdit atom = this.getUndoManager().beginUndoAtom("Mark Phase");
            document.replace(0, text.length(), this.joinLines(strLines), null);
            this.getUndoManager().endUndoAtom(atom);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String joinLines(String[] strLines) {
        StringBuilder sb = new StringBuilder();
        for (String line : strLines) {
            sb.append(line).append('\n');
        }
        return sb.toString();
    }

    private void removeOldIssueKeyMarkers(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            int issueIndex = lines[i].indexOf("  //## issuekeys:");
            if (issueIndex == -1) continue;
            lines[i] = lines[i].substring(0, issueIndex);
        }
    }

    private void addIssueKeyMarkers(String[] strLines, List<Integer> lines, Map<Integer, List<String>> map) {
        for (int iLine : lines) {
            String issues = this.makeIssueString(map.get(iLine));
            strLines[iLine - 1] = strLines[iLine - 1].concat(issues);
        }
    }

    private String makeIssueString(List<String> issues) {
        StringBuilder sb = new StringBuilder();
        for (String issue : issues) {
            sb.append(sb.length() != 0 ? ", " : "").append(issue);
        }
        sb.insert(0, "  //## issuekeys: ");
        return sb.toString();
    }

    class StopActionHandler
    extends AbstractAction {
        public StopActionHandler() {
            super("Stop");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                TaskQueue queue = TaskQueue.getInstance("_execute_gosu");
                TaskQueue.emptyAndRemoveQueue("_execute_gosu");
                queue.stop();
                GosuPanel.this.removeBusySignal();
            }
        }
    }

    class RunRecentActionHandler
    extends CommonMenus.ClearAndRunActionHandler {
        public RunRecentActionHandler() {
            super("Run Recent", new Supplier<IType>(){

                @Override
                public IType get() {
                    String recentProgram;
                    String string = recentProgram = GosuPanel.this.getExperiment() == null ? null : GosuPanel.this.getExperiment().getRecentProgram();
                    if (recentProgram != null) {
                        return TypeSystem.getByFullNameIfValid((String)recentProgram);
                    }
                    return null;
                }
            });
        }
    }

    class RedoActionHandler
    extends AbstractAction {
        RedoActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                GosuPanel.this.getUndoManager().redo();
            }
        }

        @Override
        public boolean isEnabled() {
            return GosuPanel.this.getUndoManager().canRedo();
        }
    }

    class UndoActionHandler
    extends AbstractAction {
        UndoActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                GosuPanel.this.getUndoManager().undo();
            }
        }

        @Override
        public boolean isEnabled() {
            return GosuPanel.this.getUndoManager().canUndo();
        }
    }

    public static class Runner {
        public static String run(String typeName, List<File> classpath) throws Exception {
            Gosu.init(classpath);
            GosuClassPathThing.addOurProtocolHandler();
            GosuClassPathThing.init();
            IGosuClass gsType = (IGosuClass)TypeSystem.getByFullNameIfValid((String)typeName);
            if (gsType instanceof IGosuProgram) {
                Object result = ((IGosuProgram)gsType).evaluate(null);
                return (String)CommonServices.getCoercionManager().convertValue(result, (IType)JavaTypes.STRING());
            }
            IMethodInfo mainMethod = Runner.hasStaticMain(gsType);
            if (mainMethod != null) {
                ReflectUtil.invokeStaticMethod((String)gsType.getName(), (String)"main", (Object[])new Object[]{new String[0]});
                return null;
            }
            Runner.runTest(gsType);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runTest(IGosuClass gsType) throws Exception {
            Class cls = gsType.getBackingClass();
            Object instance = cls.newInstance();
            Runner.runNamedOrAnnotatedMethod(instance, "beforeClass", "org.junit.BeforeClass");
            for (Method m : cls.getMethods()) {
                if (!Runner.isTestMethod(m)) continue;
                Runner.runNamedOrAnnotatedMethod(instance, "beforeMethod", "org.junit.Before");
                try {
                    System.out.println(" - " + m.getName());
                    m.invoke(instance, new Object[0]);
                    System.out.println("   SUCCESS");
                }
                catch (InvocationTargetException e) {
                    Throwable cause = GosuExceptionUtil.findExceptionCause((Throwable)e);
                    if (cause instanceof AssertionError) {
                        System.out.println("   FAILED: " + cause.getClass().getSimpleName() + " : " + cause.getMessage());
                        continue;
                    }
                    throw GosuExceptionUtil.forceThrow((Throwable)cause);
                }
                finally {
                    Runner.runNamedOrAnnotatedMethod(instance, "afterMethod", "org.junit.After");
                }
            }
            Runner.runNamedOrAnnotatedMethod(instance, "afterClass", "org.junit.AfterClass");
        }

        private static boolean isTestMethod(Method m) throws Exception {
            int modifiers = m.getModifiers();
            return Modifier.isPublic((int)modifiers) && (m.getName().startsWith("test") || Runner.hasAnnotation(m, "org.junit.Test")) && m.getParameters().length == 0;
        }

        private static void runNamedOrAnnotatedMethod(Object instance, String methodName, String annoName) throws Exception {
            for (Method m : instance.getClass().getMethods()) {
                if (m.getName().equals(methodName)) {
                    m.invoke(instance, new Object[0]);
                    return;
                }
                for (Annotation anno : m.getAnnotations()) {
                    if (!anno.annotationType().getName().equals(annoName)) continue;
                    m.invoke(instance, new Object[0]);
                    return;
                }
            }
        }

        private static boolean hasAnnotation(Method m, String name) throws Exception {
            for (Annotation anno : m.getAnnotations()) {
                if (!anno.annotationType().getName().equals(name)) continue;
                return true;
            }
            return false;
        }

        private static IMethodInfo hasStaticMain(IGosuClass gsType) {
            IMethodInfo main = gsType.getTypeInfo().getMethod((CharSequence)"main", new IType[]{JavaTypes.STRING().getArrayType()});
            if (main != null && main.isStatic() && main.getReturnType() == JavaTypes.pVOID()) {
                return main;
            }
            return null;
        }
    }
}

