/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractGotoPopup;
import editor.RunMe;
import editor.TypeCellRenderer;
import editor.search.StudioUtilities;
import editor.util.Experiment;
import gw.fs.IFile;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JRootPane;

public class GotoTypePopup
extends AbstractGotoPopup<String> {
    private static final int DEFAULT_WAIT_TIME = 0;
    private static final int ROW_COUNT = 10;

    public static void display() {
        GotoTypePopup valuePopup = new GotoTypePopup("");
        valuePopup.addNodeChangeListener(e -> {
            String strQualifedType = (String)e.getSource();
            GotoTypePopup.doGoTo(strQualifedType);
        });
        JRootPane host = RunMe.getEditorFrame().getRootPane();
        valuePopup.show(host, 0, 0);
    }

    public static void doGoTo(String strQualifedType) {
        StudioUtilities.showWaitCursor(true);
        try {
            IFile sourceFile;
            IType type = TypeSystem.getByFullNameIfValid((String)strQualifedType);
            if (type == null) {
                return;
            }
            IFile[] sourceFiles = type.getSourceFiles();
            if (sourceFiles != null && sourceFiles.length > 0 && (sourceFile = sourceFiles[0]).isJavaFile()) {
                RunMe.getEditorFrame().openFile(sourceFile.toJavaFile());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            StudioUtilities.showWaitCursor(false);
        }
    }

    public GotoTypePopup(String strPrefix) {
        super(0, 10, "Enter type name", strPrefix, true, true);
    }

    @Override
    protected List<String> initializeData() {
        List<String> allTypes = new ArrayList<String>(RunMe.getEditorFrame().getGosuPanel().getTypeNamesCache().getAllTypeNames(null));
        Experiment experiment = RunMe.getEditorFrame().getGosuPanel().getExperimentView().getExperiment();
        allTypes = this.filterGosuClassFromExperimentsInResources(allTypes, experiment);
        Collections.sort(allTypes, (o1, o2) -> GotoTypePopup.getRelativeTypeName(o1).compareToIgnoreCase(GotoTypePopup.getRelativeTypeName(o2)));
        return allTypes;
    }

    private List<String> filterGosuClassFromExperimentsInResources(List<String> allGosuTypes, Experiment experiment) {
        String experimentPath = experiment.getExperimentDir().getAbsolutePath();
        List relativeSrcPaths = experiment.getSourcePath().stream().map(srcPath -> (srcPath.startsWith(experimentPath) ? srcPath.substring(experimentPath.length() + 1) : srcPath).replace(File.separatorChar, '.')).collect(Collectors.toList());
        return allGosuTypes.stream().filter(s -> !relativeSrcPaths.stream().anyMatch(s::contains)).filter(s -> !s.startsWith("gw.internal")).collect(Collectors.toList());
    }

    @Override
    protected AbstractGotoPopup.AbstractPopupListModel<String> reconstructModel(String strPrefix) {
        return new TypeModel(StudioUtilities.filterStrings(this.getInitializedAllData(), strPrefix));
    }

    private static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    @Override
    protected TypeCellRenderer constructCellRenderer() {
        return new TypeCellRenderer();
    }

    @Override
    protected void handleEdit() {
        this.filterDisplay(this.escape(this._nameField.getText()), true);
    }

    private String escape(String text) {
        text = text.replace('.', '~');
        return text;
    }

    private static class TypeModel
    extends AbstractGotoPopup.AbstractPopupListModel<String> {
        private List<String> _allTypes;

        public TypeModel(List<String> allTypes) {
            this._allTypes = allTypes;
        }

        @Override
        public int getSize() {
            return this._allTypes.size();
        }

        @Override
        public String getElementAt(int i) {
            return this._allTypes.get(i);
        }
    }
}

