/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.AbstractParseExceptionResolver;
import editor.StringPopup;
import editor.util.TextComponentUtil;
import gw.config.CommonServices;
import gw.lang.parser.IParseTree;
import gw.lang.parser.IParsedElement;
import gw.lang.parser.exceptions.ParseException;
import gw.lang.parser.expressions.ILiteralExpression;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.java.JavaTypes;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StringValueCompletion
extends AbstractParseExceptionResolver {
    @Override
    public boolean canResolve(ParseException pe) {
        if (!super.canResolve(pe)) {
            return false;
        }
        IType typeExpected = this.getExpectedType(pe);
        return typeExpected == JavaTypes.STRING();
    }

    @Override
    public void resolve(ParseException pe) {
        StringPopup popup = new StringPopup("Text", JavaTypes.STRING().getRelativeName(), this.getGosuEditor().getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String s = "\"" + e.getSource().toString() + "\"";
                if (AbstractParseExceptionResolver.isEditorAtPossibleArgPosition(StringValueCompletion.this.getDeepestLocationToComplete().getParsedElement(), StringValueCompletion.this.getEditor())) {
                    StringValueCompletion.this.insertTextAtCaret(s);
                } else {
                    TextComponentUtil.replaceWordAtCaretDynamic(StringValueCompletion.this.getEditor(), s, StringValueCompletion.this.getGosuEditor().getReplaceWordCallback(), false);
                }
                StringValueCompletion.this.getEditor().requestFocus();
                StringValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                StringValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, false);
    }

    @Override
    public boolean handleCompleteValue() {
        IType typeExpected = this.getTypeExpected();
        if (typeExpected != JavaTypes.STRING()) {
            return false;
        }
        final IParseTree currentLocation = this.getDeepestLocationToComplete();
        String strValue = null;
        IParsedElement element = currentLocation.getParsedElement();
        if (element instanceof ILiteralExpression) {
            strValue = (String)CommonServices.getCoercionManager().convertValue(((ILiteralExpression)element).evaluate(), TypeSystem.get(String.class));
        }
        if (strValue == null) {
            strValue = "Text";
        }
        StringPopup popup = new StringPopup(strValue, JavaTypes.STRING().getRelativeName(), this.getGosuEditor().getEditor());
        popup.addNodeChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                StringValueCompletion.this.getGosuEditor().replaceLocation(currentLocation, "\"" + e.getSource().toString() + "\"");
                StringValueCompletion.this.getEditor().requestFocus();
                StringValueCompletion.this.getGosuEditor().fixSwingFocusBugWhenPopupCloses();
                StringValueCompletion.this.getEditor().repaint();
            }
        });
        this.showValueCompletionPopup(popup, true);
        return true;
    }
}

