/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.BatchDocument;
import editor.EditorScrollPane;
import editor.GosuEditorPane;
import editor.RunMe;
import editor.ScrollableEditorRootPane;
import editor.SourceFileAttribute;
import editor.TextComponentWriter;
import editor.util.SettleModalEventQueue;
import gw.fs.IFile;
import gw.lang.reflect.IType;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;

public class SystemPanel
extends JPanel {
    private JTextPane _outputPanel;
    private EditorScrollPane _scroller;
    private PrintStream _out;
    private PrintStream _err;
    private PrintStream _sysOut;
    private PrintStream _sysErr;

    public SystemPanel() {
        BatchDocument document = new BatchDocument();
        this._outputPanel = new JTextPane(document);
        this._out = new TextComponentWriter(Color.WHITE, document, System.out);
        this._err = new TextComponentWriter(Color.PINK, document, System.err);
        this.configureUI();
    }

    public void configureUI() {
        this.setLayout(new BorderLayout());
        this._outputPanel.setFont(new Font("monospaced", 1, 12));
        this._outputPanel.setBorder(new EmptyBorder(3, 3, 0, 0));
        this._outputPanel.setMargin(new Insets(10, 10, 10, 10));
        this._outputPanel.setForeground(Color.white);
        this._outputPanel.setBackground(Color.black);
        this._outputPanel.setEditable(false);
        ScrollableEditorRootPane editorRootScroller = new ScrollableEditorRootPane(this._outputPanel);
        editorRootScroller.setContentPane(this._outputPanel);
        editorRootScroller.setBorder(null);
        this._scroller = new EditorScrollPane(null, this._outputPanel, editorRootScroller);
        this._scroller.setBorder(null);
        JViewport vp = this._scroller.getViewport();
        vp.setScrollMode(1);
        this.add((Component)this._scroller, "Center");
        JLabel label = new JLabel("");
        label.setFont(label.getFont().deriveFont(1));
        label.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.add((Component)label, "North");
        MouseHandler ml = new MouseHandler();
        this._outputPanel.addMouseMotionListener(ml);
        this._outputPanel.addMouseListener(ml);
        this._outputPanel.addMouseWheelListener(ml);
    }

    public JTextPane getOutputPanel() {
        return this._outputPanel;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._sysOut = System.out;
        this._sysErr = System.err;
        System.setOut(this._out);
        System.setErr(this._err);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        System.setOut(this._sysOut);
        System.setErr(this._sysErr);
    }

    public void println(String strOut) {
        this._out.println(strOut);
    }

    public void setText(String strOut) {
        this._outputPanel.setText(strOut);
    }

    public void clear() {
        this._outputPanel.setText("");
        this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
    }

    private class MouseHandler
    extends MouseAdapter {
        private SourceFileAttribute _link;

        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._link = this.getLinkAtCursor(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._link == this.getLinkAtCursor(e)) {
                this.gotoLink(this._link);
            }
            this._link = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SourceFileAttribute link = this.getLinkAtCursor(e);
            if (link != null) {
                SystemPanel.this._outputPanel.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                SystemPanel.this._outputPanel.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private SourceFileAttribute getLinkAtCursor(MouseEvent e) {
            int caret = SystemPanel.this._outputPanel.viewToModel(e.getPoint());
            Element elem = this.getElementAt(caret);
            if (elem != null) {
                return (SourceFileAttribute)((AbstractDocument.LeafElement)elem).getAttribute(HTML.Tag.A);
            }
            return null;
        }

        private void gotoLink(SourceFileAttribute link) {
            IType type;
            if (link != null && (type = TypeSystem.getByFullNameIfValid((String)link.getFqn())) instanceof IGosuClass) {
                IFile sourceFile = ((IGosuClass)type).getSourceFileHandle().getFile();
                if (sourceFile != null && sourceFile.isJavaFile()) {
                    RunMe.getEditorFrame().getGosuPanel().openFile(sourceFile.toJavaFile());
                    SettleModalEventQueue.instance().run();
                }
                GosuEditorPane editor = RunMe.getEditorFrame().getGosuPanel().getCurrentEditor().getEditor();
                Element root = editor.getDocument().getDefaultRootElement();
                int startOfLineOffset = root.getElement(link.getLine() - 1).getStartOffset();
                editor.setCaretPosition(startOfLineOffset);
                editor.requestFocus();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() == 0) {
                return;
            }
            if ((e.getModifiers() & 2) == 0) {
                this.forward(e);
                return;
            }
            int iInc = e.getWheelRotation() < 0 ? -1 : 1;
            Font font = SystemPanel.this._outputPanel.getFont();
            int iSize = font.getSize() + iInc;
            if (iSize < 4 || iSize > 72) {
                return;
            }
            SystemPanel.this._outputPanel.setFont(font.deriveFont((float)iSize));
            SystemPanel.this._scroller.getAdviceColumn().revalidate();
            SystemPanel.this._scroller.getAdviceColumn().repaint();
        }

        private void forward(MouseWheelEvent e) {
            e = new MouseWheelEvent((Component)e.getComponent().getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
        }

        protected Element getElementAt(int offset) {
            return this.getElementAt(SystemPanel.this._outputPanel.getDocument().getDefaultRootElement(), offset);
        }

        private Element getElementAt(Element parent, int offset) {
            if (parent.isLeaf()) {
                return parent;
            }
            return this.getElementAt(parent.getElement(parent.getElementIndex(offset)), offset);
        }
    }
}

