/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorBasedPopup;
import editor.GosuEditor;
import editor.ISelectionPopup;
import editor.TypeCellRenderer;
import editor.util.ContainerMoverSizer;
import editor.util.ContainerSizer;
import editor.util.EditorUtilities;
import editor.util.TextComponentUtil;
import gw.lang.parser.ITypeUsesMap;
import gw.lang.reflect.TypeSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public class TypePopup
extends EditorBasedPopup
implements ISelectionPopup {
    private JPanel _pane = new JPanel();
    private JList _list;
    private ArrayList<CharSequence> _allTypes;
    private EventListenerList _nodeListenerList = new EventListenerList();
    private boolean _bLocked;
    private EditorKeyListener _editorKeyListener;
    private UndoableEditListener _docListener;
    private String _strPrefix;
    private boolean _annotationsOnly;
    private String _title;

    public TypePopup(String strPrefix, GosuEditor editor) {
        this(strPrefix, editor, false);
    }

    public TypePopup(String strPrefix, GosuEditor editor, boolean annotationsOnly) {
        super(editor);
        this._strPrefix = strPrefix;
        this._annotationsOnly = annotationsOnly;
        this._title = this._annotationsOnly ? "Annotations" : "Types";
        this.initLayout();
    }

    @Override
    public void setSelection(String strSelection) {
        this._list.setSelectedValue(strSelection, true);
    }

    public void handleSelection(String strType) {
        this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(strType));
        this.setVisible(false);
    }

    @Override
    public List<String> getPopupSuggestions() {
        ListModel popupList = this._list.getModel();
        ArrayList<String> suggestionNames = new ArrayList<String>();
        for (int i = 0; i < popupList.getSize(); ++i) {
            suggestionNames.add(popupList.getElementAt(i).toString());
        }
        return suggestionNames;
    }

    protected void initLayout() {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        GridBagLayout gridBag = new GridBagLayout();
        this._pane.setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        CompoundBorder border = BorderFactory.createCompoundBorder(UIManager.getBorder("PopupMenu.border"), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ContainerMoverSizer content = new ContainerMoverSizer(border);
        content.setLayout(new BorderLayout());
        Set allTypeNames = TypeSystem.getAllTypeNames();
        this._allTypes = new ArrayList(allTypeNames);
        Collections.sort(this._allTypes, new Comparator<CharSequence>(){

            @Override
            public int compare(CharSequence o1, CharSequence o2) {
                return TypePopup.getRelativeTypeName(o1.toString()).compareToIgnoreCase(TypePopup.getRelativeTypeName(o2.toString()));
            }
        });
        int iY = 0;
        JLabel labelTypeName = new JLabel(this._title);
        labelTypeName.setOpaque(true);
        labelTypeName.setBackground(EditorUtilities.CONTROL);
        labelTypeName.setFont(labelTypeName.getFont().deriveFont(1));
        labelTypeName.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = iY++;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this._pane.add((Component)labelTypeName, c);
        this._list = new JList(new TypeModel(this._allTypes)){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dim = super.getPreferredScrollableViewportSize();
                int iScreenWidth = this.getToolkit().getScreenSize().width;
                if (dim.width > iScreenWidth / 3) {
                    dim.width = iScreenWidth / 3;
                }
                return dim;
            }
        };
        this._list.addMouseListener(new TypeListener());
        this._list.setCellRenderer(new TypeCellRenderer());
        this._list.getSelectionModel().setSelectionMode(0);
        this._list.setVisibleRowCount(10);
        JScrollPane scrollPane = new JScrollPane(this._list);
        scrollPane.setBorder(UIManager.getBorder("TextField.border"));
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = iY;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this._pane.add((Component)scrollPane, c);
        content.add((Component)this._pane, "Center");
        JPanel sizerPanel = new JPanel(new BorderLayout());
        sizerPanel.add((Component)new JPanel(), "Center");
        sizerPanel.add((Component)new ContainerSizer(), "East");
        content.add((Component)sizerPanel, "South");
        this._editorKeyListener = new EditorKeyListener();
        this.add(content);
        if (this.getEditor() != null) {
            this._editorKeyListener = new EditorKeyListener();
            this._docListener = new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    TypePopup.this.filterDisplay();
                }
            };
        }
        if (this._strPrefix != null) {
            this.filterDisplay(this._strPrefix);
        }
    }

    @Override
    public void setVisible(boolean bVisible) {
        super.setVisible(bVisible);
        if (this.getEditor() == null) {
            return;
        }
        if (bVisible) {
            this.registerListeners();
            EditorUtilities.removePopupBorder(this);
        } else {
            this.unregisterListeners();
            this.getEditor().getEditor().requestFocus();
        }
    }

    void registerListeners() {
        this.unregisterListeners();
        this.getEditor().getEditor().addKeyListener(this._editorKeyListener);
        this.getEditor().getEditor().getDocument().addUndoableEditListener(this._docListener);
    }

    void unregisterListeners() {
        this.getEditor().getEditor().getDocument().removeUndoableEditListener(this._docListener);
        this.getEditor().getEditor().removeKeyListener(this._editorKeyListener);
    }

    void filterDisplay() {
        this.filterDisplay(null);
    }

    void filterDisplay(String strWholePath) {
        int iDotIndex;
        if (strWholePath == null && (strWholePath = TextComponentUtil.getWordAtCaret(this.getEditor().getEditor())) != null && strWholePath.length() > 0 && Character.isWhitespace(strWholePath.charAt(0))) {
            strWholePath = TextComponentUtil.getWordBeforeCaret(this.getEditor().getEditor());
        }
        String strPrefix = strWholePath;
        if (strWholePath != null && strWholePath.length() > 0 && (iDotIndex = strWholePath.lastIndexOf(46)) >= 0) {
            strPrefix = strWholePath.substring(iDotIndex + 1);
        }
        if (this.endsWithInvalidChar(strPrefix)) {
            this.setVisible(false);
            return;
        }
        ArrayList<CharSequence> allTypes = this.getAllTypes();
        ArrayList<String> filteredTypes = new ArrayList<String>();
        for (CharSequence type : allTypes) {
            String strType = type.toString();
            String strRelativeType = TypePopup.getRelativeTypeName(strType);
            if (strPrefix == null || !strRelativeType.toLowerCase().startsWith(strPrefix.toLowerCase())) continue;
            filteredTypes.add(strType);
        }
        this._list.setModel(new TypeModel(filteredTypes));
        this._list.setSelectedIndex(0);
        this._list.revalidate();
        this._list.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show(Component invoker, int iX, int iY) {
        this._bLocked = true;
        try {
            TypeModel model = (TypeModel)this._list.getModel();
            int iSize = model.getSize();
            if (iSize == 0) {
                return;
            }
            if (iSize == 1) {
                String strType = (String)model.getElementAt(0);
                if (this._strPrefix != null && !this._strPrefix.equalsIgnoreCase(strType) && this.isTypeUsed(strType)) {
                    this.fireNodeChanged(this._nodeListenerList, new ChangeEvent(strType));
                    return;
                }
            }
            super.show(invoker, iX, iY);
        }
        finally {
            this._bLocked = false;
        }
    }

    private boolean isTypeUsed(String strType) {
        String strRelativeName = TypePopup.getRelativeTypeName(strType);
        try {
            return this.getEditor().getParser().getTypeUsesMap().resolveType(strRelativeName) != null || TypeSystem.parseType((String)strRelativeName, (ITypeUsesMap)this.getEditor().getParser().getTypeUsesMap().copy()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void addNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.add(ChangeListener.class, l);
    }

    public void removeNodeChangeListener(ChangeListener l) {
        this._nodeListenerList.remove(ChangeListener.class, l);
    }

    protected void fireNodeChanged(final EventListenerList list, final ChangeEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TypePopup.this.fireNodeChangedNow(list, e);
            }
        });
    }

    protected void fireNodeChangedNow(EventListenerList list, ChangeEvent e) {
        Object[] listeners = list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(e);
        }
    }

    private ArrayList<CharSequence> getAllTypes() {
        return this._allTypes;
    }

    static String getRelativeTypeName(String strType) {
        int iIndex = strType.lastIndexOf(46);
        if (iIndex > 0) {
            return strType.substring(iIndex + 1);
        }
        return strType;
    }

    class TypeModel
    extends AbstractListModel {
        ArrayList _allTypes;

        TypeModel(ArrayList allTypes) {
            this._allTypes = allTypes;
        }

        @Override
        public int getSize() {
            return this._allTypes.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this._allTypes.get(i);
        }
    }

    class TypeListener
    extends MouseAdapter {
        TypeListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (TypePopup.this._bLocked) {
                return;
            }
            int iIndex = TypePopup.this._list.locationToIndex(e.getPoint());
            if (iIndex < 0) {
                return;
            }
            TypePopup.this._list.setSelectedIndex(iIndex);
            String strType = (String)TypePopup.this._list.getSelectedValue();
            TypePopup.this.fireNodeChanged(TypePopup.this._nodeListenerList, new ChangeEvent(strType));
            TypePopup.this.setVisible(false);
        }
    }

    class EditorKeyListener
    extends KeyAdapter {
        EditorKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224 || e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                Action selectPrevious = TypePopup.this._list.getActionMap().get("selectPreviousRow");
                selectPrevious.actionPerformed(new ActionEvent(TypePopup.this._list, 0, "selectPreviousRow"));
                e.consume();
            } else if (e.getKeyCode() == 40 || e.getKeyCode() == 225 || e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                Action selectNext = TypePopup.this._list.getActionMap().get("selectNextRow");
                selectNext.actionPerformed(new ActionEvent(TypePopup.this._list, 0, "selectNextRow"));
                e.consume();
            } else if (e.getKeyCode() == 33) {
                Action scrollUpChangeSelection = TypePopup.this._list.getActionMap().get("scrollUp");
                scrollUpChangeSelection.actionPerformed(new ActionEvent(TypePopup.this._list, 0, "scrollUp"));
                e.consume();
            } else if (e.getKeyCode() == 34) {
                Action scrollDownChangeSelection = TypePopup.this._list.getActionMap().get("scrollDown");
                scrollDownChangeSelection.actionPerformed(new ActionEvent(TypePopup.this._list, 0, "scrollDown"));
                e.consume();
            } else if (e.getKeyCode() == 10 || e.getKeyCode() == 32 || e.getKeyCode() == 9) {
                String strType = (String)TypePopup.this._list.getSelectedValue();
                if (strType != null) {
                    TypePopup.this.fireNodeChanged(TypePopup.this._nodeListenerList, new ChangeEvent(strType));
                }
                TypePopup.this.setVisible(false);
                e.consume();
            } else if (e.getKeyCode() == 46) {
                this.handleSelectionForDot();
            } else if (e.getKeyCode() == 27) {
                TypePopup.this.setVisible(false);
                e.consume();
            }
        }

        private void handleSelectionForDot() {
            final String strType = (String)TypePopup.this._list.getSelectedValue();
            if (strType == null) {
                TypePopup.this.setVisible(false);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorKeyListener.this.sendKeyEvent(8);
                    TypePopup.this.handleSelection(strType);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorKeyListener.this.sendKeyEvent(46);
                        }
                    });
                }
            });
        }

        private void sendKeyEvent(int iKey) {
            TypePopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(TypePopup.this.getEditor().getEditor(), 401, System.currentTimeMillis(), 0, iKey, '\uffff'));
            TypePopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(TypePopup.this.getEditor().getEditor(), 402, System.currentTimeMillis(), 0, iKey, '\uffff'));
            TypePopup.this.getEditor().getEditor().dispatchEvent(new KeyEvent(TypePopup.this.getEditor().getEditor(), 400, System.currentTimeMillis(), 0, 0, (char)iKey));
        }
    }
}

