/*
 * Decompiled with CFR 0.152.
 */
package editor.splitpane;

import editor.util.EditorUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class SplitPane
extends JComponent
implements SwingConstants {
    public int SPLITTER_WIDTH = 7;
    protected int _iOrientation;
    protected int _iPosition;
    protected JPanel _pane1;
    protected JPanel _pane2;
    protected JComponent _comp1;
    protected JComponent _comp2;
    protected Splitter _splitter;
    protected boolean _hasGripBumps;
    public static final int MIN_POSITION = 0;
    public static final int MAX_POSITION = 100;
    private Set<ActionListener> _listeners = new HashSet<ActionListener>();

    public SplitPane(int iOrientation, JComponent comp1, JComponent comp2) {
        this(iOrientation, comp1, comp2, true);
    }

    public SplitPane(int iOrientation, JComponent comp1, JComponent comp2, boolean hasGripBumps) {
        this._iOrientation = iOrientation;
        this._pane1 = new JPanel();
        this._pane2 = new JPanel();
        this._splitter = new Splitter();
        this._pane1.setLayout(new BorderLayout());
        this._pane2.setLayout(new BorderLayout());
        SplitterHandler splitterHandler = new SplitterHandler();
        this._splitter.addMouseListener(splitterHandler);
        this._splitter.addMouseMotionListener(splitterHandler);
        this.addMainComponents(comp1, comp2);
        this._hasGripBumps = hasGripBumps;
    }

    protected void addMainComponents(JComponent comp1, JComponent comp2) {
        this.add(this._pane1);
        this.add(this._pane2);
        this.add(this._splitter);
        this.setLayout(new SplitPaneLayout());
        this.setTop(comp1);
        this.setBottom(comp2);
    }

    public void setTop(JComponent c) {
        this._comp1 = c;
        this._pane1.add((Component)this._comp1, "Center");
    }

    public JComponent getTop() {
        return this._comp1;
    }

    public void clearTop() {
        this._pane1.removeAll();
    }

    public void setBottom(JComponent c) {
        this._comp2 = c;
        this._pane2.add((Component)this._comp2, "Center");
    }

    public JComponent getBottom() {
        return this._comp2;
    }

    public void clearBottom() {
        this._pane2.removeAll();
    }

    protected int getSplitterWidth() {
        return this.SPLITTER_WIDTH;
    }

    public int getOrientation() {
        return this._iOrientation;
    }

    public void setOrientation(int iOrientation) {
        this._iOrientation = iOrientation;
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    public boolean hasGripBumps() {
        return this._hasGripBumps;
    }

    public void setGripBumps(boolean gripBumps) {
        this._hasGripBumps = gripBumps;
    }

    public int getPosition() {
        return this._iPosition;
    }

    public void setPosition(int iPos) {
        iPos = iPos < 0 ? 0 : iPos;
        this._iPosition = iPos = iPos > 100 ? 100 : iPos;
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
        for (ActionListener listener : this._listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, Integer.toString(iPos)));
        }
    }

    public void addActionListener(ActionListener l) {
        this._listeners.add(l);
    }

    class SplitPaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parentContainer) {
            int iOrientation = SplitPane.this.getOrientation();
            Insets insets = SplitPane.this.getInsets();
            if (iOrientation == 0) {
                int iPos = (int)((float)SplitPane.this.getWidth() * ((float)SplitPane.this.getPosition() / 100.0f));
                SplitPane.this._splitter.setBounds(insets.left + (iPos - SplitPane.this.getSplitterWidth() / 2), insets.top, SplitPane.this.getSplitterWidth(), SplitPane.this.getHeight() - insets.top - insets.bottom);
                SplitPane.this._pane1.setBounds(insets.left, insets.top, SplitPane.this._splitter.getX() - insets.left, SplitPane.this.getHeight() - insets.top - insets.bottom);
                SplitPane.this._pane2.setBounds(SplitPane.this._splitter.getX() + SplitPane.this._splitter.getWidth(), insets.top, SplitPane.this.getWidth() - insets.right - (SplitPane.this._splitter.getX() + SplitPane.this._splitter.getWidth()), SplitPane.this.getHeight() - insets.top - insets.bottom);
            } else {
                int iPos = (int)((float)SplitPane.this.getHeight() * ((float)SplitPane.this.getPosition() / 100.0f));
                SplitPane.this._splitter.setBounds(insets.left, insets.top + (iPos - SplitPane.this.getSplitterWidth() / 2), SplitPane.this.getWidth() - insets.left - insets.right, SplitPane.this.getSplitterWidth());
                SplitPane.this._pane1.setBounds(insets.left, insets.top, SplitPane.this.getWidth() - insets.left - insets.right, SplitPane.this._splitter.getY() - insets.top);
                SplitPane.this._pane2.setBounds(insets.left, SplitPane.this._splitter.getY() + SplitPane.this._splitter.getHeight(), SplitPane.this.getWidth() - insets.left - insets.right, SplitPane.this.getHeight() - insets.bottom - (SplitPane.this._splitter.getY() + SplitPane.this._splitter.getHeight()));
            }
        }
    }

    class SplitterHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected Point _ptDrag;
        protected Point _ptDragSave;
        protected boolean _bDragging;
        protected Rectangle _rcLast;
        protected MouseEvent _mouseEvent;

        SplitterHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._mouseEvent = e;
            this.beginDrag(e.getPoint());
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this._mouseEvent = e;
            this.endDrag(e.getPoint());
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this._mouseEvent = e;
            this.drag(e.getPoint());
            e.consume();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            e.consume();
        }

        protected void beginDrag(Point pt) {
            this._bDragging = true;
            this._ptDrag = pt;
        }

        protected void endDrag(Point pt) {
            try {
                if (this._rcLast != null) {
                    if (SplitPane.this.getOrientation() == 0) {
                        SplitPane.this.setPosition((int)((float)(this._rcLast.x + this._rcLast.width / 2) / (float)SplitPane.this.getWidth() * 100.0f));
                    } else {
                        SplitPane.this.setPosition((int)((float)(this._rcLast.y + this._rcLast.height / 2) / (float)SplitPane.this.getHeight() * 100.0f));
                    }
                    this.dragBorderXOR(null);
                    this._rcLast = null;
                    this._ptDrag = null;
                    this._ptDragSave = null;
                }
            }
            finally {
                this._bDragging = false;
            }
        }

        protected void drag(Point pt) {
            if (this._ptDrag == null) {
                return;
            }
            Rectangle rcBounds = SplitPane.this._splitter.getBounds();
            int iXDiff = 0;
            int iYDiff = 0;
            if (SplitPane.this.getOrientation() == 0) {
                iXDiff = pt.x - this._ptDrag.x;
            } else {
                iYDiff = pt.y - this._ptDrag.y;
            }
            if (iXDiff == 0 && iYDiff == 0) {
                return;
            }
            rcBounds.x += iXDiff;
            rcBounds.y += iYDiff;
            if (this._ptDragSave != null && this._ptDragSave.equals(pt)) {
                return;
            }
            this._ptDragSave = pt;
            Rectangle rcDrag = new Rectangle(rcBounds.x, rcBounds.y, rcBounds.width, rcBounds.height);
            this.dragBorderXOR(rcDrag);
        }

        protected synchronized void dragBorderXOR(Rectangle rcBounds) {
            SplitPane parent = SplitPane.this;
            Graphics g = ((Component)parent).getGraphics();
            if (g == null) {
                return;
            }
            g.setXORMode(new Color(UIManager.getColor("desktop").getRGB()));
            g.setColor(EditorUtilities.WINDOW);
            if (this._rcLast != null) {
                g.fillRect(this._rcLast.x + 1, this._rcLast.y + 1, this._rcLast.width - 2, this._rcLast.height - 2);
            }
            this._rcLast = rcBounds;
            if (this._rcLast != null) {
                g.fillRect(this._rcLast.x + 1, this._rcLast.y + 1, this._rcLast.width - 2, this._rcLast.height - 2);
            }
            g.dispose();
            g = null;
        }
    }

    class Splitter
    extends JPanel {
        Splitter() {
            this.setBackground(EditorUtilities.CONTROL);
            int iOrientation = SplitPane.this.getOrientation();
            this.setCursor(iOrientation == 0 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(8));
        }
    }
}

