/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.search.StudioUtilities;
import editor.splitpane.ICaptionActionListener;
import editor.splitpane.ICaptionBar;
import editor.tabpane.ITab;
import editor.tabpane.InnerLabel;
import editor.tabpane.StandardTabBorder;
import editor.tabpane.TabAndToolContainer;
import editor.tabpane.TabContainer;
import editor.tabpane.TabPane;
import editor.tabpane.TabPosition;
import editor.util.EditorUtilities;
import editor.util.IEditableLabel;
import editor.util.ILabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StandardTab
extends JPanel
implements ITab {
    private TabContainer _tabContainer;
    private JLabel _innerLabel;
    private JComponent _contentPanel;
    private ILabel _label;
    private boolean _bCanClose;
    private boolean _bHover;
    private TabPositionChangeHandler _tabPositionChangeHandler;

    public StandardTab(TabContainer tabContainer, ILabel labelAttr, JComponent contentPane) {
        this(tabContainer, labelAttr, contentPane, false);
    }

    public StandardTab(TabContainer tabContainer, ILabel labelAttr, JComponent contentPane, boolean bCanClose) {
        this._label = labelAttr;
        if (this._label instanceof IEditableLabel) {
            ((IEditableLabel)this._label).addChangeListener(new LabelChangeListener());
        }
        this._bCanClose = bCanClose;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBackground(EditorUtilities.WINDOW);
        this._tabContainer = tabContainer;
        this._innerLabel = this.createInnerLabel(labelAttr);
        this.add((Component)this._innerLabel, "Center");
        this._contentPanel = contentPane;
        this.setBorder(new StandardTabBorder());
        this._tabPositionChangeHandler = new TabPositionChangeHandler();
        tabContainer.addTabpositionListener(this._tabPositionChangeHandler);
        this.addMouseListener();
    }

    protected JLabel createInnerLabel(ILabel labelAttr) {
        return new InnerLabel(this, labelAttr.getDisplayName(), labelAttr.getIcon(1), 4);
    }

    protected JLabel recreateInnerLabel() {
        return new InnerLabel(this, this._innerLabel.getText(), this._innerLabel.getIcon(), 4);
    }

    @Override
    public TabPosition getTabPosition() {
        return this._tabContainer.getTabPosition();
    }

    @Override
    public ILabel getLabel() {
        return this._label;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JComponent getContentPane() {
        return this._contentPanel;
    }

    @Override
    public Dimension getInnerSize() {
        return this._innerLabel.getPreferredSize();
    }

    @Override
    public boolean isSelected() {
        return this._tabContainer != null && this._tabContainer.getSelectedTab() == this;
    }

    @Override
    public boolean isHover() {
        return this._bHover;
    }

    @Override
    public void setHover(boolean bHover) {
        this._bHover = bHover;
    }

    @Override
    public boolean canClose() {
        return this._bCanClose;
    }

    @Override
    public void dispose() {
        this._tabContainer.removeTabpositionListener(this._tabPositionChangeHandler);
    }

    @Override
    public void refresh() {
        this._innerLabel.setText(this._label.getDisplayName());
        this._innerLabel.setIcon(this.getIcon());
        this.revalidate();
        this.repaint();
    }

    protected Icon getIcon() {
        return this._label.getIcon(1);
    }

    @Override
    public Color getBackground() {
        return this.isSelected() ? (this.getTabPane().isShowing() && this.getTabPane().isActive() ? EditorUtilities.ACTIVE_CAPTION : super.getBackground()) : EditorUtilities.CONTROL;
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2In = (Graphics2D)g;
        BufferedImage bi = g2In.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), 3);
        Graphics2D g2Image = this.getTransformedGraphics(g2In, bi);
        this.paintTab(g2Image);
        super.paintBorder(g2Image);
        if (g2Image != g2In) {
            g2Image.dispose();
            g2In.drawImage(bi, null, 0, 0);
        }
    }

    protected Color getGradient() {
        return this.isSelected() ? (this.getTabPane().isShowing() && this.getTabPane().isActive() ? EditorUtilities.ACTIVE_CAPTION : EditorUtilities.CONTROL) : (this.isHover() ? EditorUtilities.CONTROL : EditorUtilities.CONTROL_SHADOW);
    }

    private Graphics2D getTransformedGraphics(Graphics2D g2, BufferedImage bi) {
        AffineTransform transform;
        if (this.getTabPosition() == TabPosition.TOP) {
            return g2;
        }
        Graphics2D g2Image = bi.createGraphics();
        if (this.getTabPosition() == TabPosition.BOTTOM) {
            transform = AffineTransform.getScaleInstance(1.0, -1.0);
            transform.translate(0.0, 1 - this.getHeight());
        } else if (this.getTabPosition() == TabPosition.LEFT) {
            transform = AffineTransform.getRotateInstance(-1.5707963267948966);
            transform.translate(1 - this.getHeight(), 0.0);
        } else if (this.getTabPosition() == TabPosition.RIGHT) {
            transform = AffineTransform.getRotateInstance(1.5707963267948966);
            transform.translate(0.0, 1 - this.getWidth());
        } else {
            throw new IllegalStateException("Unknown TabPosition");
        }
        g2Image.setTransform(transform);
        return g2Image;
    }

    protected void paintTab(Graphics2D g2Image) {
        Color grad = this.getGradient();
        Color backgnd = this.getBackground();
        float fGradientFactor = this.getTabPosition() == TabPosition.TOP || this.getTabPosition() == TabPosition.BOTTOM ? (float)((double)this.getHeight() * (this.isSelected() || this.isHover() ? 1.0 : 1.75)) : (float)((double)this.getWidth() * (this.isSelected() || this.isHover() ? 1.0 : 1.75));
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, backgnd, 0.0f, fGradientFactor, grad);
        g2Image.setPaint(gp);
        StandardTabBorder border = (StandardTabBorder)this.getBorder();
        Polygon poly = border.getBorderPoly(this);
        g2Image.fillPolygon(poly);
        super.paintComponent(g2Image);
    }

    private void addMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    ICaptionBar caption = StandardTab.this.getTabPane().getCaption();
                    if (caption instanceof TabAndToolContainer) {
                        ICaptionActionListener.ActionType action = caption.getCaptionType() == ICaptionActionListener.ActionType.MAXIMIZE ? ICaptionActionListener.ActionType.RESTORE : ICaptionActionListener.ActionType.MAXIMIZE;
                        ((TabAndToolContainer)caption).fireCaptionActionPerformed(action);
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!StandardTab.this.getContentPane().isShowing()) {
                                return;
                            }
                            if (StandardTab.this._tabContainer.getSelectedTab() == StandardTab.this && !StudioUtilities.containsFocus(StandardTab.this.getContentPane())) {
                                StandardTab.this.getContentPane().transferFocus();
                            }
                        }
                    });
                }
            }
        });
    }

    TabPane getTabPane() {
        return (TabPane)this._tabContainer.getClientProperty("_tabPaneProperty");
    }

    private class LabelChangeListener
    implements ChangeListener {
        private LabelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StandardTab.this.refresh();
        }
    }

    private class TabPositionChangeHandler
    implements ChangeListener {
        private TabPositionChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StandardTab.this.remove(StandardTab.this._innerLabel);
            StandardTab.this._innerLabel = StandardTab.this.recreateInnerLabel();
            StandardTab.this.add((Component)StandardTab.this._innerLabel, "Center");
            StandardTab.this.revalidate();
            StandardTab.this.repaint();
        }
    }
}

