/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.FileTree;
import editor.IFileWatcherListener;
import editor.util.Experiment;
import gw.util.PathUtil;
import gw.util.concurrent.ConcurrentWeakValueHashMap;
import java.awt.EventQueue;
import java.io.File;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;

public class FileWatcher
implements Runnable {
    private static FileWatcher FILE_WATCHER = null;
    private WatchService _watcher;
    private Experiment _experiment;
    private ConcurrentWeakValueHashMap<String, IFileWatcherListener> _listeners;
    private Map<WatchKey, String> _keyToPath;
    private boolean _disposed;

    public static FileWatcher instance(Experiment experiment) {
        if (FILE_WATCHER != null && FileWatcher.FILE_WATCHER._experiment != experiment) {
            FILE_WATCHER.dispose();
        }
        if (FILE_WATCHER == null) {
            FILE_WATCHER = new FileWatcher(experiment);
        }
        return FILE_WATCHER;
    }

    private FileWatcher(Experiment experiment) {
        this._experiment = experiment;
        this._listeners = new ConcurrentWeakValueHashMap();
        this._keyToPath = new ConcurrentHashMap<WatchKey, String>();
        Path path = PathUtil.create((String)experiment.getSourcePath().get(0), (String[])new String[0]);
        try {
            this._watcher = path.getFileSystem().newWatchService();
            Executors.newSingleThreadExecutor().execute(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void register(FileTree fileTree) {
        if (!fileTree.isDirectory()) {
            throw new IllegalStateException("Expecting a directory");
        }
        try {
            Path fileOrDir = fileTree.getFileOrDir();
            WatchKey key = fileOrDir.register(this._watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this._keyToPath.put(key, PathUtil.getAbsolutePathName((Path)fileOrDir));
            this.addListener(fileTree);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregister(FileTree fileTree) {
        if (!fileTree.isDirectory()) {
            throw new IllegalStateException("Expecting a directory");
        }
        this.removeListener(fileTree);
        for (WatchKey key : this._keyToPath.keySet()) {
            String path = this._keyToPath.get(key);
            if (!path.equals(PathUtil.getAbsolutePathName((Path)fileTree.getFileOrDir()))) continue;
            this._keyToPath.remove(key);
        }
    }

    private void dispose() {
        try {
            this._disposed = true;
            this._watcher.close();
            FILE_WATCHER = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        try {
            WatchKey key = this._watcher.take();
            while (!this._disposed && key != null) {
                for (WatchEvent<?> event : key.pollEvents()) {
                    String dirPath = this._keyToPath.get(key);
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        EventQueue.invokeLater(() -> this.fireCreate(dirPath, (Path)event.context()));
                        continue;
                    }
                    if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        EventQueue.invokeLater(() -> this.fireDelete(dirPath, (Path)event.context()));
                        continue;
                    }
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    EventQueue.invokeLater(() -> this.fireModify(dirPath, (Path)event.context()));
                }
                key.reset();
                key = this._watcher.take();
            }
        }
        catch (ClosedWatchServiceException cw) {
            if (!this._disposed) {
                throw new IllegalStateException("Unexpected close file watcher, not disposed");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addListener(FileTree fileTree) {
        this._listeners.put((Object)PathUtil.getAbsolutePathName((Path)fileTree.getFileOrDir()), (Object)fileTree);
    }

    private void removeListener(FileTree fileTree) {
        this._listeners.remove((Object)PathUtil.getAbsolutePathName((Path)fileTree.getFileOrDir()));
    }

    private void fireDelete(String dirPath, Path fileName) {
        String dir = new File(dirPath).getAbsolutePath();
        IFileWatcherListener listener = (IFileWatcherListener)this._listeners.get((Object)dir);
        listener.fireDelete(dir, fileName.toString());
    }

    private void fireCreate(String dirPath, Path fileName) {
        String dir = new File(dirPath).getAbsolutePath();
        IFileWatcherListener listener = (IFileWatcherListener)this._listeners.get((Object)dir);
        listener.fireCreate(dir, fileName.toString());
    }

    private void fireModify(String dirPath, Path fileName) {
        String dir = new File(dirPath).getAbsolutePath();
        IFileWatcherListener listener = (IFileWatcherListener)this._listeners.get((Object)dir);
        listener.fireModify(dir, fileName.toString());
    }
}

