/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class GosuLabRadioButtonUI
extends BasicRadioButtonUI {
    private static final GosuLabRadioButtonUI INSTANCE = new GosuLabRadioButtonUI();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean initialized = false;

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.initialized) {
            this.dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            this.dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            this.dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            this.dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        GraphicsUtil.paintText(g, b, textRect, text, this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics g, Rectangle textRect, Dimension d) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, textRect.x, textRect.y, textRect.width, textRect.height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        AbstractButton b = (AbstractButton)c;
        if (d != null && b.isFocusPainted()) {
            if (d.width % 2 == 0) {
                ++d.width;
            }
            if (d.height % 2 == 0) {
                ++d.height;
            }
        }
        return d;
    }
}

