/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.GosuDocument;
import editor.Scheme;
import editor.util.EditorUtilities;
import editor.util.Pair;
import gw.lang.parser.exceptions.ParseWarningForDeprecatedMember;
import gw.util.GosuObjectUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;

public class GosuStyleContext
extends StyleContext
implements ViewFactory {
    public static final int KEY_WORD = -99;
    public static final int PARSE_ERROR = -98;
    public static final int DEPRECATED = -97;
    public static final int PARSE_WARNING = -96;
    public static final int TYPE_LITERAL = -95;
    public static final int NESTED_TYPE_LITERAL = -94;
    public static final int METHOD_CALL = -93;
    public static final int USES = -92;
    public static final int DEFAULT = -91;
    public static final int FIELD_ERROR = -90;
    public static final int FIELD_WARNING = -89;
    public static final int PACKAGE = -88;
    public static final int PROPERTY = -87;
    public static final int ENHANCEMENT_METHOD_CALL = -86;
    public static final int ENHANCEMENT_PROPERTY = -85;
    public static final Integer KEY_WORD_KEY = new Integer(-99);
    public static final Integer PARSE_ERROR_KEY = new Integer(-98);
    public static final Integer DEPRECATED_KEY = new Integer(-97);
    public static final Integer TYPE_LITERAL_KEY = new Integer(-95);
    public static final Integer NESTED_TYPE_LITERAL_KEY = new Integer(-94);
    public static final Integer PARSE_WARNING_KEY = new Integer(-96);
    public static final Integer METHOD_CALL_KEY = new Integer(-93);
    public static final Integer PROPERTY_KEY = new Integer(-87);
    public static final Integer ENHANCEMENT_METHOD_CALL_KEY = new Integer(-86);
    public static final Integer ENHANCEMENT_PROPERTY_KEY = new Integer(-85);
    public static final Integer USES_KEY = new Integer(-92);
    public static final Integer PACKAGE_KEY = new Integer(-88);
    public static final Integer FIELD_ERROR_KEY = new Integer(-90);
    public static final Integer FIELD_WARNING_KEY = new Integer(-89);
    public static final String DASHED = "_dashed";
    private static final Component THISISSTUPID = new Component(){};
    private static String g_defFontFamily = EditorUtilities.getFontFamilyOrDefault("Consolas", "Monospaced");
    private static int g_defFontSize = 12;
    public static final String STYLE_EOL = "EOL";
    public static final String STYLE_EOF = "EOF";
    public static final String STYLE_Whitespace = "Whitespace";
    public static final String STYLE_Comment = "Comment";
    public static final String STYLE_Caret = "Caret";
    public static final String STYLE_Number = "Number";
    public static final String STYLE_Integer = "Integer";
    public static final String STYLE_Word = "Word";
    public static final String STYLE_Operator = "Operator";
    public static final String STYLE_StringLiteral = "StringLiteral";
    public static final String STYLE_KeyWord = "KeyWord";
    public static final String STYLE_ParseError = "ParseError";
    public static final String STYLE_ParseWarning = "ParseWarning";
    public static final String STYLE_DeprecatedMember = "DeprecatedMember";
    public static final String STYLE_TypeLiteral = "ITypeLiteralExpression";
    public static final String STYLE_NestedTypeLiteral = "NestedTypeLiteral";
    public static final String STYLE_MethodCall = "MethodCall";
    public static final String STYLE_Property = "Property";
    public static final String STYLE_EnhancementMethodCall = "EnhancementMethodCall";
    public static final String STYLE_EnhancementProperty = "EnhancementProperty";
    public static final String STYLE_FieldError = "FieldError";
    public static final String STYLE_FieldWarning = "FieldWarning";
    private String _strFontFamily;
    private int _iFontSize;
    private HashMap<AttributeSet, Font> _fontCache;
    private HashMap<Integer, Style> _tokenStyles;

    public GosuStyleContext() {
        Style root = this.getStyle("default");
        this._tokenStyles = new HashMap();
        this._tokenStyles.put(new Integer(10), this.addStyle(STYLE_EOL, root));
        this._tokenStyles.put(new Integer(-1), this.addStyle(STYLE_EOF, root));
        this._tokenStyles.put(new Integer(-2), this.addStyle(STYLE_Whitespace, root));
        this._tokenStyles.put(new Integer(-3), this.addStyle(STYLE_Comment, root));
        this._tokenStyles.put(new Integer(-4), this.addStyle(STYLE_Number, root));
        this._tokenStyles.put(new Integer(-9), this.addStyle(STYLE_Integer, root));
        this._tokenStyles.put(new Integer(-5), this.addStyle(STYLE_Word, root));
        this._tokenStyles.put(new Integer(-6), this.addStyle(STYLE_Operator, root));
        this._tokenStyles.put(new Integer(34), this.addStyle(STYLE_StringLiteral, root));
        this._tokenStyles.put(39, this.addStyle(STYLE_StringLiteral, root));
        this._tokenStyles.put(KEY_WORD_KEY, this.addStyle(STYLE_KeyWord, root));
        this._tokenStyles.put(PARSE_ERROR_KEY, this.addStyle(STYLE_ParseError, root));
        this._tokenStyles.put(PARSE_WARNING_KEY, this.addStyle(STYLE_ParseWarning, root));
        this._tokenStyles.put(DEPRECATED_KEY, this.addStyle(STYLE_DeprecatedMember, root));
        this._tokenStyles.put(TYPE_LITERAL_KEY, this.addStyle(STYLE_TypeLiteral, root));
        this._tokenStyles.put(NESTED_TYPE_LITERAL_KEY, this.addStyle(STYLE_NestedTypeLiteral, root));
        this._tokenStyles.put(METHOD_CALL_KEY, this.addStyle(STYLE_MethodCall, root));
        this._tokenStyles.put(PROPERTY_KEY, this.addStyle(STYLE_Property, root));
        this._tokenStyles.put(ENHANCEMENT_METHOD_CALL_KEY, this.addStyle(STYLE_EnhancementMethodCall, root));
        this._tokenStyles.put(ENHANCEMENT_PROPERTY_KEY, this.addStyle(STYLE_EnhancementProperty, root));
        this._tokenStyles.put(FIELD_ERROR_KEY, this.addStyle(STYLE_FieldError, root));
        this._tokenStyles.put(FIELD_WARNING_KEY, this.addStyle(STYLE_FieldWarning, root));
        this.addStyle(STYLE_Caret, root);
        this._strFontFamily = g_defFontFamily;
        this._iFontSize = g_defFontSize;
        this._fontCache = new HashMap();
        this.setDefaultStyles();
    }

    public void setForeground(Style style, Color colorFore) {
        this.setAttribute(style, StyleConstants.Foreground, colorFore);
    }

    public void setBackground(Style style, Color colorBack) {
        this.setAttribute(style, StyleConstants.Background, colorBack);
    }

    public void setBold(Style style, boolean bBold) {
        this.setAttribute(style, StyleConstants.Bold, bBold);
    }

    public void setItalic(Style style, boolean bItalic) {
        this.setAttribute(style, StyleConstants.Italic, bItalic);
    }

    public void setUnderline(Style style, boolean bUnderline) {
        this.setAttribute(style, StyleConstants.Underline, bUnderline);
    }

    public void setStrikeThrough(Style style, boolean bStrikeThrough) {
        this.setAttribute(style, StyleConstants.StrikeThrough, bStrikeThrough);
    }

    public void setAttribute(Style style, Object attr, Object value) {
        Style defStyle = this.getStyle("default");
        if (defStyle == style) {
            style.addAttribute(attr, value);
            Enumeration<?> names = this.getStyleNames();
            while (names.hasMoreElements()) {
                Style csr = this.getStyle((String)names.nextElement());
                if (csr == defStyle || !GosuObjectUtil.equals((Object)csr.getAttribute(attr), (Object)value)) continue;
                csr.removeAttribute(attr);
            }
            return;
        }
        Object defValue = defStyle.getAttribute(attr);
        if (GosuObjectUtil.equals((Object)defValue, (Object)value)) {
            style.removeAttribute(attr);
        } else {
            style.addAttribute(attr, value);
        }
    }

    public void setDefaultStyles() {
        boolean bAllowBold = true;
        Style style = this.getStyle("default");
        this.setBackground(style, Scheme.active().getCodeWindow());
        this.setForeground(style, Scheme.active().getCodeWindowText());
        style = this.getStyleForScanValue(-3);
        this.setForeground(style, Scheme.active().getCodeComment());
        this.setItalic(style, true);
        style = this.getStyleForScanValue(10);
        this.setForeground(style, Scheme.active().getCodeMultilineComment());
        this.setItalic(style, true);
        style = this.getStyleForScanValue(-1);
        this.setForeground(style, Scheme.active().getCodeMultilineComment());
        this.setItalic(style, true);
        style = this.getStyleForScanValue(34);
        this.setForeground(style, Scheme.active().getCodeStringLiteral());
        this.setBold(style, bAllowBold);
        style = this.getStyleForScanValue(-4);
        this.setForeground(style, Scheme.active().getCodeNumberLiteral());
        style = this.getStyleForScanValue(-9);
        this.setForeground(style, Scheme.active().getCodeNumberLiteral());
        style = this.getStyleForScanValue(-99);
        this.setForeground(style, Scheme.active().getCodeKeyword());
        this.setBold(style, bAllowBold);
        style = this.getStyleForScanValue(-98);
        this.setForeground(style, Scheme.active().getCodeError());
        style = this.getStyleForScanValue(-96);
        this.setForeground(style, Scheme.active().getCodeWarning());
        this.setUnderline(style, true);
        style = this.getStyleForScanValue(-97);
        this.setForeground(style, Scheme.active().getCodeDeprecated());
        this.setStrikeThrough(style, true);
        style = this.getStyleForScanValue(-6);
        this.setForeground(style, Scheme.active().getCodeOperator());
        this.setBold(style, bAllowBold);
        style = this.getStyleForScanValue(-95);
        this.setForeground(style, Scheme.active().getCodeTypeLiteral());
        this.setBold(style, bAllowBold);
        style = this.getStyleForScanValue(-94);
        this.setForeground(style, Scheme.active().getCodeTypeLiteralNested());
        style = this.getStyleForScanValue(-90);
        this.setBackground(style, new Color(255, 230, 230));
        style = this.getStyleForScanValue(-89);
        this.setBackground(style, new Color(254, 251, 94));
    }

    public static void setDefaultFontFamily(String defFontFamily) {
        g_defFontFamily = defFontFamily;
    }

    public static String getDefaultFontFamily() {
        return g_defFontFamily;
    }

    public static void setDefaultFontSize(int defFontSize) {
        g_defFontSize = defFontSize;
    }

    public static int getDefaultFontSize() {
        return g_defFontSize;
    }

    public Color getForeground(int code) {
        Style s = this._tokenStyles.get(new Integer(code));
        if (s == null) {
            s = this.getStyle("default");
        }
        return this.getForeground(s);
    }

    public Color getBackground(int code) {
        Style s = this._tokenStyles.get(new Integer(code));
        if (s == null) {
            s = this.getStyle("default");
        }
        return this.getBackground(s);
    }

    public Font getFont(int code) {
        Style s = this._tokenStyles.get(new Integer(code));
        if (s == null) {
            s = this.getStyle("default");
        }
        return this.getFont(s);
    }

    public Style getStyleForScanValue(int code) {
        Style s = this._tokenStyles.get(new Integer(code));
        if (s == null) {
            s = this.getStyle("default");
        }
        return s;
    }

    @Override
    public Font getFont(AttributeSet attr) {
        Font font;
        boolean bUnderline = StyleConstants.isUnderline(attr);
        boolean bStrikethrough = StyleConstants.isStrikeThrough(attr);
        if (!bUnderline && !bStrikethrough) {
            return this.getFont(attr, this.getFontFamily(attr));
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, this.getFontFamily(attr));
        map.put(TextAttribute.SIZE, Float.valueOf(this.getFontSize()));
        map.put(TextAttribute.WEIGHT, StyleConstants.isBold(attr) ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        map.put(TextAttribute.POSTURE, StyleConstants.isItalic(attr) ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        if (bUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            if (attr.getAttribute(DASHED) != null) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
            }
        }
        if (bStrikethrough) {
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if ((font = this._fontCache.get(attr)) == null) {
            font = new Font(map);
            this._fontCache.put(attr, font);
        }
        return font;
    }

    private Font getFont(AttributeSet attr, String strFamily) {
        int iStyle = 0;
        if (StyleConstants.isBold(attr)) {
            iStyle |= 1;
        }
        if (StyleConstants.isItalic(attr)) {
            iStyle |= 2;
        }
        int iSize = this.getFontSize();
        if (StyleConstants.isSuperscript(attr) || StyleConstants.isSubscript(attr)) {
            iSize -= 2;
        }
        return this.getFont(strFamily, iStyle, iSize);
    }

    public String getFontFamily(AttributeSet a) {
        String strFamily = (String)a.getAttribute(StyleConstants.FontFamily);
        if (strFamily == null) {
            strFamily = this.getFontFamily();
        }
        return strFamily;
    }

    public String getFontFamily() {
        return this._strFontFamily;
    }

    public void setFontFamily(String strFamily) {
        this._strFontFamily = strFamily;
        this._fontCache.clear();
    }

    public int getFontSize() {
        return this._iFontSize;
    }

    public void setFontSize(int iSize) {
        this._iFontSize = iSize;
        this._fontCache.clear();
    }

    @Override
    public View create(Element elem) {
        return new GosuSourceView(elem);
    }

    public List<Style> getStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        Enumeration<?> names = this.getStyleNames();
        while (names.hasMoreElements()) {
            styles.add(this.getStyle((String)names.nextElement()));
        }
        return styles;
    }

    public boolean areStylesEquivalent(String styleName1, String styleName2) {
        Style style1 = this.getStyle(styleName1);
        Style style2 = this.getStyle(styleName2);
        Enumeration<?> names = style1.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name == StyleConstants.NameAttribute || style1.getAttribute(name).equals(style2.getAttribute(name))) continue;
            return false;
        }
        return true;
    }

    class GosuSourceView
    extends WrappedPlainView {
        GosuDocument.Scanner _lexer;

        GosuSourceView(Element elem) {
            super(elem);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            super.paint(g, a);
            this._lexer = null;
        }

        @Override
        protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            return super.drawSelectedText(g, x, y, p0, p1);
        }

        @Override
        protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
            GosuDocument doc = (GosuDocument)this.getDocument();
            Color lastFg = null;
            Color lastBg = null;
            Font lastFont = null;
            Style lastStyle = null;
            int mark = p0;
            while (p0 < p1) {
                int iCode;
                this.updateScanner(p0);
                int p = Math.min(this._lexer.getEndOffset(), p1);
                p = p <= p0 ? p1 : p;
                Pair<Boolean, ParseWarningForDeprecatedMember> parseWarning = doc.getParseWarningStartingAt(p0);
                if (parseWarning.getFirst().booleanValue()) {
                    if (parseWarning.getSecond() != null) {
                        iCode = -97;
                        p = Math.max(p, parseWarning.getSecond().getTokenEnd());
                    } else {
                        iCode = -96;
                    }
                } else {
                    Integer specialCode = doc.getStyleCodeAtPosition(p0);
                    if (specialCode != null) {
                        iCode = specialCode;
                    } else {
                        iCode = this._lexer.getType();
                        if (iCode == -7) {
                            iCode = -99;
                        }
                    }
                }
                if (doc.hasErrorStartingAt(p0)) {
                    iCode = -98;
                }
                Color fg = GosuStyleContext.this.getForeground(iCode);
                Color bg = GosuStyleContext.this.getBackground(iCode);
                Font font = GosuStyleContext.this.getFont(iCode);
                Style style = GosuStyleContext.this.getStyleForScanValue(iCode);
                if (lastStyle != null) {
                    g.setColor(lastFg);
                    ((Graphics2D)g).setBackground(lastBg);
                    g.setFont(lastFont);
                    Segment text = this.getLineBuffer();
                    doc.getText(mark, p0 - mark, text);
                    x = this.drawTabbedText(text, lastStyle, lastFont, x, y, (Graphics2D)g, this, mark);
                    if (doc.hasErrorStartingAt(mark)) {
                        ImageIcon icon = EditorUtilities.loadIcon("images/rule_error_pointer.gif");
                        icon.paintIcon(THISISSTUPID, g, x - icon.getIconWidth() / 2, y);
                    }
                    mark = p0;
                }
                lastStyle = style;
                lastFg = fg;
                lastBg = bg;
                lastFont = font;
                p0 = p;
            }
            g.setColor(lastFg);
            g.setFont(lastFont);
            Segment text = this.getLineBuffer();
            doc.getText(mark, p1 - mark, text);
            x = this.drawTabbedText(text, lastStyle, lastFont, x, y, (Graphics2D)g, this, mark);
            return x;
        }

        void updateScanner(int p) {
            try {
                if (this._lexer == null) {
                    GosuDocument doc = (GosuDocument)this.getDocument();
                    this._lexer = doc.createScanner();
                }
                while (this._lexer.getEndOffset() <= p) {
                    this._lexer.nextToken();
                }
            }
            catch (Throwable e) {
                EditorUtilities.handleUncaughtException(e);
            }
        }

        public final int drawTabbedText(Segment s, Style style, Font font, int x, int y, Graphics2D g, TabExpander e, int startOffset) {
            FontMetrics metrics = g.getFontMetrics();
            int nextX = x;
            char[] txt = s.array;
            int txtOffset = s.offset;
            int flushLen = 0;
            int flushIndex = s.offset;
            int n = s.offset + s.count;
            for (int i = txtOffset; i < n; ++i) {
                if (txt[i] == '\t') {
                    if (flushLen > 0) {
                        this.drawText(g, style, font, new String(txt, flushIndex, flushLen), x, y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    nextX = e != null ? (int)e.nextTabStop(nextX, startOffset + i - txtOffset) : (nextX += metrics.charWidth(' '));
                    x = nextX;
                    continue;
                }
                if (txt[i] == '\n' || txt[i] == '\r') {
                    if (flushLen > 0) {
                        this.drawText(g, style, font, new String(txt, flushIndex, flushLen), x, y);
                        flushLen = 0;
                    }
                    flushIndex = i + 1;
                    x = nextX;
                    continue;
                }
                ++flushLen;
                nextX += metrics.charWidth(txt[i]);
            }
            if (flushLen > 0) {
                String strText = new String(txt, flushIndex, flushLen);
                if (style.getName().equals(GosuStyleContext.STYLE_Operator)) {
                    if (strText.length() == 1 && strText.charAt(0) == '\\') {
                        strText = "\u03bb";
                    } else if (strText.length() == 2 && strText.equals("->")) {
                        strText = "\u2192 ";
                    } else if (strText.length() == 1 && strText.equals("*")) {
                        strText = "\u22c5";
                    }
                }
                this.drawText(g, style, font, strText, x, y);
            }
            return nextX;
        }

        public final void drawText(Graphics2D g2, Style style, Font font, String text, int x, int y) {
            boolean bUnderline = StyleConstants.isUnderline(style);
            boolean bStrikethrough = StyleConstants.isStrikeThrough(style);
            if (bUnderline || bStrikethrough) {
                AttributedString ats = new AttributedString(text);
                ats.addAttribute(TextAttribute.FONT, font);
                if (bUnderline) {
                    ats.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                    if (style.getAttribute(GosuStyleContext.DASHED) != null) {
                        ats.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_GRAY);
                    }
                }
                if (bStrikethrough) {
                    ats.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                }
                AttributedCharacterIterator iter = ats.getIterator();
                FontRenderContext frc = g2.getFontRenderContext();
                TextLayout tl = new TextLayout(iter, frc);
                tl.draw(g2, x, y);
            } else {
                TextLayout tl = new TextLayout(text, font, g2.getFontRenderContext());
                tl.draw(g2, x, y);
            }
        }
    }
}

