/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

class GraphicsUtil {
    GraphicsUtil() {
    }

    static void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, int textShiftOffset) {
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)b, g);
        GraphicsUtil.paintClassicText(b, g, textRect.x + textShiftOffset, textRect.y + fm.getAscent() + textShiftOffset, text, b.getDisplayedMnemonicIndex());
    }

    private static void paintClassicText(AbstractButton b, Graphics g, int x, int y, String text, int mnemIndex) {
        ButtonModel model = b.getModel();
        if (model.isEnabled()) {
            if (!(b instanceof JMenuItem && model.isArmed() || b instanceof JMenu && (model.isSelected() || model.isRollover()))) {
                g.setColor(b.getForeground());
            }
            SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        } else {
            Color color = GraphicsUtil.getDisabledTextColor(b);
            if (color == null) {
                color = UIManager.getColor("Button.shadow");
            }
            Color shadow = UIManager.getColor("Button.disabledShadow");
            if (model.isArmed()) {
                color = UIManager.getColor("Button.disabledForeground");
            } else {
                if (shadow == null) {
                    shadow = b.getBackground().darker();
                }
                g.setColor(shadow);
                SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x + 1, y + 1);
            }
            if (color == null) {
                color = b.getBackground().brighter();
            }
            g.setColor(color);
            SwingUtilities2.drawStringUnderlineCharAt(b, g, text, mnemIndex, x, y);
        }
    }

    private static Color getDisabledTextColor(AbstractButton b) {
        if (b instanceof JCheckBox) {
            return UIManager.getColor("CheckBox.disabledText");
        }
        if (b instanceof JRadioButton) {
            return UIManager.getColor("RadioButton.disabledText");
        }
        if (b instanceof JToggleButton) {
            return UIManager.getColor("ToggleButton.disabledText");
        }
        if (b instanceof JButton) {
            return UIManager.getColor("Button.disabledText");
        }
        return null;
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private RadioButtonMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (b.isSelected()) {
                g.fillRoundRect(x + 3, y + 3, this.getIconWidth() - 6, this.getIconHeight() - 6, 4, 4);
            }
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }

    static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean isSelected = model.isSelected();
            if (isSelected) {
                g.drawLine(x + 9, (y -= this.getIconHeight() / 2) + 3, x + 9, y + 3);
                g.drawLine(x + 8, y + 4, x + 9, y + 4);
                g.drawLine(x + 7, y + 5, x + 9, y + 5);
                g.drawLine(x + 6, y + 6, x + 8, y + 6);
                g.drawLine(x + 3, y + 7, x + 7, y + 7);
                g.drawLine(x + 4, y + 8, x + 6, y + 8);
                g.drawLine(x + 5, y + 9, x + 5, y + 9);
                g.drawLine(x + 3, y + 5, x + 3, y + 5);
                g.drawLine(x + 3, y + 6, x + 4, y + 6);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                g.setColor(UIManager.getColor("RadioButton.background"));
            } else {
                g.setColor(UIManager.getColor("RadioButton.interiorBackground"));
            }
            g.fillRect(x + 2, y + 2, 8, 8);
            boolean isScaledGraphics = SwingUtilities2.isScaledGraphics(g);
            if (isScaledGraphics) {
                Graphics2D g2d = (Graphics2D)g;
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(new BasicStroke(1.03f, 1, 1));
                Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(UIManager.getColor("RadioButton.shadow"));
                g.drawArc(x, y, 11, 11, 45, 180);
                g.setColor(UIManager.getColor("RadioButton.highlight"));
                g.drawArc(x, y, 11, 11, 45, -180);
                g.setColor(UIManager.getColor("RadioButton.darkShadow"));
                g.drawArc(x + 1, y + 1, 9, 9, 45, 180);
                g.setColor(UIManager.getColor("RadioButton.light"));
                g.drawArc(x + 1, y + 1, 9, 9, 45, -180);
                g2d.setStroke(oldStroke);
                if (model.isSelected()) {
                    if (model.isEnabled()) {
                        g.setColor(UIManager.getColor("RadioButton.foreground"));
                    } else {
                        g.setColor(UIManager.getColor("RadioButton.shadow"));
                    }
                    g.fillOval(x + 3, y + 3, 5, 5);
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            } else {
                g.setColor(UIManager.getColor("RadioButton.shadow"));
                g.drawLine(x + 4, y + 0, x + 7, y + 0);
                g.drawLine(x + 2, y + 1, x + 3, y + 1);
                g.drawLine(x + 8, y + 1, x + 9, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 3);
                g.drawLine(x + 0, y + 4, x + 0, y + 7);
                g.drawLine(x + 1, y + 8, x + 1, y + 9);
                g.setColor(UIManager.getColor("RadioButton.highlight"));
                g.drawLine(x + 2, y + 10, x + 3, y + 10);
                g.drawLine(x + 4, y + 11, x + 7, y + 11);
                g.drawLine(x + 8, y + 10, x + 9, y + 10);
                g.drawLine(x + 10, y + 9, x + 10, y + 8);
                g.drawLine(x + 11, y + 7, x + 11, y + 4);
                g.drawLine(x + 10, y + 3, x + 10, y + 2);
                g.setColor(UIManager.getColor("RadioButton.darkShadow"));
                g.drawLine(x + 4, y + 1, x + 7, y + 1);
                g.drawLine(x + 2, y + 2, x + 3, y + 2);
                g.drawLine(x + 8, y + 2, x + 9, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
                g.drawLine(x + 1, y + 4, x + 1, y + 7);
                g.drawLine(x + 2, y + 8, x + 2, y + 8);
                g.setColor(UIManager.getColor("RadioButton.light"));
                g.drawLine(x + 2, y + 9, x + 3, y + 9);
                g.drawLine(x + 4, y + 10, x + 7, y + 10);
                g.drawLine(x + 8, y + 9, x + 9, y + 9);
                g.drawLine(x + 9, y + 8, x + 9, y + 8);
                g.drawLine(x + 10, y + 7, x + 10, y + 4);
                g.drawLine(x + 9, y + 3, x + 9, y + 3);
                if (model.isSelected()) {
                    if (model.isEnabled()) {
                        g.setColor(UIManager.getColor("RadioButton.foreground"));
                    } else {
                        g.setColor(UIManager.getColor("RadioButton.shadow"));
                    }
                    g.fillRect(x + 4, y + 5, 4, 2);
                    g.fillRect(x + 5, y + 4, 2, 4);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }

    static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        CheckBoxIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            if (!cb.isBorderPaintedFlat()) {
                g.setColor(UIManager.getColor("CheckBox.shadow"));
                g.drawLine(x, y, x + 11, y);
                g.drawLine(x, y + 1, x, y + 11);
                g.setColor(UIManager.getColor("CheckBox.highlight"));
                g.drawLine(x + 12, y, x + 12, y + 12);
                g.drawLine(x, y + 12, x + 11, y + 12);
                g.setColor(UIManager.getColor("CheckBox.darkShadow"));
                g.drawLine(x + 1, y + 1, x + 10, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 10);
                g.setColor(UIManager.getColor("CheckBox.light"));
                g.drawLine(x + 1, y + 11, x + 11, y + 11);
                g.drawLine(x + 11, y + 1, x + 11, y + 10);
                if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                    g.setColor(UIManager.getColor("CheckBox.background"));
                } else {
                    g.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                }
                g.fillRect(x + 2, y + 2, 9, 9);
            } else {
                g.setColor(UIManager.getColor("CheckBox.shadow"));
                g.drawRect(x + 1, y + 1, 10, 10);
                if (model.isPressed() && model.isArmed() || !model.isEnabled()) {
                    g.setColor(UIManager.getColor("CheckBox.background"));
                } else {
                    g.setColor(UIManager.getColor("CheckBox.interiorBackground"));
                }
                g.fillRect(x + 2, y + 2, 9, 9);
            }
            if (model.isEnabled()) {
                g.setColor(UIManager.getColor("CheckBox.foreground"));
            } else {
                g.setColor(UIManager.getColor("CheckBox.shadow"));
            }
            if (model.isSelected()) {
                if (SwingUtilities2.isScaledGraphics(g)) {
                    int[] xPoints = new int[]{3, 5, 9, 9, 5, 3};
                    int[] yPoints = new int[]{5, 7, 3, 5, 9, 7};
                    g.translate(x, y);
                    g.fillPolygon(xPoints, yPoints, 6);
                    g.drawPolygon(xPoints, yPoints, 6);
                    g.translate(-x, -y);
                } else {
                    g.drawLine(x + 9, y + 3, x + 9, y + 3);
                    g.drawLine(x + 8, y + 4, x + 9, y + 4);
                    g.drawLine(x + 7, y + 5, x + 9, y + 5);
                    g.drawLine(x + 6, y + 6, x + 8, y + 6);
                    g.drawLine(x + 3, y + 7, x + 7, y + 7);
                    g.drawLine(x + 4, y + 8, x + 6, y + 8);
                    g.drawLine(x + 5, y + 9, x + 5, y + 9);
                    g.drawLine(x + 3, y + 5, x + 3, y + 5);
                    g.drawLine(x + 3, y + 6, x + 4, y + 6);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public int getIconHeight() {
            return 13;
        }
    }
}

