/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import editor.Scheme;
import editor.debugger.Breakpoint;
import editor.debugger.BreakpointTree;
import editor.util.EditorUtilities;
import editor.util.LabCheckbox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

class BreakpointCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final JTree _tree;
    private BreakpointTree _bpTree;
    private LabCheckbox _cbActive;
    private JLabel _label;
    private boolean _selected;

    public BreakpointCellRenderer(JTree tree) {
        super(new BorderLayout());
        this._tree = tree;
        this.configUi();
    }

    public LabCheckbox getCheckbox() {
        return this._cbActive;
    }

    private void configUi() {
        this.setOpaque(false);
        this._cbActive = new LabCheckbox();
        this._cbActive.setBorderPaintedFlat(true);
        this._cbActive.setOpaque(false);
        this._cbActive.setVisible(false);
        this.add((Component)this._cbActive, "West");
        this._label = new JLabel();
        this._label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._label.setOpaque(false);
        this.add((Component)this._label, "Center");
    }

    void setBreakpoint(BreakpointTree bpTree) {
        this._bpTree = bpTree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this._selected = selected;
        BreakpointTree bpTree = (BreakpointTree)value;
        this._label.setText(bpTree.toString());
        this._label.setIcon(bpTree.getBreakpoint() != null ? (bpTree.getBreakpoint().isActive() ? EditorUtilities.loadIcon("images/debug_linebreakpoint.png") : EditorUtilities.loadIcon("images/disabled_breakpoint.png")) : null);
        this._label.setEnabled(bpTree.getBreakpoint() == null || bpTree.getBreakpoint().isActive());
        this.setBreakpoint(bpTree);
        Breakpoint bp = this._bpTree.getBreakpoint();
        if (bp != null) {
            this._cbActive.setVisible(true);
            this._cbActive.setSelected(bp.isActive());
            this.revalidate();
        } else {
            this._cbActive.setVisible(false);
            this.revalidate();
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color bkColor;
        boolean bFocus;
        boolean bl = bFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this._tree;
        if (this._selected) {
            bkColor = this._tree.isEnabled() && bFocus ? Scheme.active().getActiveCaption() : Scheme.active().getControl();
        } else {
            bkColor = this._tree.getBackground();
            if (bkColor == null) {
                bkColor = this.getBackground();
            }
        }
        if (bkColor != null) {
            g.setColor(bkColor);
            g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            if (this._selected) {
                g.setColor(this._tree.isEnabled() && bFocus ? Scheme.active().getXpBorderColor() : Scheme.active().getControlShadow());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            g.setColor(bkColor);
        }
        this.setForeground(Scheme.active().getWindowText());
        super.paint(g);
    }
}

