/*
 * Decompiled with CFR 0.152.
 */
package editor.debugger;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import editor.AbstractTreeCellRenderer;
import editor.LabFrame;
import editor.Scheme;
import editor.debugger.Debugger;
import editor.debugger.ValueKind;
import editor.debugger.VarTree;
import editor.util.EditorUtilities;
import editor.util.TaskQueue;
import java.awt.EventQueue;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;

class VarTreeCellRenderer
extends AbstractTreeCellRenderer<VarTree> {
    private static final String FETCHING_VALUE = "<Fetching value...>";

    VarTreeCellRenderer(JTree tree) {
        super(tree);
    }

    @Override
    public void configure() {
        VarTree node = (VarTree)this.getNode();
        if (node == null) {
            return;
        }
        this.setBorder(new EmptyBorder(0, 3, 0, 3));
        String displayValue = node.getDisplayValue();
        if (displayValue == null) {
            displayValue = this.makeDisplayValue(node);
            node.setDisplayValue(displayValue);
        }
        this.setText(displayValue);
        this.setIcon(node.getIcon());
    }

    private String makeDisplayValue(VarTree node) {
        String localDisplayValue = this.makeLocalDisplayValue(node);
        if (localDisplayValue != null) {
            return localDisplayValue;
        }
        return this.makeRemoteDisplayValue(node);
    }

    private String makeLocalDisplayValue(VarTree node) {
        Object strValue;
        String address;
        String valueType;
        Value value = node.getValue();
        String string = valueType = value == null ? "" : value.type().name();
        if (value == null) {
            address = "";
            strValue = "<font color=#" + EditorUtilities.hex(Scheme.active().debugVarBlueText()) + "><b>null</b></font>";
        } else if (value instanceof PrimitiveValue) {
            address = "";
            strValue = value.toString();
            if (valueType.equals(Character.TYPE.getName())) {
                strValue = "<font face=monospaced color=#" + EditorUtilities.hex(Scheme.active().debugVarGreenText()) + ">'" + (String)strValue + "'</font> <font color=#" + EditorUtilities.hex(Scheme.active().getWindowText()) + ">" + ((String)strValue).charAt(0) + "</font>";
            }
        } else if (value instanceof ArrayReference) {
            address = "";
            strValue = "[" + ((ArrayReference)value).length() + "] " + this.makeIdValue(value);
        } else {
            return null;
        }
        return this.makeDisplayValue(node, (String)strValue, address);
    }

    private String makeRemoteDisplayValue(VarTree node) {
        TaskQueue.getInstance("jdiInvoker").postTask(() -> {
            Object strValue;
            Value value = node.getValue();
            String valueType = value == null ? "" : value.type().name();
            String idValue = this.makeIdValue(value);
            Object address = null;
            if (VarTree.getValueKind(value).isSpecial()) {
                strValue = "<font color=#C0C0C0>" + idValue + "</font>";
                address = "";
            } else {
                strValue = this.invokeToString((ObjectReference)value);
                if (((String)strValue).startsWith("\"" + value.type().name() + "@")) {
                    strValue = idValue;
                    address = "";
                }
            }
            if (address == null) {
                address = "<font color=#C0C0C0>" + idValue + "</font>";
            }
            if (valueType.equals(String.class.getName())) {
                strValue = "<font color=#" + EditorUtilities.hex(Scheme.active().debugVarGreenText()) + "><b>" + (String)strValue + "</b></font>";
            }
            strValue = this.handleSpecialValue((ObjectReference)value, (String)strValue);
            String displayValue = this.makeDisplayValue(node, (String)strValue, (String)address);
            node.setDisplayValue(displayValue);
            EventQueue.invokeLater(() -> node.getTree().getModel().valueForPathChanged(node.getPath(), node.getValue()));
        });
        return node.getDisplayValue() == null ? FETCHING_VALUE : node.getDisplayValue();
    }

    private String makeDisplayValue(VarTree node, String strValue, String address) {
        return "<html><font color=#" + EditorUtilities.hex(Scheme.active().debugVarRedText()) + ">" + node.getName() + "</font> " + address + " = " + strValue;
    }

    private String handleSpecialValue(ObjectReference value, String strValue) {
        ValueKind valueKind = VarTree.getValueKind(value);
        if (valueKind == ValueKind.Collection || valueKind == ValueKind.Map) {
            Value size;
            Debugger debugger = LabFrame.instance().getGosuPanel().getDebugger();
            if (debugger == null) {
                return "";
            }
            ThreadReference thread = debugger.getSuspendedThread();
            ReferenceType refType = value.referenceType();
            try {
                size = value.invokeMethod(thread, refType.methodsByName("size").get(0), Collections.emptyList(), 0);
            }
            catch (Exception e) {
                throw new RuntimeException("THREAD: " + thread.name(), e);
            }
            strValue = (String)strValue + " size = " + ((PrimitiveValue)size).intValue();
        }
        return strValue;
    }

    private String invokeToString(ObjectReference value) {
        Value displayValue;
        Debugger debugger = LabFrame.instance().getGosuPanel().getDebugger();
        if (debugger == null) {
            return "";
        }
        ThreadReference thread = debugger.getSuspendedThread();
        if (thread == null) {
            return "";
        }
        ReferenceType refType = value.referenceType();
        try {
            Method toString = (Method)refType.methodsByName("toString").stream().filter(e -> e.argumentTypeNames().size() == 0).collect(Collectors.toList()).get(0);
            displayValue = value.invokeMethod(thread, toString, Collections.emptyList(), 0);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return displayValue == null ? "null" : displayValue.toString();
    }

    private String makeIdValue(Value value) {
        return "{" + value.type().name() + "@" + ((ObjectReference)value).uniqueID() + "}";
    }
}

