/*
 * Decompiled with CFR 0.152.
 */
package editor.search;

import editor.EditorHost;
import editor.FileTree;
import editor.LabFrame;
import editor.search.AbstractSearchDialog;
import editor.search.SearchLocation;
import editor.search.TextSearcher;
import java.util.List;

public class LocalSearchDialog
extends AbstractSearchDialog {
    public static AbstractSearchDialog.State STATE = null;

    public LocalSearchDialog(FileTree searchFile, boolean bReplace) {
        super(searchFile, bReplace, bReplace ? "Replace..." : "Find...");
        this.setLocal();
        this.setSize(400, this.isRegex() ? 280 : 270);
    }

    @Override
    protected void find() {
        if (this.isReplace()) {
            super.find();
        } else {
            this.setState(new AbstractSearchDialog.State().save(this));
            this.close();
        }
        this.highlight();
    }

    private void highlight() {
        EditorHost editor = LabFrame.instance().getGosuPanel().getCurrentEditor();
        if (editor.getEditor().getSelectedText() != null) {
            editor.getEditor().setCaretPosition(editor.getEditor().getSelectionStart() - 1);
        }
        editor.removeAllHighlights();
        List<SearchLocation> locations = new TextSearcher(this.getPattern(), this.isCaseSensitive(), this.isWholeWords(), this.isRegex()).searchLocal();
        if (locations.size() > 0) {
            editor.highlightLocations(locations);
            editor.gotoNextUsageHighlight();
        }
    }

    @Override
    protected AbstractSearchDialog.State getState() {
        return STATE;
    }

    @Override
    protected void setState(AbstractSearchDialog.State state) {
        STATE = state;
    }
}

