/*
 * Decompiled with CFR 0.152.
 */
package editor.shipit;

import editor.FileTree;
import editor.MessageTree;
import editor.MessagesPanel;
import editor.NodeKind;
import editor.settings.CompilerSettings;
import editor.shipit.CompiledClass;
import editor.shipit.ICompileConsumer;
import editor.util.IProgressCallback;
import gw.lang.parser.GosuParserFactory;
import gw.lang.parser.IFileRepositoryBasedType;
import gw.lang.parser.IHasInnerClass;
import gw.lang.parser.IParseIssue;
import gw.lang.parser.exceptions.ParseResultsException;
import gw.lang.reflect.IType;
import gw.lang.reflect.ITypeRef;
import gw.lang.reflect.TypeSystem;
import gw.lang.reflect.gs.IGosuClass;
import gw.lang.reflect.java.IJavaType;
import gw.util.PathUtil;
import gw.util.StreamUtil;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import manifold.internal.javac.IJavaParser;

public class Compiler {
    private MessageTree _warnings;
    private int _iWarnings = 0;
    private MessageTree _errors;
    private int _iErrors = 0;
    private MessageTree _failures;
    private int _iFailures = 0;

    public boolean compileTree(FileTree tree, ICompileConsumer consumer, IProgressCallback progress, MessagesPanel messagesPanel) {
        if (progress.isAbort()) {
            return false;
        }
        if (tree.isFile()) {
            IType type = tree.getType();
            progress.incrementProgress(type != null ? type.getName() : "", new String[0]);
            if (type instanceof IFileRepositoryBasedType && !this.compile(type, consumer, messagesPanel)) {
                return false;
            }
        } else if (tree.isDirectory()) {
            for (FileTree file : tree.getChildren()) {
                if (this.compileTree(file, consumer, progress, messagesPanel)) continue;
                return false;
            }
        }
        return true;
    }

    public int getWarnings() {
        return this._iWarnings;
    }

    public int getErrors() {
        return this._iErrors;
    }

    public int getFailures() {
        return this._iFailures;
    }

    private void addWarnings(ParseResultsException parseException) {
        this._iWarnings += parseException.getParseWarnings().size();
    }

    private void addErrors(ParseResultsException parseException) {
        this._iErrors += parseException.getParseExceptions().size();
    }

    private void addFailure() {
        ++this._iFailures;
    }

    private void updateMessageTree(MessagesPanel messages) {
        EventQueue.invokeLater(() -> {
            if (this._iWarnings > 0) {
                if (this._warnings == null) {
                    this._warnings = new MessageTree("", NodeKind.Info, MessageTree.empty());
                    messages.appendToTop(this._warnings);
                }
                this._warnings.setText("Warnings: " + this._iWarnings);
            }
            if (this._iErrors > 0) {
                if (this._errors == null) {
                    this._errors = new MessageTree("", NodeKind.Info, MessageTree.empty());
                    messages.appendToTop(this._errors);
                }
                this._errors.setText("Errors: " + this._iErrors);
            }
            if (this._iFailures > 0) {
                if (this._failures == null) {
                    this._failures = new MessageTree("", NodeKind.Info, MessageTree.empty());
                    messages.appendToTop(this._failures);
                }
                this._failures.setText("Failures: " + this._iFailures);
            }
        });
    }

    public boolean compile(IType type, ICompileConsumer consumer, MessagesPanel messages) {
        if (type instanceof IGosuClass) {
            return this.compileGosu((IGosuClass)type, consumer, messages);
        }
        if (type instanceof IJavaType) {
            return this.compileJava((IJavaType)type, consumer, messages);
        }
        return true;
    }

    private boolean compileGosu(IGosuClass gsClass, ICompileConsumer consumer, MessagesPanel messages) {
        if (this.isExcluded((IType)gsClass)) {
            return true;
        }
        this.parseImpl(gsClass);
        ParseResultsException parseException = gsClass.getParseResultsException();
        if (parseException != null && !parseException.hasOnlyParseWarnings()) {
            this.addWarnings(parseException);
            this.addErrors(parseException);
            EventQueue.invokeLater(() -> {
                this.updateMessageTree(messages);
                MessageTree typeNode = messages.addTypeMessage(gsClass.getName(), null, MessageTree.empty());
                parseException.getParseWarnings().forEach(warning -> messages.addWarningMessage(this.makeIssueMessage((IParseIssue)warning, NodeKind.Warning), typeNode, MessageTree.makeIssueMessage(warning)));
                parseException.getParseExceptions().forEach(error -> messages.addErrorMessage(this.makeIssueMessage((IParseIssue)error, NodeKind.Error), typeNode, MessageTree.makeIssueMessage(error)));
            });
            return consumer.accept(new CompiledClass((IFileRepositoryBasedType)gsClass, null));
        }
        try {
            if (parseException != null && parseException.getParseIssues().size() > 0) {
                this.addWarnings(parseException);
                EventQueue.invokeLater(() -> {
                    this.updateMessageTree(messages);
                    MessageTree typeNode = messages.addTypeMessage(gsClass.getName(), null, MessageTree.empty());
                    parseException.getParseWarnings().forEach(warning -> messages.addWarningMessage(this.makeIssueMessage((IParseIssue)warning, NodeKind.Warning), typeNode, MessageTree.makeIssueMessage(warning)));
                });
            }
            return this.compileClass((IFileRepositoryBasedType)gsClass, consumer);
        }
        catch (Exception e) {
            this.addFailure();
            EventQueue.invokeLater(() -> {
                this.updateMessageTree(messages);
                MessageTree typeNode = messages.addTypeMessage(gsClass.getName(), null, MessageTree.empty());
                messages.addFailureMessage(e.getMessage(), typeNode, MessageTree.empty());
                e.printStackTrace();
            });
            return consumer.accept(new CompiledClass((IFileRepositoryBasedType)gsClass, null));
        }
    }

    private boolean compileJava(IJavaType javaType, ICompileConsumer consumer, MessagesPanel messages) {
        if (this.isExcluded((IType)javaType)) {
            return true;
        }
        IJavaParser javaParser = (IJavaParser)GosuParserFactory.getInterface(IJavaParser.class);
        DiagnosticCollector errorHandler = new DiagnosticCollector();
        javaParser.compile(javaType.getName(), Arrays.asList("-source", "8", "-g", "-nowarn", "-Xlint:none", "-proc:none", "-parameters"), errorHandler);
        boolean errant = errorHandler.getDiagnostics().stream().anyMatch(e -> e.getKind() == Diagnostic.Kind.ERROR);
        if (errant) {
            errorHandler.getDiagnostics().forEach(e -> {
                switch (e.getKind()) {
                    case ERROR: {
                        ++this._iErrors;
                        break;
                    }
                    case WARNING: 
                    case MANDATORY_WARNING: {
                        ++this._iWarnings;
                    }
                }
            });
            EventQueue.invokeLater(() -> {
                this.updateMessageTree(messages);
                MessageTree typeNode = messages.addTypeMessage(javaType.getName(), null, MessageTree.empty());
                errorHandler.getDiagnostics().forEach(e -> {
                    switch (e.getKind()) {
                        case ERROR: {
                            messages.addErrorMessage(this.makeIssueMessage((Diagnostic<? extends JavaFileObject>)e, NodeKind.Error), typeNode, MessageTree.makeIssueMessage(e, (IType)javaType));
                            break;
                        }
                        case WARNING: 
                        case MANDATORY_WARNING: {
                            messages.addWarningMessage(this.makeIssueMessage((Diagnostic<? extends JavaFileObject>)e, NodeKind.Warning), typeNode, MessageTree.makeIssueMessage(e, (IType)javaType));
                        }
                    }
                });
            });
            return consumer.accept(new CompiledClass((IFileRepositoryBasedType)javaType, null));
        }
        try {
            if (errorHandler.getDiagnostics().stream().anyMatch(e -> e.getKind() == Diagnostic.Kind.WARNING || e.getKind() == Diagnostic.Kind.MANDATORY_WARNING)) {
                errorHandler.getDiagnostics().forEach(e -> {
                    switch (e.getKind()) {
                        case WARNING: 
                        case MANDATORY_WARNING: {
                            ++this._iWarnings;
                        }
                    }
                });
                EventQueue.invokeLater(() -> {
                    this.updateMessageTree(messages);
                    MessageTree typeNode = messages.addTypeMessage(javaType.getName(), null, MessageTree.empty());
                    errorHandler.getDiagnostics().forEach(e -> {
                        switch (e.getKind()) {
                            case WARNING: 
                            case MANDATORY_WARNING: {
                                messages.addWarningMessage(this.makeIssueMessage((Diagnostic<? extends JavaFileObject>)e, NodeKind.Warning), typeNode, MessageTree.makeIssueMessage(e, (IType)javaType));
                            }
                        }
                    });
                });
            }
            return this.compileClass((IFileRepositoryBasedType)javaType, consumer);
        }
        catch (Exception e2) {
            this.addFailure();
            EventQueue.invokeLater(() -> {
                this.updateMessageTree(messages);
                MessageTree typeNode = messages.addTypeMessage(javaType.getName(), null, MessageTree.empty());
                messages.addFailureMessage(e2.getMessage(), typeNode, MessageTree.empty());
                e2.printStackTrace();
            });
            return consumer.accept(new CompiledClass((IFileRepositoryBasedType)javaType, null));
        }
    }

    private boolean isExcluded(IType type) {
        IGosuClass gsClass;
        if (type.getRelativeName().startsWith("Errant_")) {
            return true;
        }
        return type instanceof IGosuClass && (gsClass = (IGosuClass)type).getSource().contains("@DoNotVerifyResource");
    }

    private String makeIssueMessage(IParseIssue issue, NodeKind kind) {
        Object msg = kind == NodeKind.Warning ? "Warning: " : "Error: ";
        msg = (String)msg + "(" + issue.getLine() + ", " + issue.getColumn() + ") " + issue.getPlainMessage();
        return msg;
    }

    private String makeIssueMessage(Diagnostic<? extends JavaFileObject> issue, NodeKind kind) {
        Object msg = kind == NodeKind.Error ? "Error: " : "Warning: ";
        msg = (String)msg + "(" + issue.getLineNumber() + ", " + issue.getColumnNumber() + ") " + issue.getMessage(Locale.getDefault());
        return msg;
    }

    private boolean compileClass(IFileRepositoryBasedType type, ICompileConsumer consumer) {
        if (!type.isCompilable()) {
            return true;
        }
        byte[] bytes = type.compile();
        if (!consumer.accept(new CompiledClass(type, bytes))) {
            return false;
        }
        this.makeClassFile(type, bytes);
        if (type instanceof IHasInnerClass) {
            for (IType innerClass : ((IHasInnerClass)type).getInnerClasses()) {
                if (this.compileClass((IFileRepositoryBasedType)innerClass, consumer)) continue;
                return false;
            }
        }
        return true;
    }

    private void makeClassFile(IFileRepositoryBasedType type, byte[] bytes) {
        if (!CompilerSettings.isStaticCompile()) {
            return;
        }
        Path outputDir = CompilerSettings.getCompilerOutputDir();
        if (!(PathUtil.exists((Path)outputDir, (LinkOption[])new LinkOption[0]) || PathUtil.mkdirs((Path)outputDir) && PathUtil.isDirectory((Path)outputDir, (LinkOption[])new LinkOption[0]))) {
            return;
        }
        Object javaName = type.getJavaName();
        javaName = ((String)javaName).replace('.', File.separatorChar) + ".class";
        Path classFile = PathUtil.create((Path)outputDir, (String)javaName);
        PathUtil.mkdirs((Path)classFile.getParent());
        try (OutputStream writer = PathUtil.createOutputStream((Path)classFile, (OpenOption[])new OpenOption[0]);){
            writer.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.copySourceFile(type, outputDir);
    }

    private void copySourceFile(IFileRepositoryBasedType type, Path outputDir) {
        if (!(type instanceof IJavaType) && type.getEnclosingType() == null) {
            File file = type.getSourceFileHandle().getFile().toJavaFile();
            File toDir = new File(outputDir.toFile(), type.getNamespace().replace('.', File.separatorChar));
            toDir.mkdirs();
            StreamUtil.copy((File)file, (File)toDir);
        }
    }

    protected void parseImpl(IGosuClass gsClass) {
        TypeSystem.lock();
        try {
            if (gsClass != null) {
                TypeSystem.refresh((ITypeRef)((ITypeRef)gsClass));
                gsClass.setCreateEditorParser(false);
                gsClass.isValid();
            }
        }
        finally {
            TypeSystem.unlock();
        }
    }
}

