/*
 * Decompiled with CFR 0.152.
 */
package editor.shipit;

import editor.LabFrame;
import editor.shipit.CompiledClass;
import editor.shipit.ExperimentBuild;
import editor.shipit.ShipItDialog;
import editor.util.Experiment;
import gw.util.PathUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class ShipIt {
    private static ShipIt INSTANCE;
    private JarOutputStream _jo;
    private Set<String> _entries;
    private List<String> _jars;

    public static ShipIt instance() {
        return INSTANCE == null ? (INSTANCE = new ShipIt()) : INSTANCE;
    }

    public boolean shipIt(Experiment experiment) {
        ShipItDialog dlg = new ShipItDialog(experiment);
        dlg.setVisible(true);
        String programName = dlg.getProgramName();
        if (programName == null) {
            return false;
        }
        String strProgramName = dlg.getProgramName();
        ArrayList<String> progClasspath = new ArrayList<String>();
        Path outFile = PathUtil.create((Path)experiment.getExperimentDir(), (String)(experiment.getName() + ".jar"));
        if (PathUtil.exists((Path)outFile, (LinkOption[])new LinkOption[0])) {
            PathUtil.delete((Path)outFile);
        }
        this._entries = new HashSet<String>();
        this._jars = new ArrayList<String>();
        try {
            boolean bCompile;
            BufferedOutputStream bo = new BufferedOutputStream(PathUtil.createOutputStream((Path)outFile, (OpenOption[])new OpenOption[0]));
            this._jo = new JarOutputStream(bo);
            this.AddExperimentFilesAndDependencies(experiment, progClasspath);
            JarEntry je = new JarEntry("Launcher.class");
            this._jo.putNextEntry(je);
            InputStream inMain = this.getClass().getResource("/Launcher.class").openStream();
            this.writeBytes(inMain);
            inMain.close();
            boolean bBundleGosu = dlg.isBundleGosu();
            if (bBundleGosu) {
                this.bundleGosu(progClasspath);
            }
            if ((bCompile = dlg.isPrecompiled()) && !ExperimentBuild.instance().rebuild(this::addPrecompiledClass)) {
                this._jo.close();
                PathUtil.delete((Path)outFile);
                return false;
            }
            this.createJarRepoFile();
            this.createMainPropertiesFile(strProgramName, bBundleGosu);
            this.makeManifest();
            this._jo.close();
            LabFrame.openFileOrDir(outFile);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean addPrecompiledClass(CompiledClass cs) {
        Object javaName = cs.getType().getJavaName();
        javaName = ((String)javaName).replace('.', '/') + ".class";
        JarEntry je = new JarEntry((String)javaName);
        try {
            byte[] bytes = cs.getBytes();
            if (bytes == null || bytes.length == 0) {
                return false;
            }
            this._jo.putNextEntry(je);
            this._jo.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private void makeManifest() throws IOException {
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        this._jo.putNextEntry(je);
        OutputStreamWriter writer = new OutputStreamWriter(this._jo);
        writer.write("Manifest-Version: 1.0\nMain-Class: Launcher\n");
        ((Writer)writer).flush();
    }

    private void bundleGosu(List<String> progClasspath) throws IOException {
        String[] classpath;
        for (String path : classpath = System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (!path.contains("gw-asm-all") && !path.contains("manifold") && !path.contains("tools.jar")) continue;
            this.addClasspathEntry(progClasspath, PathUtil.create((String)path, (String[])new String[0]));
        }
    }

    private void AddExperimentFilesAndDependencies(Experiment experiment, List<String> progClasspath) throws IOException {
        String javaHomePath = System.getProperty("java.home");
        List<String> srcPaths = experiment.getSourcePath();
        for (String path : srcPaths) {
            if (path.startsWith(javaHomePath)) continue;
            this.addClasspathEntry(progClasspath, PathUtil.create((String)path, (String[])new String[0]));
        }
    }

    private void createMainPropertiesFile(String strProgramName, boolean bBundleGosu) throws IOException {
        JarEntry je = new JarEntry("main.properties");
        this._jo.putNextEntry(je);
        OutputStreamWriter writer = new OutputStreamWriter(this._jo);
        writer.write("Program=" + strProgramName + "\n" + (bBundleGosu ? "BundledGosu=true\n" : "") + "Classpath=\n");
        ((Writer)writer).flush();
    }

    private void addClasspathEntry(List<String> progClasspath, Path csr) throws IOException {
        if (PathUtil.isDirectory((Path)csr, (LinkOption[])new LinkOption[0])) {
            for (Path fileOrDir : PathUtil.listFiles((Path)PathUtil.getAbsolutePath((Path)csr))) {
                this.addEntry(fileOrDir, "");
                progClasspath.add(PathUtil.getAbsolutePathName((Path)fileOrDir));
            }
        } else {
            String lowercaseName = PathUtil.getName((Path)csr).toLowerCase();
            if (lowercaseName.endsWith(".jar") || lowercaseName.endsWith(".zip")) {
                this.addJarEntry(csr);
            }
        }
    }

    private void addJarEntry(Path jarFile) throws IOException {
        this.addEntry(jarFile, "JAR-REPO");
        this._jars.add(PathUtil.getName((Path)jarFile));
    }

    private void createJarRepoFile() throws IOException {
        JarEntry je = new JarEntry("JAR-REPO/jar-repo.txt");
        this._jo.putNextEntry(je);
        OutputStreamWriter writer = new OutputStreamWriter(this._jo);
        writer.write(UUID.randomUUID().toString() + "\n");
        for (String jar : this._jars) {
            writer.write(jar + "\n");
        }
        ((Writer)writer).flush();
    }

    private void addEntry(Path file, String strPath) {
        if (PathUtil.isDirectory((Path)file, (LinkOption[])new LinkOption[0])) {
            String strDir = (String)(strPath.length() > 0 ? strPath + "/" : "") + PathUtil.getName((Path)file);
            for (Path csr : PathUtil.listFiles((Path)file)) {
                this.addEntry(csr, strDir);
            }
        } else if (PathUtil.isFile((Path)file, (LinkOption[])new LinkOption[0])) {
            if (PathUtil.getName((Path)file).toLowerCase().equals("manifest.mf")) {
                return;
            }
            String strFile = (String)(strPath.length() > 0 ? strPath + "/" : "") + PathUtil.getName((Path)file);
            if (this._entries.contains(strFile)) {
                return;
            }
            this._entries.add(strFile);
            JarEntry je = new JarEntry(strFile);
            try {
                this._jo.putNextEntry(je);
                InputStream in = PathUtil.createInputStream((Path)file, (OpenOption[])new OpenOption[0]);
                this.writeBytes(in);
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException(file + " is not a file");
        }
    }

    private void writeBytes(InputStream in) throws IOException {
        int iCount;
        byte[] buf = new byte[1024];
        while ((iCount = in.read(buf, 0, buf.length)) > 0) {
            this._jo.write(buf, 0, iCount);
        }
    }
}

