/*
 * Decompiled with CFR 0.152.
 */
package editor.tabpane;

import editor.Scheme;
import editor.tabpane.StandardTab;
import editor.tabpane.TabPosition;
import editor.util.VerticalLabelUI;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;

class InnerLabel
extends JLabel {
    private StandardTab _tab;

    public InnerLabel(StandardTab tab, String strText, Icon icon, int iHorizontalAlignment) {
        super(strText, icon, iHorizontalAlignment);
        this._tab = tab;
        if (this._tab.getTabPosition() == TabPosition.TOP || this._tab.getTabPosition() == TabPosition.BOTTOM) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        } else if (this._tab.getTabPosition() == TabPosition.LEFT) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.setUI(new VerticalLabelUI(false));
        } else if (this._tab.getTabPosition() == TabPosition.RIGHT) {
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.setUI(new VerticalLabelUI(true));
        }
    }

    @Override
    public Color getForeground() {
        try {
            if (this._tab != null) {
                return this._tab.isSelected() ? (this._tab.getTabPane().isShowing() && this._tab.getTabPane().isActive() ? Scheme.active().getActiveCaptionText() : super.getForeground()) : super.getForeground();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Color.black;
    }
}

