/*
 * Decompiled with CFR 0.152.
 */
package editor.util;

import editor.util.EditorUtilities;
import java.awt.Component;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;

public class BackgroundOperation {
    private static BackgroundOperation g_instance;
    private ExecutorService _jobRunner;

    public static BackgroundOperation instance() {
        if (g_instance == null) {
            g_instance = new BackgroundOperation();
        }
        return g_instance;
    }

    private BackgroundOperation() {
    }

    public void doBackgroundWaitOp(Runnable run) {
        this.doBackgroundOp(run, true);
    }

    public void doBackgroundOp(Runnable run, boolean showWaitCursor) {
        Component[] key = new Component[1];
        ExecutorService jobRunner = this.getJobRunner();
        if (jobRunner != null) {
            jobRunner.submit(() -> this.performBackgroundOp(run, key, showWaitCursor));
        } else {
            run.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performBackgroundOp(Runnable run, Component[] key, boolean showWaitCursor) {
        if (showWaitCursor) {
            SwingUtilities.invokeLater(() -> {
                key[0] = EditorUtilities.showWaitCursor(true);
            });
        }
        try {
            run.run();
        }
        finally {
            if (showWaitCursor) {
                SwingUtilities.invokeLater(() -> EditorUtilities.showWaitCursor(false, key[0]));
            }
        }
    }

    private ExecutorService getJobRunner() {
        if (this._jobRunner == null) {
            this._jobRunner = Executors.newSingleThreadExecutor();
        }
        return this._jobRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnBackgroundOp() {
        ExecutorService jobRunner = this.getJobRunner();
        if (jobRunner != null) {
            Object wait;
            Object object = wait = new Object();
            synchronized (object) {
                BackgroundOperation.instance().doBackgroundOp(() -> {
                    Object object = wait;
                    synchronized (object) {
                        wait.notifyAll();
                    }
                }, false);
                try {
                    wait.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void waitOnBackgroundOp(long timeout) {
        Thread waiter = new Thread(this::waitOnBackgroundOp, "Background Operation Waiter");
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

